/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.plugin;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.RegistryFactory;
import org.jpox.ClassLoaderResolver;
import org.jpox.plugin.ConfigurationElement;
import org.jpox.plugin.Extension;
import org.jpox.plugin.ExtensionPoint;
import org.jpox.plugin.Plugin;
import org.jpox.plugin.PluginRegistry;
import org.osgi.framework.Bundle;

public class EclipsePluginRegistry
implements PluginRegistry {
    public EclipsePluginRegistry(ClassLoaderResolver clr) {
        if (RegistryFactory.getRegistry() == null || RegistryFactory.getRegistry().getExtensionPoint("org.jpox.store_manager") == null) {
            throw new RuntimeException("This plug-in registry class can only be used if JPOX Core is managed by Eclipse.");
        }
    }

    public ExtensionPoint getExtensionPoint(String id) {
        IExtensionPoint eclipseExPoint = RegistryFactory.getRegistry().getExtensionPoint(id);
        Plugin plugin = new Plugin(eclipseExPoint.getContributor().getName(), "", "", "", null);
        Bundle bundle = Platform.getBundle((String)eclipseExPoint.getContributor().getName());
        try {
            ExtensionPoint exPoint = new ExtensionPoint(eclipseExPoint.getUniqueIdentifier(), eclipseExPoint.getLabel(), bundle.getResource(eclipseExPoint.getSchemaReference()), plugin);
            for (int e = 0; e < eclipseExPoint.getExtensions().length; ++e) {
                Plugin pluginEx = new Plugin(eclipseExPoint.getExtensions()[e].getContributor().getName(), "", "", "", null);
                Extension ex = new Extension(exPoint, pluginEx);
                this.configurationElement(ex, eclipseExPoint.getExtensions()[e].getConfigurationElements(), null);
                exPoint.addExtension(ex);
            }
            return exPoint;
        }
        catch (InvalidRegistryObjectException e) {
            return null;
        }
    }

    private void configurationElement(Extension ex, IConfigurationElement[] elms, ConfigurationElement parent) {
        for (int c = 0; c < elms.length; ++c) {
            IConfigurationElement iconfElm = elms[c];
            ConfigurationElement confElm = new ConfigurationElement(ex, iconfElm.getName(), null);
            for (int a = 0; a < iconfElm.getAttributeNames().length; ++a) {
                confElm.putAttribute(iconfElm.getAttributeNames()[a], iconfElm.getAttribute(iconfElm.getAttributeNames()[a]));
            }
            confElm.setText(iconfElm.getValue());
            if (parent == null) {
                ex.addConfigurationElement(confElm);
            } else {
                parent.addConfigurationElement(confElm);
            }
            this.configurationElement(ex, iconfElm.getChildren(), confElm);
        }
    }

    public ExtensionPoint[] getExtensionPoints() {
        IExtensionPoint[] eclipseExPoint = RegistryFactory.getRegistry().getExtensionPoints();
        ArrayList<ExtensionPoint> elms = new ArrayList<ExtensionPoint>();
        for (int i = 0; i < eclipseExPoint.length; ++i) {
            Plugin plugin = new Plugin(eclipseExPoint[i].getContributor().getName(), "", "", "", null);
            try {
                Bundle bundle = Platform.getBundle((String)eclipseExPoint[i].getContributor().getName());
                ExtensionPoint exPoint = new ExtensionPoint(eclipseExPoint[i].getUniqueIdentifier(), eclipseExPoint[i].getLabel(), bundle.getResource(eclipseExPoint[i].getSchemaReference()), plugin);
                for (int e = 0; e < eclipseExPoint[i].getExtensions().length; ++e) {
                    Extension ex = new Extension(exPoint, plugin);
                    this.configurationElement(ex, eclipseExPoint[i].getExtensions()[e].getConfigurationElements(), null);
                    exPoint.addExtension(ex);
                }
                elms.add(exPoint);
                continue;
            }
            catch (InvalidRegistryObjectException e) {
                // empty catch block
            }
        }
        return (ExtensionPoint[])elms.toArray(new IExtensionPoint[elms.size()]);
    }

    public void registerExtensionPoints() {
    }

    public void registerExtensions() {
    }

    public URL resolveURLAsFileURL(URL url) throws IOException {
        return FileLocator.toFileURL((URL)url);
    }

    public Object createExecutableExtension(ConfigurationElement confElm, String name, Class[] argsClass, Object[] args) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class cls = Platform.getBundle((String)confElm.getExtension().getPlugin().getId()).loadClass(confElm.getAttribute(name));
        Constructor constructor = cls.getConstructor(argsClass);
        return constructor.newInstance(args);
    }

    public Class loadClass(String pluginId, String className) throws ClassNotFoundException {
        return Platform.getBundle((String)pluginId).loadClass(className);
    }
}

