/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.plugin;

import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jpox.ClassLoaderResolver;
import org.jpox.exceptions.JPOXException;
import org.jpox.plugin.ConfigurationElement;
import org.jpox.plugin.Extension;
import org.jpox.plugin.ExtensionPoint;
import org.jpox.plugin.Plugin;
import org.jpox.plugin.PluginRegistry;
import org.jpox.util.JPOXLogger;
import org.jpox.util.Localiser;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

class PluginParser {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.jpox.Localisation");

    PluginParser() {
    }

    public static List parseExtensionPoints(PluginRegistry mgr, URL fileUrl, ClassLoaderResolver clr) {
        if (JPOXLogger.PLUGIN.isDebugEnabled()) {
            JPOXLogger.PLUGIN.debug(LOCALISER.msg("Plugin.LoadingExtensionPoints", fileUrl.toString()));
        }
        ArrayList<ExtensionPoint> extensionPoints = new ArrayList<ExtensionPoint>();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = factory.newDocumentBuilder();
            try {
                Element rootElement = db.parse(new InputSource(new InputStreamReader(fileUrl.openStream()))).getDocumentElement();
                Plugin plugin = new Plugin(rootElement.getAttribute("id"), rootElement.getAttribute("name"), rootElement.getAttribute("provider-name"), rootElement.getAttribute("version"), fileUrl);
                NodeList elements = rootElement.getElementsByTagName("extension-point");
                for (int i = 0; i < elements.getLength(); ++i) {
                    Element element = (Element)elements.item(i);
                    String id = element.getAttribute("id").trim();
                    String name = element.getAttribute("name");
                    String schema = element.getAttribute("schema");
                    extensionPoints.add(new ExtensionPoint(id, name, clr.getResource(schema, null), plugin));
                }
            }
            catch (JPOXException ex) {
                throw ex;
            }
            catch (Exception e) {
                JPOXLogger.PLUGIN.error(LOCALISER.msg("Plugin.FileNonExistent", fileUrl.getFile()));
            }
        }
        catch (ParserConfigurationException e1) {
            JPOXLogger.PLUGIN.error(LOCALISER.msg("Plugin.ErrorReadingFile", fileUrl.getFile(), e1.getMessage()));
        }
        return extensionPoints;
    }

    public static List parseExtensions(PluginRegistry mgr, URL fileUrl, ClassLoaderResolver clr) {
        if (JPOXLogger.PLUGIN.isDebugEnabled()) {
            JPOXLogger.PLUGIN.debug(LOCALISER.msg("Plugin.LoadingExtensions", fileUrl.toString()));
        }
        ArrayList extensionPoints = new ArrayList();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = factory.newDocumentBuilder();
            try {
                Element rootElement = db.parse(new InputSource(new InputStreamReader(fileUrl.openStream()))).getDocumentElement();
                Plugin plugin = new Plugin(rootElement.getAttribute("id"), rootElement.getAttribute("name"), rootElement.getAttribute("provider-name"), rootElement.getAttribute("version"), fileUrl);
                NodeList elements = rootElement.getElementsByTagName("extension");
                for (int i = 0; i < elements.getLength(); ++i) {
                    Element element = (Element)elements.item(i);
                    String point = element.getAttribute("point").trim();
                    ExtensionPoint exPoint = PluginParser.getExtensionPoint(mgr, extensionPoints, point);
                    if (exPoint == null) {
                        JPOXLogger.PLUGIN.warn(LOCALISER.msg("Plugin.ExtensionPointNotRegistered", point, plugin.getId(), fileUrl.toString()));
                        continue;
                    }
                    Extension ex = new Extension(exPoint, plugin);
                    exPoint.addExtension(ex);
                    NodeList elms = element.getChildNodes();
                    for (int e = 0; e < elms.getLength(); ++e) {
                        if (!(elms.item(e) instanceof Element)) continue;
                        ex.addConfigurationElement(PluginParser.parseConfigurationElement(ex, (Element)elms.item(e), null));
                    }
                }
            }
            catch (JPOXException ex) {
                throw ex;
            }
            catch (Exception e) {
                JPOXLogger.PLUGIN.error(LOCALISER.msg("Plugin.FileNonExistent", fileUrl.getFile()));
            }
        }
        catch (ParserConfigurationException e1) {
            JPOXLogger.PLUGIN.error(LOCALISER.msg("Plugin.ErrorReadingFile", fileUrl.getFile(), e1.getMessage()));
        }
        return extensionPoints;
    }

    private static ConfigurationElement parseConfigurationElement(Extension ex, Element element, ConfigurationElement parent) {
        ConfigurationElement confElm = new ConfigurationElement(ex, element.getNodeName(), parent);
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            confElm.putAttribute(attribute.getNodeName(), attribute.getNodeValue());
        }
        NodeList elements = element.getChildNodes();
        for (int i = 0; i < elements.getLength(); ++i) {
            if (elements.item(i) instanceof Element) {
                Element elm = (Element)elements.item(i);
                ConfigurationElement child = PluginParser.parseConfigurationElement(ex, elm, confElm);
                confElm.addConfigurationElement(child);
                continue;
            }
            if (!(elements.item(i) instanceof Text)) continue;
            confElm.setText(elements.item(i).getNodeValue());
        }
        return confElm;
    }

    private static ExtensionPoint getExtensionPoint(PluginRegistry mgr, List elements, String id) {
        ExtensionPoint point = mgr.getExtensionPoint(id);
        if (point == null) {
            for (int i = 0; i < elements.size(); ++i) {
                ExtensionPoint elm = (ExtensionPoint)elements.get(i);
                if (!elm.getUniqueId().equals(id)) continue;
                return elm;
            }
        }
        return point;
    }
}

