/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.state;

import javax.jdo.JDOFatalUserException;
import javax.jdo.spi.PersistenceCapable;
import org.jpox.ClassLoaderResolver;
import org.jpox.JDOFetchPlanImpl;
import org.jpox.ObjectManager;
import org.jpox.StateManager;
import org.jpox.exceptions.ClassNotResolvedException;
import org.jpox.exceptions.JPOXException;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.MetaDataManager;
import org.jpox.state.AbstractFetchFieldManager;
import org.jpox.state.CallbackHandler;
import org.jpox.state.LifeCycleState;
import org.jpox.store.StoreManager;
import org.jpox.store.fieldmanager.FieldManager;
import org.jpox.util.Localiser;
import org.jpox.util.StringUtils;

public abstract class AbstractStateManager
implements StateManager {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.jpox.Localisation");
    protected ObjectManager myOM;
    protected StoreManager srm;
    protected Class pcClass;
    protected PersistenceCapable myPC;
    protected AbstractClassMetaData cmd;
    protected Object myInternalID;
    protected Object myID;
    protected LifeCycleState myLC;
    protected Object myVersion;
    protected Object transactionalVersion;
    protected JDOFetchPlanImpl.FetchPlanForClass myFP;
    protected int fieldCount;
    protected boolean dirty = false;
    protected boolean[] dirtyFields;
    protected boolean[] loadedFields;
    protected boolean[] unloadedFields;
    protected boolean[] secondClassMutableFields;
    protected boolean[] nonPrimaryKeyFields;
    protected int[] allFieldNumbers;
    protected int[] allNonPrimaryKeyFieldNumbers;
    protected int[] secondClassMutableFieldNumbers;
    protected boolean restoreValues = false;
    protected FieldManager currFM = null;
    protected Object currFMmonitor = new Object();
    protected CallbackHandler callback;
    protected int pcObjectType = 0;

    public AbstractStateManager(ObjectManager om, Class pcClass) {
        this.myOM = om;
        this.pcClass = pcClass;
        this.srm = this.myOM.getStoreManager();
        ClassLoaderResolver clr = this.myOM.getClassLoaderResolver();
        if (this.myOM.getOMFContext().getTypeManager().isReferenceType(pcClass)) {
            this.cmd = this.myOM.getMetaDataManager().getMetaDataForImplementationOfReference(pcClass, null, clr);
            this.pcClass = clr.classForName(this.cmd.getFullClassName(), pcClass.getClassLoader(), true);
        } else {
            try {
                this.pcClass = clr.classForName(pcClass.getName(), pcClass.getClassLoader(), true);
                this.cmd = this.myOM.getMetaDataManager().getMetaDataForClass(pcClass, clr);
            }
            catch (ClassNotResolvedException e) {
                throw new JDOFatalUserException(LOCALISER.msg("StateManager.ClassNotFoundError", pcClass.getName()));
            }
        }
        if (this.cmd == null) {
            throw new JDOFatalUserException(LOCALISER.msg("StateManager.NotPersistableClassError", pcClass));
        }
        this.initialiseFieldInformation();
        this.myFP = ((JDOFetchPlanImpl)this.myOM.getFetchPlan()).manageFetchPlanForClass(this.cmd);
    }

    protected void initialiseFieldInformation() {
        this.fieldCount = this.cmd.getNoOfInheritedManagedFields() + this.cmd.getNoOfManagedFields();
        this.dirtyFields = new boolean[this.fieldCount];
        this.loadedFields = new boolean[this.fieldCount];
        this.unloadedFields = new boolean[this.fieldCount];
        this.secondClassMutableFields = this.cmd.getSecondClassMutableFieldFlags();
        this.nonPrimaryKeyFields = this.cmd.getNonPrimaryKeyFieldFlags();
        this.allFieldNumbers = this.cmd.getAllFieldNumbers();
        this.allNonPrimaryKeyFieldNumbers = this.cmd.getNonPrimaryKeyFieldNumbers();
        this.secondClassMutableFieldNumbers = this.cmd.getSecondClassMutableFieldNumbers();
        if (this.myOM != null) {
            this.callback = this.myOM.getCallbackHandler();
        }
    }

    public StoreManager getStoreManager() {
        return this.srm;
    }

    public AbstractClassMetaData getClassMetaData() {
        return this.cmd;
    }

    public MetaDataManager getMetaDataManager() {
        return this.myOM.getMetaDataManager();
    }

    public ObjectManager getObjectManager() {
        return this.myOM;
    }

    public PersistenceCapable getObject() {
        return this.myPC;
    }

    public LifeCycleState getLifecycleState() {
        return this.myLC;
    }

    public boolean isRestoreValues() {
        return this.restoreValues;
    }

    protected void setRestoreValues(boolean restore_values) {
        this.restoreValues = restore_values;
    }

    public Object getInternalObjectId() {
        if (this.myID != null) {
            return this.myID;
        }
        if (this.myInternalID == null) {
            this.myInternalID = super.toString();
            return this.myInternalID;
        }
        return this.myInternalID;
    }

    protected abstract boolean disconnectClone(PersistenceCapable var1);

    public boolean isDirty(PersistenceCapable pc) {
        if (this.disconnectClone(pc)) {
            return false;
        }
        return this.myLC.isDirty();
    }

    public boolean isTransactional(PersistenceCapable pc) {
        if (this.disconnectClone(pc)) {
            return false;
        }
        return this.myLC.isTransactional();
    }

    public boolean isPersistent(PersistenceCapable pc) {
        if (this.disconnectClone(pc)) {
            return false;
        }
        return this.myLC.isPersistent();
    }

    public boolean isNew(PersistenceCapable pc) {
        if (this.disconnectClone(pc)) {
            return false;
        }
        return this.myLC.isNew();
    }

    public boolean isDeleted(PersistenceCapable pc) {
        if (this.disconnectClone(pc)) {
            return false;
        }
        return this.myLC.isDeleted();
    }

    public Object getVersion(PersistenceCapable pc) {
        if (pc == this.myPC) {
            return this.transactionalVersion;
        }
        return null;
    }

    public void setTransactionalVersion(Object version) {
        this.transactionalVersion = version;
    }

    public Object getTransactionalVersion(PersistenceCapable pc) {
        return this.transactionalVersion;
    }

    public void setVersion(Object version) {
        this.myVersion = version;
        this.transactionalVersion = version;
    }

    public boolean isEmbedded() {
        return this.pcObjectType > 0;
    }

    public void setPcObjectType(int embeddedType) {
        this.pcObjectType = embeddedType;
    }

    public int getPcObjectType() {
        return this.pcObjectType;
    }

    public int getHighestFieldNumber() {
        return this.fieldCount;
    }

    protected boolean isFetchPlanLoaded() {
        int[] fpFields = this.myFP.getFieldsInActualFetchPlan();
        for (int i = 0; i < fpFields.length; ++i) {
            if (this.loadedFields[fpFields[i]]) continue;
            return false;
        }
        return true;
    }

    public String[] getDirtyFieldNames() {
        int[] dirtyFieldNumbers = AbstractStateManager.getFlagsSetTo(this.dirtyFields, true);
        if (dirtyFieldNumbers != null && dirtyFieldNumbers.length > 0) {
            String[] dirtyFieldNames = new String[dirtyFieldNumbers.length];
            for (int i = 0; i < dirtyFieldNumbers.length; ++i) {
                dirtyFieldNames[i] = this.cmd.getManagedFieldAbsolute(dirtyFieldNumbers[i]).getName();
            }
            return dirtyFieldNames;
        }
        return null;
    }

    public String[] getLoadedFieldNames() {
        int[] loadedFieldNumbers = AbstractStateManager.getFlagsSetTo(this.loadedFields, true);
        if (loadedFieldNumbers != null && loadedFieldNumbers.length > 0) {
            String[] loadedFieldNames = new String[loadedFieldNumbers.length];
            for (int i = 0; i < loadedFieldNumbers.length; ++i) {
                loadedFieldNames[i] = this.cmd.getManagedFieldAbsolute(loadedFieldNumbers[i]).getName();
            }
            return loadedFieldNames;
        }
        return null;
    }

    protected void clearDirtyFlags() {
        this.dirty = false;
        AbstractStateManager.clearFlags(this.dirtyFields);
    }

    protected void clearDirtyFlags(int[] fields) {
        this.dirty = false;
        AbstractStateManager.clearFlags(this.dirtyFields, fields);
    }

    public void providedBooleanField(PersistenceCapable pc, int field, boolean currentValue) {
        this.currFM.storeBooleanField(field, currentValue);
    }

    public void providedByteField(PersistenceCapable pc, int field, byte currentValue) {
        this.currFM.storeByteField(field, currentValue);
    }

    public void providedCharField(PersistenceCapable pc, int field, char currentValue) {
        this.currFM.storeCharField(field, currentValue);
    }

    public void providedDoubleField(PersistenceCapable pc, int field, double currentValue) {
        this.currFM.storeDoubleField(field, currentValue);
    }

    public void providedFloatField(PersistenceCapable pc, int field, float currentValue) {
        this.currFM.storeFloatField(field, currentValue);
    }

    public void providedIntField(PersistenceCapable pc, int field, int currentValue) {
        this.currFM.storeIntField(field, currentValue);
    }

    public void providedLongField(PersistenceCapable pc, int field, long currentValue) {
        this.currFM.storeLongField(field, currentValue);
    }

    public void providedShortField(PersistenceCapable pc, int field, short currentValue) {
        this.currFM.storeShortField(field, currentValue);
    }

    public void providedStringField(PersistenceCapable pc, int field, String currentValue) {
        this.currFM.storeStringField(field, currentValue);
    }

    public void providedObjectField(PersistenceCapable pc, int fieldNumber, Object currentValue) {
        this.currFM.storeObjectField(fieldNumber, currentValue);
    }

    public boolean replacingBooleanField(PersistenceCapable pc, int field) {
        boolean value = this.currFM.fetchBooleanField(field);
        this.loadedFields[field] = true;
        return value;
    }

    public byte replacingByteField(PersistenceCapable obj, int field) {
        byte value = this.currFM.fetchByteField(field);
        this.loadedFields[field] = true;
        return value;
    }

    public char replacingCharField(PersistenceCapable obj, int field) {
        char value = this.currFM.fetchCharField(field);
        this.loadedFields[field] = true;
        return value;
    }

    public double replacingDoubleField(PersistenceCapable obj, int field) {
        double value = this.currFM.fetchDoubleField(field);
        this.loadedFields[field] = true;
        return value;
    }

    public float replacingFloatField(PersistenceCapable obj, int field) {
        float value = this.currFM.fetchFloatField(field);
        this.loadedFields[field] = true;
        return value;
    }

    public int replacingIntField(PersistenceCapable obj, int field) {
        int value = this.currFM.fetchIntField(field);
        this.loadedFields[field] = true;
        return value;
    }

    public long replacingLongField(PersistenceCapable obj, int field) {
        long value = this.currFM.fetchLongField(field);
        this.loadedFields[field] = true;
        return value;
    }

    public short replacingShortField(PersistenceCapable obj, int field) {
        short value = this.currFM.fetchShortField(field);
        this.loadedFields[field] = true;
        return value;
    }

    public String replacingStringField(PersistenceCapable obj, int field) {
        String value = this.currFM.fetchStringField(field);
        this.loadedFields[field] = true;
        return value;
    }

    public Object replacingObjectField(PersistenceCapable obj, int field) {
        try {
            Object value = this.currFM.fetchObjectField(field);
            this.loadedFields[field] = true;
            return value;
        }
        catch (AbstractFetchFieldManager.EndOfFetchPlanGraphException eodge) {
            return null;
        }
    }

    public boolean getBooleanField(PersistenceCapable pc, int field, boolean currentValue) {
        throw new JPOXException(LOCALISER.msg("StateManager.MethodNotSupported"));
    }

    public byte getByteField(PersistenceCapable pc, int field, byte currentValue) {
        throw new JPOXException(LOCALISER.msg("StateManager.MethodNotSupported"));
    }

    public char getCharField(PersistenceCapable pc, int field, char currentValue) {
        throw new JPOXException(LOCALISER.msg("StateManager.MethodNotSupported"));
    }

    public double getDoubleField(PersistenceCapable pc, int field, double currentValue) {
        throw new JPOXException(LOCALISER.msg("StateManager.MethodNotSupported"));
    }

    public float getFloatField(PersistenceCapable pc, int field, float currentValue) {
        throw new JPOXException(LOCALISER.msg("StateManager.MethodNotSupported"));
    }

    public int getIntField(PersistenceCapable pc, int field, int currentValue) {
        throw new JPOXException(LOCALISER.msg("StateManager.MethodNotSupported"));
    }

    public long getLongField(PersistenceCapable pc, int field, long currentValue) {
        throw new JPOXException(LOCALISER.msg("StateManager.MethodNotSupported"));
    }

    public short getShortField(PersistenceCapable pc, int field, short currentValue) {
        throw new JPOXException(LOCALISER.msg("StateManager.MethodNotSupported"));
    }

    public String getStringField(PersistenceCapable pc, int field, String currentValue) {
        throw new JPOXException(LOCALISER.msg("StateManager.MethodNotSupported"));
    }

    public Object getObjectField(PersistenceCapable pc, int field, Object currentValue) {
        throw new JPOXException(LOCALISER.msg("StateManager.MethodNotSupported"));
    }

    protected static boolean equals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    protected static void clearFlags(boolean[] flags) {
        for (int i = 0; i < flags.length; ++i) {
            flags[i] = false;
        }
    }

    protected static void clearFlags(boolean[] flags, int[] fields) {
        for (int i = 0; i < fields.length; ++i) {
            flags[fields[i]] = false;
        }
    }

    protected static int[] getFlagsSetTo(boolean[] flags, boolean state) {
        int[] temp = new int[flags.length];
        int j = 0;
        for (int i = 0; i < flags.length; ++i) {
            if (flags[i] != state) continue;
            temp[j++] = i;
        }
        if (j != 0) {
            int[] fieldNumbers = new int[j];
            System.arraycopy(temp, 0, fieldNumbers, 0, j);
            return fieldNumbers;
        }
        return null;
    }

    protected static int[] getFlagsSetTo(boolean[] flags, int[] indices, boolean state) {
        int[] temp = new int[indices.length];
        int j = 0;
        for (int i = 0; i < indices.length; ++i) {
            if (flags[indices[i]] != state) continue;
            temp[j++] = indices[i];
        }
        if (j != 0) {
            int[] fieldNumbers = new int[j];
            System.arraycopy(temp, 0, fieldNumbers, 0, j);
            return fieldNumbers;
        }
        return null;
    }

    protected static Object peekField(Object obj, String fieldName) {
        try {
            Object value = obj.getClass().getDeclaredField(fieldName).get(obj);
            if (value instanceof PersistenceCapable) {
                return StringUtils.toJVMIDString(value);
            }
            return value;
        }
        catch (Exception e) {
            return e.toString();
        }
    }
}

