/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.state;

import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jdo.FetchPlan;
import javax.jdo.JDOException;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.JDOFatalUserException;
import javax.jdo.JDOUserException;
import javax.jdo.PersistenceManager;
import javax.jdo.spi.Detachable;
import javax.jdo.spi.JDOImplHelper;
import javax.jdo.spi.PersistenceCapable;
import org.jpox.ClassLoaderResolver;
import org.jpox.JDOFetchPlanImpl;
import org.jpox.ObjectManager;
import org.jpox.StateManager;
import org.jpox.Transaction;
import org.jpox.cache.CachedPC;
import org.jpox.exceptions.ClassNotResolvedException;
import org.jpox.exceptions.JPOXException;
import org.jpox.exceptions.JPOXObjectNotFoundException;
import org.jpox.jdo.JPOXJDOHelper;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.AbstractPropertyMetaData;
import org.jpox.metadata.FieldMetaData;
import org.jpox.metadata.IdentityStrategy;
import org.jpox.metadata.IdentityType;
import org.jpox.metadata.MetaDataUtils;
import org.jpox.sco.SCO;
import org.jpox.sco.SCOCollection;
import org.jpox.sco.SCOContainer;
import org.jpox.sco.SCOMap;
import org.jpox.sco.SCOUtils;
import org.jpox.sco.UnsetOwners;
import org.jpox.state.AbstractFetchFieldManager;
import org.jpox.state.AbstractStateManager;
import org.jpox.state.ActivityState;
import org.jpox.state.AttachFieldManager;
import org.jpox.state.DetachFieldManager;
import org.jpox.state.FetchPlanState;
import org.jpox.state.LoadFieldManager;
import org.jpox.state.MakeTransientFieldManager;
import org.jpox.state.NullifyRelationFieldManager;
import org.jpox.store.DatastoreClass;
import org.jpox.store.FieldValues;
import org.jpox.store.OID;
import org.jpox.store.OIDFactory;
import org.jpox.store.exceptions.NotYetFlushedException;
import org.jpox.store.fieldmanager.FieldManager;
import org.jpox.store.fieldmanager.SingleTypeFieldManager;
import org.jpox.store.fieldmanager.SingleValueFieldManager;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.util.AIDUtils;
import org.jpox.util.ClassUtils;
import org.jpox.util.JPOXLogger;
import org.jpox.util.StringUtils;
import org.jpox.util.TypeConversionHelper;

final class JDOStateManagerImpl
extends AbstractStateManager
implements javax.jdo.spi.StateManager {
    private static final JDOImplHelper HELPER;
    private static final SingleTypeFieldManager HOLLOWFIELDMANAGER;
    private byte jdoFlags;
    private BitSet jdoLoadedFields;
    private BitSet jdoModifiedFields;
    private PersistenceCapable savedImage = null;
    private byte savedFlags;
    private boolean[] savedLoadedFields = null;
    private boolean flushedNew = false;
    private ActivityState inserting = ActivityState.NONE;
    private boolean flushing = false;
    private boolean changingState = false;
    private boolean postLoadPending = false;
    private boolean disconnecting = false;
    private boolean deleting = false;
    private boolean detaching = false;
    private PersistenceCapable detachingPC = null;
    private boolean attaching = false;
    private PersistenceCapable attachedPC = null;
    private List insertionNotifyList = new ArrayList();
    private Map insertionUpdateFieldList = new HashMap();
    private List embeddedOwners = null;
    private HashMap externalFieldValuesByMapping = new HashMap();
    boolean loadingFieldsInFetchPlan = false;
    private boolean updatingEmbeddedFieldsWithOwner = false;
    private DatastoreClass latestInsertedDatastoreClass = null;
    private boolean storingPC = false;
    private boolean retrievingDetachedState = false;
    private boolean resettingDetachedState = false;
    static /* synthetic */ Class class$javax$jdo$spi$PersistenceCapable;
    static /* synthetic */ Class class$java$lang$Object;

    public JDOStateManagerImpl(ObjectManager om, Class pcClass) {
        super(om, pcClass);
    }

    public void initialiseForHollow(Object id, FieldValues fv) {
        this.myID = id;
        this.myLC = this.myOM.getOMFContext().getApiAdapter().getLifeCycleState(4);
        this.jdoFlags = 1;
        this.myPC = id instanceof OID || id == null ? HELPER.newInstance(this.pcClass, (javax.jdo.spi.StateManager)this) : HELPER.newInstance(this.pcClass, (javax.jdo.spi.StateManager)this, this.myID);
        if (fv != null) {
            this.loadFieldValues(fv);
        }
    }

    public void initialiseForHollowAppId(FieldValues fv) {
        if (this.cmd.getIdentityType() != IdentityType.APPLICATION) {
            throw new JDOFatalUserException("This constructor is only for objects using application identity.");
        }
        this.myLC = this.myOM.getOMFContext().getApiAdapter().getLifeCycleState(4);
        this.jdoFlags = 1;
        this.myPC = HELPER.newInstance(this.pcClass, (javax.jdo.spi.StateManager)this);
        if (this.myPC == null) {
            if (!HELPER.getRegisteredClasses().contains(this.pcClass)) {
                throw new JDOFatalUserException(LOCALISER.msg("StateManager.ClassNotRegistered", this.pcClass.getName()));
            }
            throw new JDOFatalUserException(LOCALISER.msg("StateManager.ClassNotConstructable", this.pcClass.getName()));
        }
        this.loadFieldValues(fv);
        this.myID = this.myPC.jdoNewObjectIdInstance();
        if (!this.cmd.usesSingleFieldIdentityClass()) {
            this.myPC.jdoCopyKeyFieldsToObjectId(this.myID);
        }
    }

    public void initialiseForPersistentClean(Object id, PersistenceCapable pc) {
        this.myID = id;
        this.myLC = this.myOM.getOMFContext().getApiAdapter().getLifeCycleState(2);
        this.jdoFlags = 1;
        this.myPC = pc;
        this.replaceStateManager(this);
        this.myPC.jdoReplaceFlags();
        for (int i = 0; i < this.loadedFields.length; ++i) {
            this.loadedFields[i] = true;
        }
        this.myOM.putObjectIntoCache(this, true, true);
    }

    public void initialiseForEmbedded(PersistenceCapable pc, boolean copyPc) {
        this.pcObjectType = 1;
        this.myID = null;
        this.myLC = this.myOM.getOMFContext().getApiAdapter().getLifeCycleState(1);
        this.jdoFlags = 1;
        this.myPC = pc;
        this.replaceStateManager(this);
        if (copyPc) {
            PersistenceCapable pcCopy = this.myPC.jdoNewInstance((javax.jdo.spi.StateManager)this);
            pcCopy.jdoCopyFields((Object)this.myPC, this.allFieldNumbers);
            pcCopy.jdoReplaceStateManager((javax.jdo.spi.StateManager)this);
            this.myPC = pcCopy;
            this.disconnectClone(pc);
        }
        for (int i = 0; i < this.loadedFields.length; ++i) {
            this.loadedFields[i] = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialiseForPersistentNew(PersistenceCapable pc, FieldValues preInsertChanges) {
        this.myPC = pc;
        this.myLC = this.myOM.getOMFContext().getApiAdapter().getLifeCycleState(1);
        this.jdoFlags = (byte)-1;
        for (int i = 0; i < this.loadedFields.length; ++i) {
            this.loadedFields[i] = true;
        }
        this.replaceStateManager(this);
        this.myPC.jdoReplaceFlags();
        this.saveFields();
        this.populateStrategyFields();
        if (preInsertChanges != null) {
            preInsertChanges.fetchFields(this);
        }
        if (this.cmd.getIdentityType() == IdentityType.APPLICATION) {
            for (int fieldNumber = 0; fieldNumber < this.allFieldNumbers.length; ++fieldNumber) {
                AbstractPropertyMetaData fmd = this.cmd.getManagedFieldAbsolute(fieldNumber);
                if (!fmd.isPrimaryKey() || this.myOM.getMetaDataManager().getMetaDataForClass(fmd.getType(), this.getObjectManager().getClassLoaderResolver()) == null) continue;
                Object object = this.currFMmonitor;
                synchronized (object) {
                    FieldManager prevFM = this.currFM;
                    try {
                        this.currFM = new SingleValueFieldManager();
                        this.myPC.jdoProvideField(fieldNumber);
                        PersistenceCapable pkFieldPC = (PersistenceCapable)((SingleValueFieldManager)this.currFM).fetchObjectField(fieldNumber);
                        if (pkFieldPC == null) {
                            throw new JDOUserException(LOCALISER.msg("StateManager.PrimaryKeyFieldIsNull", fmd.getFullFieldName()));
                        }
                        if (!pkFieldPC.jdoIsPersistent()) {
                            this.myOM.persistObjectInternal(pkFieldPC, null);
                        }
                    }
                    finally {
                        this.currFM = prevFM;
                    }
                    continue;
                }
            }
        }
        this.setIdentity();
        if (this.getObjectManager().getTransaction().isActive()) {
            this.myOM.enlistInTransaction(this);
        }
        this.callback.postCreate(this.myPC);
    }

    public void initialiseForTransactionalTransient(PersistenceCapable pc) {
        this.myPC = pc;
        this.myLC = null;
        this.jdoFlags = (byte)-1;
        for (int i = 0; i < this.loadedFields.length; ++i) {
            this.loadedFields[i] = true;
        }
        this.myPC.jdoReplaceFlags();
        this.populateStrategyFields();
        this.setIdentity();
        if (this.myOM.getTransaction().isActive()) {
            this.myOM.enlistInTransaction(this);
        }
    }

    public void initialiseForDetached(PersistenceCapable pc, Object id, Object version) {
        this.myID = id;
        this.myPC = pc;
        this.setVersion(version);
        this.myLC = this.myOM.getOMFContext().getApiAdapter().getLifeCycleState(11);
        this.srm = null;
        this.myFP = null;
        this.myPC.jdoReplaceFlags();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialiseForCachedPC(PersistenceCapable pc, Object id, boolean[] loaded) {
        this.initialiseForHollow(id, null);
        this.myLC = this.myOM.getOMFContext().getApiAdapter().getLifeCycleState(2);
        this.jdoFlags = (byte)-1;
        PersistenceCapable persistenceCapable = pc;
        synchronized (persistenceCapable) {
            int i;
            pc.jdoReplaceStateManager((javax.jdo.spi.StateManager)this);
            this.myPC.jdoCopyFields((Object)pc, this.allFieldNumbers);
            for (i = 0; i < this.loadedFields.length; ++i) {
                this.loadedFields[i] = loaded[i];
            }
            for (i = 0; i < this.cmd.getPersistenceCapableFieldNumbers().length; ++i) {
                this.loadedFields[this.cmd.getPersistenceCapableFieldNumbers()[i]] = false;
            }
            for (i = 0; i < this.secondClassMutableFieldNumbers.length; ++i) {
                this.loadedFields[this.secondClassMutableFieldNumbers[i]] = false;
            }
            this.disconnectClone(pc);
        }
        if (this.isFetchPlanLoaded()) {
            this.postLoad();
        }
    }

    public void checkInheritance(FieldValues fv) {
        ClassLoaderResolver clr = this.myOM.getClassLoaderResolver();
        String className = this.srm.getClassNameForObjectID(this.myID, clr, this.myOM);
        if (className == null) {
            throw new JPOXObjectNotFoundException(LOCALISER.msg("StateManager.ObjectDoesntExist"), this.myID);
        }
        if (!this.cmd.getFullClassName().equals(className)) {
            Class pcClass;
            try {
                pcClass = this.getObjectManager().getClassLoaderResolver().classForName(className, this.myID.getClass().getClassLoader(), true);
                this.cmd = this.myOM.getMetaDataManager().getMetaDataForClass(pcClass, this.getObjectManager().getClassLoaderResolver());
            }
            catch (ClassNotResolvedException e) {
                JPOXLogger.JDO.warn(LOCALISER.msg("StateManager.GetObjectByIdClassNotFound", this.myID));
                throw new JDOUserException(LOCALISER.msg("StateManager.GetObjectByIdClassNotFound", this.myID), (Throwable)e);
            }
            if (this.cmd == null) {
                throw new JDOFatalUserException(LOCALISER.msg("StateManager.NotPersistableClassError", pcClass));
            }
            if (this.cmd.getIdentityType() != IdentityType.APPLICATION) {
                throw new JDOFatalUserException("This method should only be used for objects using application identity.");
            }
            this.myFP = ((JDOFetchPlanImpl)this.myOM.getFetchPlan()).manageFetchPlanForClass(this.cmd);
            this.initialiseFieldInformation();
            this.myPC = HELPER.newInstance(pcClass, (javax.jdo.spi.StateManager)this);
            if (this.myPC == null) {
                throw new JDOFatalUserException(LOCALISER.msg("StateManager.ClassNotRegistered", this.cmd.getFullClassName()));
            }
            this.loadFieldValues(fv);
            this.myID = this.myPC.jdoNewObjectIdInstance();
            if (!this.cmd.usesSingleFieldIdentityClass()) {
                this.myPC.jdoCopyKeyFieldsToObjectId(this.myID);
            }
        }
    }

    private void populateStrategyFields() {
        int totalFieldCount = this.cmd.getNoOfInheritedManagedFields() + this.cmd.getNoOfManagedFields();
        DatastoreClass table = null;
        if (!this.cmd.isEmbeddedOnly() && this.srm.usesDatastoreClass()) {
            table = this.srm.getDatastoreClass(this.cmd.getFullClassName(), this.myOM.getClassLoaderResolver());
        }
        for (int fieldNumber = 0; fieldNumber < totalFieldCount; ++fieldNumber) {
            AbstractPropertyMetaData fmd = this.cmd.getManagedFieldAbsolute(fieldNumber);
            IdentityStrategy strategy = fmd.getValueStrategy();
            if (strategy == null || this.srm.isStrategyDatastoreAttributed(strategy, false)) continue;
            boolean applyStrategy = true;
            if (!fmd.getType().isPrimitive() && strategy != null && fmd.hasExtension("strategy-when-notnull") && fmd.getValueForExtension("strategy-when-notnull").equalsIgnoreCase("false") && this.provideField(fieldNumber) != null) {
                applyStrategy = false;
            }
            if (!applyStrategy) continue;
            DatastoreClass fieldTable = null;
            if (this.srm.usesDatastoreClass()) {
                fieldTable = table.getBaseDatastoreClassWithField(fmd);
            }
            Object obj = this.srm.getStrategyValue(this.myOM, fieldTable, this.cmd, fieldNumber);
            this.replaceField(fieldNumber, obj, true);
        }
    }

    public void loadFieldValues(FieldValues fv) {
        JDOFetchPlanImpl.FetchPlanForClass origFetchPlan = this.myFP;
        JDOFetchPlanImpl loadFetchPlan = fv.getFetchPlanForLoading();
        if (loadFetchPlan != null) {
            this.myFP = loadFetchPlan.manageFetchPlanForClass(this.cmd);
        }
        boolean callPostLoad = this.myFP.isToCallPostLoadFetchPlan(this.loadedFields);
        fv.fetchFields(this);
        if (callPostLoad && this.isFetchPlanLoaded()) {
            this.postLoad();
        }
        this.myFP = origFetchPlan;
    }

    private void setIdentity() {
        if (this.cmd.getIdentityType() == IdentityType.APPLICATION) {
            boolean isObjectIDDatastoreAttributed = false;
            int totalFieldCount = this.cmd.getNoOfInheritedManagedFields() + this.cmd.getNoOfManagedFields();
            for (int fieldNumber = 0; fieldNumber < totalFieldCount; ++fieldNumber) {
                AbstractPropertyMetaData fmd = this.cmd.getManagedFieldAbsolute(fieldNumber);
                if (!fmd.isPrimaryKey()) continue;
                if (this.srm.isStrategyDatastoreAttributed(fmd.getValueStrategy(), false)) {
                    isObjectIDDatastoreAttributed = true;
                    break;
                }
                if (!this.cmd.usesSingleFieldIdentityClass() || this.provideField(fieldNumber) != null) continue;
                throw new JDOFatalUserException(LOCALISER.msg("StateManager.SingleFieldIdentityPKFieldIsNull", this.cmd.getFullClassName(), fmd.getName()));
            }
            if (!isObjectIDDatastoreAttributed) {
                this.myID = this.srm.newObjectID(this.myOM, this.cmd.getFullClassName(), this.myPC);
            }
        } else if (this.cmd.getIdentityMetaData() == null || !this.srm.isStrategyDatastoreAttributed(this.cmd.getIdentityMetaData().getStrategyValue(), true)) {
            this.myID = this.srm.newObjectID(this.myOM, this.cmd.getFullClassName(), this.myPC);
        }
        if (this.myInternalID != this.myID && this.myID != null) {
            this.myOM.replaceObjectId(this.myPC, this.myInternalID, this.myID);
        }
    }

    public CachedPC getL2CacheableObject() {
        PersistenceCapable pcCopy = this.myPC.jdoNewInstance((javax.jdo.spi.StateManager)this, this.myPC.jdoGetObjectId());
        int[] containerFieldNumbers = this.cmd.getSecondClassContainerFieldNumbers();
        int[] noncontainerFieldNumbers = new int[this.allFieldNumbers.length - containerFieldNumbers.length];
        boolean[] l2loadedFields = new boolean[this.allFieldNumbers.length];
        int nonNum = 0;
        for (int i = 0; i < this.allFieldNumbers.length; ++i) {
            boolean noncontainer = true;
            for (int j = 0; j < containerFieldNumbers.length; ++j) {
                if (containerFieldNumbers[j] != this.allFieldNumbers[i]) continue;
                noncontainer = false;
                break;
            }
            if (noncontainer) {
                noncontainerFieldNumbers[nonNum++] = this.allFieldNumbers[i];
                l2loadedFields[i] = noncontainer && this.loadedFields[i];
                continue;
            }
            l2loadedFields[i] = false;
        }
        pcCopy.jdoCopyFields((Object)this.myPC, noncontainerFieldNumbers);
        pcCopy.jdoReplaceFlags();
        pcCopy.jdoReplaceStateManager(null);
        return new CachedPC(pcCopy, l2loadedFields);
    }

    public void replaceManagedPC(PersistenceCapable pc) {
        if (pc == null) {
            return;
        }
        pc.jdoReplaceStateManager((javax.jdo.spi.StateManager)this);
        for (int i = 0; i < this.loadedFields.length; ++i) {
            this.loadedFields[i] = true;
        }
        this.myPC.jdoReplaceStateManager(null);
        this.myPC = pc;
        this.myOM.putObjectIntoCache(this, true, true);
    }

    public void copyFieldsFromObject(PersistenceCapable pc, int[] fieldNumbers) {
        if (pc == null) {
            return;
        }
        if (!pc.getClass().getName().equals(this.myPC.getClass().getName())) {
            return;
        }
        pc.jdoReplaceStateManager((javax.jdo.spi.StateManager)this);
        this.myPC.jdoCopyFields((Object)pc, fieldNumbers);
        pc.jdoReplaceStateManager(null);
        for (int i = 0; i < fieldNumbers.length; ++i) {
            this.loadedFields[fieldNumbers[i]] = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.flush();
        }
        finally {
            super.finalize();
        }
    }

    private void replaceStateManager(javax.jdo.spi.StateManager sm) {
        try {
            this.myPC.jdoReplaceStateManager(sm);
        }
        catch (SecurityException e) {
            throw new JDOFatalUserException(LOCALISER.msg("StateManager.SecurityProblem"), (Throwable)e);
        }
    }

    public void enlistInTransaction() {
        if (!this.getObjectManager().getTransaction().isActive()) {
            return;
        }
        this.myOM.enlistInTransaction(this);
        if (this.jdoFlags == 1 && this.isFetchPlanLoaded()) {
            this.jdoFlags = (byte)-1;
            this.myPC.jdoReplaceFlags();
        }
    }

    public void evictFromTransaction() {
        this.myOM.evictFromTransaction(this);
        this.jdoFlags = 1;
        this.myPC.jdoReplaceFlags();
    }

    public void saveFields() {
        this.savedImage = this.myPC.jdoNewInstance((javax.jdo.spi.StateManager)this);
        this.savedImage.jdoCopyFields((Object)this.myPC, this.allFieldNumbers);
        this.savedFlags = this.jdoFlags;
        this.savedLoadedFields = (boolean[])this.loadedFields.clone();
    }

    public void restoreFields() {
        if (this.savedImage != null) {
            this.loadedFields = this.savedLoadedFields;
            this.jdoFlags = this.savedFlags;
            this.myPC.jdoReplaceFlags();
            this.myPC.jdoCopyFields((Object)this.savedImage, this.allFieldNumbers);
            this.clearDirtyFlags();
            this.clearSavedFields();
        }
    }

    public void clearFields() {
        this.clearFieldsByNumbers(this.allFieldNumbers);
    }

    public void clearNonPrimaryKeyFields() {
        this.clearFieldsByNumbers(this.allNonPrimaryKeyFieldNumbers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearFieldsByNumbers(int[] fieldNumbers) {
        try {
            this.callback.preClear(this.myPC);
        }
        finally {
            this.replaceFields(fieldNumbers, HOLLOWFIELDMANAGER);
            this.clearLoadedFlags();
            this.clearDirtyFlags();
            this.callback.postClear(this.myPC);
        }
    }

    public void clearSavedFields() {
        this.savedImage = null;
        this.savedFlags = 0;
        this.savedLoadedFields = null;
    }

    public void clearLoadedFlags() {
        this.jdoFlags = 1;
        this.myPC.jdoReplaceFlags();
        JDOStateManagerImpl.clearFlags(this.loadedFields);
    }

    public void makeDirty(int field) {
        boolean wasDirty = this.preWriteField(field);
        this.postWriteField(wasDirty);
    }

    public void makeDirty(PersistenceCapable pc, String fieldName) {
        if (!this.disconnectClone(pc)) {
            int fieldNumber = this.cmd.getFieldNumberAbsolute(fieldName);
            if (fieldNumber == -1) {
                throw new JDOUserException(LOCALISER.msg("StateManager.InvalidFieldForClass", fieldName, this.cmd.getFullClassName()));
            }
            this.makeDirty(fieldNumber);
        }
    }

    public PersistenceManager getPersistenceManager(PersistenceCapable pc) {
        if (this.myPC != null && this.disconnectClone(pc)) {
            return null;
        }
        if (this.myOM == null) {
            return null;
        }
        this.myOM.hereIsStateManager(this, this.myPC);
        return (PersistenceManager)this.myOM.getOwner();
    }

    public Object getObjectId(PersistenceCapable pc) {
        if (this.disconnectClone(pc)) {
            return null;
        }
        return this.getExternalObjectId(pc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPostStoreNewObjectId(Object id) {
        if (this.cmd.getIdentityType() == IdentityType.APPLICATION) {
            try {
                this.myID = null;
                int fieldNumber = 0;
                for (fieldNumber = 0; fieldNumber < this.fieldCount; ++fieldNumber) {
                    AbstractPropertyMetaData fmd = this.cmd.getManagedFieldAbsolute(fieldNumber);
                    if (!fmd.isPrimaryKey() || !this.srm.isStrategyDatastoreAttributed(fmd.getValueStrategy(), false)) continue;
                    this.replaceField(fieldNumber, TypeConversionHelper.convertTo(id, fmd.getType()), true);
                }
            }
            catch (Exception e) {
                JPOXLogger.JDO.error(e);
            }
            finally {
                this.myID = AIDUtils.getNewObjectId(this.getObject(), this.cmd);
            }
        } else {
            this.myID = OIDFactory.getInstance(this.myOM, this.cmd.getFullClassName(), id);
        }
        if (this.myInternalID != this.myID && this.myID != null) {
            this.myOM.replaceObjectId(this.myPC, this.myInternalID, this.myID);
        }
    }

    public Object getExternalObjectId(PersistenceCapable pc) {
        if (this.cmd.getIdentityType() == IdentityType.APPLICATION) {
            if (!this.flushing && !this.flushedNew && this.inserting == ActivityState.NONE && this.myLC.stateType() == 1) {
                int[] pkFieldNumbers = this.cmd.getPrimaryKeyFieldNumbers();
                for (int i = 0; i < pkFieldNumbers.length; ++i) {
                    AbstractPropertyMetaData fmd = this.cmd.getManagedFieldAbsolute(i);
                    if (!this.srm.isStrategyDatastoreAttributed(fmd.getValueStrategy(), false)) continue;
                    this.flush();
                    break;
                }
            }
            if (this.cmd.usesSingleFieldIdentityClass()) {
                return this.myID;
            }
            return AIDUtils.getNewObjectId(this.myPC, this.cmd);
        }
        if (this.cmd.getIdentityType() == IdentityType.DATASTORE && !this.flushing && !this.flushedNew && this.inserting == ActivityState.NONE && this.myLC.stateType() == 1 && this.srm.isStrategyDatastoreAttributed(this.cmd.getIdentityMetaData().getStrategyValue(), true)) {
            this.flush();
        }
        return this.myID;
    }

    public javax.jdo.spi.StateManager replacingStateManager(PersistenceCapable pc, javax.jdo.spi.StateManager sm) {
        if (this.myLC == null) {
            throw new JDOFatalInternalException("Null LifeCycleState");
        }
        if (this.myLC.stateType() == 11) {
            return sm;
        }
        if (pc == this.myPC) {
            if (sm == null) {
                return null;
            }
            if (sm == this) {
                return this;
            }
            if (this.myOM == ((AbstractStateManager)sm).myOM) {
                ((JDOStateManagerImpl)sm).disconnect();
                return this;
            }
            if (sm != null) {
                throw new JDOUserException(LOCALISER.msg("StateManager.StateManagerChangeError"));
            }
            if (!this.disconnecting) {
                throw new JDOUserException(LOCALISER.msg("StateManager.StateManagerDisconnectError"));
            }
            if (JPOXLogger.JDO.isDebugEnabled()) {
                JPOXLogger.JDO.debug(LOCALISER.msg("StateManager.ClearingStateManager", StringUtils.toJVMIDString(pc)));
            }
            return null;
        }
        if (pc == this.savedImage) {
            return null;
        }
        return sm;
    }

    public Object getTransactionalObjectId(PersistenceCapable pc) {
        return this.getObjectId(pc);
    }

    private void loadSCONonContainerFields() {
        int[] noncontainerFieldNumbers = this.cmd.getSecondClassNonContainerFieldNumbers();
        int[] fieldNumbers = JDOStateManagerImpl.getFlagsSetTo(this.loadedFields, noncontainerFieldNumbers, false);
        if (fieldNumbers != null) {
            this.srm.fetch(this, fieldNumbers);
            this.myOM.putObjectIntoCache(this, false, true);
        }
    }

    private void loadSpecifiedFields(int[] fieldNumbers) {
        if (this.srm == null) {
            return;
        }
        if (!this.isEmbedded()) {
            this.srm.fetch(this, fieldNumbers);
        }
        this.myOM.putObjectIntoCache(this, false, true);
    }

    public void loadUnloadedFields() {
        int[] fieldNumbers = JDOStateManagerImpl.getFlagsSetTo(this.loadedFields, this.allFieldNumbers, false);
        if (fieldNumbers != null) {
            boolean callPostLoad = this.myFP.isToCallPostLoadFetchPlan(this.loadedFields);
            this.srm.fetch(this, fieldNumbers);
            for (int i = 0; i < this.secondClassMutableFieldNumbers.length; ++i) {
                SingleValueFieldManager sfv = new SingleValueFieldManager();
                this.provideFields(new int[]{this.secondClassMutableFieldNumbers[i]}, sfv);
                Object value = sfv.fetchObjectField(i);
                if (!(value instanceof SCOContainer)) continue;
                ((SCOContainer)value).load();
            }
            if (callPostLoad) {
                this.postLoad();
            }
            this.myOM.putObjectIntoCache(this, false, true);
        }
    }

    public void loadFieldsInFetchPlan(FetchPlanState state) {
        if (this.loadingFieldsInFetchPlan) {
            return;
        }
        this.loadingFieldsInFetchPlan = true;
        this.loadUnloadedFieldsInFetchPlan();
        int[] fieldNumbers = JDOStateManagerImpl.getFlagsSetTo(this.loadedFields, this.allFieldNumbers, true);
        if (fieldNumbers != null && fieldNumbers.length > 0) {
            this.replaceFields(fieldNumbers, new LoadFieldManager(this, this.secondClassMutableFields, this.myFP, state));
        }
        this.loadingFieldsInFetchPlan = false;
    }

    public void loadUnloadedFieldsInFetchPlan() {
        int[] fieldNumbers = JDOStateManagerImpl.getFlagsSetTo(this.loadedFields, this.myFP.getFieldsInActualFetchPlan(), false);
        if (fieldNumbers != null) {
            boolean callPostLoad = this.myFP.isToCallPostLoadFetchPlan(this.loadedFields);
            this.srm.fetch(this, fieldNumbers);
            if (callPostLoad) {
                this.postLoad();
            }
            this.myOM.putObjectIntoCache(this, false, true);
        }
    }

    public void loadUnloadedFieldsOfClassInFetchPlan(FetchPlan fetchPlan) {
        JDOFetchPlanImpl.FetchPlanForClass fpc = ((JDOFetchPlanImpl)fetchPlan).manageFetchPlanForClass(this.cmd);
        int[] fieldNumbers = JDOStateManagerImpl.getFlagsSetTo(this.loadedFields, fpc.getFieldsInActualFetchPlan(), false);
        if (fieldNumbers != null) {
            boolean callPostLoad = fpc.isToCallPostLoadFetchPlan(this.loadedFields);
            this.srm.fetch(this, fieldNumbers);
            if (callPostLoad) {
                this.postLoad();
            }
            this.myOM.putObjectIntoCache(this, false, true);
        }
    }

    public void refreshFieldsInFetchPlan() {
        int[] fieldNumbers = this.myFP.getFieldsInActualFetchPlan();
        if (fieldNumbers != null) {
            this.clearDirtyFlags(fieldNumbers);
            JDOStateManagerImpl.clearFlags(this.loadedFields, fieldNumbers);
            boolean callPostLoad = this.myFP.isToCallPostLoadFetchPlan(this.loadedFields);
            this.srm.fetch(this, fieldNumbers);
            if (this.cmd.hasRelations(this.myOM.getClassLoaderResolver())) {
                for (int i = 0; i < fieldNumbers.length; ++i) {
                    Object value;
                    AbstractPropertyMetaData fmd = this.cmd.getManagedFieldAbsolute(fieldNumbers[i]);
                    int relationType = fmd.getRelationType(this.myOM.getClassLoaderResolver());
                    if (relationType != 0 || !fmd.isCascadeRefresh() || (value = this.provideField(fieldNumbers[i])) == null) continue;
                    if (value instanceof Collection) {
                        SCOUtils.refreshFetchPlanFieldsForCollection(this, ((Collection)value).toArray());
                        continue;
                    }
                    if (value instanceof Map) {
                        SCOUtils.refreshFetchPlanFieldsForMap(this, ((Map)value).entrySet());
                        continue;
                    }
                    if (!(value instanceof PersistenceCapable)) continue;
                    this.myOM.refreshObject(value);
                }
            }
            if (callPostLoad) {
                this.postLoad();
            }
            this.callback.postRefresh(this.myPC);
            this.myOM.putObjectIntoCache(this, false, true);
        }
    }

    public void refreshLoadedFields() {
        int[] fieldNumbers = JDOStateManagerImpl.getFlagsSetTo(this.loadedFields, this.myFP.getFieldsInActualFetchPlan(), true);
        if (fieldNumbers != null) {
            this.clearDirtyFlags();
            JDOStateManagerImpl.clearFlags(this.loadedFields);
            boolean callPostLoad = this.myFP.isToCallPostLoadFetchPlan(this.loadedFields);
            this.srm.fetch(this, fieldNumbers);
            if (callPostLoad) {
                this.postLoad();
            }
            this.myOM.putObjectIntoCache(this, false, true);
        }
    }

    public void unloadField(String fieldName) {
        FieldMetaData fmd = (FieldMetaData)this.getClassMetaData().getField(fieldName);
        int fieldNumber = fmd.getAbsoluteFieldNumber();
        if (this.pcObjectType != 0) {
            throw new JDOUserException("Cannot unload field of embedded object");
        }
        this.loadedFields[fieldNumber] = false;
        this.unloadedFields[fieldNumber] = true;
    }

    public void loadFieldFromDatastore(int fieldNumber) {
        this.srm.fetch(this, new int[]{fieldNumber});
    }

    public boolean isLoaded(PersistenceCapable pc, int field) {
        try {
            if (this.disconnectClone(pc)) {
                return true;
            }
            this.transitionReadField(this.loadedFields[field]);
            if (!this.loadedFields[field]) {
                Object value;
                if (!this.unloadedFields[field] && (value = this.provideField(field)) != null) {
                    if (this.secondClassMutableFields[field]) {
                        if (value instanceof SCO && !(value instanceof SCOCollection) && !(value instanceof SCOMap)) {
                            SCO newValue = (SCO)this.newSCOEmptyInstance(field);
                            newValue.setValueFrom(value, true);
                            this.loadedFields[field] = true;
                            return true;
                        }
                    } else if (this.isPCField(field) && value instanceof PersistenceCapable && this.loadPCFieldFromCache(field, (PersistenceCapable)value)) {
                        return true;
                    }
                }
                if (this.pcObjectType != 0) {
                    return true;
                }
                if (this.myFP.isFieldInActualFetchPlan(field)) {
                    this.loadUnloadedFieldsInFetchPlan();
                } else {
                    this.loadSpecifiedFields(new int[]{field});
                }
                this.unloadedFields[field] = false;
            }
            return true;
        }
        catch (JPOXException jpe) {
            throw JPOXJDOHelper.getJDOExceptionForJPOXException(jpe);
        }
    }

    private boolean isPCField(int fieldNumber) {
        int[] pcFields = this.cmd.getPersistenceCapableFieldNumbers();
        for (int i = 0; i < pcFields.length; ++i) {
            if (pcFields[i] != fieldNumber) continue;
            return true;
        }
        return false;
    }

    private boolean loadPCFieldFromCache(int fieldNumber, PersistenceCapable pc) {
        Object externalID;
        PersistenceCapable cachedPC;
        AbstractClassMetaData fieldCmd = this.myOM.getMetaDataManager().getMetaDataForClass(pc.getClass(), this.myOM.getClassLoaderResolver());
        if (fieldCmd.getIdentityType() == IdentityType.APPLICATION && (cachedPC = this.myOM.getObjectFromCache(externalID = AIDUtils.getNewObjectId(pc, fieldCmd))) != null) {
            this.replaceField(fieldNumber, cachedPC, true);
            this.loadedFields[fieldNumber] = true;
            this.myOM.putObjectIntoCache(this.myOM.findStateManager(cachedPC), true, true);
            return true;
        }
        return false;
    }

    private void writeField(int field, Object newValue) {
        this.replaceField(field, newValue, true);
    }

    public void setBooleanField(PersistenceCapable pc, int field, boolean currentValue, boolean newValue) {
        if (pc != this.myPC) {
            this.replaceField(pc, field, newValue ? Boolean.TRUE : Boolean.FALSE, true);
            this.disconnectClone(pc);
        } else if (this.myLC != null) {
            if (!this.loadedFields[field] || currentValue != newValue) {
                boolean wasDirty = this.preWriteField(field);
                this.writeField(field, newValue ? Boolean.TRUE : Boolean.FALSE);
                this.postWriteField(wasDirty);
            }
        } else {
            this.replaceField(field, newValue ? Boolean.TRUE : Boolean.FALSE, true);
        }
    }

    public void setByteField(PersistenceCapable pc, int field, byte currentValue, byte newValue) {
        if (pc != this.myPC) {
            this.replaceField(pc, field, new Byte(newValue), true);
            this.disconnectClone(pc);
        } else if (this.myLC != null) {
            if (!this.loadedFields[field] || currentValue != newValue) {
                boolean wasDirty = this.preWriteField(field);
                this.writeField(field, new Byte(newValue));
                this.postWriteField(wasDirty);
            }
        } else {
            this.replaceField(field, new Byte(newValue), true);
        }
    }

    public void setCharField(PersistenceCapable pc, int field, char currentValue, char newValue) {
        if (pc != this.myPC) {
            this.replaceField(pc, field, new Character(newValue), true);
            this.disconnectClone(pc);
        } else if (this.myLC != null) {
            if (!this.loadedFields[field] || currentValue != newValue) {
                boolean wasDirty = this.preWriteField(field);
                this.writeField(field, new Character(newValue));
                this.postWriteField(wasDirty);
            }
        } else {
            this.replaceField(field, new Character(newValue), true);
        }
    }

    public void setDoubleField(PersistenceCapable pc, int field, double currentValue, double newValue) {
        if (pc != this.myPC) {
            this.replaceField(pc, field, new Double(newValue), true);
            this.disconnectClone(pc);
        } else if (this.myLC != null) {
            if (!this.loadedFields[field] || currentValue != newValue) {
                boolean wasDirty = this.preWriteField(field);
                this.writeField(field, new Double(newValue));
                this.postWriteField(wasDirty);
            }
        } else {
            this.replaceField(field, new Double(newValue), true);
        }
    }

    public void setFloatField(PersistenceCapable pc, int field, float currentValue, float newValue) {
        if (pc != this.myPC) {
            this.replaceField(pc, field, new Float(newValue), true);
            this.disconnectClone(pc);
        } else if (this.myLC != null) {
            if (!this.loadedFields[field] || currentValue != newValue) {
                boolean wasDirty = this.preWriteField(field);
                this.writeField(field, new Float(newValue));
                this.postWriteField(wasDirty);
            }
        } else {
            this.replaceField(field, new Float(newValue), true);
        }
    }

    public void setIntField(PersistenceCapable pc, int field, int currentValue, int newValue) {
        if (pc != this.myPC) {
            this.replaceField(pc, field, new Integer(newValue), true);
            this.disconnectClone(pc);
        } else if (this.myLC != null) {
            if (!this.loadedFields[field] || currentValue != newValue) {
                boolean wasDirty = this.preWriteField(field);
                this.writeField(field, new Integer(newValue));
                this.postWriteField(wasDirty);
            }
        } else {
            this.replaceField(field, new Integer(newValue), true);
        }
    }

    public void setLongField(PersistenceCapable pc, int field, long currentValue, long newValue) {
        if (pc != this.myPC) {
            this.replaceField(pc, field, new Long(newValue), true);
            this.disconnectClone(pc);
        } else if (this.myLC != null) {
            if (!this.loadedFields[field] || currentValue != newValue) {
                boolean wasDirty = this.preWriteField(field);
                this.writeField(field, new Long(newValue));
                this.postWriteField(wasDirty);
            }
        } else {
            this.replaceField(field, new Long(newValue), true);
        }
    }

    public void setShortField(PersistenceCapable pc, int field, short currentValue, short newValue) {
        if (pc != this.myPC) {
            this.replaceField(pc, field, new Short(newValue), true);
            this.disconnectClone(pc);
        } else if (this.myLC != null) {
            if (!this.loadedFields[field] || currentValue != newValue) {
                boolean wasDirty = this.preWriteField(field);
                this.writeField(field, new Short(newValue));
                this.postWriteField(wasDirty);
            }
        } else {
            this.replaceField(field, new Short(newValue), true);
        }
    }

    public void setStringField(PersistenceCapable pc, int field, String currentValue, String newValue) {
        if (pc != this.myPC) {
            this.replaceField(pc, field, newValue, true);
            this.disconnectClone(pc);
        } else if (this.myLC != null) {
            if (!this.loadedFields[field] || !JDOStateManagerImpl.equals(currentValue, newValue)) {
                boolean wasDirty = this.preWriteField(field);
                this.writeField(field, newValue);
                this.postWriteField(wasDirty);
            }
        } else {
            this.replaceField(field, newValue, true);
        }
    }

    public void setObjectField(PersistenceCapable pc, int field, Object currentValue, Object newValue) {
        JDOStateManagerImpl currentSM;
        if (currentValue != null && currentValue != newValue && currentValue instanceof PersistenceCapable && (currentSM = (JDOStateManagerImpl)this.myOM.findStateManager((PersistenceCapable)currentValue)) != null && currentSM.isEmbedded()) {
            currentSM.removeEmbeddedOwner(this, field);
        }
        if (pc != this.myPC) {
            this.replaceField(pc, field, newValue, true);
            this.disconnectClone(pc);
        } else if (this.myLC != null) {
            boolean loadedOldValue = false;
            Object oldValue = currentValue;
            AbstractPropertyMetaData fmd = this.cmd.getManagedFieldAbsolute(field);
            if (fmd.isDependent() && currentValue == null && newValue == null && !this.loadedFields[field]) {
                this.loadSpecifiedFields(new int[]{field});
                loadedOldValue = true;
                oldValue = this.provideField(field);
            }
            boolean wasDirty = this.preWriteField(field);
            if (!this.loadedFields[field] || currentValue != newValue) {
                SCO sco;
                Object owner;
                if (currentValue instanceof SCO) {
                    ((SCO)currentValue).unsetOwner();
                }
                if (newValue instanceof SCO && (owner = (sco = (SCO)newValue).getOwner()) != null) {
                    throw new JDOUserException(LOCALISER.msg("StateManager.SecondClassObjectShareError", sco.getFieldName(), owner));
                }
                this.writeField(field, newValue);
            } else if (loadedOldValue) {
                this.writeField(field, newValue);
            }
            this.postWriteField(wasDirty);
            if (fmd.isDependent() && oldValue != null && newValue == null && oldValue instanceof PersistenceCapable) {
                this.flush();
                JPOXLogger.JDO.debug(LOCALISER.msg("StateManager.DeleteDependentNulledField", oldValue, fmd.getFullFieldName()));
                this.myOM.deleteObject(oldValue);
            }
        } else {
            this.replaceField(field, newValue, true);
        }
    }

    public byte replacingFlags(PersistenceCapable pc) {
        if (pc != this.myPC) {
            return 0;
        }
        return this.jdoFlags;
    }

    public Object provideField(int fieldNumber) {
        if (!this.unloadedFields[fieldNumber]) {
            return this.provideField(this.myPC, fieldNumber);
        }
        return null;
    }

    public void replaceField(int fieldNumber, Object value, boolean makeDirty) {
        this.replaceField(this.myPC, fieldNumber, value, makeDirty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object provideField(PersistenceCapable pc, int fieldNumber) {
        Object obj;
        Object object = this.currFMmonitor;
        synchronized (object) {
            FieldManager prevFM = this.currFM;
            this.currFM = new SingleValueFieldManager();
            try {
                pc.jdoProvideField(fieldNumber);
                obj = this.currFM.fetchObjectField(fieldNumber);
            }
            finally {
                this.currFM = prevFM;
            }
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceField(PersistenceCapable pc, int fieldNumber, Object value, boolean makeDirty) {
        if (this.embeddedOwners != null) {
            Iterator ownerIter = this.embeddedOwners.iterator();
            while (ownerIter.hasNext()) {
                EmbeddedOwnerRelation owner = (EmbeddedOwnerRelation)ownerIter.next();
                JDOStateManagerImpl ownerSM = (JDOStateManagerImpl)owner.sm;
                if (ownerSM == null || ownerSM.cmd == null) continue;
                AbstractPropertyMetaData ownerFmd = ownerSM.cmd.getManagedFieldAbsolute(owner.fieldNumber);
                if (ownerFmd.getCollection() != null) {
                    Object ownerField = ownerSM.provideField(owner.fieldNumber);
                    if (!(ownerField instanceof SCOCollection)) continue;
                    ((SCOCollection)ownerField).updateEmbeddedElement(this.myPC, fieldNumber, value);
                    continue;
                }
                if (ownerFmd.getMap() != null) {
                    Object ownerField = ownerSM.provideField(owner.fieldNumber);
                    if (!(ownerField instanceof SCOMap)) continue;
                    if (this.pcObjectType == 3) {
                        ((SCOMap)ownerField).updateEmbeddedKey(this.myPC, fieldNumber, value);
                    }
                    if (this.pcObjectType != 4) continue;
                    ((SCOMap)ownerField).updateEmbeddedValue(this.myPC, fieldNumber, value);
                    continue;
                }
                if (ownerSM.updatingEmbeddedFieldsWithOwner) continue;
                if (ownerSM.isEmbedded()) {
                    ownerSM.replaceField(owner.fieldNumber, pc, makeDirty);
                    continue;
                }
                if (makeDirty) {
                    boolean wasDirty = ownerSM.preWriteField(owner.fieldNumber);
                    ownerSM.replaceField(owner.fieldNumber, pc, true);
                    ownerSM.postWriteField(wasDirty);
                    continue;
                }
                ownerSM.replaceField(owner.fieldNumber, pc, false);
            }
        }
        Object object = this.currFMmonitor;
        synchronized (object) {
            FieldManager prevFM = this.currFM;
            this.currFM = new SingleValueFieldManager();
            try {
                this.currFM.storeObjectField(fieldNumber, value);
                pc.jdoReplaceField(fieldNumber);
            }
            finally {
                this.currFM = prevFM;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void provideFields(int[] fieldNumbers, FieldManager fm) {
        Object object = this.currFMmonitor;
        synchronized (object) {
            FieldManager prevFM = this.currFM;
            this.currFM = fm;
            try {
                this.myPC.jdoProvideFields(fieldNumbers);
            }
            finally {
                this.currFM = prevFM;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceFields(int[] fieldNumbers, FieldManager fm, boolean replaceWhenDirty) {
        Object object = this.currFMmonitor;
        synchronized (object) {
            FieldManager prevFM = this.currFM;
            this.currFM = fm;
            try {
                int[] fieldsToReplace = fieldNumbers;
                if (!replaceWhenDirty) {
                    int numberToReplace = fieldNumbers.length;
                    for (int i = 0; i < fieldNumbers.length; ++i) {
                        if (!this.dirtyFields[fieldNumbers[i]]) continue;
                        --numberToReplace;
                    }
                    if (numberToReplace > 0 && numberToReplace != fieldNumbers.length) {
                        fieldsToReplace = new int[numberToReplace];
                        int n = 0;
                        for (int i = 0; i < fieldNumbers.length; ++i) {
                            if (this.dirtyFields[fieldNumbers[i]]) continue;
                            fieldsToReplace[n++] = fieldNumbers[i];
                        }
                    } else if (numberToReplace == 0) {
                        fieldsToReplace = null;
                    }
                }
                if (fieldsToReplace != null) {
                    this.myPC.jdoReplaceFields(fieldsToReplace);
                }
            }
            finally {
                this.currFM = prevFM;
            }
        }
    }

    public void replaceFields(int[] fieldNumbers, FieldManager fm) {
        this.replaceFields(fieldNumbers, fm, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceNonLoadedFields(int[] fieldNumbers, FieldManager fm) {
        Object object = this.currFMmonitor;
        synchronized (object) {
            FieldManager prevFM = this.currFM;
            this.currFM = fm;
            boolean callPostLoad = this.myFP.isToCallPostLoadFetchPlan(this.loadedFields);
            try {
                int[] fieldsToReplace = JDOStateManagerImpl.getFlagsSetTo(this.loadedFields, fieldNumbers, false);
                if (fieldsToReplace != null) {
                    this.myPC.jdoReplaceFields(fieldsToReplace);
                }
            }
            finally {
                this.currFM = prevFM;
            }
            if (callPostLoad && this.isFetchPlanLoaded()) {
                this.postLoad();
            }
        }
    }

    public void addEmbeddedOwner(StateManager ownerSM, int ownerFieldNumber) {
        if (ownerSM == null) {
            return;
        }
        if (this.embeddedOwners == null) {
            this.embeddedOwners = new ArrayList();
        }
        this.embeddedOwners.add(new EmbeddedOwnerRelation(ownerSM, ownerFieldNumber));
    }

    public void removeEmbeddedOwner(javax.jdo.spi.StateManager ownerSM, int ownerFieldNumber) {
        if (this.embeddedOwners != null) {
            Iterator iter = this.embeddedOwners.iterator();
            while (iter.hasNext()) {
                EmbeddedOwnerRelation relation = (EmbeddedOwnerRelation)iter.next();
                if (relation.sm != ownerSM || relation.fieldNumber != ownerFieldNumber) continue;
                iter.remove();
                break;
            }
        }
    }

    public StateManager[] getEmbeddedOwners() {
        if (this.embeddedOwners == null) {
            return null;
        }
        StateManager[] owners = new StateManager[this.embeddedOwners.size()];
        for (int i = 0; i < owners.length; ++i) {
            EmbeddedOwnerRelation relation = (EmbeddedOwnerRelation)this.embeddedOwners.get(i);
            owners[i] = relation.sm;
        }
        return owners;
    }

    public Object newSCOInstance(int fieldNumber, Object value, boolean forUpdate) {
        AbstractPropertyMetaData fmd;
        if (value instanceof PersistenceCapable && (fmd = this.cmd.getManagedFieldAbsolute(fieldNumber)).getEmbeddedMetaData() != null && fmd.getEmbeddedMetaData().getOwnerField() != null) {
            JDOStateManagerImpl subSM = (JDOStateManagerImpl)this.myOM.findStateManager((PersistenceCapable)value);
            int ownerAbsFieldNum = subSM.cmd.getFieldNumberAbsolute(fmd.getEmbeddedMetaData().getOwnerField());
            if (ownerAbsFieldNum >= 0) {
                this.updatingEmbeddedFieldsWithOwner = true;
                subSM.replaceField(ownerAbsFieldNum, this.myPC, true);
                this.updatingEmbeddedFieldsWithOwner = false;
            }
        }
        if (this.secondClassMutableFields[fieldNumber] && value != null && (!(value instanceof SCO) || this.myPC != ((SCO)value).getOwner())) {
            fmd = this.cmd.getManagedFieldAbsolute(fieldNumber);
            if (JPOXLogger.JDO.isDebugEnabled()) {
                JPOXLogger.JDO.debug(LOCALISER.msg("StateManager.ReplacingSCO", fmd.getFullFieldName()));
            }
            SCO newValue = SCOUtils.newSCOInstance(fmd.getType(), this, fmd, value, forUpdate);
            value = newValue;
        }
        return value;
    }

    public Object replaceSCOField(int fieldNumber, Object value, boolean makeDirty) {
        Object newValue = this.newSCOInstance(fieldNumber, value, makeDirty);
        if (newValue != value) {
            this.replaceField(fieldNumber, newValue, makeDirty);
        }
        return newValue;
    }

    public Object newSCOEmptyInstance(int fieldNumber) {
        AbstractPropertyMetaData fmd = this.cmd.getManagedFieldAbsolute(fieldNumber);
        if (JPOXLogger.JDO.isDebugEnabled()) {
            JPOXLogger.JDO.debug(LOCALISER.msg("StateManager.ReplacingSCO", fmd.getFullFieldName()));
        }
        SCO newValue = SCOUtils.newSCOInstance(fmd.getType(), this, fmd, null, false);
        return newValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transitionReadField(boolean isLoaded) {
        if (this.myLC == null) {
            return;
        }
        PersistenceCapable persistenceCapable = this.myPC;
        synchronized (persistenceCapable) {
            this.preStateChange();
            try {
                this.myLC = this.myLC.transitionReadField(this, isLoaded);
            }
            finally {
                this.postStateChange();
            }
        }
    }

    private void transitionReadField() {
        this.transitionReadField(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transitionWriteField() {
        PersistenceCapable persistenceCapable = this.myPC;
        synchronized (persistenceCapable) {
            this.preStateChange();
            try {
                this.myLC = this.myLC.transitionWriteField(this);
            }
            finally {
                this.postStateChange();
            }
        }
    }

    public void runReachability(Set reachables) {
        if (reachables == null) {
            return;
        }
        if (!reachables.contains(this.getInternalObjectId())) {
            this.flush();
            if (this.isDeleted(this.myPC)) {
                return;
            }
            if (this.getObjectManager().isEnlistedInTransaction(this.getInternalObjectId())) {
                this.loadUnloadedFields();
            }
            if (JPOXLogger.REACHABILITY.isDebugEnabled()) {
                JPOXLogger.REACHABILITY.debug(LOCALISER.msg("Reachability.Commit.AddingInstanceToReachables", StringUtils.toJVMIDString(this.myPC), this.getObjectId(this.myPC), this.myLC));
            }
            reachables.add(this.getInternalObjectId());
            for (int i = 0; i < this.loadedFields.length; ++i) {
                PersistenceCapable pc;
                StateManager valueSM;
                if (!this.loadedFields[i]) continue;
                Object value = this.provideField(i);
                if (value == null) {
                    if (!JPOXLogger.REACHABILITY.isDebugEnabled()) continue;
                    JPOXLogger.REACHABILITY.debug(LOCALISER.msg("Reachability.Commit.ProcessingNullField", this.cmd.getManagedFieldAbsolute(i).getFullFieldName()));
                    continue;
                }
                if (this.secondClassMutableFields[i] && value instanceof SCOContainer) {
                    SCOContainer sco;
                    if (JPOXLogger.REACHABILITY.isDebugEnabled()) {
                        JPOXLogger.REACHABILITY.debug(LOCALISER.msg("Reachability.Commit.ProcessingSCOContainer", this.cmd.getManagedFieldAbsolute(i).getFullFieldName()));
                    }
                    if ((sco = (SCOContainer)value) instanceof Collection) {
                        SCOUtils.runReachabilityForCollection(this, ((Collection)((Object)sco)).toArray(), reachables);
                        continue;
                    }
                    if (!(sco instanceof Map)) continue;
                    SCOUtils.runReachabilityForMap(this, ((Map)((Object)sco)).entrySet(), reachables);
                    continue;
                }
                if (value.getClass().isArray()) {
                    if (JPOXLogger.REACHABILITY.isDebugEnabled()) {
                        JPOXLogger.REACHABILITY.debug(LOCALISER.msg("Reachability.Commit.ProcessingArrayField", this.cmd.getManagedFieldAbsolute(i).getFullFieldName()));
                    }
                    if (!(class$javax$jdo$spi$PersistenceCapable == null ? JDOStateManagerImpl.class$("javax.jdo.spi.PersistenceCapable") : class$javax$jdo$spi$PersistenceCapable).isAssignableFrom(value.getClass().getComponentType()) && !value.getClass().getComponentType().isInterface() && value.getClass().getComponentType() != (class$java$lang$Object == null ? JDOStateManagerImpl.class$("java.lang.Object") : class$java$lang$Object)) continue;
                    Object[] arrValue = (Object[])value;
                    for (int j = 0; j < arrValue.length; ++j) {
                        PersistenceCapable pc2 = (PersistenceCapable)arrValue[j];
                        StateManager elementSM = this.myOM.findStateManager(pc2);
                        if (elementSM == null) continue;
                        elementSM.runReachability(reachables);
                    }
                    continue;
                }
                if (!(value instanceof PersistenceCapable)) continue;
                if (JPOXLogger.REACHABILITY.isDebugEnabled()) {
                    JPOXLogger.REACHABILITY.debug(LOCALISER.msg("Reachability.Commit.ProcessingPCField", this.cmd.getManagedFieldAbsolute(i).getFullFieldName()));
                }
                if ((valueSM = this.myOM.findStateManager(pc = (PersistenceCapable)value)) != null) {
                    valueSM.runReachability(reachables);
                    continue;
                }
                if (!JPOXLogger.REACHABILITY.isDebugEnabled()) continue;
                JPOXLogger.REACHABILITY.debug(LOCALISER.msg("Reachability.Commit.FailedToFindStateManager", pc.jdoGetObjectId(), this.cmd.getManagedFieldAbsolute(i).getFullFieldName()));
            }
        }
    }

    public void makePersistent() {
        if (this.flushedNew) {
            this.registerTransactional();
            return;
        }
        if (this.cmd.isEmbeddedOnly()) {
            return;
        }
        if (this.myID == null) {
            this.setIdentity();
        }
        this.dirty = true;
        if (this.myOM.isDelayDatastoreOperationsEnabled()) {
            this.myOM.markDirty(this);
            if (JPOXLogger.PERSISTENCE.isDebugEnabled()) {
                JPOXLogger.PERSISTENCE.debug(LOCALISER.msg("StateManager.PersistenceDelayed", this.myID));
            }
        } else {
            this.internalMakePersistent();
        }
        this.registerTransactional();
    }

    private void internalMakePersistent() {
        this.inserting = ActivityState.INSERTING;
        boolean[] tmpDirtyFields = this.dirtyFields;
        try {
            this.callback.preStore(this.myPC);
            this.clearDirtyFlags();
            this.srm.insert(this);
            this.flushedNew = true;
            this.callback.postStore(this.myPC);
        }
        catch (NotYetFlushedException ex) {
            this.dirtyFields = tmpDirtyFields;
            this.myOM.markDirty(this);
            this.dirty = true;
            throw ex;
        }
        finally {
            this.inserting = ActivityState.NONE;
        }
    }

    public boolean isInserting() {
        return this.inserting == ActivityState.INSERTING;
    }

    public boolean isInserted(int fieldNumber) {
        if (!this.isInserting()) {
            return true;
        }
        if (this.latestInsertedDatastoreClass == null) {
            return false;
        }
        AbstractPropertyMetaData fmd = this.cmd.getManagedFieldAbsolute(fieldNumber);
        if (fmd == null) {
            return false;
        }
        return this.latestInsertedDatastoreClass.managesClass(fmd.getClassName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeActivityState(ActivityState activityState, DatastoreClass table) {
        if (activityState != ActivityState.INSERTING_CALLBACKS) {
            this.inserting = activityState;
        }
        if (activityState == ActivityState.INSERTING_CALLBACKS) {
            this.latestInsertedDatastoreClass = table;
            if (table.managesClass(this.cmd.getFullClassName())) {
                this.inserting = activityState;
                List list = this.insertionNotifyList;
                synchronized (list) {
                    for (int i = 0; i < this.insertionNotifyList.size(); ++i) {
                        JDOStateManagerImpl notifySM = (JDOStateManagerImpl)this.insertionNotifyList.get(i);
                        notifySM.insertionCompleted(this);
                    }
                    this.insertionNotifyList.clear();
                }
            }
        }
    }

    public void addInsertionNotifier(javax.jdo.spi.StateManager sm, ActivityState activityState) {
        this.insertionNotifyList.add(sm);
    }

    public void updateFieldAfterInsert(PersistenceCapable pc, int fieldNumber) {
        JDOStateManagerImpl otherSM = (JDOStateManagerImpl)this.myOM.findStateManager(pc);
        otherSM.addInsertionNotifier(this, ActivityState.INSERTING_CALLBACKS);
        FieldContainer cont = (FieldContainer)this.insertionUpdateFieldList.get(otherSM);
        if (cont == null) {
            cont = new FieldContainer(fieldNumber);
        } else {
            cont.set(fieldNumber);
        }
        this.insertionUpdateFieldList.put(otherSM, cont);
        if (JPOXLogger.JDO.isDebugEnabled()) {
            JPOXLogger.JDO.debug(LOCALISER.msg("StateManager.FieldRegisteredForUpdateAfterInsertion", this.cmd.getManagedFieldAbsolute(fieldNumber).getName(), this.myID));
        }
    }

    void insertionCompleted(JDOStateManagerImpl sm) {
        FieldContainer fldCont = (FieldContainer)this.insertionUpdateFieldList.get(sm);
        if (fldCont != null) {
            this.dirty = true;
            int[] fieldsToUpdate = fldCont.getFields();
            for (int i = 0; i < fieldsToUpdate.length; ++i) {
                if (JPOXLogger.JDO.isDebugEnabled()) {
                    JPOXLogger.JDO.debug(LOCALISER.msg("StateManager.FieldBeingUpdatedNowValueInserted", this.cmd.getManagedFieldAbsolute(fieldsToUpdate[i]).getName(), this.myID));
                }
                this.dirtyFields[fieldsToUpdate[i]] = true;
            }
            this.insertionUpdateFieldList.remove(sm);
            this.flush();
        }
    }

    public void setExternalFieldValueForMapping(JavaTypeMapping mapping, Object value) {
        this.externalFieldValuesByMapping.put(mapping, value);
    }

    public Object getValueForExternalField(JavaTypeMapping mapping) {
        return this.externalFieldValuesByMapping.get(mapping);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makePersistentTransactionalTransient() {
        this.preStateChange();
        try {
            if (this.myLC.isTransactional && !this.myLC.isPersistent) {
                this.makePersistent();
                this.myLC = this.myLC.transitionMakePersistent(this);
            }
        }
        finally {
            this.postStateChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeTransactional() {
        this.preStateChange();
        try {
            if (this.myLC == null) {
                this.initializeSM(5);
                this.setRestoreValues(true);
            } else {
                this.myLC = this.myLC.transitionMakeTransactional(this);
            }
        }
        finally {
            this.postStateChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeNontransactional() {
        this.preStateChange();
        try {
            this.myLC = this.myLC.transitionMakeNontransactional(this);
        }
        finally {
            this.postStateChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeTransient(FetchPlanState state) {
        if (state == null) {
            int[] fieldNumbers = JDOStateManagerImpl.getFlagsSetTo(this.loadedFields, this.secondClassMutableFieldNumbers, true);
            if (fieldNumbers != null) {
                this.provideFields(fieldNumbers, new UnsetOwners());
            }
        } else {
            this.loadUnloadedFieldsInFetchPlan();
            int[] fieldNumbers = JDOStateManagerImpl.getFlagsSetTo(this.loadedFields, this.secondClassMutableFieldNumbers, true);
            if (fieldNumbers != null && fieldNumbers.length > 0) {
                this.replaceFields(fieldNumbers, new MakeTransientFieldManager(this, this.secondClassMutableFields, this.myFP, state));
            }
        }
        this.preStateChange();
        try {
            this.myLC = this.myLC.transitionMakeTransient(this, state != null, this.myOM.getDetachAllOnCommit());
        }
        finally {
            this.postStateChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detach(FetchPlanState state) {
        if (this.myLC.isDeleted() || this.myPC.jdoIsDetached() || this.detaching) {
            return;
        }
        boolean detachable = ClassUtils.isDetachable(this.myPC);
        if (detachable) {
            if (JPOXLogger.PERSISTENCE.isDebugEnabled()) {
                JPOXLogger.PERSISTENCE.debug(LOCALISER.msg("PM.Detach", StringUtils.toJVMIDString(this.myPC), "" + state.getCurrentFetchDepth()));
            }
            this.callback.preDetach(this.myPC);
        }
        try {
            this.detaching = true;
            if ((this.myOM.getFetchPlan().getDetachmentOptions() & 1) != 0) {
                this.loadUnloadedFieldsInFetchPlan();
            }
            DetachFieldManager detachFieldManager = new DetachFieldManager(this, this.secondClassMutableFields, this.myFP, state, false);
            for (int i = 0; i < this.loadedFields.length; ++i) {
                if (!this.loadedFields[i]) continue;
                AbstractPropertyMetaData fmd = this.myFP.getAbstractClassMetaData().getManagedFieldAbsolute(i);
                boolean requiresFCOFetching = MetaDataUtils.getInstance().storesFCO(fmd, this.getObjectManager().getClassLoaderResolver());
                if (!requiresFCOFetching) continue;
                try {
                    detachFieldManager.fetchObjectField(i);
                    continue;
                }
                catch (AbstractFetchFieldManager.EndOfFetchPlanGraphException eofpge) {
                    // empty catch block
                }
            }
            if (detachable) {
                this.myLC = this.myLC.transitionDetach(this);
                this.myPC.jdoReplaceFlags();
                ((Detachable)this.myPC).jdoReplaceDetachedState();
                this.callback.postDetach(this.myPC, this.myPC);
                PersistenceCapable toCheckPC = this.myPC;
                Object toCheckID = this.myID;
                this.disconnect();
                if (!toCheckPC.jdoIsDetached()) {
                    throw new JDOUserException(LOCALISER.msg("StateManager.DetachOfObjectFailed", toCheckPC.getClass().getName(), toCheckID));
                }
            } else {
                this.makeTransient(null);
            }
        }
        finally {
            this.detaching = false;
        }
    }

    private int[] getFieldsNumbersToDetach() {
        int[] loadedFieldNumbers;
        int[] fieldsToDetach = this.myFP.getFieldsInActualFetchPlan();
        if ((this.myOM.getFetchPlan().getDetachmentOptions() & 2) == 0 && (loadedFieldNumbers = JDOStateManagerImpl.getFlagsSetTo(this.loadedFields, this.allFieldNumbers, true)) != null) {
            int i;
            boolean[] flds = new boolean[this.allFieldNumbers.length];
            for (i = 0; i < fieldsToDetach.length; ++i) {
                flds[fieldsToDetach[i]] = true;
            }
            for (i = 0; i < loadedFieldNumbers.length; ++i) {
                flds[loadedFieldNumbers[i]] = true;
            }
            fieldsToDetach = JDOStateManagerImpl.getFlagsSetTo(flds, true);
        }
        return fieldsToDetach;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object detachCopy(FetchPlanState state) {
        PersistenceCapable detachedPC;
        if (this.myLC.isDeleted()) {
            throw new JDOUserException(LOCALISER.msg("StateManager.DetachOfDeletedObjectNotPossible", this.myPC.getClass().getName(), this.myID));
        }
        if (this.myPC.jdoIsDetached()) {
            throw new JDOUserException(LOCALISER.msg("StateManager.DetachOfAlreadyDetachedObjectNotPossible", this.myPC.getClass().getName(), this.myID));
        }
        if (this.dirty) {
            this.myOM.flush(false);
        }
        if (this.detaching) {
            return this.detachingPC;
        }
        this.detachingPC = detachedPC = this.myPC.jdoNewInstance((javax.jdo.spi.StateManager)this);
        boolean detachable = ClassUtils.isDetachable(this.myPC);
        PersistenceCapable persistenceCapable = this.detachingPC;
        synchronized (persistenceCapable) {
            if (detachable) {
                if (JPOXLogger.PERSISTENCE.isDebugEnabled()) {
                    JPOXLogger.PERSISTENCE.debug(LOCALISER.msg("PM.DetachCopy", StringUtils.toJVMIDString(this.myPC), "" + state.getCurrentFetchDepth()));
                }
                this.callback.preDetach(this.myPC);
            }
            try {
                this.detaching = true;
                if ((this.myOM.getFetchPlan().getDetachmentOptions() & 1) != 0) {
                    this.loadUnloadedFieldsInFetchPlan();
                }
                if (this.myLC == this.myOM.getOMFContext().getApiAdapter().getLifeCycleState(4) || this.myLC == this.myOM.getOMFContext().getApiAdapter().getLifeCycleState(9)) {
                    this.myLC = this.myLC.transitionReadField(this, true);
                }
                JDOStateManagerImpl smDetachedPC = new JDOStateManagerImpl(this.myOM, detachedPC.getClass());
                smDetachedPC.initialiseForDetached(detachedPC, this.getExternalObjectId(this.myPC), this.myVersion);
                detachedPC.jdoReplaceStateManager((javax.jdo.spi.StateManager)smDetachedPC);
                smDetachedPC.replaceFields(this.getFieldsNumbersToDetach(), new DetachFieldManager(this, this.secondClassMutableFields, this.myFP, state, true));
                if (detachable) {
                    detachedPC.jdoReplaceFlags();
                    ((Detachable)detachedPC).jdoReplaceDetachedState();
                } else {
                    smDetachedPC.makeTransient(null);
                }
                detachedPC.jdoReplaceStateManager(null);
            }
            catch (Exception e) {
                JPOXLogger.JDO.debug("DETACH ERROR : Error thrown while detaching " + StringUtils.toJVMIDString(this.myPC) + " (id=" + this.myID + ")", e);
            }
            finally {
                this.detaching = false;
                this.detachingPC = null;
            }
            if (detachable && !detachedPC.jdoIsDetached()) {
                throw new JDOUserException(LOCALISER.msg("StateManager.DetachOfObjectFailed", detachedPC.getClass().getName(), this.myID));
            }
            if (detachable) {
                this.callback.postDetach(this.myPC, detachedPC);
            }
        }
        return detachedPC;
    }

    public Object getAttachedPC() {
        return this.attachedPC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object attachCopy(PersistenceCapable detachedPC, boolean embedded) {
        if (this.attaching) {
            return this.myPC;
        }
        this.attaching = true;
        try {
            boolean persistent = false;
            if (embedded) {
                persistent = true;
            } else if (!this.myOM.getOMFContext().getPersistenceConfiguration().getAttachSameDatastore()) {
                try {
                    this.srm.locate(this);
                    persistent = true;
                }
                catch (JPOXObjectNotFoundException onfe) {}
            } else {
                persistent = true;
            }
            this.callback.preAttach(detachedPC);
            if (detachedPC.jdoIsDeleted()) {
                this.myLC = this.myLC.transitionDeletePersistent(this);
            }
            if (this.myLC == this.myOM.getOMFContext().getApiAdapter().getLifeCycleState(4) || this.myLC == this.myOM.getOMFContext().getApiAdapter().getLifeCycleState(9)) {
                this.myLC = this.myLC.transitionMakeTransactional(this);
            }
            if (persistent) {
                this.loadSCONonContainerFields();
            }
            JDOStateManagerImpl smDetachedPC = new JDOStateManagerImpl(this.myOM, detachedPC.getClass());
            smDetachedPC.initialiseForDetached(detachedPC, this.getExternalObjectId(detachedPC), null);
            detachedPC.jdoReplaceStateManager((javax.jdo.spi.StateManager)smDetachedPC);
            smDetachedPC.attachedPC = this.myPC;
            this.retrieveDetachState(smDetachedPC);
            if (!persistent) {
                this.internalAttachCopy(this, smDetachedPC, smDetachedPC.loadedFields, smDetachedPC.dirtyFields, persistent, smDetachedPC.myVersion, false);
                this.makePersistent();
            }
            this.internalAttachCopy(this, smDetachedPC, smDetachedPC.loadedFields, smDetachedPC.dirtyFields, persistent, smDetachedPC.myVersion, true);
            detachedPC.jdoReplaceStateManager(null);
            smDetachedPC.attachedPC = null;
            this.callback.postAttach(this.myPC, detachedPC);
        }
        finally {
            this.attaching = false;
        }
        return this.myPC;
    }

    private void internalAttachCopy(StateManager sm, StateManager smDetached, boolean[] loadedFields, boolean[] dirtyFields, boolean persistent, Object version, boolean cascade) {
        int[] attachFieldNumbers = null;
        int numberOfAttachFields = 0;
        for (int i = 0; i < loadedFields.length; ++i) {
            if (!loadedFields[i] && !dirtyFields[i]) continue;
            ++numberOfAttachFields;
        }
        attachFieldNumbers = new int[numberOfAttachFields];
        int n = 0;
        for (int i = 0; i < loadedFields.length; ++i) {
            if (!loadedFields[i] && !dirtyFields[i]) continue;
            attachFieldNumbers[n++] = this.allFieldNumbers[i];
        }
        sm.setVersion(version);
        if (attachFieldNumbers != null) {
            smDetached.provideFields(attachFieldNumbers, new AttachFieldManager(sm, this.secondClassMutableFields, dirtyFields, persistent, cascade));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletePersistent() {
        if (!this.myLC.isDeleted()) {
            this.callback.preDelete(this.myPC);
            this.srm.deleteDependent(this, this.allFieldNumbers);
            this.dirty = true;
            this.preStateChange();
            try {
                this.myLC = this.myLC.transitionDeletePersistent(this);
            }
            finally {
                this.postStateChange();
            }
            if (this.myOM.isDelayDatastoreOperationsEnabled()) {
                this.myOM.markDirty(this);
            } else {
                this.internalDeletePersistent();
            }
            this.callback.postDelete(this.myPC);
        }
    }

    public void nullifyFields() {
        if (!this.myLC.isDeleted() && !this.myPC.jdoIsDetached()) {
            this.replaceFields(this.allNonPrimaryKeyFieldNumbers, new NullifyRelationFieldManager(this));
            this.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalDeletePersistent() {
        if (this.deleting) {
            throw new JDOUserException(LOCALISER.msg("StateManager.DeleteRecursiveError"));
        }
        this.deleting = true;
        try {
            if (this.dirty) {
                this.clearDirtyFlags();
                this.myOM.flush(false);
            }
            this.srm.delete(this);
        }
        finally {
            this.deleting = false;
        }
    }

    public void locate() {
        this.srm.locate(this);
    }

    public void validate() {
        if (!this.myLC.isTransactional) {
            int[] fieldNumbers = JDOStateManagerImpl.getFlagsSetTo(this.loadedFields, this.myFP.getFieldsInActualFetchPlan(), false);
            if (fieldNumbers != null) {
                fieldNumbers = JDOStateManagerImpl.getFlagsSetTo(this.nonPrimaryKeyFields, fieldNumbers, true);
            }
            if (fieldNumbers != null) {
                fieldNumbers = JDOStateManagerImpl.getFlagsSetTo(this.secondClassMutableFields, fieldNumbers, false);
            }
            if (fieldNumbers != null && fieldNumbers.length > 0) {
                this.transitionReadField();
                fieldNumbers = this.myFP.getFieldsInActualFetchPlan();
                if (fieldNumbers != null) {
                    boolean callPostLoad = this.myFP.isToCallPostLoadFetchPlan(this.loadedFields);
                    this.srm.fetch(this, fieldNumbers);
                    if (callPostLoad) {
                        this.postLoad();
                    }
                    this.myOM.putObjectIntoCache(this, false, true);
                }
            } else {
                this.srm.locate(this);
                this.transitionReadField();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evict() {
        if (this.myLC != this.myOM.getOMFContext().getApiAdapter().getLifeCycleState(2) && this.myLC != this.myOM.getOMFContext().getApiAdapter().getLifeCycleState(9)) {
            return;
        }
        this.preStateChange();
        try {
            try {
                this.callback.preClear(this.myPC);
                this.callback.postClear(this.myPC);
            }
            finally {
                this.myLC = this.myLC.transitionEvict(this);
            }
        }
        finally {
            this.postStateChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        this.preStateChange();
        try {
            this.myLC = this.myLC.transitionRefresh(this);
        }
        finally {
            this.postStateChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retrieve(boolean fgOnly) {
        this.preStateChange();
        try {
            this.myLC = this.myLC.transitionRetrieve((StateManager)this, fgOnly);
        }
        finally {
            this.postStateChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retrieve(FetchPlan fetchPlan) {
        this.preStateChange();
        try {
            this.myLC = this.myLC.transitionRetrieve((StateManager)this, fetchPlan);
        }
        finally {
            this.postStateChange();
        }
    }

    private void preStateChange() {
        this.changingState = true;
    }

    private void postStateChange() {
        this.changingState = false;
        if (this.postLoadPending && this.isFetchPlanLoaded()) {
            this.postLoadPending = false;
            this.postLoad();
        }
    }

    private boolean preWriteField(int field) {
        boolean wasDirty = this.dirty;
        if (this.inserting == ActivityState.NONE) {
            if (!wasDirty) {
                this.callback.preDirty(this.myPC);
            }
            this.transitionWriteField();
            this.dirty = true;
            this.dirtyFields[field] = true;
            this.loadedFields[field] = true;
        }
        return wasDirty;
    }

    private void postWriteField(boolean wasDirty) {
        if (this.dirty && !wasDirty) {
            this.callback.postDirty(this.myPC);
        }
        if (!(this.inserting != ActivityState.NONE || this.flushing || this.myLC.isTransactional && !this.myLC.isPersistent)) {
            this.myOM.markDirty(this);
        }
    }

    private void postLoad() {
        if (this.changingState) {
            this.postLoadPending = true;
        } else {
            if (this.jdoFlags == 1 && this.myLC.isTransactional()) {
                this.jdoFlags = (byte)-1;
                this.myPC.jdoReplaceFlags();
            }
            this.callback.postLoad(this.myPC);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postCommit(Transaction tx) {
        this.preStateChange();
        try {
            this.myLC = this.myLC.transitionCommit(this, tx);
        }
        finally {
            this.postStateChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preBegin(Transaction tx) {
        this.preStateChange();
        try {
            this.myLC = this.myLC.transitionBegin(this, tx);
        }
        finally {
            this.postStateChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preRollback(Transaction tx) {
        this.preStateChange();
        try {
            this.myOM.clearDirty(this);
            this.myLC = this.myLC.transitionRollback(this, tx);
        }
        finally {
            this.postStateChange();
        }
    }

    public void setStoringPC() {
        this.storingPC = true;
    }

    public void unsetStoringPC() {
        this.storingPC = false;
    }

    public void preSerialize(PersistenceCapable pc) {
        if (this.disconnectClone(pc)) {
            return;
        }
        this.retrieve(false);
        this.myLC = this.myLC.transitionSerialize(this);
        if (!this.storingPC && pc instanceof Detachable && !this.myLC.isDeleted && this.myLC.isPersistent) {
            if (this.myLC.isDirty) {
                this.flush();
            }
            ((Detachable)pc).jdoReplaceDetachedState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        if (this.dirty) {
            if (this.flushing) {
                return;
            }
            this.flushing = true;
            try {
                if (this.myLC.stateType() == 1 && !this.flushedNew) {
                    if (!this.isEmbedded()) {
                        this.internalMakePersistent();
                    } else {
                        this.callback.preStore(this.myPC);
                        this.callback.postStore(this.myPC);
                    }
                    this.dirty = false;
                } else if (this.myLC.stateType() == 8) {
                    this.callback.preDelete(this.myPC);
                    if (!this.isEmbedded()) {
                        this.internalDeletePersistent();
                    }
                    this.callback.postDelete(this.myPC);
                } else if (this.myLC.stateType() == 7) {
                    if (this.flushedNew) {
                        this.callback.preDelete(this.myPC);
                        if (!this.isEmbedded()) {
                            this.internalDeletePersistent();
                        }
                        this.callback.postDelete(this.myPC);
                    } else {
                        this.dirty = false;
                    }
                } else {
                    int[] dirtyFieldNumbers;
                    if (!this.deleting) {
                        this.callback.preStore(this.myPC);
                    }
                    if ((dirtyFieldNumbers = JDOStateManagerImpl.getFlagsSetTo(this.dirtyFields, true)) == null) {
                        throw new JDOFatalInternalException(LOCALISER.msg("StateManager.InconsistentDirtyStateError"));
                    }
                    if (!this.isEmbedded()) {
                        this.srm.update(this, dirtyFieldNumbers);
                        this.myOM.putObjectIntoCache(this, true, true);
                    }
                    this.clearDirtyFlags();
                    this.callback.postStore(this.myPC);
                }
            }
            finally {
                this.flushing = false;
            }
        }
    }

    private void initializeSM(int newState) {
        final JDOStateManagerImpl thisSM = this;
        this.myLC = this.myOM.getOMFContext().getApiAdapter().getLifeCycleState(newState);
        try {
            if (this.myLC.isPersistent()) {
                this.myOM.addStateManager(this);
            }
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        JDOStateManagerImpl.this.myPC.jdoReplaceStateManager((javax.jdo.spi.StateManager)thisSM);
                        return null;
                    }
                    catch (SecurityException e) {
                        throw new JDOFatalUserException("EXC_CannotSetStateManager", (Throwable)e);
                    }
                }
            });
        }
        catch (SecurityException e) {
            throw new JDOUserException(e.getMessage());
        }
        catch (JDOException jdoException) {
            if (this.myOM.getStateManagerById(this.myID) == this) {
                this.myOM.removeStateManager(this);
            }
            throw jdoException;
        }
    }

    protected boolean disconnectClone(PersistenceCapable pc) {
        if (this.detaching) {
            return false;
        }
        if (pc != this.myPC) {
            if (JPOXLogger.JDO.isDebugEnabled()) {
                JPOXLogger.JDO.debug(LOCALISER.msg("StateManager.DisconnectClone", StringUtils.toJVMIDString(pc), this));
            }
            pc.jdoReplaceFlags();
            pc.jdoReplaceStateManager(null);
            return true;
        }
        return false;
    }

    private void unsetOwnerInSCOFields() {
        int[] fieldNumbers = JDOStateManagerImpl.getFlagsSetTo(this.loadedFields, this.secondClassMutableFieldNumbers, true);
        if (fieldNumbers != null) {
            this.provideFields(fieldNumbers, new UnsetOwners());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        if (JPOXLogger.JDO.isDebugEnabled()) {
            JPOXLogger.JDO.debug(LOCALISER.msg("StateManager.Disconnect", StringUtils.toJVMIDString(this.myPC), this));
        }
        if (this.postLoadPending) {
            this.changingState = false;
            this.postLoadPending = false;
            this.postLoad();
        }
        this.unsetOwnerInSCOFields();
        this.myOM.removeStateManager(this);
        this.jdoFlags = 0;
        this.myPC.jdoReplaceFlags();
        this.disconnecting = true;
        try {
            this.replaceStateManager(null);
        }
        finally {
            this.disconnecting = false;
        }
        this.clearSavedFields();
        this.myOM = null;
        this.myFP = null;
        this.myPC = null;
        this.myID = null;
        this.myLC = null;
        this.cmd = null;
        this.srm = null;
    }

    public void registerTransactional() {
        this.myOM.addStateManager(this);
    }

    public void retrieveDetachState(StateManager sm) {
        if (sm.getObject() instanceof Detachable) {
            ((JDOStateManagerImpl)sm).retrievingDetachedState = true;
            ((Detachable)sm.getObject()).jdoReplaceDetachedState();
            ((JDOStateManagerImpl)sm).retrievingDetachedState = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetDetachState() {
        if (this.getObject() instanceof Detachable) {
            this.resettingDetachedState = true;
            try {
                ((Detachable)this.getObject()).jdoReplaceDetachedState();
            }
            finally {
                this.resettingDetachedState = false;
            }
        }
    }

    public Object[] replacingDetachedState(Detachable pc, Object[] currentState) {
        int i;
        if (this.resettingDetachedState) {
            return null;
        }
        if (this.retrievingDetachedState) {
            int i2;
            this.jdoLoadedFields = (BitSet)currentState[2];
            for (i2 = 0; i2 < this.loadedFields.length; ++i2) {
                this.loadedFields[i2] = this.jdoLoadedFields.get(i2);
            }
            this.jdoModifiedFields = (BitSet)currentState[3];
            for (i2 = 0; i2 < this.dirtyFields.length; ++i2) {
                this.dirtyFields[i2] = this.jdoModifiedFields.get(i2);
            }
            this.setVersion(currentState[1]);
            return currentState;
        }
        Object[] state = new Object[4];
        state[0] = this.myID;
        state[1] = this.myVersion;
        if (currentState == null || currentState[2] == null) {
            BitSet loadedState = new BitSet();
            for (i = 0; i < this.loadedFields.length; ++i) {
                if (this.loadedFields[i]) {
                    loadedState.set(i);
                    continue;
                }
                loadedState.clear(i);
            }
            state[2] = loadedState;
        } else {
            state[2] = currentState[2];
        }
        if (currentState == null || currentState[3] == null) {
            BitSet modifiedState = new BitSet();
            for (i = 0; i < this.dirtyFields.length; ++i) {
                if (this.dirtyFields[i]) {
                    modifiedState.set(i);
                    continue;
                }
                modifiedState.clear(i);
            }
            state[3] = modifiedState;
        } else {
            state[3] = currentState[3];
        }
        return state;
    }

    private static void dumpPC(PersistenceCapable pc, PrintWriter out) {
        out.println(StringUtils.toJVMIDString(pc));
        if (pc == null) {
            return;
        }
        out.print("jdoStateManager = " + JDOStateManagerImpl.peekField(pc, "jdoStateManager"));
        out.print("jdoFlags = ");
        Object flagsObj = JDOStateManagerImpl.peekField(pc, "jdoFlags");
        if (flagsObj instanceof Byte) {
            out.println(StringUtils.jdoFlagsToString((Byte)flagsObj));
        } else {
            out.println(flagsObj);
        }
        Class<?> c = pc.getClass();
        do {
            String[] fieldNames = HELPER.getFieldNames(c);
            for (int i = 0; i < fieldNames.length; ++i) {
                out.print(fieldNames[i]);
                out.print(" = ");
                out.println(JDOStateManagerImpl.peekField(pc, fieldNames[i]));
            }
        } while ((c = c.getSuperclass()) != null && (class$javax$jdo$spi$PersistenceCapable == null ? JDOStateManagerImpl.class$("javax.jdo.spi.PersistenceCapable") : class$javax$jdo$spi$PersistenceCapable).isAssignableFrom(c));
    }

    public void dump(PrintWriter out) {
        out.println("myPM = " + this.myOM);
        out.println("myID = " + this.myID);
        out.println("myLC = " + this.myLC);
        out.println("cmd = " + this.cmd);
        out.println("srm = " + this.srm);
        out.println("fieldCount = " + this.fieldCount);
        out.println("dirty = " + this.dirty);
        out.println("flushing = " + this.flushing);
        out.println("changingState = " + this.changingState);
        out.println("postLoadPending = " + this.postLoadPending);
        out.println("disconnecting = " + this.disconnecting);
        out.println("dirtyFields = " + StringUtils.booleanArrayToString(this.dirtyFields));
        out.println("secondClassMutableFields = " + StringUtils.booleanArrayToString(this.secondClassMutableFields));
        out.println("allFieldNumbers = " + StringUtils.intArrayToString(this.allFieldNumbers));
        out.println("secondClassMutableFieldNumbers = " + StringUtils.intArrayToString(this.secondClassMutableFieldNumbers));
        out.println();
        out.println("jdoFlags = " + StringUtils.jdoFlagsToString(this.jdoFlags));
        out.println("loadedFields = " + StringUtils.booleanArrayToString(this.loadedFields));
        out.print("myPC = ");
        JDOStateManagerImpl.dumpPC(this.myPC, out);
        out.println();
        out.println("savedFlags = " + StringUtils.jdoFlagsToString(this.savedFlags));
        out.println("savedLoadedFields = " + StringUtils.booleanArrayToString(this.savedLoadedFields));
        out.print("savedImage = ");
        JDOStateManagerImpl.dumpPC(this.savedImage, out);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        HOLLOWFIELDMANAGER = new SingleTypeFieldManager();
        HELPER = (JDOImplHelper)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return JDOImplHelper.getInstance();
                }
                catch (SecurityException e) {
                    throw new JDOFatalUserException(AbstractStateManager.LOCALISER.msg("StateManager.SecurityProblem"), (Throwable)e);
                }
            }
        });
    }

    private class FieldContainer {
        boolean[] fieldsToUpdate;

        public FieldContainer(int fieldNumber) {
            this.fieldsToUpdate = new boolean[JDOStateManagerImpl.this.allFieldNumbers.length];
            this.fieldsToUpdate[fieldNumber] = true;
        }

        public void set(int fieldNumber) {
            this.fieldsToUpdate[fieldNumber] = true;
        }

        public int[] getFields() {
            return AbstractStateManager.getFlagsSetTo(this.fieldsToUpdate, true);
        }
    }

    private class EmbeddedOwnerRelation {
        private StateManager sm;
        private int fieldNumber;

        public EmbeddedOwnerRelation(StateManager ownerSM, int ownerFieldNumber) {
            this.sm = ownerSM;
            this.fieldNumber = ownerFieldNumber;
        }
    }
}

