/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.state.jpa;

import javax.jdo.FetchPlan;
import org.jpox.StateManager;
import org.jpox.Transaction;
import org.jpox.state.LifeCycleState;

class PersistentClean
extends LifeCycleState {
    protected PersistentClean() {
        this.isPersistent = true;
        this.isDirty = false;
        this.isNew = false;
        this.isDeleted = false;
        this.isTransactional = true;
        this.stateType = 2;
    }

    public LifeCycleState transitionDeletePersistent(StateManager sm) {
        return this.changeState(sm, 8);
    }

    public LifeCycleState transitionMakeNontransactional(StateManager sm) {
        sm.clearSavedFields();
        return this.changeState(sm, 9);
    }

    public LifeCycleState transitionMakeTransient(StateManager sm, boolean useFetchPlan, boolean detachAllOnCommit) {
        if (useFetchPlan) {
            sm.loadUnloadedFieldsInFetchPlan();
        }
        return this.changeState(sm, 0);
    }

    public LifeCycleState transitionCommit(StateManager sm, Transaction tx) {
        sm.clearSavedFields();
        if (tx.getRetainValues()) {
            return this.changeState(sm, 9);
        }
        sm.clearNonPrimaryKeyFields();
        return this.changeState(sm, 4);
    }

    public LifeCycleState transitionRollback(StateManager sm, Transaction tx) {
        if (tx.getRestoreValues()) {
            sm.restoreFields();
            return this.changeState(sm, 9);
        }
        sm.clearNonPrimaryKeyFields();
        sm.clearSavedFields();
        return this.changeState(sm, 4);
    }

    public LifeCycleState transitionEvict(StateManager sm) {
        sm.clearNonPrimaryKeyFields();
        sm.clearSavedFields();
        return this.changeState(sm, 4);
    }

    public LifeCycleState transitionWriteField(StateManager sm) {
        Transaction tx = sm.getObjectManager().getTransaction();
        if (tx.getRestoreValues()) {
            sm.saveFields();
        }
        return this.changeState(sm, 3);
    }

    public LifeCycleState transitionRefresh(StateManager sm) {
        sm.clearSavedFields();
        sm.refreshFieldsInFetchPlan();
        Transaction tx = sm.getObjectManager().getTransaction();
        if (tx.isActive()) {
            return this.changeState(sm, 2);
        }
        return this.changeState(sm, 9);
    }

    public LifeCycleState transitionRetrieve(StateManager sm, boolean fgOnly) {
        if (fgOnly) {
            sm.loadUnloadedFieldsInFetchPlan();
        } else {
            sm.loadUnloadedFields();
        }
        return this;
    }

    public LifeCycleState transitionRetrieve(StateManager sm, FetchPlan fetchPlan) {
        sm.loadUnloadedFieldsOfClassInFetchPlan(fetchPlan);
        return this;
    }

    public LifeCycleState transitionDetach(StateManager sm) {
        return this.changeState(sm, 11);
    }

    public String toString() {
        return "P_CLEAN";
    }
}

