/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store;

import javax.jdo.JDOUnsupportedOptionException;
import javax.jdo.JDOUserException;
import javax.transaction.Synchronization;
import org.jpox.Transaction;
import org.jpox.jdo.exceptions.TransactionCommitingException;
import org.jpox.util.Localiser;

public abstract class AbstractTransaction
implements Transaction {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.jpox.Localisation");
    protected boolean active = false;
    protected boolean commiting = false;
    protected boolean retainValues;
    protected boolean restoreValues;
    protected boolean optimistic;
    protected boolean nontransactionalRead;
    protected boolean nontransactionalWrite;
    protected boolean rollbackOnly = false;
    protected Synchronization sync = null;
    protected boolean isJDOConnectionInUse = false;
    protected int isolationLevel;

    public void close() {
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isCommitting() {
        return this.commiting;
    }

    public synchronized void setRetainValues(boolean retainValues) {
        this.assertNotCommiting();
        this.retainValues = retainValues;
        if (retainValues) {
            this.nontransactionalRead = true;
        }
    }

    public boolean getRetainValues() {
        return this.retainValues;
    }

    public synchronized void setRestoreValues(boolean restoreValues) {
        this.assertNotInUse();
        this.assertNotCommiting();
        this.restoreValues = restoreValues;
    }

    public boolean getRestoreValues() {
        return this.restoreValues;
    }

    public synchronized void setOptimistic(boolean optimistic) {
        this.assertNotInUse();
        this.assertNotCommiting();
        this.optimistic = optimistic;
    }

    public boolean getOptimistic() {
        return this.optimistic;
    }

    public synchronized void setNontransactionalRead(boolean nontransactionalRead) {
        this.assertNotCommiting();
        this.nontransactionalRead = nontransactionalRead;
    }

    public boolean getNontransactionalRead() {
        return this.nontransactionalRead;
    }

    public synchronized void setNontransactionalWrite(boolean nontransactionalWrite) {
        this.assertNotInUse();
        this.assertNotCommiting();
        if (nontransactionalWrite) {
            throw new JDOUnsupportedOptionException("Non-transactional write mode not (yet) supported");
        }
        this.nontransactionalWrite = nontransactionalWrite;
    }

    public boolean getNontransactionalWrite() {
        return this.nontransactionalWrite;
    }

    public boolean getRollbackOnly() {
        return this.rollbackOnly;
    }

    public void setRollbackOnly() {
        if (this.active) {
            this.rollbackOnly = true;
        }
    }

    public Synchronization getSynchronization() {
        return this.sync;
    }

    public synchronized void setSynchronization(Synchronization sync) {
        this.assertNotCommiting();
        this.sync = sync;
    }

    public int getTransactionIsolation() {
        return this.isolationLevel;
    }

    protected abstract void assertNotInUse();

    protected void assertNotCommiting() {
        if (this.commiting) {
            throw new TransactionCommitingException(this);
        }
    }

    protected void assertJDOConnectionNotInUse() {
        if (this.isJDOConnectionInUse) {
            throw new JDOUserException("The JDOConnection was acquired by the developer and must be closed before using the JDO API.");
        }
    }
}

