/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store;

import java.io.PrintStream;
import java.io.Writer;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.jdo.identity.SingleFieldIdentity;
import javax.jdo.spi.PersistenceCapable;
import org.jpox.ClassLoaderResolver;
import org.jpox.ConnectionFactory;
import org.jpox.OMFContext;
import org.jpox.ObjectManager;
import org.jpox.ObjectManagerFactoryImpl;
import org.jpox.StateManager;
import org.jpox.exceptions.ClassNotResolvedException;
import org.jpox.exceptions.JPOXException;
import org.jpox.exceptions.JPOXOptimisticException;
import org.jpox.exceptions.JPOXUserException;
import org.jpox.management.ManagementServer;
import org.jpox.management.runtime.StoreManagerRuntime;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.AbstractPropertyMetaData;
import org.jpox.metadata.ClassMetaData;
import org.jpox.metadata.IdentityStrategy;
import org.jpox.metadata.IdentityType;
import org.jpox.metadata.InheritanceStrategy;
import org.jpox.metadata.MetaDataManager;
import org.jpox.metadata.SequenceMetaData;
import org.jpox.metadata.VersionMetaData;
import org.jpox.metadata.VersionStrategy;
import org.jpox.store.AutoStartMechanism;
import org.jpox.store.DatastoreAdapter;
import org.jpox.store.DatastoreClass;
import org.jpox.store.DatastoreContainerObject;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.DatastoreObject;
import org.jpox.store.Extent;
import org.jpox.store.FetchStatement;
import org.jpox.store.IdentifierFactory;
import org.jpox.store.JPOXConnection;
import org.jpox.store.JPOXSequence;
import org.jpox.store.OID;
import org.jpox.store.OIDFactory;
import org.jpox.store.SCOID;
import org.jpox.store.StoreData;
import org.jpox.store.TableStoreData;
import org.jpox.store.exceptions.DatastoreInitialisationException;
import org.jpox.store.exceptions.DatastorePermissionException;
import org.jpox.store.exceptions.NoTableManagedException;
import org.jpox.store.mapping.MappingManager;
import org.jpox.store.poid.PoidManager;
import org.jpox.store.query.Query;
import org.jpox.store.scostore.ArrayStore;
import org.jpox.store.scostore.CollectionStore;
import org.jpox.store.scostore.MapStore;
import org.jpox.util.AIDUtils;
import org.jpox.util.ClassUtils;
import org.jpox.util.JPOXLogger;
import org.jpox.util.Localiser;
import org.jpox.util.MacroString;
import org.jpox.util.MultiMap;
import org.jpox.util.StringUtils;

public abstract class StoreManager {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.jpox.store.Localisation");
    protected DatastoreAdapter dba;
    protected String userName;
    protected String password;
    protected final boolean readOnlyDatastore;
    protected final boolean fixedDatastore;
    protected AutoStartMechanism starter = null;
    protected boolean starterInitialised = false;
    protected final OMFContext omfContext;
    protected final boolean autoCreateTables;
    protected final boolean autoCreateColumns;
    protected final boolean autoCreateConstraints;
    protected final boolean autoCreateWarnOnError;
    protected final boolean validateTables;
    protected final boolean validateColumns;
    protected final boolean validateConstraints;
    protected final boolean checkExistTablesOrViews;
    protected final PoidManager poidManager;
    protected IdentifierFactory identifierFactory;
    protected StoreManagerRuntime storeManagerRuntime;
    protected Map storeDataByClass = new HashMap();
    protected MultiMap storeDataByAppIdClass = new MultiMap();
    protected String autoStartMechanism = null;
    protected Map datastoreContainerByIdentifier = new HashMap();
    static /* synthetic */ Class class$org$jpox$ObjectManagerFactoryImpl;
    static /* synthetic */ Class class$org$jpox$store$StoreManager;
    static /* synthetic */ Class class$org$jpox$ClassLoaderResolver;
    static /* synthetic */ Class class$org$jpox$ObjectManager;
    static /* synthetic */ Class class$javax$jdo$spi$PersistenceCapable;

    protected StoreManager(ClassLoaderResolver clr, ObjectManagerFactoryImpl omf, String userName, String password) {
        this.userName = userName;
        this.password = password;
        this.omfContext = omf.getOMFContext();
        this.readOnlyDatastore = omf.getReadOnlyDatastore();
        this.fixedDatastore = omf.getFixedDatastore();
        this.omfContext.setStoreManager(this);
        this.poidManager = new PoidManager();
        this.autoCreateColumns = omf.getPersistenceConfiguration().getAutoCreateColumns();
        this.autoCreateTables = omf.getPersistenceConfiguration().getAutoCreateTables();
        this.autoCreateConstraints = omf.getPersistenceConfiguration().getAutoCreateConstraints();
        this.autoCreateWarnOnError = omf.getPersistenceConfiguration().getAutoCreateWarnOnError();
        this.validateTables = omf.getPersistenceConfiguration().getValidateTables();
        this.validateColumns = omf.getPersistenceConfiguration().getValidateColumns();
        this.validateConstraints = omf.getPersistenceConfiguration().getValidateConstraints();
        this.checkExistTablesOrViews = omf.getPersistenceConfiguration().getCheckExistTablesOrViews();
        this.storeManagerRuntime = new StoreManagerRuntime();
        String mbeanName = this.omfContext.getDomainName() + ":InstanceName=" + this.omfContext.getInstanceName() + ",Type=" + ClassUtils.getClassNameForClass(this.storeManagerRuntime.getClass()) + ",Name=StoreManager";
        ManagementServer mgntServer = this.omfContext.getManagement().getManagementServer();
        if (mgntServer != null) {
            mgntServer.registerMBean(this.storeManagerRuntime, mbeanName);
        }
    }

    public void close() {
        this.poidManager.clear();
        this.storeDataByClass.clear();
        this.storeDataByAppIdClass.clear();
        this.starterInitialised = false;
        this.starter = null;
        this.dba = null;
    }

    public abstract ConnectionFactory getConnectionFactory();

    public abstract JPOXSequence getJPOXSequence(ObjectManager var1, SequenceMetaData var2);

    public abstract JPOXConnection getJPOXConnection(ObjectManager var1);

    public PoidManager getPoidManager() {
        return this.poidManager;
    }

    protected void registerStoreData(StoreData data) {
        if (data.isFCO()) {
            this.storeDataByClass.put(data.getName(), data);
            ClassMetaData cmd = (ClassMetaData)data.getMetaData();
            if (cmd.getIdentityType() == IdentityType.APPLICATION && !cmd.usesSingleFieldIdentityClass()) {
                this.storeDataByAppIdClass.put(cmd.getObjectidClass(), data);
            }
        } else {
            this.storeDataByClass.put(data.getMetaData(), data);
        }
        if (JPOXLogger.PERSISTENCE.isInfoEnabled()) {
            JPOXLogger.PERSISTENCE.info(LOCALISER.msg("StoreManager.AddStoreData", data));
        }
        if (this.starter != null && this.starterInitialised) {
            this.starter.addClass(data);
        }
    }

    protected void deregisterAllStoreData() {
        this.storeDataByClass.clear();
        this.storeDataByAppIdClass.clear();
        this.starterInitialised = false;
        if (JPOXLogger.PERSISTENCE.isInfoEnabled()) {
            JPOXLogger.PERSISTENCE.info(LOCALISER.msg("StoreManager.RemoveStoreData"));
        }
        this.clearAutoStarter();
    }

    public synchronized TableStoreData[] getStoreDataForDatastoreContainerObject(DatastoreIdentifier tableIdentifier) {
        HashSet<StoreData> dataForTable = null;
        Iterator iterator = this.storeDataByClass.values().iterator();
        while (iterator.hasNext()) {
            TableStoreData tableData;
            StoreData data = (StoreData)iterator.next();
            if (!(data instanceof TableStoreData) || (tableData = (TableStoreData)data).getDatastoreIdentifier() == null || !tableData.getDatastoreIdentifier().equals(tableIdentifier) || !tableData.isTableOwner) continue;
            if (dataForTable == null) {
                dataForTable = new HashSet<StoreData>();
            }
            dataForTable.add(data);
        }
        if (dataForTable != null) {
            return dataForTable.toArray(new TableStoreData[dataForTable.size()]);
        }
        return null;
    }

    public DatastoreClass getDatastoreContainerForIdentifier(DatastoreIdentifier identifier) {
        return (DatastoreClass)this.datastoreContainerByIdentifier.get(identifier);
    }

    public void addDatastoreContainer(DatastoreContainerObject table) {
        if (table != null && this.datastoreContainerByIdentifier.get(table.getIdentifier()) == null) {
            this.datastoreContainerByIdentifier.put(table, table.getIdentifier());
        }
    }

    public abstract void outputDatastoreInformation(PrintStream var1) throws Exception;

    public abstract void outputSchemaInformation(PrintStream var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialiseAutoStart(String mechanism, String mode, ClassLoaderResolver clr) throws DatastoreInitialisationException {
        block22: {
            if (this.starterInitialised) {
                return;
            }
            this.autoStartMechanism = mechanism;
            String autoStarterClassName = this.getOMFContext().getPluginManager().getAttributeValueForExtension("org.jpox.autostart", "name", mechanism, "class-name");
            if (autoStarterClassName != null) {
                this.starter = (AutoStartMechanism)ClassUtils.newInstance(clr.classForName(autoStarterClassName, (class$org$jpox$ObjectManagerFactoryImpl == null ? (class$org$jpox$ObjectManagerFactoryImpl = StoreManager.class$("org.jpox.ObjectManagerFactoryImpl")) : class$org$jpox$ObjectManagerFactoryImpl).getClassLoader()), new Class[]{class$org$jpox$store$StoreManager == null ? (class$org$jpox$store$StoreManager = StoreManager.class$("org.jpox.store.StoreManager")) : class$org$jpox$store$StoreManager, class$org$jpox$ClassLoaderResolver == null ? (class$org$jpox$ClassLoaderResolver = StoreManager.class$("org.jpox.ClassLoaderResolver")) : class$org$jpox$ClassLoaderResolver}, new Object[]{this, clr});
                this.starter.setMode(mode);
            }
            if (this.starter == null) {
                this.starterInitialised = true;
                return;
            }
            boolean illegalState = false;
            try {
                Collection existingData;
                if (!this.starter.isOpen()) {
                    this.starter.open();
                }
                if ((existingData = this.starter.getAllClassData()) == null || existingData.size() <= 0) break block22;
                ArrayList<String> classesNeedingAdding = new ArrayList<String>();
                Iterator existingDataIter = existingData.iterator();
                while (existingDataIter.hasNext()) {
                    boolean classFound;
                    StoreData data;
                    block23: {
                        data = (StoreData)existingDataIter.next();
                        if (!data.isFCO()) continue;
                        classFound = false;
                        try {
                            if (clr.classForName(data.getName()) != null) {
                                classFound = true;
                            }
                        }
                        catch (ClassNotResolvedException cnre) {
                            if (data.getInterfaceName() == null) break block23;
                            try {
                                this.getOMFContext().getImplementationCreator().newInstance(clr.classForName(data.getInterfaceName()), this.getMetaDataManager(), clr);
                                if (clr.classForName(data.getName()) != null) {
                                    classFound = true;
                                }
                            }
                            catch (ClassNotResolvedException cnre2) {
                                // empty catch block
                            }
                        }
                    }
                    if (classFound) {
                        JPOXLogger.PERSISTENCE.info(LOCALISER.msg("StoreManager.AddPreviousStoreData", data.getName()));
                        classesNeedingAdding.add(data.getName());
                        continue;
                    }
                    String msg = LOCALISER.msg("AutoStarter.ClassNotFoundError", data.getName());
                    if (this.starter.getMode().equals("Checked")) {
                        JPOXLogger.PERSISTENCE.error(msg);
                        throw new DatastoreInitialisationException(msg);
                    }
                    if (this.starter.getMode().equals("Ignored")) {
                        JPOXLogger.PERSISTENCE.warn(msg);
                        continue;
                    }
                    if (!this.starter.getMode().equals("Quiet")) continue;
                    JPOXLogger.PERSISTENCE.warn(msg);
                    JPOXLogger.PERSISTENCE.warn(LOCALISER.msg("AutoStarter.DeleteClass", data.getName()));
                    this.starter.deleteClass(data.getName());
                }
                String[] classesToLoad = new String[classesNeedingAdding.size()];
                Iterator classesNeedingAddingIter = classesNeedingAdding.iterator();
                int n = 0;
                while (classesNeedingAddingIter.hasNext()) {
                    classesToLoad[n++] = (String)classesNeedingAddingIter.next();
                }
                try {
                    this.addClasses(classesToLoad, clr);
                }
                catch (Exception e) {
                    JPOXLogger.PERSISTENCE.warn(LOCALISER.msg("AutoStarter.UnknownError", e));
                    illegalState = true;
                }
            }
            finally {
                if (this.starter.isOpen()) {
                    this.starter.close();
                }
                if (illegalState) {
                    JPOXLogger.PERSISTENCE.warn(LOCALISER.msg("AutoStarter.IllegalStateDisablingAutoStart"));
                    this.starter = null;
                }
            }
        }
        this.starterInitialised = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearAutoStarter() {
        if (this.starter != null) {
            try {
                if (!this.starter.isOpen()) {
                    this.starter.open();
                }
                this.starter.deleteAllClasses();
            }
            finally {
                if (this.starter.isOpen()) {
                    this.starter.close();
                }
            }
        }
    }

    public AutoStartMechanism getAutoStartMechanism() {
        return this.starter;
    }

    public Collection getManagedClasses() {
        return Collections.unmodifiableCollection(this.storeDataByClass.keySet());
    }

    public boolean managesClass(String className) {
        return this.storeDataByClass.containsKey(className);
    }

    public void addClass(String className, ClassLoaderResolver clr) {
        this.addClasses(new String[]{className}, clr, null, false);
    }

    public abstract void addClasses(String[] var1, ClassLoaderResolver var2, Writer var3, boolean var4);

    public void addClasses(String[] classNames, ClassLoaderResolver clr) {
        this.addClasses(classNames, clr, null, false);
    }

    public abstract void removeAllClasses(ClassLoaderResolver var1);

    public AbstractClassMetaData[] getClassesManagingTableForClass(AbstractClassMetaData cmd, ClassLoaderResolver clr) {
        if (cmd == null) {
            return null;
        }
        if (cmd.getInheritanceMetaData().getStrategyValue() == InheritanceStrategy.NEW_TABLE) {
            return new AbstractClassMetaData[]{cmd};
        }
        if (cmd.getInheritanceMetaData().getStrategyValue() == InheritanceStrategy.SUBCLASS_TABLE) {
            int i;
            String[] subclasses = this.getMetaDataManager().getSubclassesForClass(cmd.getFullClassName(), true);
            if (subclasses != null) {
                for (int i2 = 0; i2 < subclasses.length; ++i2) {
                    if (this.storeDataByClass.get(subclasses[i2]) != null) continue;
                    this.addClass(subclasses[i2], clr);
                }
            }
            HashSet<AbstractClassMetaData> managingClasses = new HashSet<AbstractClassMetaData>();
            Set managedClasses = this.storeDataByClass.keySet();
            Iterator managedClassesIter = managedClasses.iterator();
            while (managedClassesIter.hasNext()) {
                AbstractClassMetaData[] superCmds;
                StoreData data = (StoreData)this.storeDataByClass.get(managedClassesIter.next());
                if (!data.isFCO() || ((AbstractClassMetaData)data.getMetaData()).getSuperAbstractClassMetaData() == null || ((AbstractClassMetaData)data.getMetaData()).getSuperAbstractClassMetaData().getFullClassName() != cmd.getFullClassName() || (superCmds = this.getClassesManagingTableForClass((AbstractClassMetaData)data.getMetaData(), clr)) == null) continue;
                for (i = 0; i < superCmds.length; ++i) {
                    managingClasses.add(superCmds[i]);
                }
            }
            Iterator managingClassesIter = managingClasses.iterator();
            AbstractClassMetaData[] managingCmds = new AbstractClassMetaData[managingClasses.size()];
            i = 0;
            while (managingClassesIter.hasNext()) {
                managingCmds[i++] = (AbstractClassMetaData)managingClassesIter.next();
            }
            return managingCmds;
        }
        if (cmd.getInheritanceMetaData().getStrategyValue() == InheritanceStrategy.SUPERCLASS_TABLE) {
            return this.getClassesManagingTableForClass(cmd.getSuperAbstractClassMetaData(), clr);
        }
        return null;
    }

    public String manageClassForIdentity(OID id, ClassLoaderResolver clr) {
        String className = null;
        className = id.getPcClass();
        AbstractClassMetaData cmd = this.getMetaDataManager().getMetaDataForClass(className, clr);
        if (cmd.getIdentityType() != IdentityType.DATASTORE) {
            throw new JPOXUserException(LOCALISER.msg("Identity.AssignedToIncorrectClass", id, cmd.getFullClassName()));
        }
        if (!this.managesClass(className)) {
            this.addClass(className, clr);
        }
        return className;
    }

    public String manageClassForIdentity(SingleFieldIdentity id, ClassLoaderResolver clr) {
        String className = null;
        className = id.getTargetClassName();
        AbstractClassMetaData cmd = this.getMetaDataManager().getMetaDataForClass(className, clr);
        if (cmd.getIdentityType() != IdentityType.APPLICATION || !cmd.getObjectidClass().equals(id.getClass().getName())) {
            throw new JPOXUserException(LOCALISER.msg("Identity.AssignedToIncorrectClass", id, cmd.getFullClassName()));
        }
        if (!this.managesClass(className)) {
            this.addClass(className, clr);
        }
        return className;
    }

    public boolean usesDatastoreClass() {
        return true;
    }

    public abstract Extent getExtent(ObjectManager var1, Class var2, boolean var3);

    public abstract boolean supportsQueryLanguage(String var1);

    public Query newQuery(String language, ObjectManager om, Object query) {
        if (language == null) {
            return null;
        }
        String queryClassName = this.getOMFContext().getPluginManager().getAttributeValueForExtension("org.jpox.store_query_query", "name", language, "class-name");
        if (queryClassName != null) {
            if (query == null) {
                return (Query)ClassUtils.newInstance(om.getClassLoaderResolver().classForName(queryClassName, (class$org$jpox$ObjectManagerFactoryImpl == null ? (class$org$jpox$ObjectManagerFactoryImpl = StoreManager.class$("org.jpox.ObjectManagerFactoryImpl")) : class$org$jpox$ObjectManagerFactoryImpl).getClassLoader()), new Class[]{class$org$jpox$ObjectManager == null ? (class$org$jpox$ObjectManager = StoreManager.class$("org.jpox.ObjectManager")) : class$org$jpox$ObjectManager}, new Object[]{om});
            }
            return (Query)ClassUtils.newInstance(om.getClassLoaderResolver().classForName(queryClassName, (class$org$jpox$ObjectManagerFactoryImpl == null ? (class$org$jpox$ObjectManagerFactoryImpl = StoreManager.class$("org.jpox.ObjectManagerFactoryImpl")) : class$org$jpox$ObjectManagerFactoryImpl).getClassLoader()), new Class[]{class$org$jpox$ObjectManager == null ? (class$org$jpox$ObjectManager = StoreManager.class$("org.jpox.ObjectManager")) : class$org$jpox$ObjectManager, query.getClass()}, new Object[]{om, query});
        }
        return null;
    }

    public abstract String getClassNameForObjectID(Object var1, ClassLoaderResolver var2, ObjectManager var3);

    public boolean isStrategyDatastoreAttributed(IdentityStrategy identityStrategy, boolean datastoreIdentityField) {
        if (identityStrategy == null) {
            return false;
        }
        return identityStrategy == IdentityStrategy.IDENTITY;
    }

    public abstract Object getStrategyValue(ObjectManager var1, DatastoreClass var2, AbstractClassMetaData var3, int var4);

    public Object newObjectID(ObjectManager om, String className, PersistenceCapable pc) {
        AbstractClassMetaData cmd = this.getMetaDataManager().getMetaDataForClass(className, om.getClassLoaderResolver());
        if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            DatastoreClass t = null;
            if (this.usesDatastoreClass()) {
                t = this.getDatastoreClass(className, om.getClassLoaderResolver());
                if (t == null && cmd.getInheritanceMetaData().getStrategyValue() == InheritanceStrategy.SUBCLASS_TABLE) {
                    throw new JPOXUserException(LOCALISER.msg("StoreManager.NoTableForClass", className));
                }
                boolean has_superclass = true;
                while (has_superclass) {
                    DatastoreClass supert = t.getSuperDatastoreClass();
                    if (supert != null) {
                        t = supert;
                        continue;
                    }
                    has_superclass = false;
                }
            }
            Object nextIdentifier = this.getStrategyValue(om, t, cmd, -1);
            return OIDFactory.getInstance(om, cmd.getFullClassName(), nextIdentifier);
        }
        if (cmd.getIdentityType() == IdentityType.APPLICATION) {
            return AIDUtils.getNewObjectId(pc, cmd);
        }
        return new SCOID(className);
    }

    public void insert(StateManager sm) {
        if (this.readOnlyDatastore) {
            throw new DatastorePermissionException(LOCALISER.msg("StoreManager.InsertObjectWhileReadOnlyError"));
        }
        DatastoreClass dc = this.getDatastoreClass(sm.getObject().getClass().getName(), sm.getObjectManager().getClassLoaderResolver());
        if (dc == null) {
            AbstractClassMetaData cmd = this.getMetaDataManager().getMetaDataForClass(sm.getObject().getClass(), sm.getObjectManager().getClassLoaderResolver());
            if (cmd.getInheritanceMetaData().getStrategyValue() == InheritanceStrategy.SUBCLASS_TABLE) {
                throw new JPOXUserException(LOCALISER.msg("StoreManager.NoTableForClass", sm.getObject().getClass().getName()));
            }
            throw new JPOXException(LOCALISER.msg("StoreManager.CantFindTableForClass", sm.getObject().getClass().getName(), cmd.getInheritanceMetaData().getStrategyValue())).setFatal();
        }
        this.storeManagerRuntime.incrementInsertCount();
        dc.insert(sm);
    }

    public void fetch(StateManager sm, int[] fieldNumbers) {
        AbstractPropertyMetaData[] fmds = null;
        if (fieldNumbers != null) {
            fmds = new AbstractPropertyMetaData[fieldNumbers.length];
            for (int i = 0; i < fmds.length; ++i) {
                fmds[i] = sm.getClassMetaData().getManagedFieldAbsolute(fieldNumbers[i]);
            }
        }
        this.storeManagerRuntime.incrementFetchCount();
        this.getDatastoreClass(sm.getObject().getClass().getName(), sm.getObjectManager().getClassLoaderResolver()).fetch(sm, fmds);
    }

    public void update(StateManager sm, int[] fieldNumbers) {
        if (this.readOnlyDatastore) {
            throw new DatastorePermissionException(LOCALISER.msg("StoreManager.UpdateObjectWhileReadOnlyError"));
        }
        AbstractPropertyMetaData[] fmds = null;
        if (fieldNumbers != null) {
            fmds = new AbstractPropertyMetaData[fieldNumbers.length];
            for (int i = 0; i < fmds.length; ++i) {
                fmds[i] = sm.getClassMetaData().getManagedFieldAbsolute(fieldNumbers[i]);
            }
        }
        this.storeManagerRuntime.incrementUpdateCount();
        this.getDatastoreClass(sm.getObject().getClass().getName(), sm.getObjectManager().getClassLoaderResolver()).update(sm, fmds);
    }

    public void delete(StateManager sm) {
        if (this.readOnlyDatastore) {
            throw new DatastorePermissionException(LOCALISER.msg("StoreManager.DeleteObjectWhileReadOnlyError"));
        }
        this.storeManagerRuntime.incrementDeleteCount();
        this.getDatastoreClass(sm.getObject().getClass().getName(), sm.getObjectManager().getClassLoaderResolver()).delete(sm);
    }

    public void locate(StateManager sm) {
        this.getDatastoreClass(sm.getObject().getClass().getName(), sm.getObjectManager().getClassLoaderResolver()).locate(sm);
    }

    public void deleteDependent(StateManager sm, int[] fieldNumbers) {
        if (this.readOnlyDatastore) {
            throw new DatastorePermissionException(LOCALISER.msg("StoreManager.DeleteDependentObjectWhileReadOnlyError"));
        }
        AbstractPropertyMetaData[] fmds = null;
        if (fieldNumbers != null) {
            fmds = new AbstractPropertyMetaData[fieldNumbers.length];
            for (int i = 0; i < fmds.length; ++i) {
                fmds[i] = sm.getClassMetaData().getManagedFieldAbsolute(fieldNumbers[i]);
            }
        }
        this.getDatastoreClass(sm.getObject().getClass().getName(), sm.getObjectManager().getClassLoaderResolver()).deleteDependent(sm, fmds);
    }

    public void performVersionCheck(StateManager sm, Object versionDatastore) {
        boolean valid;
        Object versionObject = sm.getTransactionalVersion(sm.getObject());
        if (versionObject == null) {
            return;
        }
        VersionMetaData versionMetaData = sm.getClassMetaData().getVersionMetaData();
        if (versionMetaData == null) {
            throw new JPOXUserException("JPOX doesnt currently support the use of optimistic transactions when no strategy is specified");
        }
        if (versionMetaData.getVersionStrategy() == VersionStrategy.DATE_TIME) {
            valid = ((Timestamp)versionObject).getTime() == ((Timestamp)versionDatastore).getTime();
        } else if (versionMetaData.getVersionStrategy() == VersionStrategy.VERSION_NUMBER) {
            valid = ((Long)versionObject).longValue() == ((Long)versionDatastore).longValue();
        } else {
            if (versionMetaData.getVersionStrategy() == VersionStrategy.STATE_IMAGE) {
                throw new JPOXUserException(LOCALISER.msg("StoreManager.OptimisticStrategyNotSupported", sm.getClassMetaData().getFullClassName(), versionMetaData.getVersionStrategy()));
            }
            throw new JPOXUserException(LOCALISER.msg("StoreManager.OptimisticStrategyNotSupported", sm.getClassMetaData().getFullClassName(), versionMetaData.getVersionStrategy()));
        }
        if (!valid) {
            String msg = LOCALISER.msg("StoreManager.OptimisticVersionMismatch", StringUtils.toJVMIDString(sm.getObject()), sm.getInternalObjectId(), "" + versionDatastore, "" + versionObject);
            JPOXLogger.PERSISTENCE.error(msg);
            throw new JPOXOptimisticException(msg, sm.getObject());
        }
    }

    public abstract void flush(ObjectManager var1);

    public abstract DatastoreContainerObject newJoinDatastoreContainerObject(AbstractPropertyMetaData var1, ClassLoaderResolver var2);

    public HashSet getSubClassesForClass(String className, boolean includeDescendents, ClassLoaderResolver clr) {
        HashSet<String> subclasses = new HashSet<String>();
        String[] subclassNames = this.getMetaDataManager().getSubclassesForClass(className, includeDescendents);
        if (subclassNames != null) {
            for (int i = 0; i < subclassNames.length; ++i) {
                if (this.storeDataByClass.get(subclassNames[i]) == null) {
                    this.addClass(subclassNames[i], clr);
                }
                subclasses.add(subclassNames[i]);
            }
        }
        return subclasses;
    }

    public IdentifierFactory getIdentifierFactory() {
        return this.identifierFactory;
    }

    public OMFContext getOMFContext() {
        return this.omfContext;
    }

    public MetaDataManager getMetaDataManager() {
        return this.omfContext.getMetaDataManager();
    }

    public MappingManager getMappingManager() {
        return this.dba.getMappingManager();
    }

    public DatastoreAdapter getDatastoreAdapter() {
        return this.dba;
    }

    public abstract Date getDatastoreDate();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatastoreClass getDatastoreClass(String className, ClassLoaderResolver clr) {
        DatastoreClass ct = null;
        if (className == null) {
            JPOXLogger.PERSISTENCE.error(LOCALISER.msg("StoreManager.TableRetrievalError"));
            return null;
        }
        boolean classKnown = false;
        StoreManager storeManager = this;
        synchronized (storeManager) {
            StoreData sd = (StoreData)this.storeDataByClass.get(className);
            if (sd != null && sd instanceof TableStoreData) {
                classKnown = true;
                ct = (DatastoreClass)((TableStoreData)sd).getDatastoreContainerObject();
            }
        }
        if (!classKnown) {
            boolean toBeAdded = false;
            if (clr != null) {
                Class cls = clr.classForName(className);
                if (cls != null && !cls.isInterface() && (class$javax$jdo$spi$PersistenceCapable == null ? (class$javax$jdo$spi$PersistenceCapable = StoreManager.class$("javax.jdo.spi.PersistenceCapable")) : class$javax$jdo$spi$PersistenceCapable).isAssignableFrom(cls)) {
                    toBeAdded = true;
                }
            } else {
                toBeAdded = true;
            }
            if (toBeAdded) {
                this.addClass(className, clr);
                StoreManager storeManager2 = this;
                synchronized (storeManager2) {
                    StoreData sd = (StoreData)this.storeDataByClass.get(className);
                    if (sd != null && sd instanceof TableStoreData) {
                        classKnown = true;
                        ct = (DatastoreClass)((TableStoreData)sd).getDatastoreContainerObject();
                    }
                }
            }
        }
        if (!classKnown && ct == null) {
            throw new NoTableManagedException(className);
        }
        return ct;
    }

    public synchronized DatastoreContainerObject getDatastoreContainerObject(AbstractPropertyMetaData fmd) {
        StoreData sd = (StoreData)this.storeDataByClass.get(fmd);
        if (sd != null && sd instanceof TableStoreData) {
            return ((TableStoreData)sd).getDatastoreContainerObject();
        }
        return null;
    }

    public synchronized DatastoreClass getDatastoreClass(DatastoreIdentifier name) {
        Iterator iterator = this.storeDataByClass.values().iterator();
        while (iterator.hasNext()) {
            TableStoreData tsd;
            StoreData sd = (StoreData)iterator.next();
            if (!(sd instanceof TableStoreData) || !(tsd = (TableStoreData)sd).hasTable() || !tsd.getDatastoreIdentifier().equals(name)) continue;
            return (DatastoreClass)tsd.getDatastoreContainerObject();
        }
        return null;
    }

    public AbstractClassMetaData getClassWithPrimaryKeyForClass(AbstractClassMetaData cmd, ClassLoaderResolver clr) {
        if (cmd == null) {
            return null;
        }
        if (cmd.getSuperAbstractClassMetaData() == null) {
            return cmd;
        }
        if (this.getDatastoreClass(cmd.getFullClassName(), clr) != null) {
            return cmd;
        }
        return this.getClassWithPrimaryKeyForClass(cmd.getSuperAbstractClassMetaData(), clr);
    }

    public abstract void resolveIdentifierMacro(MacroString.IdentifierMacro var1, ClassLoaderResolver var2);

    public abstract FetchStatement getFetchStatement(DatastoreContainerObject var1);

    public abstract CollectionStore getBackingStoreForCollection(AbstractPropertyMetaData var1, DatastoreObject var2, ClassLoaderResolver var3, boolean var4, boolean var5);

    public abstract MapStore getBackingStoreForMap(AbstractPropertyMetaData var1, DatastoreObject var2, ClassLoaderResolver var3);

    public abstract ArrayStore getBackingStoreForArray(AbstractPropertyMetaData var1, DatastoreObject var2, ClassLoaderResolver var3);

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

