/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store;

import org.jpox.metadata.AbstractPropertyMetaData;
import org.jpox.metadata.ClassMetaData;
import org.jpox.store.DatastoreClass;
import org.jpox.store.DatastoreContainerObject;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.StoreData;

public class TableStoreData
extends StoreData {
    protected final String interfaceName;
    protected String tableName;
    protected final boolean isTableOwner;
    protected DatastoreContainerObject table;

    public TableStoreData(String name, String tableName, boolean tableOwner, int type, String interfaceName) {
        super(name, null, type, interfaceName);
        this.tableName = tableName;
        this.isTableOwner = tableOwner;
        this.interfaceName = interfaceName;
    }

    public TableStoreData(ClassMetaData cmd, DatastoreContainerObject table, boolean tableOwner) {
        super(cmd.getFullClassName(), cmd, 1, null);
        this.table = table;
        this.tableName = table != null ? table.toString() : null;
        this.isTableOwner = tableOwner;
        String interfaces = null;
        for (int i = 0; i < cmd.getImplementsMetaData().length; ++i) {
            interfaces = interfaces == null ? "" : interfaces + ",";
            interfaces = interfaces + cmd.getImplementsMetaData()[i].getName();
        }
        this.interfaceName = interfaces;
    }

    public TableStoreData(AbstractPropertyMetaData fmd, DatastoreContainerObject table) {
        super(fmd.getFullFieldName(), fmd, 2, null);
        this.table = table;
        this.tableName = table != null ? table.toString() : null;
        this.isTableOwner = true;
        this.interfaceName = table.getStoreManager().getMetaDataManager().isPersistentInterface(fmd.getType().getName()) ? fmd.getType().getName() : null;
    }

    public String getTableName() {
        return this.tableName;
    }

    public boolean isTableOwner() {
        return this.isTableOwner;
    }

    public boolean hasTable() {
        return this.tableName != null;
    }

    public DatastoreContainerObject getDatastoreContainerObject() {
        return this.table;
    }

    public DatastoreIdentifier getDatastoreIdentifier() {
        if (this.table != null) {
            return this.table.getIdentifier();
        }
        return null;
    }

    public void setDatastoreContainerObject(DatastoreClass table) {
        if (table != null) {
            this.tableName = ((Object)table).toString();
            this.table = table;
        }
    }

    public String toString() {
        if (this.metadata instanceof ClassMetaData) {
            ClassMetaData cmd = (ClassMetaData)this.metadata;
            if (this.tableName != null) {
                return LOCALISER.msg("StoreData.DataForClassInTable", this.name, this.tableName, cmd.getInheritanceMetaData().getStrategyValue().toString());
            }
            return LOCALISER.msg("StoreData.DataForClassInTable", this.name, "(none)", cmd.getInheritanceMetaData().getStrategyValue().toString());
        }
        if (this.metadata instanceof AbstractPropertyMetaData) {
            return LOCALISER.msg("StoreData.DataForFieldInTable", this.name, this.tableName);
        }
        return LOCALISER.msg("StoreData.DataForClassInTable", this.name, this.tableName);
    }
}

