/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.expression;

import org.jpox.store.expression.BooleanBitColumnLiteral;
import org.jpox.store.expression.BooleanExpression;
import org.jpox.store.expression.LogicSetExpression;
import org.jpox.store.expression.NullLiteral;
import org.jpox.store.expression.NumericExpression;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.rdbms.query.StatementText;

public class BooleanBitColumnExpression
extends BooleanExpression {
    private boolean truthTest;
    private StatementText booleanCondition = new StatementText();

    public BooleanBitColumnExpression(QueryExpression qs, JavaTypeMapping mapping, LogicSetExpression te) {
        this(qs, mapping, te, true);
    }

    public BooleanBitColumnExpression(QueryExpression qs, JavaTypeMapping mapping, LogicSetExpression te, boolean truthTest) {
        super(qs, mapping, te);
        this.truthTest = truthTest;
        this.booleanCondition.append(" = ").append(new BooleanBitColumnLiteral(qs, mapping, truthTest));
        this.lowestOperator = OP_EQ;
    }

    public BooleanExpression not() {
        return new BooleanBitColumnExpression(this.qs, this.mapping, this.te, !this.truthTest);
    }

    public BooleanExpression eq(ScalarExpression expr) {
        if (expr instanceof NullLiteral) {
            return expr.eq(new NumericExpression(this.qs, this.mapping, this.te));
        }
        if (expr instanceof BooleanBitColumnExpression) {
            return new BooleanExpression(new NumericExpression(this.qs, this.mapping, this.te), OP_EQ, new NumericExpression(this.qs, expr.mapping, expr.te));
        }
        return super.eq(expr);
    }

    public BooleanExpression noteq(ScalarExpression expr) {
        if (expr instanceof NullLiteral) {
            return expr.noteq(new NumericExpression(this.qs, this.mapping, this.te));
        }
        if (expr instanceof BooleanBitColumnExpression) {
            return new BooleanExpression(new NumericExpression(this.qs, this.mapping, this.te), OP_NOTEQ, new NumericExpression(this.qs, expr.mapping, expr.te));
        }
        return super.noteq(expr);
    }

    public StatementText toStatementText(int mode) {
        StatementText st = super.toStatementText(mode);
        if (mode == ScalarExpression.FILTER) {
            st.append(this.booleanCondition, mode);
        }
        return st;
    }
}

