/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.expression;

import org.jpox.store.expression.BooleanCharColumnLiteral;
import org.jpox.store.expression.BooleanExpression;
import org.jpox.store.expression.CharacterExpression;
import org.jpox.store.expression.LogicSetExpression;
import org.jpox.store.expression.NullLiteral;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.rdbms.query.StatementText;

public class BooleanCharColumnExpression
extends BooleanExpression {
    private boolean truthTest;
    private StatementText booleanCondition = new StatementText();

    public BooleanCharColumnExpression(QueryExpression qs, JavaTypeMapping mapping, LogicSetExpression te) {
        this(qs, mapping, te, true);
    }

    public BooleanCharColumnExpression(QueryExpression qs, JavaTypeMapping mapping, LogicSetExpression te, boolean truthTest) {
        super(qs, mapping, te);
        this.truthTest = truthTest;
        this.booleanCondition.append(" = ").append(new BooleanCharColumnLiteral(qs, mapping, truthTest));
        this.lowestOperator = OP_EQ;
    }

    public BooleanExpression not() {
        return new BooleanCharColumnExpression(this.qs, this.mapping, this.te, !this.truthTest);
    }

    public BooleanExpression eq(ScalarExpression expr) {
        if (expr instanceof NullLiteral) {
            return expr.eq(new CharacterExpression(this.qs, this.mapping, this.te));
        }
        if (expr instanceof BooleanCharColumnExpression) {
            return new BooleanExpression(new CharacterExpression(this.qs, this.mapping, this.te), OP_EQ, new CharacterExpression(this.qs, expr.mapping, expr.te));
        }
        return super.eq(expr);
    }

    public BooleanExpression noteq(ScalarExpression expr) {
        if (expr instanceof NullLiteral) {
            return expr.noteq(new CharacterExpression(this.qs, this.mapping, this.te));
        }
        if (expr instanceof BooleanCharColumnExpression) {
            return new BooleanExpression(new CharacterExpression(this.qs, this.mapping, this.te), OP_NOTEQ, new CharacterExpression(this.qs, expr.mapping, expr.te));
        }
        return super.noteq(expr);
    }

    public BooleanExpression in(ScalarExpression expr) {
        return new BooleanExpression(new CharacterExpression(this.qs, this.mapping, this.te), OP_IN, expr);
    }

    public StatementText toStatementText(int mode) {
        StatementText st = super.toStatementText(mode);
        if (mode == ScalarExpression.FILTER) {
            st.append(this.booleanCondition, mode);
        }
        return st;
    }
}

