/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.expression;

import org.jpox.store.expression.BooleanExpression;
import org.jpox.store.expression.Literal;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.mapping.JavaTypeMapping;

public class BooleanLiteral
extends BooleanExpression
implements Literal {
    private final boolean value;

    public BooleanLiteral(QueryExpression qs, JavaTypeMapping mapping, boolean value) {
        super(qs);
        this.mapping = mapping;
        this.value = value;
        this.st.append(value ? this.getBooleanTrueValue() : this.getBooleanFalseValue());
    }

    public Object getValue() {
        return new Boolean(this.value);
    }

    protected String getBooleanTrueValue() {
        return "TRUE";
    }

    protected String getBooleanFalseValue() {
        return "(1=0)";
    }

    public BooleanExpression and(ScalarExpression expr) {
        if (expr instanceof BooleanExpression) {
            return this.value ? (BooleanExpression)expr : this;
        }
        return super.and(expr);
    }

    public BooleanExpression eor(ScalarExpression expr) {
        if (expr instanceof BooleanExpression) {
            return this.value ? expr.not() : (BooleanExpression)expr;
        }
        return super.eor(expr);
    }

    public BooleanExpression ior(ScalarExpression expr) {
        if (expr instanceof BooleanExpression) {
            return this.value ? this : (BooleanExpression)expr;
        }
        return super.ior(expr);
    }

    public BooleanExpression not() {
        return new BooleanLiteral(this.qs, this.mapping, !this.value);
    }

    public BooleanExpression eq(ScalarExpression expr) {
        if (expr instanceof BooleanExpression) {
            return this.value ? (BooleanExpression)expr : expr.not();
        }
        return super.eq(expr);
    }

    public BooleanExpression noteq(ScalarExpression expr) {
        if (expr instanceof BooleanExpression) {
            return this.value ? expr.not() : (BooleanExpression)expr;
        }
        return super.noteq(expr);
    }
}

