/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.expression;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.jdo.JDOHelper;
import javax.jdo.identity.SingleFieldIdentity;
import javax.jdo.spi.PersistenceCapable;
import org.jpox.ClassLoaderResolver;
import org.jpox.ObjectManager;
import org.jpox.ObjectManagerHelper;
import org.jpox.StateManager;
import org.jpox.exceptions.JPOXException;
import org.jpox.exceptions.JPOXUserException;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.AbstractPropertyMetaData;
import org.jpox.metadata.IdentityType;
import org.jpox.store.DatastoreAdapter;
import org.jpox.store.OID;
import org.jpox.store.StoreManager;
import org.jpox.store.expression.BooleanBitColumnExpression;
import org.jpox.store.expression.BooleanExpression;
import org.jpox.store.expression.BooleanLiteral;
import org.jpox.store.expression.Literal;
import org.jpox.store.expression.NullLiteral;
import org.jpox.store.expression.ObjectExpression;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.fieldmanager.SingleValueFieldManager;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.PersistenceCapableMapping;
import org.jpox.util.AIDUtils;
import org.jpox.util.JPOXLogger;

public class ObjectLiteral
extends ObjectExpression
implements Literal {
    private Object value;
    private String mappingClass;

    public ObjectLiteral(QueryExpression qs, JavaTypeMapping mapping, Object value) {
        super(qs);
        this.st.appendParameter(mapping, value);
        this.mapping = mapping;
        this.value = value;
    }

    public ObjectLiteral(QueryExpression qs, JavaTypeMapping mapping, Object value, String mappingClass) {
        super(qs);
        this.st.appendParameter(mapping, value);
        this.value = value;
        this.mapping = mapping;
        this.mappingClass = mappingClass;
    }

    public Object getValue() {
        return this.value;
    }

    public BooleanExpression eq(ScalarExpression expr) {
        if (expr instanceof ObjectLiteral) {
            return new BooleanLiteral(this.qs, this.mapping, this.value.equals(((ObjectLiteral)expr).value));
        }
        if (expr instanceof BooleanBitColumnExpression) {
            return null;
        }
        if (expr instanceof ObjectExpression) {
            BooleanExpression bExpr = this.getEqualityExpressionForObjectExpression((ObjectExpression)expr);
            return bExpr;
        }
        return super.eq(expr);
    }

    public BooleanExpression noteq(ScalarExpression expr) {
        if (expr instanceof ObjectLiteral) {
            return new BooleanLiteral(this.qs, this.mapping, !this.value.equals(((ObjectLiteral)expr).value));
        }
        if (expr instanceof ObjectExpression) {
            BooleanExpression bExpr = this.getEqualityExpressionForObjectExpression((ObjectExpression)expr);
            bExpr = new BooleanExpression(this, OP_NOTEQ, bExpr);
            return bExpr;
        }
        return super.noteq(expr);
    }

    private BooleanExpression getEqualityExpressionForObjectExpression(ObjectExpression expr) {
        BooleanExpression bExpr = null;
        if (this.value == null) {
            bExpr = expr.eq(new NullLiteral(this.qs));
        } else {
            StoreManager storeMgr = this.qs.getStoreManager();
            DatastoreAdapter dba = storeMgr.getDatastoreAdapter();
            ClassLoaderResolver clr = this.qs.getClassLoaderResolver();
            if (this.value instanceof OID) {
                JavaTypeMapping m = dba.getMapping(((OID)this.value).getKeyValue().getClass(), storeMgr, clr);
                ScalarExpression oidExpr = m.newLiteral(this.qs, ((OID)this.value).getKeyValue());
                bExpr = expr.expressionList.getExpression(0).eq(oidExpr);
            } else {
                AbstractClassMetaData cmd = storeMgr.getMetaDataManager().getMetaDataForClass(this.value.getClass(), clr);
                if (cmd == null) {
                    if (AIDUtils.isSingleFieldIdentityClass(this.value.getClass().getName())) {
                        JavaTypeMapping m = dba.getMapping(((SingleFieldIdentity)this.value).getTargetClass(), storeMgr, clr);
                        ScalarExpression oidExpr = m.newLiteral(this.qs, ((SingleFieldIdentity)this.value).getKeyAsObject());
                        bExpr = expr.expressionList.getExpression(0).eq(oidExpr);
                    } else {
                        String pcClassName = storeMgr.getClassNameForObjectID(this.value, clr, null);
                        if (pcClassName != null) {
                            cmd = storeMgr.getMetaDataManager().getMetaDataForClass(pcClassName, clr);
                            bExpr = this.eqApplicationIdentity(this.value, null, expr, null, storeMgr, clr);
                        } else {
                            bExpr = new BooleanLiteral(this.qs, this.mapping, false).eq(new BooleanLiteral(this.qs, this.mapping, true));
                        }
                    }
                } else {
                    JavaTypeMapping[] pkMappingsApp = null;
                    Object[] pkFieldValues = null;
                    if (cmd.getIdentityType() == IdentityType.APPLICATION && JDOHelper.getObjectId((Object)this.value) != null) {
                        pkMappingsApp = new JavaTypeMapping[expr.expressionList.size()];
                        pkFieldValues = new Object[expr.expressionList.size()];
                        int j = 0;
                        for (int i = 0; i < cmd.getNoOfPrimaryKeyFields(); ++i) {
                            AbstractPropertyMetaData fmd = cmd.getManagedFieldAbsolute(cmd.getPrimaryKeyFieldNumbers()[i]);
                            Object fieldValue = this.getFieldValue(fmd, this.value);
                            JavaTypeMapping mapping = dba.getMapping(fieldValue.getClass(), storeMgr, clr);
                            if (mapping instanceof PersistenceCapableMapping) {
                                JavaTypeMapping[] subMappings = ((PersistenceCapableMapping)mapping).getJavaTypeMapping();
                                for (int k = 0; k < subMappings.length; ++k) {
                                    pkMappingsApp[j] = subMappings[k];
                                    pkFieldValues[j] = this.getFieldValue(subMappings[k].getFieldMetaData(), fieldValue);
                                    ++j;
                                }
                                continue;
                            }
                            pkMappingsApp[j] = mapping;
                            pkFieldValues[j] = fieldValue;
                            ++j;
                        }
                    }
                    for (int i = 0; i < expr.expressionList.size(); ++i) {
                        ScalarExpression source = expr.expressionList.getExpression(i);
                        if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                            if (JDOHelper.getObjectId((Object)this.value) == null) {
                                JPOXLogger.QUERY.warn(LOCALISER.msg("ObjectLiteral.ComparisonWithObjectWithoutId", this.value));
                                bExpr = new BooleanLiteral(this.qs, this.mapping, false).eq(new BooleanLiteral(this.qs, this.mapping, true));
                                continue;
                            }
                            ScalarExpression target = pkMappingsApp[i].newLiteral(this.qs, pkFieldValues[i]);
                            if (bExpr == null) {
                                bExpr = source.eq(target);
                                continue;
                            }
                            bExpr = bExpr.and(source.eq(target));
                            continue;
                        }
                        OID objectId = (OID)JDOHelper.getObjectId((Object)this.value);
                        if (objectId == null) {
                            JPOXLogger.QUERY.warn(LOCALISER.msg("ObjectLiteral.ComparisonWithObjectWithoutId", this.value));
                            bExpr = new BooleanLiteral(this.qs, this.mapping, false).eq(new BooleanLiteral(this.qs, this.mapping, true));
                            continue;
                        }
                        JavaTypeMapping m = dba.getMapping(objectId.getKeyValue().getClass(), storeMgr, clr);
                        ScalarExpression oidExpr = m.newLiteral(this.qs, objectId.getKeyValue());
                        bExpr = expr.expressionList.getExpression(0).eq(oidExpr);
                    }
                }
                if (expr.conditionExpr != null) {
                    bExpr = new BooleanExpression(expr.conditionExpr, OP_AND, bExpr);
                }
            }
        }
        return bExpr;
    }

    private BooleanExpression eqApplicationIdentity(Object id, BooleanExpression bExpr, ScalarExpression expr, Index index, StoreManager storeMgr, ClassLoaderResolver clr) {
        if (index == null) {
            index = new Index();
        }
        for (int i = 0; i < id.getClass().getDeclaredFields().length; ++i) {
            Object value = this.getFieldValue(id, id.getClass().getDeclaredFields()[i].getName());
            String pcClassName = storeMgr.getClassNameForObjectID(value, clr, null);
            if (pcClassName != null) {
                if (bExpr == null) {
                    bExpr = this.eqApplicationIdentity(value, bExpr, expr, index, storeMgr, clr);
                    continue;
                }
                bExpr = bExpr.and(this.eqApplicationIdentity(value, bExpr, expr, index, storeMgr, clr));
                continue;
            }
            ScalarExpression source = expr.getExpressionList().getExpression(index.index);
            JavaTypeMapping mapping = storeMgr.getDatastoreAdapter().getMapping(value.getClass(), storeMgr, clr);
            ScalarExpression target = mapping.newLiteral(this.qs, value);
            bExpr = bExpr == null ? source.eq(target) : bExpr.and(source.eq(target));
            if (target.getExpressionList().size() == 0) {
                ++index.index;
                continue;
            }
            index.index += target.getExpressionList().size();
        }
        return bExpr;
    }

    public ScalarExpression accessField(String subfieldName, boolean innerJoin) {
        Object fieldValue = null;
        try {
            AbstractClassMetaData acmd = this.qs.getStoreManager().getMetaDataManager().getMetaDataForClass(this.mappingClass, this.qs.getClassLoaderResolver());
            if (acmd == null) {
                fieldValue = this.getFieldValue(this.value, subfieldName);
            } else {
                AbstractPropertyMetaData fmd = acmd.getField(subfieldName);
                if (fmd == null) {
                    throw new JPOXUserException("Cannot access field " + subfieldName + " on type " + this.mappingClass);
                }
                fieldValue = this.getFieldValue(fmd, this.value);
            }
        }
        catch (Exception e) {
            fieldValue = this.getFieldValue(this.value, subfieldName);
        }
        try {
            if (fieldValue == null) {
                return new NullLiteral(this.qs);
            }
            DatastoreAdapter dba = this.qs.getStoreManager().getDatastoreAdapter();
            JavaTypeMapping mapping = this.mappingClass != null && subfieldName == null ? dba.getMapping(this.qs.getClassLoaderResolver().classForName(this.mappingClass), this.qs.getStoreManager(), this.qs.getClassLoaderResolver()) : dba.getMapping(fieldValue.getClass(), this.qs.getStoreManager(), this.qs.getClassLoaderResolver());
            return mapping.newLiteral(this.qs, fieldValue);
        }
        catch (SecurityException e) {
            throw new JPOXUserException("Cannot access field: " + subfieldName, e);
        }
        catch (IllegalArgumentException e) {
            throw new JPOXUserException("Cannot access field: " + subfieldName, e);
        }
        catch (Exception e) {
            throw new JPOXUserException("Cannot access field: " + subfieldName + " " + e, e);
        }
    }

    public String toString() {
        return super.toString() + " = " + this.value.toString();
    }

    private Field getDeclaredFieldPrivileged(final Class clazz, final String fieldName) {
        if (clazz == null || fieldName == null) {
            return null;
        }
        return (Field)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Class seekingClass = clazz;
                do {
                    try {
                        return seekingClass.getDeclaredField(fieldName);
                    }
                    catch (SecurityException ex) {
                        throw new JPOXException("CannotGetDeclaredField", ex).setFatal();
                    }
                    catch (NoSuchFieldException ex) {
                    }
                    catch (LinkageError ex) {
                        throw new JPOXException("ClassLoadingError", ex).setFatal();
                    }
                } while ((seekingClass = seekingClass.getSuperclass()) != null);
                return null;
            }
        });
    }

    private Object getFieldValue(AbstractPropertyMetaData fmd, Object object) {
        ObjectManager om = ObjectManagerHelper.getObjectManager(object);
        if (om == null) {
            return this.getFieldValue(object, fmd.getName());
        }
        StateManager sm = om.findStateManager((PersistenceCapable)object);
        SingleValueFieldManager fm = new SingleValueFieldManager();
        if (!fmd.isPrimaryKey()) {
            sm.isLoaded((PersistenceCapable)object, fmd.getAbsoluteFieldNumber());
        }
        sm.provideFields(new int[]{fmd.getAbsoluteFieldNumber()}, fm);
        return fm.fetchObjectField(fmd.getAbsoluteFieldNumber());
    }

    private Object getFieldValue(Object object, String fieldName) {
        Object fieldValue;
        final Field field = this.getDeclaredFieldPrivileged(object.getClass(), fieldName);
        if (field == null) {
            throw new JPOXUserException("Cannot access field: " + fieldName + " in type " + object.getClass());
        }
        try {
            if (!field.isAccessible()) {
                try {
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            field.setAccessible(true);
                            return null;
                        }
                    });
                }
                catch (SecurityException ex) {
                    throw new JPOXException("Cannot access field: " + fieldName, ex).setFatal();
                }
            }
            fieldValue = field.get(object);
        }
        catch (IllegalArgumentException e2) {
            throw new JPOXUserException("Cannot access field: " + fieldName, e2);
        }
        catch (IllegalAccessException e2) {
            throw new JPOXUserException("Cannot access field: " + fieldName, e2);
        }
        return fieldValue;
    }

    private static class Index {
        int index;

        private Index() {
        }
    }
}

