/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.expression;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.jpox.store.expression.BooleanExpression;
import org.jpox.store.expression.ByteLiteral;
import org.jpox.store.expression.CharacterExpression;
import org.jpox.store.expression.CharacterLiteral;
import org.jpox.store.expression.FloatingPointLiteral;
import org.jpox.store.expression.IntegerLiteral;
import org.jpox.store.expression.Literal;
import org.jpox.store.expression.LogicSetExpression;
import org.jpox.store.expression.MatchExpressionParser;
import org.jpox.store.expression.NullLiteral;
import org.jpox.store.expression.NumericExpression;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.expression.SqlTemporalExpression;
import org.jpox.store.expression.StringLiteral;
import org.jpox.store.mapping.JavaTypeMapping;

public class StringExpression
extends ScalarExpression {
    protected StringExpression(QueryExpression qs) {
        super(qs);
    }

    public StringExpression(QueryExpression qs, JavaTypeMapping mapping, LogicSetExpression te) {
        super(qs, mapping, te);
    }

    public StringExpression(String functionName, List args) {
        super(functionName, args);
    }

    public StringExpression(String functionName, List args, List types) {
        super(functionName, args, types);
    }

    public StringExpression(ScalarExpression operand1, ScalarExpression.DyadicOperator op, ScalarExpression operand2) {
        super(operand1, op, operand2);
    }

    public BooleanExpression eq(ScalarExpression expr) {
        if (expr instanceof NullLiteral) {
            return expr.eq(this);
        }
        if (expr instanceof CharacterLiteral) {
            return new BooleanExpression(this, OP_EQ, expr);
        }
        if (expr instanceof StringExpression) {
            return new BooleanExpression(this, OP_EQ, expr);
        }
        if (expr instanceof ByteLiteral) {
            int value = ((BigInteger)((ByteLiteral)expr).getValue()).intValue();
            CharacterLiteral literal = new CharacterLiteral(this.qs, this.mapping, String.valueOf((char)value));
            return new BooleanExpression(this, OP_EQ, literal);
        }
        if (expr instanceof IntegerLiteral) {
            int value = ((Number)((IntegerLiteral)expr).getValue()).intValue();
            CharacterLiteral literal = new CharacterLiteral(this.qs, this.mapping, String.valueOf((char)value));
            return new BooleanExpression(this, OP_EQ, literal);
        }
        if (expr instanceof FloatingPointLiteral) {
            int value = ((BigDecimal)((FloatingPointLiteral)expr).getValue()).intValue();
            CharacterLiteral literal = new CharacterLiteral(this.qs, this.mapping, String.valueOf((char)value));
            return new BooleanExpression(this, OP_EQ, literal);
        }
        if (expr instanceof NumericExpression) {
            return new BooleanExpression(this, OP_EQ, expr);
        }
        if (expr instanceof SqlTemporalExpression) {
            return new BooleanExpression(this, OP_EQ, expr);
        }
        return super.eq(expr);
    }

    public BooleanExpression noteq(ScalarExpression expr) {
        if (expr instanceof NullLiteral) {
            return expr.noteq(this);
        }
        if (expr instanceof CharacterLiteral) {
            return new BooleanExpression(this, OP_NOTEQ, expr);
        }
        if (expr instanceof StringExpression) {
            return new BooleanExpression(this, OP_NOTEQ, expr);
        }
        if (expr instanceof ByteLiteral) {
            int value = ((BigInteger)((ByteLiteral)expr).getValue()).intValue();
            CharacterLiteral literal = new CharacterLiteral(this.qs, this.mapping, String.valueOf((char)value));
            return new BooleanExpression(this, OP_NOTEQ, literal);
        }
        if (expr instanceof IntegerLiteral) {
            int value = ((Number)((IntegerLiteral)expr).getValue()).intValue();
            CharacterLiteral literal = new CharacterLiteral(this.qs, this.mapping, String.valueOf((char)value));
            return new BooleanExpression(this, OP_NOTEQ, literal);
        }
        if (expr instanceof FloatingPointLiteral) {
            int value = ((BigDecimal)((FloatingPointLiteral)expr).getValue()).intValue();
            CharacterLiteral literal = new CharacterLiteral(this.qs, this.mapping, String.valueOf((char)value));
            return new BooleanExpression(this, OP_NOTEQ, literal);
        }
        if (expr instanceof NumericExpression) {
            return new BooleanExpression(this, OP_NOTEQ, expr);
        }
        if (expr instanceof SqlTemporalExpression) {
            return new BooleanExpression(this, OP_NOTEQ, expr);
        }
        return super.noteq(expr);
    }

    public BooleanExpression lt(ScalarExpression expr) {
        if (expr instanceof NullLiteral) {
            return expr.lt(this);
        }
        if (expr instanceof CharacterLiteral) {
            return new BooleanExpression(this, OP_LT, expr);
        }
        if (expr instanceof StringExpression) {
            return new BooleanExpression(this, OP_LT, expr);
        }
        if (expr instanceof ByteLiteral) {
            int value = ((BigInteger)((ByteLiteral)expr).getValue()).intValue();
            CharacterLiteral literal = new CharacterLiteral(this.qs, this.mapping, String.valueOf((char)value));
            return new BooleanExpression(this, OP_LT, literal);
        }
        if (expr instanceof IntegerLiteral) {
            int value = ((Number)((IntegerLiteral)expr).getValue()).intValue();
            CharacterLiteral literal = new CharacterLiteral(this.qs, this.mapping, String.valueOf((char)value));
            return new BooleanExpression(this, OP_LT, literal);
        }
        if (expr instanceof FloatingPointLiteral) {
            int value = ((BigDecimal)((FloatingPointLiteral)expr).getValue()).intValue();
            CharacterLiteral literal = new CharacterLiteral(this.qs, this.mapping, String.valueOf((char)value));
            return new BooleanExpression(this, OP_LT, literal);
        }
        if (expr instanceof NumericExpression) {
            return new BooleanExpression(this, OP_LT, expr);
        }
        return super.lt(expr);
    }

    public BooleanExpression lteq(ScalarExpression expr) {
        if (expr instanceof NullLiteral) {
            return expr.lteq(this);
        }
        if (expr instanceof CharacterLiteral) {
            return new BooleanExpression(this, OP_LTEQ, expr);
        }
        if (expr instanceof StringExpression) {
            return new BooleanExpression(this, OP_LTEQ, expr);
        }
        if (expr instanceof ByteLiteral) {
            int value = ((BigInteger)((ByteLiteral)expr).getValue()).intValue();
            CharacterLiteral literal = new CharacterLiteral(this.qs, this.mapping, String.valueOf((char)value));
            return new BooleanExpression(this, OP_LTEQ, literal);
        }
        if (expr instanceof IntegerLiteral) {
            int value = ((Number)((IntegerLiteral)expr).getValue()).intValue();
            CharacterLiteral literal = new CharacterLiteral(this.qs, this.mapping, String.valueOf((char)value));
            return new BooleanExpression(this, OP_LTEQ, literal);
        }
        if (expr instanceof FloatingPointLiteral) {
            int value = ((BigDecimal)((FloatingPointLiteral)expr).getValue()).intValue();
            CharacterLiteral literal = new CharacterLiteral(this.qs, this.mapping, String.valueOf((char)value));
            return new BooleanExpression(this, OP_LTEQ, literal);
        }
        if (expr instanceof NumericExpression) {
            return new BooleanExpression(this, OP_LTEQ, expr);
        }
        return super.lteq(expr);
    }

    public BooleanExpression gt(ScalarExpression expr) {
        if (expr instanceof NullLiteral) {
            return expr.gt(this);
        }
        if (expr instanceof CharacterLiteral) {
            return new BooleanExpression(this, OP_GT, expr);
        }
        if (expr instanceof StringExpression) {
            return new BooleanExpression(this, OP_GT, expr);
        }
        if (expr instanceof ByteLiteral) {
            int value = ((BigInteger)((ByteLiteral)expr).getValue()).intValue();
            CharacterLiteral literal = new CharacterLiteral(this.qs, this.mapping, String.valueOf((char)value));
            return new BooleanExpression(this, OP_GT, literal);
        }
        if (expr instanceof IntegerLiteral) {
            int value = ((Number)((IntegerLiteral)expr).getValue()).intValue();
            CharacterLiteral literal = new CharacterLiteral(this.qs, this.mapping, String.valueOf((char)value));
            return new BooleanExpression(this, OP_GT, literal);
        }
        if (expr instanceof FloatingPointLiteral) {
            int value = ((BigDecimal)((FloatingPointLiteral)expr).getValue()).intValue();
            CharacterLiteral literal = new CharacterLiteral(this.qs, this.mapping, String.valueOf((char)value));
            return new BooleanExpression(this, OP_GT, literal);
        }
        if (expr instanceof NumericExpression) {
            return new BooleanExpression(this, OP_GT, expr);
        }
        return super.gt(expr);
    }

    public BooleanExpression gteq(ScalarExpression expr) {
        if (expr instanceof NullLiteral) {
            return expr.gteq(this);
        }
        if (expr instanceof CharacterLiteral) {
            return new BooleanExpression(this, OP_GTEQ, expr);
        }
        if (expr instanceof StringExpression) {
            return new BooleanExpression(this, OP_GTEQ, expr);
        }
        if (expr instanceof ByteLiteral) {
            int value = ((BigInteger)((ByteLiteral)expr).getValue()).intValue();
            CharacterLiteral literal = new CharacterLiteral(this.qs, this.mapping, String.valueOf((char)value));
            return new BooleanExpression(this, OP_GTEQ, literal);
        }
        if (expr instanceof IntegerLiteral) {
            int value = ((Number)((IntegerLiteral)expr).getValue()).intValue();
            CharacterLiteral literal = new CharacterLiteral(this.qs, this.mapping, String.valueOf((char)value));
            return new BooleanExpression(this, OP_GTEQ, literal);
        }
        if (expr instanceof FloatingPointLiteral) {
            int value = ((BigDecimal)((FloatingPointLiteral)expr).getValue()).intValue();
            CharacterLiteral literal = new CharacterLiteral(this.qs, this.mapping, String.valueOf((char)value));
            return new BooleanExpression(this, OP_GTEQ, literal);
        }
        if (expr instanceof NumericExpression) {
            return new BooleanExpression(this, OP_GTEQ, expr);
        }
        return super.gteq(expr);
    }

    public ScalarExpression add(ScalarExpression expr) {
        if (expr instanceof StringLiteral) {
            return new StringExpression(this, OP_CONCAT, new StringLiteral(this.qs, expr.mapping, (String)((StringLiteral)expr).getValue()));
        }
        if (expr instanceof StringExpression) {
            return new StringExpression(this, OP_CONCAT, expr);
        }
        if (expr instanceof CharacterExpression) {
            return new StringExpression(this, OP_CONCAT, expr);
        }
        if (expr instanceof NumericExpression) {
            return new StringExpression(this, OP_CONCAT, this.qs.getStoreManager().getDatastoreAdapter().toStringExpression((NumericExpression)expr));
        }
        if (expr instanceof NullLiteral) {
            return expr;
        }
        return new StringExpression(this, OP_CONCAT, expr);
    }

    public BooleanExpression in(ScalarExpression expr) {
        return new BooleanExpression(this, OP_IN, expr);
    }

    public BooleanExpression equalsMethod(ScalarExpression expr) {
        return this.eq(expr);
    }

    public StringExpression charAtMethod(ScalarExpression index) {
        if (!(index instanceof NumericExpression)) {
            throw new ScalarExpression.IllegalArgumentTypeException(index);
        }
        NumericExpression begin = (NumericExpression)index;
        NumericExpression end = (NumericExpression)begin.add(new IntegerLiteral(this.qs, this.mapping, BigInteger.ONE));
        return this.substringMethod(begin, end);
    }

    public BooleanExpression endsWithMethod(ScalarExpression str) {
        if (!(str instanceof StringExpression)) {
            throw new ScalarExpression.IllegalArgumentTypeException(str);
        }
        return this.qs.getStoreManager().getDatastoreAdapter().endsWithMethod(this, str);
    }

    public NumericExpression indexOfMethod(ScalarExpression str) {
        if (!(str instanceof StringExpression) && !(str instanceof CharacterLiteral)) {
            throw new ScalarExpression.IllegalArgumentTypeException(str);
        }
        return this.qs.getStoreManager().getDatastoreAdapter().indexOfMethod(this, str, null);
    }

    public NumericExpression indexOfMethod(ScalarExpression str, ScalarExpression fromIndex) {
        if (!(str instanceof StringExpression) && !(str instanceof CharacterLiteral)) {
            throw new ScalarExpression.IllegalArgumentTypeException(str);
        }
        if (!(fromIndex instanceof NumericExpression)) {
            throw new ScalarExpression.IllegalArgumentTypeException(fromIndex);
        }
        return this.qs.getStoreManager().getDatastoreAdapter().indexOfMethod(this, str, (NumericExpression)fromIndex);
    }

    public NumericExpression lengthMethod() {
        return this.qs.getStoreManager().getDatastoreAdapter().lengthMethod(this);
    }

    public BooleanExpression startsWithMethod(ScalarExpression str) {
        if (!(str instanceof StringExpression)) {
            throw new ScalarExpression.IllegalArgumentTypeException(str);
        }
        return this.qs.getStoreManager().getDatastoreAdapter().startsWithMethod(this, str);
    }

    public BooleanExpression startsWithMethod(ScalarExpression str, ScalarExpression toffset) {
        return this.substringMethod(toffset).startsWithMethod(str);
    }

    public StringExpression substringMethod(ScalarExpression begin) {
        if (!(begin instanceof NumericExpression)) {
            throw new ScalarExpression.IllegalArgumentTypeException(begin);
        }
        return this.qs.getStoreManager().getDatastoreAdapter().substringMethod(this, (NumericExpression)begin);
    }

    public StringExpression substringMethod(ScalarExpression begin, ScalarExpression end) {
        if (!(begin instanceof NumericExpression)) {
            throw new ScalarExpression.IllegalArgumentTypeException(begin);
        }
        if (!(end instanceof NumericExpression)) {
            throw new ScalarExpression.IllegalArgumentTypeException(end);
        }
        return this.qs.getStoreManager().getDatastoreAdapter().substringMethod(this, (NumericExpression)begin, (NumericExpression)end);
    }

    public StringExpression translateMethod(ScalarExpression toExpr, ScalarExpression fromExpr) {
        return this.qs.getStoreManager().getDatastoreAdapter().translateMethod(this, toExpr, fromExpr);
    }

    public StringExpression toLowerCaseMethod() {
        ArrayList<StringExpression> args = new ArrayList<StringExpression>();
        args.add(this);
        return new StringExpression("LOWER", args);
    }

    public StringExpression toUpperCaseMethod() {
        ArrayList<StringExpression> args = new ArrayList<StringExpression>();
        args.add(this);
        return new StringExpression("UPPER", args);
    }

    public BooleanExpression matchesMethod(ScalarExpression expr) {
        if (expr instanceof StringLiteral) {
            String pattern = (String)((Literal)((Object)expr)).getValue();
            boolean caseSensitive = false;
            if (pattern.startsWith("(?i)")) {
                caseSensitive = true;
                pattern = pattern.substring(4);
            }
            MatchExpressionParser parser = new MatchExpressionParser(pattern, this.qs.getStoreManager().getDatastoreAdapter().getPatternExpressionZeroMoreCharacters().charAt(0), this.qs.getStoreManager().getDatastoreAdapter().getPatternExpressionAnyCharacter().charAt(0), this.qs.getStoreManager().getDatastoreAdapter().getEscapeCharacter().charAt(0));
            if (caseSensitive) {
                StringLiteral patternExpr = new StringLiteral(this.qs, this.mapping, parser.parsePattern().toLowerCase());
                return new BooleanExpression(this.toLowerCaseMethod(), ScalarExpression.OP_LIKE, patternExpr);
            }
            StringLiteral patternExpr = new StringLiteral(this.qs, this.mapping, parser.parsePattern());
            return new BooleanExpression(this, ScalarExpression.OP_LIKE, patternExpr);
        }
        if (expr instanceof StringExpression) {
            return this.qs.getStoreManager().getDatastoreAdapter().matchesMethod(this, (StringExpression)expr);
        }
        throw new ScalarExpression.IllegalOperationException(this, "matches", expr);
    }

    public BooleanExpression likeMethod(ScalarExpression expr) {
        return new BooleanExpression(this, ScalarExpression.OP_LIKE, expr);
    }

    public StringExpression trimMethod() {
        return this.qs.getStoreManager().getDatastoreAdapter().trimMethod(this);
    }
}

