/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.fieldmanager;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.jdo.spi.PersistenceCapable;
import org.jpox.StateManager;
import org.jpox.metadata.AbstractPropertyMetaData;
import org.jpox.sco.SCO;
import org.jpox.store.fieldmanager.AbstractFieldManager;

public class PersistFieldManager
extends AbstractFieldManager {
    private final StateManager sm;
    private final boolean replaceSCOsWithWrappers;

    public PersistFieldManager(StateManager sm, boolean replaceSCOsWithWrappers) {
        this.sm = sm;
        this.replaceSCOsWithWrappers = replaceSCOsWithWrappers;
    }

    public void storeObjectField(int fieldNumber, Object value) {
        block7: {
            AbstractPropertyMetaData fmd;
            block10: {
                Iterator<Object> iter;
                Map map;
                block9: {
                    int relationType;
                    block8: {
                        StateManager valueSM;
                        boolean[] secondClassMutableFieldFlags;
                        if (value == null) break block7;
                        fmd = this.sm.getClassMetaData().getManagedFieldAbsolute(fieldNumber);
                        boolean persistCascade = fmd.isCascadePersist();
                        if (this.replaceSCOsWithWrappers && (secondClassMutableFieldFlags = this.sm.getClassMetaData().getSecondClassMutableFieldFlags())[fieldNumber] && !(value instanceof SCO)) {
                            this.sm.replaceSCOField(fieldNumber, value, true);
                        }
                        if (!persistCascade) break block7;
                        relationType = fmd.getRelationType(this.sm.getObjectManager().getClassLoaderResolver());
                        if (relationType != 2 && relationType != 1 && relationType != 6) break block8;
                        if (!(value instanceof PersistenceCapable) || (valueSM = this.sm.getObjectManager().findStateManager((PersistenceCapable)value)) != null) break block7;
                        this.processPersistenceCapable((PersistenceCapable)value);
                        break block7;
                    }
                    if (relationType != 4 && relationType != 3 && relationType != 5) break block7;
                    if (!fmd.hasCollection() || fmd.getCollection().getElementClassMetaData() == null) break block9;
                    if (fmd.getCollection().getElementClassMetaData() == null) break block7;
                    Collection coll = (Collection)value;
                    Iterator iter2 = coll.iterator();
                    while (iter2.hasNext()) {
                        StateManager elementSM;
                        Object element = iter2.next();
                        if (element == null || !(element instanceof PersistenceCapable) || (elementSM = this.sm.getObjectManager().findStateManager((PersistenceCapable)element)) != null) continue;
                        this.processPersistenceCapable((PersistenceCapable)element);
                    }
                    break block7;
                }
                if (!fmd.hasMap()) break block10;
                if (fmd.getMap().getKeyClassMetaData() != null) {
                    map = (Map)value;
                    Set keys = map.keySet();
                    iter = keys.iterator();
                    while (iter.hasNext()) {
                        StateManager keySM;
                        Object mapKey = iter.next();
                        if (mapKey == null || !(mapKey instanceof PersistenceCapable) || (keySM = this.sm.getObjectManager().findStateManager((PersistenceCapable)mapKey)) != null) continue;
                        this.processPersistenceCapable((PersistenceCapable)mapKey);
                    }
                }
                if (fmd.getMap().getValueClassMetaData() == null) break block7;
                map = (Map)value;
                Collection values = map.values();
                iter = values.iterator();
                while (iter.hasNext()) {
                    StateManager valueSM;
                    Object mapValue = iter.next();
                    if (mapValue == null || !(mapValue instanceof PersistenceCapable) || (valueSM = this.sm.getObjectManager().findStateManager((PersistenceCapable)mapValue)) != null) continue;
                    this.processPersistenceCapable((PersistenceCapable)mapValue);
                }
                break block7;
            }
            if (fmd.hasArray() && fmd.getArray().getElementClassMetaData() != null) {
                for (int i = 0; i < Array.getLength(value); ++i) {
                    StateManager elementSM;
                    Object element = Array.get(value, i);
                    if (element == null || !(element instanceof PersistenceCapable) || (elementSM = this.sm.getObjectManager().findStateManager((PersistenceCapable)element)) != null) continue;
                    this.processPersistenceCapable((PersistenceCapable)element);
                }
            }
        }
    }

    protected void processPersistenceCapable(PersistenceCapable pc) {
        this.sm.getObjectManager().persistObjectInternal(pc, null);
    }

    public void storeBooleanField(int fieldNumber, boolean value) {
    }

    public void storeByteField(int fieldNumber, byte value) {
    }

    public void storeCharField(int fieldNumber, char value) {
    }

    public void storeDoubleField(int fieldNumber, double value) {
    }

    public void storeFloatField(int fieldNumber, float value) {
    }

    public void storeIntField(int fieldNumber, int value) {
    }

    public void storeLongField(int fieldNumber, long value) {
    }

    public void storeShortField(int fieldNumber, short value) {
    }

    public void storeStringField(int fieldNumber, String value) {
    }
}

