/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.mapping;

import java.util.Collection;
import javax.jdo.JDOHelper;
import org.jpox.ClassLoaderResolver;
import org.jpox.StateManager;
import org.jpox.exceptions.JPOXException;
import org.jpox.exceptions.JPOXUserException;
import org.jpox.metadata.AbstractPropertyMetaData;
import org.jpox.sco.SCO;
import org.jpox.store.expression.CollectionExpression;
import org.jpox.store.expression.CollectionLiteral;
import org.jpox.store.expression.CollectionSubqueryExpression;
import org.jpox.store.expression.LogicSetExpression;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.mapping.AbstractContainerMapping;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.MappingCallbacks;
import org.jpox.store.query.Queryable;
import org.jpox.store.scostore.CollectionStore;
import org.jpox.store.scostore.ListStore;
import org.jpox.store.scostore.SetStore;
import org.jpox.util.JPOXLogger;
import org.jpox.util.JavaUtils;

public class CollectionMapping
extends AbstractContainerMapping
implements MappingCallbacks {
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$util$Queue;
    static /* synthetic */ Class class$java$util$Set;
    static /* synthetic */ Class class$java$util$Collection;

    protected boolean isListBased() {
        if (this.instantiatedType == null) {
            return false;
        }
        if ((class$java$util$List == null ? (class$java$util$List = CollectionMapping.class$("java.util.List")) : class$java$util$List).isAssignableFrom(this.instantiatedType)) {
            return true;
        }
        return JavaUtils.isJRE1_5OrAbove() && (class$java$util$Queue == null ? (class$java$util$Queue = CollectionMapping.class$("java.util.Queue")) : class$java$util$Queue).isAssignableFrom(this.instantiatedType);
    }

    public synchronized CollectionStore getBackingStore(ClassLoaderResolver clr) {
        if (this.containerIsStoredInSingleColumn()) {
            return null;
        }
        if (this.contentsStore == null) {
            this.contentsStore = this.storeMgr.getBackingStoreForCollection(this.fmd, this.contentsTable, clr, this.instantiatedType != null, this.isListBased());
        } else if (this.instantiatedType != null) {
            boolean recreateBackingStore = false;
            if (this.contentsStore instanceof ListStore && (class$java$util$Set == null ? (class$java$util$Set = CollectionMapping.class$("java.util.Set")) : class$java$util$Set).isAssignableFrom(this.instantiatedType)) {
                recreateBackingStore = true;
            } else if (this.contentsStore instanceof SetStore && (class$java$util$List == null ? (class$java$util$List = CollectionMapping.class$("java.util.List")) : class$java$util$List).isAssignableFrom(this.instantiatedType)) {
                recreateBackingStore = true;
            }
            if (recreateBackingStore) {
                this.contentsStore = this.storeMgr.getBackingStoreForCollection(this.fmd, this.contentsTable, clr, this.instantiatedType != null, this.isListBased());
            }
        }
        return (CollectionStore)this.contentsStore;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        CollectionMapping sm = (CollectionMapping)obj;
        return this.fmd.equals(sm.fmd) && this.storeMgr.equals(sm.storeMgr);
    }

    public Class getJavaType() {
        return class$java$util$Collection == null ? (class$java$util$Collection = CollectionMapping.class$("java.util.Collection")) : class$java$util$Collection;
    }

    public void postInsert(StateManager sm) {
        Collection value = (Collection)sm.provideField(this.fmd.getAbsoluteFieldNumber());
        if (this.containerIsStoredInSingleColumn()) {
            this.validateElementsForWriting(sm, value);
            return;
        }
        if (value == null) {
            sm.replaceField(this.fmd.getAbsoluteFieldNumber(), this.newWrapper(sm, this.fieldName), true);
            return;
        }
        if (!this.fmd.isCascadePersist()) {
            if (JPOXLogger.REACHABILITY.isDebugEnabled()) {
                JPOXLogger.REACHABILITY.debug(LOCALISER.msg("Reachability.NotRunForFieldOnInsert", this.fmd.getFullFieldName()));
            }
            return;
        }
        if (JPOXLogger.REACHABILITY.isDebugEnabled()) {
            JPOXLogger.REACHABILITY.debug(LOCALISER.msg("Reachability.PersistingField", this.fmd.getFullFieldName()));
        }
        if (this.instantiatedType == null) {
            this.instantiatedType = value.getClass();
        }
        boolean needsAttaching = false;
        Object[] collElements = value.toArray();
        for (int i = 0; i < collElements.length; ++i) {
            if (!JDOHelper.isDetached((Object)collElements[i])) continue;
            needsAttaching = true;
            break;
        }
        if (needsAttaching) {
            SCO collWrapper = (SCO)this.newWrapper(sm, this.fieldName);
            collWrapper.attachCopy(value);
            sm.replaceField(this.fmd.getAbsoluteFieldNumber(), collWrapper, true);
        } else {
            CollectionStore backingStore = this.getBackingStore(sm.getObjectManager().getClassLoaderResolver());
            if (backingStore instanceof ListStore) {
                ((ListStore)backingStore).addAll(sm, value, true);
            } else {
                this.getBackingStore(sm.getObjectManager().getClassLoaderResolver()).addAll(sm, value);
            }
            sm.replaceField(this.fmd.getAbsoluteFieldNumber(), this.newWrapper(sm, this.fieldName), true);
        }
    }

    public void postUpdate(StateManager sm) {
        Collection value = (Collection)sm.provideField(this.fmd.getAbsoluteFieldNumber());
        if (this.containerIsStoredInSingleColumn()) {
            this.validateElementsForWriting(sm, value);
            return;
        }
        if (value == null) {
            this.getBackingStore(sm.getObjectManager().getClassLoaderResolver()).clear(sm);
            sm.replaceField(this.fmd.getAbsoluteFieldNumber(), this.newWrapper(sm, this.fieldName), true);
            return;
        }
        if (value instanceof SCO) {
            SCO sco = (SCO)((Object)value);
            if (sm.getObject() == sco.getOwner() && this.fieldName.equals(sco.getFieldName())) {
                return;
            }
            if (sco.getOwner() != null) {
                throw new JPOXException(LOCALISER.msg("CollectionMapping.WrongOwnerError")).setFatal();
            }
        }
        if (!this.fmd.isCascadeUpdate()) {
            if (JPOXLogger.REACHABILITY.isDebugEnabled()) {
                JPOXLogger.REACHABILITY.debug(LOCALISER.msg("Reachability.NotRunForFieldOnUpdate", this.fmd.getFullFieldName()));
            }
            return;
        }
        if (JPOXLogger.REACHABILITY.isDebugEnabled()) {
            JPOXLogger.REACHABILITY.debug(LOCALISER.msg("Reachability.UpdatingField", this.fmd.getFullFieldName()));
        }
        if (this.instantiatedType == null) {
            this.instantiatedType = value.getClass();
        }
        CollectionStore backingStore = this.getBackingStore(sm.getObjectManager().getClassLoaderResolver());
        backingStore.clear(sm);
        if (backingStore instanceof ListStore) {
            ((ListStore)backingStore).addAll(sm, value, true);
        } else {
            this.getBackingStore(sm.getObjectManager().getClassLoaderResolver()).addAll(sm, value);
        }
        sm.replaceField(this.fmd.getAbsoluteFieldNumber(), this.newWrapper(sm, this.fieldName), true);
    }

    public void preDelete(StateManager sm) {
    }

    public void deleteDependent(StateManager sm) {
        if (this.containerIsStoredInSingleColumn()) {
            return;
        }
        boolean isDependentElement = this.fmd.getCollection().isDependentElement();
        boolean hasJoin = this.fmd.getJoinMetaData() != null;
        boolean hasFK = false;
        if (!hasJoin) {
            if (this.fmd.getElementMetaData() != null && this.fmd.getElementMetaData().getForeignKeyMetaData() != null) {
                hasFK = true;
            } else if (this.fmd.getForeignKeyMetaData() != null) {
                hasFK = true;
            }
            AbstractPropertyMetaData relatedFmd = this.fmd.getRelatedFieldMetaData(sm.getObjectManager().getClassLoaderResolver());
            if (relatedFmd != null && relatedFmd.getForeignKeyMetaData() != null) {
                hasFK = true;
            }
        }
        if (sm.getObjectManager().getOMFContext().getPersistenceConfiguration().getDeletionPolicy().equals("JDO2")) {
            hasFK = false;
        }
        if (isDependentElement || hasJoin || !hasFK) {
            this.getBackingStore(sm.getObjectManager().getClassLoaderResolver()).clear(sm);
        }
    }

    public ScalarExpression newLiteral(QueryExpression qs, Object value) {
        if (this.containerIsStoredInSingleColumn()) {
            throw new JPOXUserException(LOCALISER.msg("ContainerMapping.QueryInvalidIfSerialised", this.fmd.getFullFieldName())).setFatal();
        }
        if (value instanceof Queryable) {
            return new CollectionSubqueryExpression(qs, ((Queryable)value).newQueryStatement());
        }
        return new CollectionLiteral(qs, (JavaTypeMapping)this, (Collection)value);
    }

    public ScalarExpression newScalarExpression(QueryExpression qs, LogicSetExpression te) {
        if (this.containerIsStoredInSingleColumn()) {
            throw new JPOXUserException(LOCALISER.msg("ContainerMapping.QueryInvalidIfSerialised", this.fmd.getFullFieldName())).setFatal();
        }
        return new CollectionExpression(qs, this.datastoreContainer.getIDMapping(), te, this.getBackingStore(qs.getClassLoaderResolver()), this.fieldName);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

