/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.mapping;

import org.jpox.ClassLoaderResolver;
import org.jpox.exceptions.JPOXException;
import org.jpox.metadata.AbstractPropertyMetaData;
import org.jpox.store.DatastoreAdapter;
import org.jpox.store.DatastoreContainerObject;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.util.Localiser;

public final class MappingFactory {
    private static final Localiser LOCALISER = Localiser.getInstance("org.jpox.store.Localisation");

    private MappingFactory() {
    }

    public static JavaTypeMapping createMapping(Class mappingClass, DatastoreAdapter dba, String type) {
        JavaTypeMapping mapping = null;
        try {
            mapping = (JavaTypeMapping)mappingClass.newInstance();
        }
        catch (Exception e) {
            throw new JPOXException(LOCALISER.msg("Mapping.ConstructionFailure", mappingClass.getName(), e), e).setFatal();
        }
        mapping.initialize(dba, type);
        return mapping;
    }

    public static JavaTypeMapping createMapping(Class mappingClass, DatastoreAdapter dba, AbstractPropertyMetaData fmd, int roleForField, DatastoreContainerObject datastoreContainer, ClassLoaderResolver clr) {
        JavaTypeMapping mapping = null;
        try {
            mapping = (JavaTypeMapping)mappingClass.newInstance();
        }
        catch (Exception e) {
            throw new JPOXException(LOCALISER.msg("Mapping.ConstructionFailure", mappingClass.getName(), e), e).setFatal();
        }
        if (roleForField >= 0) {
            mapping.setRoleForField(roleForField);
        }
        mapping.initialize(dba, fmd, datastoreContainer, clr);
        return mapping;
    }
}

