/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.mapping;

import org.jpox.ClassNameConstants;
import org.jpox.ObjectManager;
import org.jpox.store.expression.IntegerLiteral;
import org.jpox.store.expression.LogicSetExpression;
import org.jpox.store.expression.NumericExpression;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.SimpleDatastoreRepresentation;
import org.jpox.store.mapping.SingleFieldMapping;

public abstract class ObjectAsLongMapping
extends SingleFieldMapping
implements SimpleDatastoreRepresentation {
    public ScalarExpression newLiteral(QueryExpression qs, Object value) {
        return new IntegerLiteral(qs, (JavaTypeMapping)this, this.objectToLong(value));
    }

    public ScalarExpression newScalarExpression(QueryExpression qs, LogicSetExpression te) {
        return new NumericExpression(qs, this, te);
    }

    public abstract Class getJavaType();

    public String getJavaTypeForDatastoreMapping(int index) {
        return ClassNameConstants.JAVA_LANG_LONG;
    }

    public void setObject(ObjectManager om, Object preparedStatement, int[] exprIndex, Object value) {
        this.getDataStoreMapping(0).setObject(preparedStatement, exprIndex[0], this.objectToLong(value));
    }

    public Object getObject(ObjectManager om, Object resultSet, int[] exprIndex) {
        if (exprIndex == null) {
            return null;
        }
        Object datastoreValue = this.getDataStoreMapping(0).getObject(resultSet, exprIndex[0]);
        Object value = null;
        if (datastoreValue != null) {
            value = this.longToObject((Long)datastoreValue);
        }
        return value;
    }

    protected abstract Long objectToLong(Object var1);

    protected abstract Object longToObject(Long var1);
}

