/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.mapping;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.jdo.spi.PersistenceCapable;
import org.jpox.ClassLoaderResolver;
import org.jpox.JDOFetchPlanImpl;
import org.jpox.ObjectManager;
import org.jpox.ObjectManagerHelper;
import org.jpox.StateManager;
import org.jpox.exceptions.JPOXDataStoreException;
import org.jpox.exceptions.JPOXException;
import org.jpox.exceptions.JPOXUserException;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.AbstractPropertyMetaData;
import org.jpox.metadata.ClassMetaData;
import org.jpox.metadata.ColumnMetaData;
import org.jpox.metadata.IdentityStrategy;
import org.jpox.metadata.IdentityType;
import org.jpox.metadata.InheritanceStrategy;
import org.jpox.metadata.MetaDataManager;
import org.jpox.store.DatastoreAdapter;
import org.jpox.store.DatastoreClass;
import org.jpox.store.DatastoreContainerObject;
import org.jpox.store.DatastoreField;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.FieldValues;
import org.jpox.store.OID;
import org.jpox.store.StatementExpressionIndex;
import org.jpox.store.StoreManager;
import org.jpox.store.exceptions.NotYetFlushedException;
import org.jpox.store.expression.LogicSetExpression;
import org.jpox.store.expression.ObjectExpression;
import org.jpox.store.expression.ObjectLiteral;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.mapping.AppIDObjectIdFieldConsumer;
import org.jpox.store.mapping.DatastoreMapping;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.MappingManager;
import org.jpox.store.mapping.OIDMapping;
import org.jpox.store.rdbms.fieldmanager.ResultSetGetter;
import org.jpox.store.rdbms.table.CorrespondentColumnsMapping;
import org.jpox.store.rdbms.table.ElementContainerTable;
import org.jpox.util.AIDUtils;
import org.jpox.util.JPOXLogger;

public class PersistenceCapableMapping
extends OIDMapping {
    protected JavaTypeMapping[] javaTypeMappings = new JavaTypeMapping[0];
    private AbstractClassMetaData cmd;
    private int numberOfDatastoreFields = 0;
    static /* synthetic */ Class class$javax$jdo$identity$LongIdentity;
    static /* synthetic */ Class class$javax$jdo$identity$IntIdentity;
    static /* synthetic */ Class class$javax$jdo$identity$ShortIdentity;

    public void initialize(DatastoreAdapter dba, AbstractPropertyMetaData fmd, DatastoreContainerObject container, ClassLoaderResolver clr) {
        super.initialize(dba, fmd, container, clr);
        this.prepareDatastoreMapping(clr);
    }

    public void addJavaTypeMapping(JavaTypeMapping mapping) {
        if (mapping == null) {
            throw new JPOXException("mapping argument in PersistenceCapableMapping.addJavaTypeMapping is null").setFatal();
        }
        JavaTypeMapping[] jtm = this.javaTypeMappings;
        this.javaTypeMappings = new JavaTypeMapping[jtm.length + 1];
        System.arraycopy(jtm, 0, this.javaTypeMappings, 0, jtm.length);
        this.javaTypeMappings[jtm.length] = mapping;
    }

    protected void prepareDatastoreMapping() {
    }

    protected void prepareDatastoreMapping(ClassLoaderResolver clr) {
        StoreManager storeMgr = this.datastoreContainer.getStoreManager();
        AbstractClassMetaData refCmd = storeMgr.getMetaDataManager().getMetaDataForClass(this.fmd.getType(), clr);
        JavaTypeMapping referenceMapping = null;
        if (refCmd.getInheritanceMetaData().getStrategyValue() == InheritanceStrategy.SUBCLASS_TABLE) {
            AbstractClassMetaData[] cmds = storeMgr.getClassesManagingTableForClass(refCmd, clr);
            if (cmds != null && cmds.length > 0) {
                if (cmds.length > 1) {
                    JPOXLogger.PERSISTENCE.warn("Field " + this.fmd.getFullFieldName() + " represents either a 1-1 relation, or a N-1 relation " + "where the other end uses \"subclass-table\" inheritance strategy and more than 1 subclasses with a table. " + "This is not fully supported by JPOX");
                }
            } else {
                return;
            }
            referenceMapping = storeMgr.getDatastoreClass(cmds[0].getFullClassName(), clr).getIDMapping();
        } else {
            referenceMapping = storeMgr.getDatastoreClass(this.fmd.getType().getName(), clr).getIDMapping();
        }
        CorrespondentColumnsMapping correspondentColumnsMapping = new CorrespondentColumnsMapping(this.fmd, referenceMapping, true);
        int relationType = this.fmd.getRelationType(clr);
        boolean createDatastoreMappings = true;
        if (relationType == 6) {
            AbstractPropertyMetaData relatedFmd = this.fmd.getRelatedFieldMetaData(clr);
            createDatastoreMappings = relatedFmd.getJoinMetaData() == null;
        } else if (relationType == 2) {
            createDatastoreMappings = this.fmd.getMappedBy() == null;
        }
        for (int i = 0; i < referenceMapping.getNumberOfDatastoreFields(); ++i) {
            DatastoreMapping refDatastoreMapping = referenceMapping.getDataStoreMapping(i);
            JavaTypeMapping mapping = this.dba.getMapping(refDatastoreMapping.getJavaTypeMapping().getJavaType(), storeMgr);
            this.addJavaTypeMapping(mapping);
            if (createDatastoreMappings) {
                ColumnMetaData colmd = correspondentColumnsMapping.getColumnMetaDataByIdentifier(refDatastoreMapping.getDatastoreField().getIdentifier());
                if (colmd == null) {
                    throw new JPOXUserException(LOCALISER.msg("PersistenceCapableMapping.PrimaryKeyColumnNotMapped", refDatastoreMapping.getDatastoreField().getIdentifier(), this.toString())).setFatal();
                }
                MappingManager mmgr = this.datastoreContainer.getStoreManager().getMappingManager();
                DatastoreField col = mmgr.createDatastoreField(this.fmd, this.datastoreContainer, mapping, colmd, refDatastoreMapping.getDatastoreField(), clr);
                DatastoreMapping datastoreMapping = mmgr.createDatastoreMapping(mapping, storeMgr, col, refDatastoreMapping.getJavaTypeMapping().getJavaTypeForDatastoreMapping(i));
                this.addDataStoreMapping(datastoreMapping);
                continue;
            }
            mapping.setReferenceMapping(referenceMapping);
        }
    }

    public JavaTypeMapping[] getJavaTypeMapping() {
        return this.javaTypeMappings;
    }

    public int getNumberOfDatastoreFields() {
        if (this.numberOfDatastoreFields == 0) {
            for (int i = 0; i < this.javaTypeMappings.length; ++i) {
                this.numberOfDatastoreFields += this.javaTypeMappings[i].getNumberOfDatastoreFields();
            }
        }
        return this.numberOfDatastoreFields;
    }

    public DatastoreMapping getDataStoreMapping(int index) {
        int currentIndex = 0;
        int numberJavaMappings = this.javaTypeMappings.length;
        for (int i = 0; i < numberJavaMappings; ++i) {
            int numberDatastoreMappings = this.javaTypeMappings[i].getNumberOfDatastoreFields();
            for (int j = 0; j < numberDatastoreMappings; ++j) {
                if (currentIndex == index) {
                    return this.javaTypeMappings[i].getDataStoreMapping(j);
                }
                ++currentIndex;
            }
        }
        throw new JPOXException("Invalid index " + index + " for DataStoreMapping.").setFatal();
    }

    public void setObject(ObjectManager om, Object ps, int[] param, Object value) {
        this.setObject(om, ps, param, value, null, -1);
    }

    private void assertPersistenceCapable(Object value) {
        if (!(value instanceof PersistenceCapable)) {
            throw new JPOXException(LOCALISER.msg("Mapping.ObjectIsNotPersistenceCapable", value.getClass(), value)).setFatal();
        }
    }

    public void setObject(ObjectManager om, Object ps, int[] param, Object value, StateManager ownerSM, int ownerFieldNumber) {
        if (value == null) {
            this.setObjectAsNull(om, ps, param);
        } else {
            this.setObjectAsValue(om, ps, param, value, ownerSM, ownerFieldNumber);
        }
    }

    private void setObjectAsNull(ObjectManager om, Object ps, int[] param) {
        int n = 0;
        for (int i = 0; i < this.javaTypeMappings.length; ++i) {
            JavaTypeMapping mapping = this.javaTypeMappings[i];
            if (mapping.getNumberOfDatastoreFields() <= 0) continue;
            int[] posMapping = new int[mapping.getNumberOfDatastoreFields()];
            for (int j = 0; j < posMapping.length; ++j) {
                posMapping[j] = param[n++];
            }
            mapping.setObject(om, ps, posMapping, null);
        }
    }

    private boolean hasDatastoreAttributedPrimaryKeyValues(MetaDataManager mdm, StoreManager srm, ClassLoaderResolver clr) {
        AbstractClassMetaData acmd;
        boolean hasDatastoreAttributedPrimaryKeyValues = false;
        if (this.fmd != null && (acmd = mdm.getMetaDataForClass(this.fmd.getType(), clr)).getIdentityType() == IdentityType.APPLICATION) {
            for (int i = 0; i < acmd.getPrimaryKeyFieldNumbers().length; ++i) {
                IdentityStrategy strategy = acmd.getManagedFieldAbsolute(acmd.getPrimaryKeyFieldNumbers()[i]).getValueStrategy();
                if (strategy == null) continue;
                hasDatastoreAttributedPrimaryKeyValues |= srm.isStrategyDatastoreAttributed(strategy, false);
            }
        }
        return hasDatastoreAttributedPrimaryKeyValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setObjectAsValue(ObjectManager om, Object ps, int[] param, Object value, StateManager ownerSM, int ownerFieldNumber) {
        block31: {
            this.assertPersistenceCapable(value);
            StateManager sm = om.findStateManager((PersistenceCapable)value);
            try {
                PersistenceCapable pc = (PersistenceCapable)value;
                ClassLoaderResolver clr = om.getClassLoaderResolver();
                boolean hasDatastoreAttributedPrimaryKeyValues = this.hasDatastoreAttributedPrimaryKeyValues(om.getMetaDataManager(), om.getStoreManager(), clr);
                boolean inserted = false;
                if (ownerFieldNumber >= 0) {
                    inserted = om.isInserted(pc, ownerFieldNumber);
                }
                if (sm != null && sm.getAttachedPC() != null && ownerSM != null) {
                    ownerSM.replaceField(ownerFieldNumber, sm.getAttachedPC(), true);
                }
                if (inserted || !om.isInserting(pc) || !hasDatastoreAttributedPrimaryKeyValues && this.fmd != null && this.fmd.isPrimaryKey()) {
                    Object id = pc.jdoGetObjectId();
                    boolean requiresPersisting = false;
                    if (pc.jdoIsDetached() && ownerSM != null) {
                        requiresPersisting = true;
                    } else if (id == null) {
                        requiresPersisting = true;
                    } else {
                        ObjectManager pcPM = ObjectManagerHelper.getObjectManager(pc);
                        if (pcPM != null && om != pcPM) {
                            throw new JPOXUserException(LOCALISER.msg("Mapping.FieldNotAssignableIsFromAnotherPM"), id);
                        }
                    }
                    if (requiresPersisting) {
                        if (this.fmd != null && !this.fmd.isCascadePersist()) {
                            if (JPOXLogger.REACHABILITY.isDebugEnabled()) {
                                JPOXLogger.REACHABILITY.debug(LOCALISER.msg("Reachability.NotRunForFieldOnInsert", this.fmd.getFullFieldName()));
                            }
                            this.setObjectAsNull(om, ps, param);
                            return;
                        }
                        if (JPOXLogger.REACHABILITY.isDebugEnabled()) {
                            JPOXLogger.REACHABILITY.debug(LOCALISER.msg("Reachability.PersistingField", this.fmd != null ? this.fmd.getFullFieldName() : null));
                        }
                        try {
                            PersistenceCapable pcNew = (PersistenceCapable)om.persistObjectInternal(value, null);
                            if (hasDatastoreAttributedPrimaryKeyValues) {
                                om.flush(false);
                            }
                            id = pcNew.jdoGetObjectId();
                            if (pc.jdoIsDetached() && ownerSM != null) {
                                ownerSM.replaceField(ownerFieldNumber, pcNew, true);
                                int relationType = this.fmd.getRelationType(clr);
                                if (relationType == 6) {
                                    if (JPOXLogger.PERSISTENCE.isInfoEnabled()) {
                                        JPOXLogger.PERSISTENCE.info("PCMapping.setObject : object " + ownerSM.getInternalObjectId() + " has field " + ownerFieldNumber + " that is 1-N bidirectional." + " Have just attached the N side so should really update the reference in the 1 side collection" + " to refer to this attached object. Not yet implemented");
                                    }
                                } else if (relationType == 2) {
                                    AbstractPropertyMetaData relatedFmd = this.fmd.getRelatedFieldMetaData(clr);
                                    StateManager relatedSM = om.findStateManager(pcNew);
                                    relatedSM.replaceField(relatedFmd.getAbsoluteFieldNumber(), ownerSM.getObject(), true);
                                }
                            }
                        }
                        catch (NotYetFlushedException e) {
                            this.setObjectAsNull(om, ps, param);
                            throw new NotYetFlushedException(pc);
                        }
                    }
                    if (sm != null) {
                        sm.setStoringPC();
                    }
                    if (this.getNumberOfDatastoreFields() > 0) {
                        if (id instanceof OID) {
                            super.setObject(om, ps, param, id);
                        } else {
                            pc.jdoCopyKeyFieldsFromObjectId((PersistenceCapable.ObjectIdFieldConsumer)new AppIDObjectIdFieldConsumer(param, om, ps, this.javaTypeMappings), id);
                        }
                    }
                    break block31;
                }
                if (sm != null) {
                    sm.setStoringPC();
                }
                if (this.getNumberOfDatastoreFields() > 0) {
                    this.setObjectAsNull(om, ps, param);
                    throw new NotYetFlushedException(pc);
                }
            }
            finally {
                if (sm != null) {
                    sm.unsetStoringPC();
                }
            }
        }
    }

    public Object getObject(ObjectManager om, Object rs, int[] param) {
        try {
            if (((ResultSet)rs).getObject(param[0]) == null) {
                return null;
            }
        }
        catch (SQLException e) {
            throw new JPOXDataStoreException(e.getMessage(), e);
        }
        if (this.cmd == null) {
            this.cmd = om.getMetaDataManager().getMetaDataForClass(this.getType(), om.getClassLoaderResolver());
        }
        if (this.cmd.getIdentityType() == IdentityType.DATASTORE) {
            return this.getObjectForDatastoreIdentity(om, rs, param, this.cmd);
        }
        if (this.cmd.getIdentityType() == IdentityType.APPLICATION) {
            return this.getObjectForApplicationIdentity(om, rs, param, this.cmd);
        }
        return null;
    }

    public ScalarExpression newLiteral(QueryExpression qs, Object value) {
        ObjectLiteral expr = new ObjectLiteral(qs, this, value, this.getType());
        return expr;
    }

    public ScalarExpression newScalarExpression(QueryExpression qs, LogicSetExpression te) {
        if (this.getNumberOfDatastoreFields() > 0) {
            return new ObjectExpression(qs, this, te);
        }
        ClassLoaderResolver clr = qs.getClassLoaderResolver();
        StoreManager srm = qs.getStoreManager();
        int relationType = this.fmd.getRelationType(clr);
        if (relationType == 2) {
            DatastoreClass targetTable = srm.getDatastoreClass(this.fmd.getTypeName(), clr);
            JavaTypeMapping refMapping = targetTable.getFieldMapping(this.fmd.getRelatedFieldMetaData(clr));
            JavaTypeMapping selectMapping = targetTable.getIDMapping();
            DatastoreIdentifier targetTableIdentifier = srm.getIdentifierFactory().newIdentifier(0, "RELATED" + this.fmd.getAbsoluteFieldNumber());
            LogicSetExpression targetTe = qs.newTableExpression(targetTable, targetTableIdentifier);
            return new ObjectExpression(qs, this, te, refMapping, targetTe, selectMapping);
        }
        if (relationType == 6) {
            AbstractPropertyMetaData relatedFmd = this.fmd.getRelatedFieldMetaData(clr);
            if (this.fmd.getJoinMetaData() != null || relatedFmd.getJoinMetaData() != null) {
                DatastoreContainerObject targetTable = srm.getDatastoreContainerObject(relatedFmd);
                JavaTypeMapping refMapping = null;
                JavaTypeMapping selectMapping = null;
                ElementContainerTable elementTable = (ElementContainerTable)targetTable;
                refMapping = elementTable.getElementMapping();
                selectMapping = elementTable.getOwnerMapping();
                DatastoreIdentifier targetTableIdentifier = srm.getIdentifierFactory().newIdentifier(0, "JOINTABLE" + this.fmd.getAbsoluteFieldNumber());
                LogicSetExpression targetTe = qs.newTableExpression(targetTable, targetTableIdentifier);
                return new ObjectExpression(qs, this, te, refMapping, targetTe, selectMapping);
            }
        }
        return null;
    }

    public void deleteDependent(StateManager sm) {
        PersistenceCapable pc;
        int fieldNumber = this.fmd.getAbsoluteFieldNumber();
        sm.isLoaded(sm.getObject(), fieldNumber);
        ClassLoaderResolver clr = sm.getObjectManager().getClassLoaderResolver();
        AbstractPropertyMetaData relatedFmd = this.fmd.getRelatedFieldMetaData(clr);
        boolean hasFK = false;
        if (this.fmd.getForeignKeyMetaData() != null) {
            hasFK = true;
        }
        if (relatedFmd != null && relatedFmd.getForeignKeyMetaData() != null) {
            hasFK = true;
        }
        if (sm.getObjectManager().getOMFContext().getPersistenceConfiguration().getDeletionPolicy().equals("JDO2")) {
            hasFK = false;
        }
        if ((pc = (PersistenceCapable)sm.provideField(fieldNumber)) != null) {
            if (!hasFK || this.fmd.getRelationType(clr) == 6) {
                boolean isNullable = this.isNullable();
                if (this.getNumberOfDatastoreFields() == 0 && relatedFmd != null) {
                    DatastoreClass relatedTable = sm.getStoreManager().getDatastoreClass(relatedFmd.getClassName(), clr);
                    JavaTypeMapping relatedMapping = relatedTable.getFieldMapping(relatedFmd);
                    isNullable = relatedMapping.isNullable();
                }
                if (isNullable) {
                    sm.replaceField(fieldNumber, null, true);
                    sm.makeDirty(fieldNumber);
                }
            }
            sm.getObjectManager().deleteObject(pc);
        }
    }

    private Object getObjectForDatastoreIdentity(ObjectManager om, Object rs, int[] param, AbstractClassMetaData cmd) {
        Object oid = super.getObject(om, rs, param);
        if (oid instanceof PersistenceCapable) {
            return oid;
        }
        return oid == null ? null : om.findObject(oid, false, true, null);
    }

    private Object createSingleFieldIdentity(ObjectManager om, Object rs, int[] param, AbstractClassMetaData cmd, Class objectIdClass, Class pcClass) {
        int paramNumber = param[0];
        try {
            Object idObj = ((ResultSet)rs).getObject(paramNumber);
            if (idObj == null) {
                throw new JPOXException(LOCALISER.msg("PersistenceCapableMapping.CantCreateSingleFieldIdentityWithNull")).setFatal();
            }
            idObj = this.convertIfNecessary(objectIdClass, idObj);
            return AIDUtils.getNewSingleFieldIdentity(objectIdClass, pcClass, idObj);
        }
        catch (Exception e) {
            JPOXLogger.PERSISTENCE.error(LOCALISER.msg("PersistenceCapableMapping.CantCreateAID", cmd.getObjectidClass(), e));
            return null;
        }
    }

    private Object convertIfNecessary(Class objectIdClass, Object idObj) {
        if (!(idObj instanceof Number)) {
            return idObj;
        }
        Number value = (Number)idObj;
        if ((class$javax$jdo$identity$LongIdentity == null ? (class$javax$jdo$identity$LongIdentity = PersistenceCapableMapping.class$("javax.jdo.identity.LongIdentity")) : class$javax$jdo$identity$LongIdentity).isAssignableFrom(objectIdClass) && !(value instanceof Long)) {
            idObj = new Long(value.longValue());
        } else if ((class$javax$jdo$identity$IntIdentity == null ? (class$javax$jdo$identity$IntIdentity = PersistenceCapableMapping.class$("javax.jdo.identity.IntIdentity")) : class$javax$jdo$identity$IntIdentity).isAssignableFrom(objectIdClass) && !(value instanceof Integer)) {
            idObj = new Integer(value.intValue());
        } else if ((class$javax$jdo$identity$ShortIdentity == null ? (class$javax$jdo$identity$ShortIdentity = PersistenceCapableMapping.class$("javax.jdo.identity.ShortIdentity")) : class$javax$jdo$identity$ShortIdentity).isAssignableFrom(objectIdClass) && !(value instanceof Short)) {
            idObj = new Short(value.shortValue());
        }
        return idObj;
    }

    private Object createObjectIdInstanceReflection(ObjectManager om, Object rs, int[] param, AbstractClassMetaData cmd, Class objectIdClass) {
        Object fieldValue = null;
        try {
            Object id = objectIdClass.newInstance();
            int paramIndex = 0;
            for (int i = 0; i < cmd.getPrimaryKeyFieldNumbers().length; ++i) {
                AbstractPropertyMetaData fmd = cmd.getManagedFieldAbsolute(cmd.getPrimaryKeyFieldNumbers()[i]);
                Field field = objectIdClass.getField(fmd.getName());
                JavaTypeMapping m = om.getStoreManager().getDatastoreClass(cmd.getFullClassName(), om.getClassLoaderResolver()).getFieldMapping(fmd);
                for (int j = 0; j < m.getNumberOfDatastoreFields(); ++j) {
                    Object obj;
                    if ((obj = ((ResultSet)rs).getObject(param[paramIndex++])) instanceof BigDecimal) {
                        BigDecimal bigDecimal = (BigDecimal)obj;
                        obj = this.convertIfNecessary(field.getType(), bigDecimal);
                        if (!bigDecimal.subtract(new BigDecimal("" + obj)).equals(new BigDecimal("0"))) {
                            throw new JPOXException("Cannot convert retrieved BigInteger value to field of object id class!").setFatal();
                        }
                    }
                    fieldValue = obj;
                }
                field.set(id, fieldValue);
            }
            return id;
        }
        catch (Exception e) {
            JPOXLogger.PERSISTENCE.error(LOCALISER.msg("PersistenceCapableMapping.CantCreateAIDWithReflection", cmd.getObjectidClass(), this.fmd == null ? null : this.fmd.getName(), fieldValue, e));
            return null;
        }
    }

    private Object getObjectForAbstractClass(ObjectManager om, Object rs, int[] param, AbstractClassMetaData cmd) {
        ClassLoaderResolver clr = om.getClassLoaderResolver();
        Class objectIdClass = clr.classForName(cmd.getObjectidClass());
        Class pcClass = clr.classForName(cmd.getFullClassName());
        Object id = cmd.usesSingleFieldIdentityClass() ? this.createSingleFieldIdentity(om, rs, param, cmd, objectIdClass, pcClass) : this.createObjectIdInstanceReflection(om, rs, param, cmd, objectIdClass);
        return om.findObject(id, false, true, null);
    }

    private Object getObjectForApplicationIdentity(ObjectManager om, final Object rs, int[] param, AbstractClassMetaData cmd) {
        ClassLoaderResolver clr = om.getClassLoaderResolver();
        if (((ClassMetaData)cmd).isAbstractPersistenceCapable() && cmd.getObjectidClass() != null) {
            return this.getObjectForAbstractClass(om, rs, param, cmd);
        }
        int totalFieldCount = cmd.getNoOfManagedFields() + cmd.getNoOfInheritedManagedFields();
        final StatementExpressionIndex[] statementExpressionIndex = new StatementExpressionIndex[totalFieldCount];
        int paramIndex = 0;
        DatastoreClass datastoreClass = om.getStoreManager().getDatastoreClass(cmd.getFullClassName(), clr);
        final int[] pkFieldNumbers = cmd.getPrimaryKeyFieldNumbers();
        for (int i = 0; i < pkFieldNumbers.length; ++i) {
            AbstractPropertyMetaData fmd = cmd.getManagedFieldAbsolute(pkFieldNumbers[i]);
            JavaTypeMapping m = datastoreClass.getFieldMapping(fmd);
            statementExpressionIndex[fmd.getAbsoluteFieldNumber()] = new StatementExpressionIndex();
            statementExpressionIndex[fmd.getAbsoluteFieldNumber()].setMapping(m);
            int[] expressionsIndex = new int[m.getNumberOfDatastoreFields()];
            for (int j = 0; j < expressionsIndex.length; ++j) {
                expressionsIndex[j] = param[paramIndex++];
            }
            statementExpressionIndex[fmd.getAbsoluteFieldNumber()].setExpressionIndex(expressionsIndex);
        }
        return om.findObjectUsingAID(clr.classForName(cmd.getFullClassName()), new FieldValues(){

            public void fetchFields(StateManager sm) {
                sm.replaceFields(pkFieldNumbers, new ResultSetGetter(sm, (ResultSet)rs, statementExpressionIndex));
            }

            public void fetchNonLoadedFields(StateManager sm) {
                sm.replaceNonLoadedFields(pkFieldNumbers, new ResultSetGetter(sm, (ResultSet)rs, statementExpressionIndex));
            }

            public JDOFetchPlanImpl getFetchPlanForLoading() {
                return null;
            }
        }, false, true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

