/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.mapping;

import java.sql.Timestamp;
import org.jpox.ClassLoaderResolver;
import org.jpox.ObjectManager;
import org.jpox.exceptions.JPOXUserException;
import org.jpox.metadata.ColumnMetaData;
import org.jpox.metadata.ExtendableMetaData;
import org.jpox.metadata.VersionMetaData;
import org.jpox.metadata.VersionStrategy;
import org.jpox.store.DatastoreAdapter;
import org.jpox.store.DatastoreContainerObject;
import org.jpox.store.DatastoreField;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.IdentifierFactory;
import org.jpox.store.expression.LogicSetExpression;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.mapping.DatastoreMapping;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.SimpleDatastoreRepresentation;
import org.jpox.store.mapping.SingleFieldMapping;

public final class VersionMapping
extends SingleFieldMapping
implements SimpleDatastoreRepresentation {
    private final JavaTypeMapping delegate;
    private final VersionMetaData versionMetaData;
    static /* synthetic */ Class class$org$jpox$store$mapping$VersionMapping;

    public VersionMapping(DatastoreAdapter dba, DatastoreContainerObject datastoreContainer, JavaTypeMapping delegate) {
        ColumnMetaData colmd;
        this.initialize(dba, delegate.getType());
        this.delegate = delegate;
        this.versionMetaData = datastoreContainer.getVersionMetaData();
        ColumnMetaData[] versionColumnMetaData = this.versionMetaData.getColumnMetaData();
        IdentifierFactory idFactory = datastoreContainer.getStoreManager().getIdentifierFactory();
        DatastoreIdentifier id = null;
        if (versionColumnMetaData.length == 0) {
            id = idFactory.newVersionFieldIdentifier();
            colmd = new ColumnMetaData((ExtendableMetaData)this.versionMetaData, id.getIdentifier());
            datastoreContainer.getVersionMetaData().addColumn(colmd);
        } else {
            colmd = versionColumnMetaData[0];
            id = idFactory.newDatastoreFieldIdentifier(colmd.getName());
        }
        DatastoreField column = datastoreContainer.addDatastoreField(this.getType(), id, this, colmd);
        datastoreContainer.getStoreManager().getMappingManager().createDatastoreMapping(delegate, datastoreContainer.getStoreManager(), column, this.getType());
    }

    public Object getSampleValue(ClassLoaderResolver clr) {
        return this.delegate.getSampleValue(clr);
    }

    public ScalarExpression newLiteral(QueryExpression qs, Object value) {
        return this.delegate.newLiteral(qs, value);
    }

    public ScalarExpression newScalarExpression(QueryExpression qs, LogicSetExpression te) {
        return this.delegate.newScalarExpression(qs, te);
    }

    public boolean includeInFetchStatement() {
        return false;
    }

    public int getNumberOfDatastoreFields() {
        return this.delegate.getNumberOfDatastoreFields();
    }

    public DatastoreMapping getDataStoreMapping(int index) {
        return this.delegate.getDataStoreMapping(index);
    }

    public void addDataStoreMapping(DatastoreMapping datastoreMapping) {
        this.delegate.addDataStoreMapping(datastoreMapping);
    }

    public Object getNextVersion(Object actualVersion) {
        if (this.versionMetaData == null) {
            throw new JPOXUserException("JPOX doesnt currently support the use of optimistic transactions when no strategy is specified");
        }
        if (this.versionMetaData.getVersionStrategy() == VersionStrategy.NONE) {
            if (actualVersion == null) {
                return new Long(1L);
            }
            return new Long((Long)actualVersion + 1L);
        }
        if (this.versionMetaData.getVersionStrategy() == VersionStrategy.DATE_TIME) {
            return new Timestamp(System.currentTimeMillis());
        }
        if (this.versionMetaData.getVersionStrategy() == VersionStrategy.VERSION_NUMBER) {
            if (actualVersion == null) {
                return new Long(1L);
            }
            return new Long((Long)actualVersion + 1L);
        }
        if (this.versionMetaData.getVersionStrategy() == VersionStrategy.STATE_IMAGE) {
            throw new JPOXUserException("JPOX doesnt currently support optimistic version strategy \"state-image\"");
        }
        throw new JPOXUserException("Unknown optimistic version strategy - not supported");
    }

    public Class getJavaType() {
        return class$org$jpox$store$mapping$VersionMapping == null ? (class$org$jpox$store$mapping$VersionMapping = VersionMapping.class$("org.jpox.store.mapping.VersionMapping")) : class$org$jpox$store$mapping$VersionMapping;
    }

    public void setObject(ObjectManager om, Object preparedStatement, int[] exprIndex, Object value) {
        this.delegate.setObject(om, preparedStatement, exprIndex, value);
    }

    public Object getObject(ObjectManager om, Object resultSet, int[] exprIndex) {
        return this.delegate.getObject(om, resultSet, exprIndex);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

