/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.poid;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import org.jpox.store.poid.Poid;
import org.jpox.util.StringUtils;

public class PoidBlock
implements Serializable {
    private int nextIndex = 0;
    private final List poidBlock;

    public PoidBlock(Object[] oid) {
        this.poidBlock = Arrays.asList(oid);
    }

    public PoidBlock(List oid) {
        this.poidBlock = new ArrayList(oid);
    }

    public Poid current() {
        if (this.nextIndex == 0 || this.nextIndex - 1 >= this.poidBlock.size()) {
            throw new NoSuchElementException();
        }
        return new Poid(this.poidBlock.get(this.nextIndex - 1));
    }

    public Poid next() {
        if (this.nextIndex >= this.poidBlock.size()) {
            throw new NoSuchElementException();
        }
        return new Poid(this.poidBlock.get(this.nextIndex++));
    }

    public boolean hasNext() {
        return this.nextIndex < this.poidBlock.size();
    }

    public void addBlock(PoidBlock block) {
        if (block == null) {
            return;
        }
        while (block.hasNext()) {
            this.poidBlock.add(block.next());
        }
    }

    public String toString() {
        return "PoidBlock : " + StringUtils.collectionToString(this.poidBlock);
    }
}

