/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.query;

import java.util.Collection;
import java.util.Iterator;
import javax.jdo.FetchPlan;
import javax.jdo.JDOFatalInternalException;
import org.jpox.ObjectManager;
import org.jpox.store.Extent;
import org.jpox.store.expression.BooleanExpression;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.query.Queryable;
import org.jpox.store.query.ResultObjectFactory;
import org.jpox.util.Localiser;

public class CollectionCandidates
implements Queryable {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.jpox.store.Localisation");
    private Collection userCandidates;
    private Extent extent;
    private final ObjectManager om;

    public CollectionCandidates(ObjectManager om, Class candidateClass, Collection candidates) {
        this.userCandidates = candidates;
        this.om = om;
        if (candidates == null) {
            throw new JDOFatalInternalException(LOCALISER.msg("Candidates.CollectionCantBeNull"));
        }
        this.extent = om.getExtent(candidateClass, true);
    }

    public Collection getUserCandidates() {
        return this.userCandidates;
    }

    public FetchPlan getFetchPlan() {
        return this.extent.getFetchPlan();
    }

    public QueryExpression newQueryStatement() {
        return ((Queryable)((Object)this.extent)).newQueryStatement();
    }

    public QueryExpression newQueryStatement(Class candidateClass) {
        QueryExpression stmt = ((Queryable)((Object)this.extent)).newQueryStatement(candidateClass);
        JavaTypeMapping m = this.om.getStoreManager().getDatastoreClass(candidateClass.getName(), this.om.getClassLoaderResolver()).getIDMapping();
        BooleanExpression elementsExpr = null;
        Iterator it = this.userCandidates.iterator();
        while (it.hasNext()) {
            Object candidateValue = it.next();
            BooleanExpression keyExpr = null;
            ScalarExpression expr = m.newScalarExpression(stmt, stmt.getDefaultTableExpression());
            keyExpr = keyExpr == null ? expr.eq(m.newLiteral(stmt, candidateValue)) : keyExpr.and(expr.eq(m.newLiteral(stmt, candidateValue)));
            if (elementsExpr == null) {
                elementsExpr = keyExpr;
                continue;
            }
            elementsExpr = elementsExpr.ior(keyExpr);
        }
        if (elementsExpr != null) {
            stmt.andCondition(elementsExpr, true);
        }
        return stmt;
    }

    public ResultObjectFactory newResultObjectFactory(QueryExpression stmt, boolean ignoreCache, Class resultClass, boolean useFetchPlan) {
        return ((Queryable)((Object)this.extent)).newResultObjectFactory(stmt, ignoreCache, resultClass, useFetchPlan);
    }

    public boolean isEmpty() {
        return this.userCandidates.isEmpty();
    }
}

