/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.query;

import java.util.Iterator;
import org.jpox.ClassLoaderResolver;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.DiscriminatorMetaData;
import org.jpox.metadata.DiscriminatorStrategy;
import org.jpox.store.DatastoreContainerObject;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.StoreManager;
import org.jpox.store.expression.LogicSetExpression;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.query.AbstractIteratorStatement;

public class DiscriminatorIteratorStatement
extends AbstractIteratorStatement {
    private boolean selectDiscriminator;
    private boolean restrictDiscriminator = true;
    private DatastoreContainerObject selectTable;
    private JavaTypeMapping selectCandidateMapping;
    private DatastoreIdentifier candidateTableIdentifier;
    private Class[] candidateTypes;

    public DiscriminatorIteratorStatement(ClassLoaderResolver clr, Class[] candidateTypes, boolean includeSubclasses, StoreManager storeMgr, boolean selectDiscriminator) {
        super(candidateTypes[0], clr, includeSubclasses, storeMgr);
        this.selectDiscriminator = selectDiscriminator;
        this.candidateTypes = candidateTypes;
    }

    public DiscriminatorIteratorStatement(ClassLoaderResolver clr, Class[] candidateType, boolean includeSubclasses, StoreManager storeMgr, boolean selectDiscriminator, DatastoreContainerObject selectTable, JavaTypeMapping selectCandidateMapping, DatastoreIdentifier candidateTableIdentifier) {
        this(clr, candidateType, includeSubclasses, storeMgr, selectDiscriminator);
        this.selectTable = selectTable;
        this.selectCandidateMapping = selectCandidateMapping;
        this.candidateTableIdentifier = candidateTableIdentifier;
    }

    public void setRestrictDiscriminator(boolean restrict) {
        this.restrictDiscriminator = restrict;
    }

    public QueryExpression getQueryStatement() {
        QueryExpression stmt = null;
        DiscriminatorMetaData dismd = this.candidateTable.getDiscriminatorMetaData();
        JavaTypeMapping discriminatorMapping = this.candidateTable.getDiscriminatorMapping();
        boolean hasDiscriminator = discriminatorMapping != null && dismd.getStrategy() != DiscriminatorStrategy.NONE;
        LogicSetExpression discrimTableExpr = null;
        if (this.selectTable != null) {
            stmt = this.dba.newQueryStatement(this.selectTable, this.clr);
            ScalarExpression selectExpression = this.selectCandidateMapping.newScalarExpression(stmt, stmt.getDefaultTableExpression());
            LogicSetExpression candidateTableExpression = stmt.newTableExpression(this.candidateTable, this.candidateTableIdentifier);
            ScalarExpression candidateExpression = this.candidateTable.getIDMapping().newScalarExpression(stmt, candidateTableExpression);
            stmt.innerJoin(selectExpression, candidateExpression, candidateTableExpression, true);
            discrimTableExpr = stmt.getTableExpression(this.candidateTableIdentifier);
            if (hasDiscriminator && this.selectDiscriminator) {
                stmt.selectScalarExpression(this.candidateTable.getDiscriminatorMapping().newScalarExpression(stmt, candidateTableExpression));
            }
        } else {
            stmt = this.dba.newQueryStatement(this.candidateTable, this.clr);
            discrimTableExpr = stmt.getDefaultTableExpression();
            if (hasDiscriminator && this.selectDiscriminator) {
                stmt.select(discriminatorMapping);
            }
        }
        if (hasDiscriminator && this.restrictDiscriminator) {
            for (int i = 0; i < this.candidateTypes.length; ++i) {
                String candidateName = this.candidateTypes[i].getName();
                DiscriminatorIteratorStatement.addConditionForCandidateClass(stmt, candidateName, dismd, discriminatorMapping, discrimTableExpr, this.storeMgr);
                if (!this.includeSubclasses) continue;
                Iterator iterator = this.storeMgr.getSubClassesForClass(candidateName, true, this.clr).iterator();
                while (iterator.hasNext()) {
                    String subCandidateType = (String)iterator.next();
                    DiscriminatorIteratorStatement.addConditionForCandidateClass(stmt, subCandidateType, dismd, discriminatorMapping, discrimTableExpr, this.storeMgr);
                }
            }
        }
        return stmt;
    }

    private static void addConditionForCandidateClass(QueryExpression stmt, String className, DiscriminatorMetaData dismd, JavaTypeMapping discriminatorMapping, LogicSetExpression discrimTableExpr, StoreManager storeMgr) {
        String discriminatorValue = className;
        if (dismd.getStrategy() == DiscriminatorStrategy.VALUE_MAP) {
            AbstractClassMetaData targetCmd = storeMgr.getMetaDataManager().getMetaDataForClass(className, stmt.getClassLoaderResolver());
            discriminatorValue = targetCmd.getInheritanceMetaData().getDiscriminatorMetaData().getValue();
        }
        ScalarExpression discrExpr = discriminatorMapping.newScalarExpression(stmt, discrimTableExpr);
        ScalarExpression discrVal = discriminatorMapping.newLiteral(stmt, discriminatorValue);
        stmt.iorCondition(discrExpr.eq(discrVal));
    }
}

