/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.jdo.JDODataStoreException;
import javax.jdo.datastore.Sequence;
import org.jpox.ManagedConnection;
import org.jpox.ObjectManager;
import org.jpox.exceptions.JPOXDataStoreException;
import org.jpox.exceptions.JPOXException;
import org.jpox.metadata.ExtensionMetaData;
import org.jpox.metadata.SequenceMetaData;
import org.jpox.store.JPOXSequence;
import org.jpox.store.StoreManager;
import org.jpox.store.poid.PoidConnectionProvider;
import org.jpox.store.poid.PoidGenerator;
import org.jpox.store.poid.PoidManager;
import org.jpox.store.rdbms.RDBMSManager;
import org.jpox.util.JPOXLogger;
import org.jpox.util.Localiser;

public class JDOSequenceImpl
implements Sequence,
JPOXSequence {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.jpox.Localisation");
    protected final StoreManager storeManager;
    protected final SequenceMetaData seqMetaData;
    protected final PoidGenerator generator;
    protected final ObjectManager om;

    public JDOSequenceImpl(ObjectManager objectMgr, StoreManager storeMgr, SequenceMetaData seqmd) {
        this.om = objectMgr;
        this.storeManager = storeMgr;
        this.seqMetaData = seqmd;
        String poidGeneratorName = null;
        poidGeneratorName = storeMgr.getDatastoreAdapter().supportsSequences() ? "org.jpox.store.rdbms.poid.SequencePoidGenerator" : "org.jpox.store.rdbms.poid.TablePoidGenerator";
        Properties props = new Properties();
        ExtensionMetaData[] seqExtensions = seqmd.getExtensions();
        if (seqExtensions != null && seqExtensions.length > 0) {
            for (int i = 0; i < seqExtensions.length; ++i) {
                props.put(seqExtensions[i].getKey(), seqExtensions[i].getValue());
            }
        }
        if (poidGeneratorName.equals("org.jpox.store.rdbms.poid.SequencePoidGenerator")) {
            props.put("sequence-name", this.seqMetaData.getDatastoreSequence());
        } else if (poidGeneratorName.equals("org.jpox.store.rdbms.poid.TablePoidGenerator")) {
            props.put("sequence-name", this.seqMetaData.getDatastoreSequence());
        }
        PoidManager mgr = storeMgr.getPoidManager();
        PoidConnectionProvider connProvider = new PoidConnectionProvider(){
            ManagedConnection mconn;
            Connection conn;

            public Object retrieveConnection() {
                try {
                    this.mconn = ((RDBMSManager)JDOSequenceImpl.this.storeManager).getConnection(JDOSequenceImpl.this.om.getOMFContext().getPersistenceConfiguration().getPoidTransactionIsolationLevel());
                    this.conn = (Connection)this.mconn.getConnection();
                }
                catch (SQLException e) {
                    String msg = LOCALISER.msg("Sequence.POIDConnectionOpenError", e);
                    JPOXLogger.JDO.error(msg);
                    throw new JDODataStoreException(msg, (Throwable)e);
                }
                return this.conn;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void releaseConnection() {
                try {
                    boolean success = false;
                    try {
                        if (!this.conn.getAutoCommit()) {
                            this.conn.commit();
                        }
                        success = true;
                    }
                    finally {
                        if (!success && !this.conn.getAutoCommit()) {
                            this.conn.rollback();
                        }
                    }
                    this.mconn.close();
                }
                catch (SQLException e) {
                    String msg = LOCALISER.msg("Sequence.POIDConnectionCloseError", e);
                    JPOXLogger.JDO.error(msg);
                    throw new JDODataStoreException(msg);
                }
            }
        };
        this.generator = mgr.createPoidGenerator(this.om.getClassLoaderResolver(), this.seqMetaData.getName(), poidGeneratorName, props, this.storeManager, connProvider);
        if (JPOXLogger.JDO.isDebugEnabled()) {
            JPOXLogger.JDO.debug(LOCALISER.msg("Sequence.Allocated", this.seqMetaData.getName(), poidGeneratorName));
        }
    }

    public String getName() {
        return this.seqMetaData.getName();
    }

    public void allocate(int additional) {
        try {
            this.generator.allocate(additional);
        }
        catch (JPOXException jPOXException) {
            // empty catch block
        }
    }

    public Object next() {
        try {
            return this.generator.next();
        }
        catch (JPOXDataStoreException dse) {
            if (dse.getFailedObject() != null) {
                throw new JDODataStoreException(dse.getMessage(), dse.getFailedObject());
            }
            throw new JDODataStoreException(dse.getMessage(), dse.getNestedExceptions());
        }
    }

    public long nextValue() {
        try {
            return this.generator.nextValue();
        }
        catch (JPOXDataStoreException dse) {
            if (dse.getFailedObject() != null) {
                throw new JDODataStoreException(dse.getMessage(), dse.getFailedObject());
            }
            throw new JDODataStoreException(dse.getMessage(), dse.getNestedExceptions());
        }
    }

    public Object current() {
        try {
            return this.generator.current();
        }
        catch (JPOXDataStoreException dse) {
            if (dse.getFailedObject() != null) {
                throw new JDODataStoreException(dse.getMessage(), dse.getFailedObject());
            }
            throw new JDODataStoreException(dse.getMessage(), dse.getNestedExceptions());
        }
    }

    public long currentValue() {
        try {
            return this.generator.currentValue();
        }
        catch (JPOXDataStoreException dse) {
            if (dse.getFailedObject() != null) {
                throw new JDODataStoreException(dse.getMessage(), dse.getFailedObject());
            }
            throw new JDODataStoreException(dse.getMessage(), dse.getNestedExceptions());
        }
    }
}

