/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.jpox.store.rdbms.ParamLoggingPreparedStatement;
import org.jpox.util.JPOXLogger;
import org.jpox.util.JavaUtils;
import org.jpox.util.Localiser;

public class SQLController {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.jpox.store.rdbms.Localisation");
    protected boolean supportsBatching = false;
    protected int maxBatchSize = -1;
    protected int queryTimeout = 0;
    Map connectionStatements = new HashMap();

    public SQLController(boolean supportsBatching, int maxBatchSize, int queryTimeout) {
        this.supportsBatching = supportsBatching;
        this.maxBatchSize = maxBatchSize;
        this.queryTimeout = queryTimeout;
    }

    public PreparedStatement getStatementForUpdate(Connection conn, String stmtText, boolean batchable) throws SQLException {
        ConnectionStatementState state;
        if (this.supportsBatching && (state = this.getConnectionStatementState(conn)) != null) {
            if (state.processable) {
                if (!batchable) {
                    this.processConnectionStatement(conn);
                } else if (state.stmtText.equals(stmtText)) {
                    if (this.maxBatchSize == -1 || state.batchSize < this.maxBatchSize) {
                        ++state.batchSize;
                        state.processable = false;
                        if (JPOXLogger.RDBMS_SQL.isDebugEnabled()) {
                            JPOXLogger.RDBMS_SQL.debug(LOCALISER.msg("SQLController.AddingStatementToBatch", stmtText, "" + state.batchSize));
                        }
                        return state.stmt;
                    }
                    if (JPOXLogger.RDBMS_SQL.isDebugEnabled()) {
                        JPOXLogger.RDBMS_SQL.debug(LOCALISER.msg("SQLController.BatchLimitReached", state.stmtText));
                    }
                    this.processConnectionStatement(conn);
                } else {
                    this.processConnectionStatement(conn);
                }
            } else if (batchable) {
                if (JPOXLogger.RDBMS_SQL.isDebugEnabled()) {
                    JPOXLogger.RDBMS_SQL.debug(LOCALISER.msg("SQLController.StatementNotBatchable", state.stmtText, stmtText));
                }
                batchable = false;
            }
        }
        PreparedStatement ps = conn.prepareStatement(stmtText);
        if (JPOXLogger.RDBMS_SQL.isDebugEnabled() && JavaUtils.isJRE1_4OrAbove()) {
            ps = new ParamLoggingPreparedStatement(ps, stmtText);
        }
        if (batchable && this.supportsBatching) {
            if (JPOXLogger.RDBMS_SQL.isDebugEnabled()) {
                JPOXLogger.RDBMS_SQL.debug(LOCALISER.msg("SQLController.BatchableStatement", stmtText));
            }
            ConnectionStatementState state2 = new ConnectionStatementState();
            state2.stmt = ps;
            state2.stmtText = stmtText;
            state2.batchSize = 1;
            this.setConnectionStatementState(conn, state2);
        }
        return ps;
    }

    public PreparedStatement getStatementForQuery(Connection conn, String stmtText) throws SQLException {
        return this.getStatementForQuery(conn, stmtText, null, null);
    }

    public PreparedStatement getStatementForQuery(Connection conn, String stmtText, String resultSetType, String resultSetConcurrency) throws SQLException {
        ConnectionStatementState state;
        if (this.supportsBatching && (state = this.getConnectionStatementState(conn)) != null && state.processable) {
            this.processConnectionStatement(conn);
        }
        PreparedStatement ps = null;
        if (resultSetType != null || resultSetConcurrency != null) {
            int rsTypeValue = 1003;
            if (resultSetType.equals("scroll-sensitive")) {
                rsTypeValue = 1005;
            } else if (resultSetType.equals("scroll-insensitive")) {
                rsTypeValue = 1004;
            }
            int rsConcurrencyValue = 1007;
            if (resultSetConcurrency.equals("updateable")) {
                rsConcurrencyValue = 1008;
            }
            ps = conn.prepareStatement(stmtText, rsTypeValue, rsConcurrencyValue);
        } else {
            ps = conn.prepareStatement(stmtText);
        }
        if (this.queryTimeout > 0) {
            ps.setQueryTimeout(this.queryTimeout);
        }
        if (JPOXLogger.RDBMS_SQL.isDebugEnabled() && JavaUtils.isJRE1_4OrAbove()) {
            ps = new ParamLoggingPreparedStatement(ps, stmtText);
        }
        return ps;
    }

    public int[] executeStatementUpdate(Connection conn, String stmt, PreparedStatement ps, boolean processNow) throws SQLException {
        ConnectionStatementState state = this.getConnectionStatementState(conn);
        if (state != null && state.stmt == ps) {
            if (JPOXLogger.RDBMS_SQL.isDebugEnabled()) {
                JPOXLogger.RDBMS_SQL.debug(LOCALISER.msg("SQLController.StatementBatchAdded", state.stmtText, "" + state.batchSize));
            }
            state.processable = true;
            state.stmt.addBatch();
            if (processNow) {
                state.closeStatementOnProcess = false;
                return this.processConnectionStatement(conn);
            }
            return null;
        }
        if (JPOXLogger.RDBMS_SQL.isDebugEnabled()) {
            if (ps instanceof ParamLoggingPreparedStatement) {
                JPOXLogger.RDBMS_SQL.debug(((ParamLoggingPreparedStatement)ps).getStatementWithParamsReplaced());
            } else {
                JPOXLogger.RDBMS_SQL.debug(stmt);
            }
        }
        long startTime = System.currentTimeMillis();
        int ind = ps.executeUpdate();
        if (JPOXLogger.RDBMS_SQL.isDebugEnabled()) {
            JPOXLogger.RDBMS_SQL.debug(LOCALISER.msg("JDBC.Statement.ExecutionTime", System.currentTimeMillis() - startTime));
        }
        return new int[]{ind};
    }

    public ResultSet executeStatementQuery(Connection conn, String stmt, PreparedStatement ps) throws SQLException {
        ConnectionStatementState state;
        if (this.supportsBatching && (state = this.getConnectionStatementState(conn)) != null) {
            if (state.processable) {
                this.processConnectionStatement(conn);
            } else if (JPOXLogger.RDBMS_SQL.isDebugEnabled()) {
                JPOXLogger.RDBMS_SQL.debug(LOCALISER.msg("SQLController.QueryProcessSinceBatchNotReady", state.stmtText, stmt));
            }
        }
        if (JPOXLogger.RDBMS_SQL.isDebugEnabled()) {
            if (ps instanceof ParamLoggingPreparedStatement) {
                JPOXLogger.RDBMS_SQL.debug(((ParamLoggingPreparedStatement)ps).getStatementWithParamsReplaced());
            } else {
                JPOXLogger.RDBMS_SQL.debug(stmt);
            }
        }
        long startTime = System.currentTimeMillis();
        ResultSet rs = ps.executeQuery();
        if (JPOXLogger.RDBMS_SQL.isDebugEnabled()) {
            JPOXLogger.RDBMS_SQL.debug(LOCALISER.msg("JDBC.Statement.ExecutionTime", System.currentTimeMillis() - startTime));
        }
        return rs;
    }

    public void abortStatementForConnection(Connection conn, PreparedStatement ps) {
        ConnectionStatementState state = this.getConnectionStatementState(conn);
        if (state != null && state.stmt == ps) {
            try {
                this.removeConnectionStatementState(conn);
                ps.close();
            }
            catch (SQLException sqe) {
                // empty catch block
            }
        }
    }

    public void closeStatement(Connection conn, PreparedStatement ps) throws SQLException {
        ConnectionStatementState state = this.getConnectionStatementState(conn);
        if (state != null && state.stmt == ps) {
            state.closeStatementOnProcess = true;
        } else {
            ps.close();
        }
    }

    public void processStatementsForConnection(Connection conn) throws SQLException {
        if (!this.supportsBatching || this.getConnectionStatementState(conn) == null) {
            return;
        }
        this.processConnectionStatement(conn);
    }

    protected int[] processConnectionStatement(Connection conn) throws SQLException {
        ConnectionStatementState state = this.getConnectionStatementState(conn);
        if (state == null || !state.processable) {
            return null;
        }
        if (JPOXLogger.RDBMS_SQL.isDebugEnabled()) {
            JPOXLogger.RDBMS_SQL.debug(LOCALISER.msg("SQLController.ProcessStatementBatch", state.stmtText, "" + state.batchSize));
            if (state.stmt instanceof ParamLoggingPreparedStatement) {
                JPOXLogger.RDBMS_SQL.debug(((ParamLoggingPreparedStatement)state.stmt).getStatementWithParamsReplaced());
            } else {
                JPOXLogger.RDBMS_SQL.debug(state.stmtText);
            }
        }
        long startTime = System.currentTimeMillis();
        int[] ind = state.stmt.executeBatch();
        if (JPOXLogger.RDBMS_SQL.isDebugEnabled()) {
            JPOXLogger.RDBMS_SQL.debug(LOCALISER.msg("JDBC.Statement.ExecutionTime", System.currentTimeMillis() - startTime));
        }
        this.removeConnectionStatementState(conn);
        if (state.closeStatementOnProcess) {
            state.stmt.close();
        }
        return ind;
    }

    protected void removeConnectionStatementState(Connection conn) {
        this.connectionStatements.remove(conn);
    }

    protected ConnectionStatementState getConnectionStatementState(Connection conn) {
        return (ConnectionStatementState)this.connectionStatements.get(conn);
    }

    protected void setConnectionStatementState(Connection conn, ConnectionStatementState state) {
        this.connectionStatements.put(conn, state);
    }

    class ConnectionStatementState {
        PreparedStatement stmt = null;
        String stmtText = null;
        int batchSize = 0;
        boolean processable = false;
        boolean closeStatementOnProcess = false;

        ConnectionStatementState() {
        }
    }
}

