/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import org.jpox.ClassLoaderResolver;
import org.jpox.PersistenceManagerFactoryImpl;
import org.jpox.exceptions.JPOXException;
import org.jpox.store.AbstractAutoStartMechanism;
import org.jpox.store.StoreData;
import org.jpox.store.StoreManager;
import org.jpox.store.TableStoreData;
import org.jpox.store.exceptions.DatastoreInitialisationException;
import org.jpox.store.rdbms.RDBMSManager;
import org.jpox.store.rdbms.SchemaTable;
import org.jpox.util.Localiser;

public class SchemaAutoStarter
extends AbstractAutoStartMechanism {
    public static final String SCHEMA_TABLE = "SchemaTable";
    private static final Localiser LOCALISER_RDBMS = Localiser.getInstance("org.jpox.store.rdbms.Localisation");
    protected SchemaTable schemaTable = null;
    protected RDBMSManager storeMgr = null;
    PersistenceManagerFactory pmf;
    PersistenceManager pm;
    static /* synthetic */ Class class$org$jpox$store$rdbms$SchemaTable;

    public SchemaAutoStarter(StoreManager store_mgr, ClassLoaderResolver clr) {
        this.storeMgr = (RDBMSManager)store_mgr;
        this.storeMgr.addClass((class$org$jpox$store$rdbms$SchemaTable == null ? (class$org$jpox$store$rdbms$SchemaTable = SchemaAutoStarter.class$("org.jpox.store.rdbms.SchemaTable")) : class$org$jpox$store$rdbms$SchemaTable).getName(), clr);
        HashMap<String, String> props = new HashMap<String, String>();
        props.putAll(this.storeMgr.getOMFContext().getPersistenceConfiguration().getOptions());
        props.put("org.jpox.autoStartMechanism", "None");
        this.pmf = PersistenceManagerFactoryImpl.getPersistenceManagerFactory(props);
    }

    public Collection getAllClassData() throws DatastoreInitialisationException {
        HashSet<TableStoreData> schema_data = new HashSet<TableStoreData>();
        Iterator it = this.pm.getExtent(class$org$jpox$store$rdbms$SchemaTable == null ? (class$org$jpox$store$rdbms$SchemaTable = SchemaAutoStarter.class$("org.jpox.store.rdbms.SchemaTable")) : class$org$jpox$store$rdbms$SchemaTable).iterator();
        while (it.hasNext()) {
            SchemaTable st = (SchemaTable)it.next();
            TableStoreData data = new TableStoreData(st.getClassName(), st.getTableName(), st.getOwner().equals("1"), st.getOwner().equals("FCO") ? 1 : 2, st.getInterfaceName());
            schema_data.add(data);
        }
        return schema_data;
    }

    private void assertIsOpen() {
        if (this.pm == null) {
            throw new JPOXException(LOCALISER_RDBMS.msg("RDBMS.SchemaAutoStarter.AssertIsOpen")).setFatal();
        }
    }

    private void assertIsClosed() {
        if (this.pm != null) {
            throw new JPOXException(LOCALISER_RDBMS.msg("RDBMS.SchemaAutoStarter.AssertIsClosed")).setFatal();
        }
    }

    public void open() {
        this.assertIsClosed();
        this.pm = this.pmf.getPersistenceManager();
        this.pm.currentTransaction().begin();
    }

    public void close() {
        this.assertIsOpen();
        this.pm.currentTransaction().commit();
        this.pm.close();
        this.pm = null;
    }

    public boolean isOpen() {
        return this.pm != null;
    }

    public void addClass(StoreData data) {
        this.assertIsOpen();
        if (this.hasClass(data.getName())) {
            return;
        }
        TableStoreData tableData = (TableStoreData)data;
        SchemaTable st = new SchemaTable();
        st.setClassName(tableData.getName());
        st.setInterfaceName(tableData.getInterfaceName());
        st.setOwner(tableData.isTableOwner() ? "1" : "0");
        st.setTableName(tableData.getTableName());
        st.setType(data.isFCO() ? "FCO" : "SCO");
        st.setVersion("JPOX");
        this.pm.makePersistent((Object)st);
    }

    public boolean hasClass(String class_name) {
        this.assertIsOpen();
        return ((Collection)this.pm.newQuery(class$org$jpox$store$rdbms$SchemaTable == null ? (class$org$jpox$store$rdbms$SchemaTable = SchemaAutoStarter.class$("org.jpox.store.rdbms.SchemaTable")) : class$org$jpox$store$rdbms$SchemaTable, "className == :name").execute((Object)class_name)).size() > 0;
    }

    public void deleteClass(String class_name) {
        this.assertIsOpen();
        this.pm.newQuery(class$org$jpox$store$rdbms$SchemaTable == null ? (class$org$jpox$store$rdbms$SchemaTable = SchemaAutoStarter.class$("org.jpox.store.rdbms.SchemaTable")) : class$org$jpox$store$rdbms$SchemaTable, "className == :name").deletePersistentAll(new Object[]{class_name});
    }

    public void deleteAllClasses() {
        this.assertIsOpen();
        this.pm.newQuery(class$org$jpox$store$rdbms$SchemaTable == null ? (class$org$jpox$store$rdbms$SchemaTable = SchemaAutoStarter.class$("org.jpox.store.rdbms.SchemaTable")) : class$org$jpox$store$rdbms$SchemaTable).deletePersistentAll();
    }

    public String getStorageDescription() {
        return LOCALISER_RDBMS.msg("RDBMS.SchemaAutoStarter.StorageDescription", this.schemaTable.toString());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

