/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.adapter;

import java.math.BigInteger;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.jpox.exceptions.JPOXDataStoreException;
import org.jpox.store.DatastoreContainerObject;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.expression.BooleanExpression;
import org.jpox.store.expression.LogicSetExpression;
import org.jpox.store.expression.NumericExpression;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.expression.StringExpression;
import org.jpox.store.expression.StringLiteral;
import org.jpox.store.expression.TableExprAsJoins;
import org.jpox.store.expression.TableExprAsSubquery;
import org.jpox.store.rdbms.adapter.DatabaseAdapter;
import org.jpox.store.rdbms.columninfo.ColumnInfo;
import org.jpox.store.rdbms.columninfo.DB2ColumnInfo;
import org.jpox.store.rdbms.key.ForeignKey;
import org.jpox.store.rdbms.typeinfo.DB2TypeInfo;
import org.jpox.store.rdbms.typeinfo.TypeInfo;

public class DB2Adapter
extends DatabaseAdapter {
    public static final String DB2_RESERVED_WORDS = "ACCESS,ALIAS,ALLOW,ASUTIME,AUDIT,AUX,AUXILIARY,BUFFERPOOL,CAPTURE,CCSID,CLUSTER,COLLECTION,COLLID,COMMENT,CONCAT,CONTAINS,COUNT_BIG,CURRENT_LC_PATH,CURRENT_SERVER,CURRENT_TIMEZONE,DATABASE,DAYS,DB2GENERAL,DB2SQL,DBA,DBINFO,DBSPACE,DISALLOW,DSSIZE,EDITPROC,ERASE,EXCLUSIVE,EXPLAIN,FENCED,FIELDPROC,FILE,FINAL,GENERATED,GRAPHIC,HOURS,IDENTIFIED,INDEX,INTEGRITY,ISOBID,JAVA,LABEL,LC_CTYPE,LINKTYPE,LOCALE,LOCATORS,LOCK,LOCKSIZE,LONG,MICROSECOND,MICROSECONDS,MINUTES,MODE,MONTHS,NAME,NAMED,NHEADER,NODENAME,NODENUMBER,NULLS,NUMPARTS,OBID,OPTIMIZATION,OPTIMIZE,PACKAGE,PAGE,PAGES,PART,PCTFREE,PCTINDEX,PIECESIZE,PLAN,PRIQTY,PRIVATE,PROGRAM,PSID,QYERYNO,RECOVERY,RENAME,RESET,RESOURCE,RRN,RUN,SCHEDULE,SCRATCHPAD,SECONDS,SECQTY,SECURITY,SHARE,SIMPLE,SOURCE,STANDARD,STATISTICS,STAY,STOGROUP,STORES,STORPOOL,STYLE,SUBPAGES,SYNONYM,TABLESPACE,TYPE,VALIDPROC,VARIABLE,VARIANT,VCAT,VOLUMES,WLM,YEARS";
    static /* synthetic */ Class class$java$math$BigInteger;

    public DB2Adapter(DatabaseMetaData metadata) {
        super(metadata);
        this.reservedKeywords.addAll(this.parseKeywordList(DB2_RESERVED_WORDS));
    }

    public String getVendorID() {
        return "db2";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSchemaName(Connection conn) throws SQLException {
        Statement stmt = conn.createStatement();
        try {
            String string;
            String stmtText = "VALUES (CURRENT SCHEMA)";
            ResultSet rs = stmt.executeQuery(stmtText);
            try {
                if (!rs.next()) {
                    throw new JPOXDataStoreException("No result returned from " + stmtText).setFatal();
                }
                string = rs.getString(1).trim();
            }
            catch (Throwable throwable) {
                rs.close();
                throw throwable;
            }
            rs.close();
            return string;
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeConnection(Connection conn) throws SQLException {
        try {
            conn.rollback();
        }
        catch (Exception exception) {
        }
        finally {
            conn.close();
        }
    }

    public int getMaxConstraintNameLength() {
        return 18;
    }

    public int getMaxIndexNameLength() {
        return 18;
    }

    public boolean supportsLockWithSelectForUpdate() {
        return true;
    }

    public boolean supportsBooleanComparison() {
        return false;
    }

    public boolean supportsDeferredConstraints() {
        return false;
    }

    public boolean supportsForeignKeyUpdateAction(ForeignKey.FKAction action) {
        return action.equals(ForeignKey.RESTRICT_ACTION);
    }

    public boolean supportsForeignKeyDeleteAction(ForeignKey.FKAction action) {
        return action.equals(ForeignKey.CASCADE_ACTION) || action.equals(ForeignKey.RESTRICT_ACTION) || action.equals(ForeignKey.NULL_ACTION);
    }

    public boolean supportsNullsInCandidateKeys() {
        return false;
    }

    public TypeInfo newTypeInfo(ResultSet rs) {
        DB2TypeInfo ti = new DB2TypeInfo(rs);
        return ti;
    }

    protected void createTypeInfo(DatabaseMetaData metadata) throws SQLException {
        TypeInfo ti;
        super.createTypeInfo(metadata);
        Integer key = new Integer(6);
        if (this.typesByTypeNumber.get(key) == null) {
            ti = new TypeInfo("FLOAT", 6, 53, null, null, null, 1, false, 2, false, false, false, null, 0, 0, 0);
            this.typesByTypeNumber.put(key, ti);
        }
        if (this.typesByTypeNumber.get(key = new Integer(2)) == null) {
            ti = new TypeInfo("NUMERIC", 2, 31, null, null, "PRECISION,SCALE", 1, false, 2, false, false, false, null, 0, 31, 0);
            this.typesByTypeNumber.put(key, ti);
        }
        if (this.typesByTypeNumber.get(key = new Integer(-5)) == null) {
            ti = new TypeInfo("BIGINT", -5, 20, null, null, null, 1, false, 2, false, true, false, null, 0, 0, 10);
            this.typesByTypeNumber.put(key, ti);
        }
    }

    public ColumnInfo newColumnInfo(ResultSet rs) {
        return new DB2ColumnInfo(rs);
    }

    public LogicSetExpression newTableExpression(QueryExpression qs, DatastoreContainerObject table, DatastoreIdentifier rangeVar) {
        if (this.datastoreMajorVersion >= 8) {
            return new TableExprAsJoins(qs, table, rangeVar);
        }
        return new TableExprAsSubquery(qs, table, rangeVar);
    }

    public NumericExpression modOperator(ScalarExpression operand1, ScalarExpression operand2) {
        ArrayList<NumericExpression> args = new ArrayList<NumericExpression>();
        ArrayList<String> types = new ArrayList<String>();
        types.add("BIGINT");
        ArrayList<ScalarExpression> argsOp1 = new ArrayList<ScalarExpression>();
        argsOp1.add(operand1);
        args.add(new NumericExpression("CAST", argsOp1, types));
        ArrayList<ScalarExpression> argsOp2 = new ArrayList<ScalarExpression>();
        argsOp2.add(operand2);
        args.add(new NumericExpression("CAST", argsOp2, types));
        return new NumericExpression("MOD", args);
    }

    public int getUnlimitedLengthPrecisionValue(TypeInfo typeInfo) {
        if (typeInfo.dataType == 2004 || typeInfo.dataType == 2005) {
            return 0x40000000;
        }
        return super.getUnlimitedLengthPrecisionValue(typeInfo);
    }

    public String getDropTableStatement(DatastoreContainerObject table) {
        return "DROP TABLE " + table.toString();
    }

    public NumericExpression lengthMethod(StringExpression str) {
        ArrayList<StringExpression> args = new ArrayList<StringExpression>();
        args.add(str);
        return new NumericExpression("LENGTH", args);
    }

    public StringExpression substringMethod(StringExpression str, NumericExpression begin) {
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        if (str instanceof StringLiteral) {
            args.add(this.toStringExpression((StringLiteral)str));
        } else {
            args.add(str);
        }
        args.add(begin.add(this.getMapping(class$java$math$BigInteger == null ? (class$java$math$BigInteger = DB2Adapter.class$("java.math.BigInteger")) : class$java$math$BigInteger, str).newLiteral(str.getQueryExpression(), BigInteger.ONE)));
        return new StringExpression("SUBSTR", args);
    }

    public StringExpression substringMethod(StringExpression str, NumericExpression begin, NumericExpression end) {
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        if (str instanceof StringLiteral) {
            args.add(this.toStringExpression((StringLiteral)str));
        } else {
            args.add(str);
        }
        args.add(begin.add(this.getMapping(class$java$math$BigInteger == null ? (class$java$math$BigInteger = DB2Adapter.class$("java.math.BigInteger")) : class$java$math$BigInteger, str).newLiteral(str.getQueryExpression(), BigInteger.ONE)));
        args.add(end.sub(begin));
        return new StringExpression("SUBSTR", args);
    }

    public StringExpression trimMethod(StringExpression str) {
        ArrayList<StringExpression> args = new ArrayList<StringExpression>();
        args.add(str);
        return new StringExpression("RTRIM", args);
    }

    public NumericExpression indexOfMethod(ScalarExpression source, ScalarExpression str, NumericExpression from) {
        ScalarExpression integerLiteral = this.getMapping(class$java$math$BigInteger == null ? (class$java$math$BigInteger = DB2Adapter.class$("java.math.BigInteger")) : class$java$math$BigInteger, source).newLiteral(source.getQueryExpression(), BigInteger.ONE);
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        args.add(source);
        ArrayList<ScalarExpression> argsOp0 = new ArrayList<ScalarExpression>();
        argsOp0.add(str);
        ArrayList<String> types = new ArrayList<String>();
        types.add("VARCHAR(4000)");
        args.add(new StringExpression("CAST", argsOp0, types));
        if (from != null) {
            types = new ArrayList();
            types.add("BIGINT");
            ArrayList<NumericExpression> argsOp1 = new ArrayList<NumericExpression>();
            argsOp1.add(new NumericExpression(from, ScalarExpression.OP_ADD, integerLiteral));
            args.add(new NumericExpression("CAST", argsOp1, types));
        }
        NumericExpression locateExpr = new NumericExpression("LOCATE", args);
        return new NumericExpression(locateExpr, ScalarExpression.OP_SUB, integerLiteral);
    }

    public boolean supportsNullsKeywordInColumnOptions() {
        return false;
    }

    public boolean supportsAutoIncrementFields() {
        return true;
    }

    public String getAutoIncrementStmt(String tableName, String columnName) {
        return "VALUES IDENTITY_VAL_LOCAL()";
    }

    public String getAutoIncrementKeyword() {
        return "generated always as identity (start with 1)";
    }

    public String getContinuationString() {
        return " ";
    }

    public boolean supportsSequences() {
        return true;
    }

    public String getSequenceCreateStmt(String sequence_name, String min, String max, String start, String increment, String cache_size) {
        if (sequence_name == null) {
            throw new UnsupportedOperationException("Adapter.SequenceNameNullNotSupported");
        }
        StringBuffer stmt = new StringBuffer("CREATE SEQUENCE ");
        stmt.append(sequence_name);
        stmt.append(" AS INTEGER ");
        if (start != null && start.length() > 0) {
            stmt.append(" START WITH " + start);
        }
        if (increment != null && increment.length() > 0) {
            stmt.append(" INCREMENT BY " + increment);
        }
        if (min != null && min.length() > 0) {
            stmt.append(" MINVALUE " + min);
        }
        if (max != null && max.length() > 0) {
            stmt.append(" MAXVALUE " + max);
        }
        if (cache_size != null && cache_size.length() > 0) {
            stmt.append(" CACHE " + cache_size);
        } else {
            stmt.append(" NOCACHE");
        }
        return stmt.toString();
    }

    public String getSequenceNextStmt(String sequence_name) {
        if (sequence_name == null) {
            throw new UnsupportedOperationException("Adapter.SequenceNameNullNotSupported");
        }
        StringBuffer stmt = new StringBuffer("VALUES NEXTVAL FOR ");
        stmt.append(sequence_name);
        return stmt.toString();
    }

    public StringExpression toStringExpression(StringLiteral expr) {
        ArrayList<StringLiteral> args = new ArrayList<StringLiteral>();
        args.add(expr);
        ArrayList<String> types = new ArrayList<String>();
        types.add("VARCHAR(32672)");
        return new StringExpression("CAST", args, types);
    }

    public StringExpression translateMethod(ScalarExpression expr, ScalarExpression toExpr, ScalarExpression fromExpr) {
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        args.add(expr);
        args.add(toExpr);
        args.add(fromExpr);
        return new StringExpression("TRANSLATE", args);
    }

    public BooleanExpression startsWithMethod(ScalarExpression source, ScalarExpression str) {
        ScalarExpression integerLiteral = this.getMapping(class$java$math$BigInteger == null ? (class$java$math$BigInteger = DB2Adapter.class$("java.math.BigInteger")) : class$java$math$BigInteger, source).newLiteral(source.getQueryExpression(), BigInteger.ONE);
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        if (str instanceof StringLiteral) {
            args.add(this.toStringExpression((StringLiteral)str));
        } else {
            args.add(str);
        }
        if (source instanceof StringLiteral) {
            args.add(this.toStringExpression((StringLiteral)source));
        } else {
            args.add(source);
        }
        return new BooleanExpression(new StringExpression("LOCATE", args), ScalarExpression.OP_EQ, integerLiteral);
    }

    public ScalarExpression concatOperator(ScalarExpression operand1, ScalarExpression operand2) {
        ArrayList<String> types = new ArrayList<String>();
        types.add("VARCHAR(4000)");
        ArrayList<ScalarExpression> argsOp1 = new ArrayList<ScalarExpression>();
        argsOp1.add(operand1);
        ArrayList<ScalarExpression> argsOp2 = new ArrayList<ScalarExpression>();
        argsOp2.add(operand2);
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        args.add(super.concatOperator(new StringExpression("CAST", argsOp1, types), new StringExpression("CAST", argsOp2, types)));
        return new StringExpression("CAST", args, types);
    }

    public BooleanExpression endsWithMethod(ScalarExpression leftOperand, ScalarExpression rightOperand) {
        if (!(rightOperand instanceof StringExpression)) {
            throw new ScalarExpression.IllegalArgumentTypeException(rightOperand);
        }
        ArrayList<String> types = new ArrayList<String>();
        types.add("VARCHAR(4000)");
        ArrayList<ScalarExpression> argsOp1 = new ArrayList<ScalarExpression>();
        argsOp1.add(leftOperand);
        StringLiteral pct = new StringLiteral(leftOperand.getQueryExpression(), leftOperand.getMapping(), '%');
        return new BooleanExpression(new StringExpression("CAST", argsOp1, types), ScalarExpression.OP_LIKE, pct.add(leftOperand.getQueryExpression().getStoreManager().getDatastoreAdapter().getEscapedPatternExpression(rightOperand)));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

