/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.adapter;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.jpox.store.DatastoreContainerObject;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.IdentifierFactory;
import org.jpox.store.expression.LogicSetExpression;
import org.jpox.store.expression.NumericExpression;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.expression.StringExpression;
import org.jpox.store.expression.TableExprAsJoins;
import org.jpox.store.rdbms.Column;
import org.jpox.store.rdbms.adapter.DatabaseAdapter;
import org.jpox.store.rdbms.key.ForeignKey;
import org.jpox.store.rdbms.key.PrimaryKey;
import org.jpox.store.rdbms.table.Table;
import org.jpox.store.rdbms.typeinfo.HSQLTypeInfo;
import org.jpox.store.rdbms.typeinfo.TypeInfo;

public class HSQLAdapter
extends DatabaseAdapter {
    public HSQLAdapter(DatabaseMetaData metadata) {
        super(metadata);
    }

    public String getVendorID() {
        return "hsql";
    }

    public int getMaxTableNameLength() {
        return 128;
    }

    public int getMaxConstraintNameLength() {
        return 128;
    }

    public int getMaxIndexNameLength() {
        return 128;
    }

    public int getMaxColumnNameLength() {
        return 128;
    }

    public String getAddColumnStatement(DatastoreContainerObject table, Column col) {
        return "ALTER TABLE " + table.toString() + " ADD COLUMN " + col.getSQLDefinition();
    }

    public String getRangeByLimitSelectClause(long offset, long count) {
        if (offset >= 0L && count > 0L) {
            return " LIMIT " + offset + " " + count + " ";
        }
        if (offset <= 0L && count > 0L) {
            return " LIMIT 0 " + count + " ";
        }
        return "";
    }

    public TypeInfo newTypeInfo(ResultSet rs) {
        return new HSQLTypeInfo(rs);
    }

    public boolean supportsTransactionIsolationLevel(int isolationLevel) {
        return isolationLevel == 1;
    }

    public int getRequiredTransactionIsolationLevel() {
        return 1;
    }

    public boolean supportsPrimaryKeyInCreateStatements() {
        return true;
    }

    public boolean supportsStatementGetGeneratedKeys() {
        return false;
    }

    public boolean supportsStatementBatching() {
        return false;
    }

    public boolean supportsAnalysisMethods() {
        return false;
    }

    public String getSchemaName(Connection conn) throws SQLException {
        return "";
    }

    public String getAddPrimaryKeyStatement(PrimaryKey pk, IdentifierFactory factory) {
        return null;
    }

    public String getDropTableStatement(DatastoreContainerObject table) {
        return "DROP TABLE " + table.toString();
    }

    public LogicSetExpression newTableExpression(QueryExpression qs, DatastoreContainerObject table, DatastoreIdentifier rangeVar) {
        return new TableExprAsJoins(qs, table, rangeVar);
    }

    public boolean supportsDeferredConstraints() {
        return false;
    }

    public boolean supportsForeignKeyUpdateAction(ForeignKey.FKAction action) {
        if (this.datastoreMajorVersion < 1 || this.datastoreMajorVersion == 1 && this.datastoreMinorVersion < 7) {
            return false;
        }
        return action.equals(ForeignKey.CASCADE_ACTION) || action.equals(ForeignKey.DEFAULT_ACTION) || action.equals(ForeignKey.NULL_ACTION);
    }

    public boolean supportsForeignKeyDeleteAction(ForeignKey.FKAction action) {
        if (this.datastoreMajorVersion < 1 || this.datastoreMajorVersion == 1 && this.datastoreMinorVersion < 7) {
            return false;
        }
        return action.equals(ForeignKey.CASCADE_ACTION) || action.equals(ForeignKey.DEFAULT_ACTION) || action.equals(ForeignKey.NULL_ACTION);
    }

    public boolean supportsAutoIncrementFields() {
        return true;
    }

    public String getAutoIncrementStmt(String tableName, String columnName) {
        return "CALL IDENTITY()";
    }

    public String getAutoIncrementKeyword() {
        return "IDENTITY";
    }

    public String getInsertStatementForNoColumns(Table table) {
        return "INSERT INTO " + table.toString() + " VALUES (null)";
    }

    public boolean supportsUniqueConstraintsInEndCreateStatements() {
        return true;
    }

    public boolean supportsCheckInCreateStatements() {
        return false;
    }

    public boolean supportsCheckConstraintsInEndCreateStatements() {
        return this.datastoreMajorVersion >= 1 && (this.datastoreMajorVersion != 1 || this.datastoreMinorVersion >= 7) && (this.datastoreMajorVersion != 1 || this.datastoreMinorVersion != 7 || this.datastoreRevisionVersion >= 2);
    }

    public boolean isValidPrimaryKeyType(int datatype) {
        return datatype != 2004 && datatype != 2005 && datatype != -4 && datatype != 1111 && datatype != -1;
    }

    public NumericExpression modOperator(ScalarExpression operand1, ScalarExpression operand2) {
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        args.add(operand1);
        args.add(operand2);
        return new NumericExpression("MOD", args);
    }

    public StringExpression trimMethod(StringExpression str) {
        ArrayList<StringExpression> args = new ArrayList<StringExpression>();
        args.add(str);
        StringExpression strExpr = new StringExpression("RTRIM", args);
        args.clear();
        args.add(strExpr);
        return new StringExpression("LTRIM", args);
    }

    public String getDatastoreDateStatement() {
        return "CALL NOW()";
    }
}

