/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.adapter;

import java.math.BigInteger;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import org.jpox.store.DatastoreContainerObject;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.IdentifierFactory;
import org.jpox.store.expression.BooleanExpression;
import org.jpox.store.expression.Literal;
import org.jpox.store.expression.LogicSetExpression;
import org.jpox.store.expression.NumericExpression;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.expression.StringExpression;
import org.jpox.store.expression.TableExprAsJoins;
import org.jpox.store.rdbms.Column;
import org.jpox.store.rdbms.adapter.DatabaseAdapter;
import org.jpox.store.rdbms.columninfo.ColumnInfo;
import org.jpox.store.rdbms.columninfo.MySQLColumnInfo;
import org.jpox.store.rdbms.key.PrimaryKey;
import org.jpox.store.rdbms.table.TableImpl;
import org.jpox.store.rdbms.typeinfo.MySQLTypeInfo;
import org.jpox.store.rdbms.typeinfo.TypeInfo;

public class MySQLAdapter
extends DatabaseAdapter {
    public static final String NONSQL92_RESERVED_WORDS = "ANALYZE,AUTO_INCREMENT,BDB,BERKELEYDB,BIGINT,BINARY,BLOB,BTREE,CHANGE,COLUMNS,DATABASE,DATABASES,DAY_HOUR,DAY_MINUTE,DAY_SECOND,DELAYED,DISTINCTROW,DIV,ENCLOSED,ERRORS,ESCAPED,EXPLAIN,FIELDS,FORCE,FULLTEXT,FUNCTION,GEOMETRY,HASH,HELP,HIGH_PRIORITY,HOUR_MINUTE,HOUR_SECOND,IF,IGNORE,INDEX,INFILE,INNODB,KEYS,KILL,LIMIT,LINES,LOAD,LOCALTIME,LOCALTIMESTAMP,LOCK,LONG,LONGBLOB,LONGTEXT,LOW_PRIORITY,MASTER_SERVER_ID,MEDIUMBLOB,MEDIUMINT,MEDIUMTEXT,MIDDLEINT,MINUTE_SECOND,MOD,MRG_MYISAM,OPTIMIZE,OPTIONALLY,OUTFILE,PURGE,REGEXP,RENAME,REPLACE,REQUIRE,RETURNS,RLIKE,RTREE,SHOW,SONAME,SPATIAL,SQL_BIG_RESULT,SQL_CALC_FOUND_ROWS,SQL_SMALL_RESULT,SSL,STARTING,STRAIGHT_JOIN,STRIPED,TABLES,TERMINATED,TINYBLOB,TINYINT,TINYTEXT,TYPES,UNLOCK,UNSIGNED,USE,USER_RESOURCES,VARBINARY,VARCHARACTER,WARNINGS,XOR,YEAR_MONTH,ZEROFILL";
    static /* synthetic */ Class class$java$math$BigInteger;

    public MySQLAdapter(DatabaseMetaData metadata) {
        super(metadata);
        this.reservedKeywords.addAll(this.parseKeywordList(NONSQL92_RESERVED_WORDS));
    }

    public String getVendorID() {
        return "mysql";
    }

    protected void createTypeInfo(DatabaseMetaData metadata) throws SQLException {
        TypeInfo ti;
        super.createTypeInfo(metadata);
        Integer key = new Integer(2004);
        if (this.typesByTypeNumber.get(key) == null) {
            ti = new TypeInfo("MEDIUMBLOB", 2004, Integer.MAX_VALUE, null, null, null, 1, false, 1, false, false, false, "MEDIUMBLOB", 0, 0, 0);
            this.typesByTypeNumber.put(key, ti);
        }
        if (this.typesByTypeNumber.get(key = new Integer(2005)) == null) {
            ti = new TypeInfo("MEDIUMTEXT", 2005, Integer.MAX_VALUE, null, null, null, 1, true, 1, false, false, false, "MEDIUMTEXT", 0, 0, 0);
            this.typesByTypeNumber.put(key, ti);
        }
    }

    public ColumnInfo newColumnInfo(ResultSet rs) {
        if (this.driverMajorVersion <= 3) {
            return new MySQLColumnInfo(rs);
        }
        return super.newColumnInfo(rs);
    }

    public String getAddPrimaryKeyStatement(PrimaryKey pk, IdentifierFactory factory) {
        return null;
    }

    public boolean supportsPrimaryKeyInCreateStatements() {
        return true;
    }

    public boolean supportsDefaultBeforeNullInColumnOptions() {
        return false;
    }

    public String getCreateTableStatement(TableImpl table, Column[] columns, Properties props) {
        StringBuffer createStmt = new StringBuffer(super.getCreateTableStatement(table, columns, props));
        String engineType = "INNODB";
        if (props != null && props.containsKey("mysql-engine-type")) {
            engineType = props.getProperty("mysql-engine-type");
        }
        boolean engineKeywordPresent = false;
        if (this.datastoreMajorVersion >= 5 || this.datastoreMajorVersion == 4 && this.datastoreMinorVersion >= 1 && this.datastoreRevisionVersion >= 2 || this.datastoreMajorVersion == 4 && this.datastoreMinorVersion == 0 && this.datastoreRevisionVersion >= 18) {
            engineKeywordPresent = true;
        }
        if (engineKeywordPresent) {
            createStmt.append(" ENGINE=" + engineType);
        } else {
            createStmt.append(" TYPE=" + engineType);
        }
        return createStmt.toString();
    }

    public String getDropTableStatement(DatastoreContainerObject table) {
        return "DROP TABLE " + table.toString();
    }

    public boolean supportsExistsSyntax() {
        return this.datastoreMajorVersion >= 5 || this.datastoreMajorVersion >= 4 && this.datastoreMinorVersion >= 1;
    }

    public boolean supportsUnionSyntax() {
        return this.datastoreMajorVersion >= 4;
    }

    public boolean supportsAnalysisMethods() {
        return false;
    }

    public String getRangeByLimitWhereClause(long offset, long count) {
        if (offset >= 0L && count > 0L) {
            return " LIMIT " + offset + "," + count;
        }
        if (offset <= 0L && count > 0L) {
            return " LIMIT " + count;
        }
        return "";
    }

    public LogicSetExpression newTableExpression(QueryExpression qs, DatastoreContainerObject table, DatastoreIdentifier rangeVar) {
        return new TableExprAsJoins(qs, table, rangeVar);
    }

    public TypeInfo newTypeInfo(ResultSet rs) {
        MySQLTypeInfo ti = new MySQLTypeInfo(rs);
        if (ti.typeName.equalsIgnoreCase("binary") || ti.typeName.equalsIgnoreCase("varbinary")) {
            return null;
        }
        return ti;
    }

    public boolean supportsSettingBlobUsingSetString() {
        return true;
    }

    public boolean supportsSettingClobUsingSetString() {
        return true;
    }

    public boolean createIndexesBeforeForeignKeys() {
        return true;
    }

    public String getAddColumnStatement(DatastoreContainerObject table, Column col) {
        return "ALTER TABLE " + table.toString() + " ADD COLUMN " + col.getSQLDefinition();
    }

    public ScalarExpression concatOperator(ScalarExpression operand1, ScalarExpression operand2) {
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        args.add(operand1);
        args.add(operand2);
        return new StringExpression("CONCAT", args);
    }

    public BooleanExpression startsWithMethod(ScalarExpression source, ScalarExpression str) {
        ScalarExpression integerLiteral = this.getMapping(class$java$math$BigInteger == null ? (class$java$math$BigInteger = MySQLAdapter.class$("java.math.BigInteger")) : class$java$math$BigInteger, source).newLiteral(source.getQueryExpression(), BigInteger.ONE);
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        args.add(str);
        args.add(source);
        return new BooleanExpression(new StringExpression("LOCATE", args), ScalarExpression.OP_EQ, integerLiteral);
    }

    public boolean supportsLockWithSelectForUpdate() {
        return true;
    }

    public boolean supportsAlterTableDropConstraint() {
        return false;
    }

    public boolean supportsAlterTableDropForeignKeyConstraint() {
        return this.datastoreMajorVersion >= 4 && (this.datastoreMajorVersion != 4 || this.datastoreMinorVersion != 0 || this.datastoreRevisionVersion >= 13);
    }

    public boolean supportsDeferredConstraints() {
        return false;
    }

    public boolean includeOrderByColumnsInSelectUsingAlias() {
        return true;
    }

    public String getSelectNewUUIDStmt() {
        return "SELECT uuid()";
    }

    public boolean supportsAutoIncrementFields() {
        return true;
    }

    public String getAutoIncrementStmt(String tableName, String columnName) {
        return "SELECT LAST_INSERT_ID()";
    }

    public String getAutoIncrementKeyword() {
        return "AUTO_INCREMENT";
    }

    public String getEscapePatternExpression() {
        return "ESCAPE '\\\\'";
    }

    public StringExpression toStringExpression(NumericExpression expr) {
        if (expr instanceof Literal) {
            return super.toStringExpression(expr);
        }
        ArrayList<NumericExpression> args = new ArrayList<NumericExpression>();
        args.add(expr);
        ArrayList<String> types = new ArrayList<String>();
        types.add("CHAR(4000)");
        return new StringExpression("CAST", args, types);
    }

    public String cartersianProduct(LogicSetExpression Y) {
        StringBuffer sb = new StringBuffer();
        sb.append(" CROSS JOIN ");
        sb.append(Y.toString());
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

