/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.adapter;

import java.math.BigInteger;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.jpox.ClassLoaderResolver;
import org.jpox.exceptions.JPOXDataStoreException;
import org.jpox.store.DatastoreContainerObject;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.expression.LogicSetExpression;
import org.jpox.store.expression.NumericExpression;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.expression.SqlTemporalExpression;
import org.jpox.store.expression.StringExpression;
import org.jpox.store.expression.TableExprAsJoins;
import org.jpox.store.expression.TableExprAsSubquery;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.MappingManager;
import org.jpox.store.rdbms.adapter.DatabaseAdapter;
import org.jpox.store.rdbms.columninfo.ColumnInfo;
import org.jpox.store.rdbms.columninfo.OracleColumnInfo;
import org.jpox.store.rdbms.key.ForeignKey;
import org.jpox.store.rdbms.mapping.oracle.OracleRDBMSMappingManager;
import org.jpox.store.rdbms.query.Oracle99QueryStatement;
import org.jpox.store.rdbms.query.OracleQueryStatement;
import org.jpox.store.rdbms.typeinfo.TypeInfo;
import org.jpox.util.JPOXLogger;

public class OracleAdapter
extends DatabaseAdapter {
    public static final String ORACLE_8_RESERVED_WORDS = "ACCESS,AUDIT,CLUSTER,COMMENT,COMPRESS,EXCLUSIVE,FILE,IDENTIFIED,INCREMENT,INDEX,INITIAL,LOCK,LONG,MAXEXTENTS,MINUS,MLSLABEL,MODE,MODIFY,NOAUDIT,NOCOMPRESS,NOWAIT,NUMBER,OFFLINE,ONLINE,PCTFREE,RAW,RENAME,RESOURCE,ROWID,ROWNUM,SHARE,SUCCESSFUL,SYNONYM,SYSDATE,UID,VALIDATE,VARCHAR2,VALIDATE,VARCHAR2";
    public static final String ORACLE_9_RESERVED_WORDS = "ACCESS,CHAR,DEFAULT,ADD,CHECK,DELETE,ALL,CLUSTER,DESC,ALTER,COLUMN,DISTINCT,AND,COMMENT,DROP,ANY,COMPRESS,ELSE,AS,CONNECT,EXCLUSIVE,ASC,CREATE,EXISTS,AUDIT,CURRENT,FILE,BETWEEN,DATE,FLOAT,BY,DECIMAL,FOR,FROM,NOT,SHARE,GRANT,NOWAIT,SIZE,GROUP,NULL,SMALLINT,HAVING,NUMBER,START,IDENTIFIED,OF,SUCCESSFUL,IMMEDIATE,OFFLINE,SYNONYM,IN,ON,SYSDATE,INCREMENT,ONLINE,TABLE,INDEX,OPTION,THEN,INITIAL,OR,TO,INSERT,ORDER,TRIGGER,INTEGER,PCTFREE,UID,INTERSECT,PRIOR,UNION,INTO,PRIVILEGES,UNIQUE,IS,PUBLIC,UPDATE,LEVEL,RAW,USER,LIKE,RENAME,VALIDATE,LOCK,RESOURCE,VALUES,LONG,REVOKE,VARCHAR,MAXEXTENTS,ROW,VARCHAR2,MINUS,ROWID,VIEW,MLSLABEL,ROWNUM,WHENEVER,MODE,ROWS,WHERE,MODIFY,SELECT,WITH,NOAUDIT,SESSION,NOCOMPRESS,SET";
    public static final String ORACLE_10_RESERVED_WORDS = "ACCESS,ADD,ALL,ALTER,AND,ANY,AS,ASC,AUDIT,BETWEEN,BY,CHAR,CHECK,CLUSTER,COLUMN,COMMENT,COMPRESS,CONNECT,CREATE,CURRENT,DATE,DECIMAL,DEFAULT,DELETE,DESC,DISTINCT,DROP,ELSE,EXCLUSIVE,EXISTS,FILE,FLOAT,FOR,FROM,GRANT,GROUP,HAVING,IDENTIFIED,IMMEDIATE,IN,INCREMENT,INDEX,INITIAL,INSERT,INTEGER,INTERSECT,INTO,IS,LEVEL,LIKE,LOCK,LONG,MAXEXTENTS,MINUS,MLSLABEL,MODE,MODIFY,NOAUDIT,NOCOMPRESS,NOT,NOWAIT,NULL,NUMBER,OF,OFFLINE,ON,ONLINE,OPTION,OR,ORDER,PCTFREE,PRIOR,PRIVILEGES,PUBLIC,RAW,RENAME,RESOURCE,REVOKE,ROW,ROWID,ROWNUM,ROWS,SELECT,SESSION,SET,SHARE,SIZE,SMALLINT,START,SUCCESSFUL,SYNONYM,SYSDATE,TABLE,THEN,TO,TRIGGER,UID,UNION,UNIQUE,UPDATE,USER,VALIDATE,VALUES,VARCHAR,VARCHAR2,VIEW,WHENEVER,WHERE,WITH";
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$lang$String;

    public OracleAdapter(DatabaseMetaData metadata) {
        super(metadata);
        if (this.datastoreMajorVersion <= 8) {
            this.reservedKeywords.addAll(this.parseKeywordList(ORACLE_8_RESERVED_WORDS));
        } else if (this.datastoreMajorVersion == 9) {
            this.reservedKeywords.addAll(this.parseKeywordList(ORACLE_9_RESERVED_WORDS));
        } else if (this.datastoreMajorVersion >= 10) {
            this.reservedKeywords.addAll(this.parseKeywordList(ORACLE_10_RESERVED_WORDS));
        }
    }

    public String getVendorID() {
        return "oracle";
    }

    protected void createTypeInfo(DatabaseMetaData metadata) throws SQLException {
        TypeInfo ti;
        Integer doubleKey;
        Integer decimalKey;
        Integer dateKey;
        super.createTypeInfo(metadata);
        Integer clobKey = new Integer(2005);
        if (this.typesByTypeNumber.get(clobKey) == null) {
            TypeInfo ti2 = new TypeInfo("CLOB", 2005, 0x3FFFFFFF, "'", "'", null, 1, true, 0, false, false, false, "CLOB", 0, 0, 10);
            this.typesByTypeNumber.put(clobKey, ti2);
        }
        if (this.typesByTypeNumber.get(dateKey = new Integer(91)) == null) {
            TypeInfo ti3 = new TypeInfo("DATE", 91, 7, null, null, null, 1, false, 3, false, false, false, "DATE", 0, 0, 10);
            this.typesByTypeNumber.put(dateKey, ti3);
        }
        if (this.typesByTypeNumber.get(decimalKey = new Integer(3)) == null) {
            TypeInfo ti4 = new TypeInfo("DECIMAL", 3, 38, null, null, null, 1, false, 3, false, true, false, "NUMBER", -84, 127, 10);
            this.typesByTypeNumber.put(decimalKey, ti4);
        }
        if (this.typesByTypeNumber.get(doubleKey = new Integer(8)) == null) {
            ti = new TypeInfo("DOUBLE", 8, 38, null, null, null, 1, false, 3, false, true, false, "NUMBER", -84, 127, 10);
            this.typesByTypeNumber.put(doubleKey, ti);
        }
        ti = new TypeInfo("SDO_GEOMETRY", 2002, 0, null, null, null, 1, false, 0, false, false, false, "SDO_GEOMETRY", 0, 0, 10);
        this.typesByTypeNumber.put(new Integer(-123), ti);
        ti = new TypeInfo("SYS.XMLTYPE", 2007, 0x3FFFFFFF, "'", "'", null, 1, true, 0, false, false, false, "SYS.XMLTYPE", 0, 0, 10);
        this.typesByTypeNumber.put(new Integer(2007), ti);
    }

    public boolean isNullEqualsEmptyStrings() {
        return true;
    }

    public String getSurrogateForEmptyStrings() {
        return "\u0001";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSchemaName(Connection conn) throws SQLException {
        Statement stmt = conn.createStatement();
        try {
            String string;
            String stmtText = "SELECT SYS_CONTEXT('USERENV', 'CURRENT_SCHEMA') FROM DUAL";
            ResultSet rs = stmt.executeQuery(stmtText);
            try {
                if (!rs.next()) {
                    throw new JPOXDataStoreException("No result returned from " + stmtText).setFatal();
                }
                string = rs.getString(1);
            }
            catch (Throwable throwable) {
                rs.close();
                throw throwable;
            }
            rs.close();
            return string;
        }
        finally {
            stmt.close();
        }
    }

    public boolean supportsLockWithSelectForUpdate() {
        return true;
    }

    public boolean supportsForeignKeyDeleteAction(ForeignKey.FKAction action) {
        if (action == ForeignKey.CASCADE_ACTION) {
            return true;
        }
        return action == ForeignKey.NULL_ACTION;
    }

    public boolean supportsForeignKeyUpdateAction(ForeignKey.FKAction action) {
        return false;
    }

    public boolean supportsBooleanComparison() {
        return false;
    }

    public boolean supportsAnsiJoinSyntax() {
        return this.datastoreMajorVersion >= 9;
    }

    public String getNonAnsiInnerJoinWhereClause(String col1, String col2) {
        if (this.datastoreMajorVersion < 9) {
            StringBuffer str = new StringBuffer();
            str.append(col1);
            str.append(" = ");
            str.append(col2);
            return str.toString();
        }
        return null;
    }

    public String getNonAnsiLeftOuterJoinWhereClause(String col1, String col2) {
        if (this.datastoreMajorVersion < 9) {
            StringBuffer str = new StringBuffer();
            str.append(col1);
            str.append(" = ");
            str.append(col2);
            str.append(" (+) ");
            return str.toString();
        }
        return null;
    }

    public String getNonAnsiRightOuterJoinWhereClause(String col1, String col2) {
        if (this.datastoreMajorVersion < 9) {
            StringBuffer str = new StringBuffer();
            str.append(col1);
            str.append(" (+) = ");
            str.append(col2);
            str.append(" ");
            return str.toString();
        }
        return null;
    }

    public ResultSet getExistingIndexes(Connection conn, DatabaseMetaData dmd, String catalog, String schema, String table) throws SQLException {
        String GET_INDEXES_STMT = "select null as table_cat, owner as table_schem, table_name, 0 as NON_UNIQUE, null as index_qualifier, null as index_name, 0 as type, 0 as ordinal_position, null as column_name, null as asc_or_desc, num_rows as cardinality, blocks as pages, null as filter_condition from all_tables where table_name = ? and owner = ? union select null as table_cat, i.owner as table_schem, i.table_name, decode (i.uniqueness, 'UNIQUE', 0, 1), null as index_qualifier, i.index_name, 1 as type, c.column_position as ordinal_position, c.column_name, null as asc_or_desc, i.distinct_keys as cardinality, i.leaf_blocks as pages, null as filter_condition from all_indexes i, all_ind_columns c where i.table_name = ? and i.owner = ? and i.index_name = c.index_name and i.table_owner = c.table_owner and i.table_name = c.table_name and i.owner = c.index_owner order by non_unique, type, index_name, ordinal_position";
        if (this.datastoreMajorVersion == 10) {
            PreparedStatement stmt = conn.prepareStatement(GET_INDEXES_STMT);
            stmt.setString(1, table);
            stmt.setString(2, schema);
            stmt.setString(3, table);
            stmt.setString(4, schema);
            return stmt.executeQuery();
        }
        return super.getExistingIndexes(conn, dmd, catalog, schema, table);
    }

    public QueryExpression newQueryStatement(DatastoreContainerObject table, ClassLoaderResolver clr) {
        if (this.datastoreMajorVersion >= 9) {
            return new Oracle99QueryStatement(table, clr);
        }
        return new OracleQueryStatement(table, clr);
    }

    public QueryExpression newQueryStatement(DatastoreContainerObject table, DatastoreIdentifier rangeVar, ClassLoaderResolver clr) {
        if (this.datastoreMajorVersion >= 9) {
            return new Oracle99QueryStatement(table, rangeVar, clr);
        }
        return new OracleQueryStatement(table, rangeVar, clr);
    }

    public LogicSetExpression newTableExpression(QueryExpression qs, DatastoreContainerObject table, DatastoreIdentifier rangeVar) {
        if (this.datastoreMajorVersion >= 9) {
            return new TableExprAsJoins(qs, table, rangeVar);
        }
        return new TableExprAsSubquery(qs, table, rangeVar);
    }

    public String getDropTableStatement(DatastoreContainerObject table) {
        if (this.datastoreMajorVersion >= 10) {
            return "DROP TABLE " + table.toString() + " CASCADE CONSTRAINTS PURGE";
        }
        return "DROP TABLE " + table.toString() + " CASCADE CONSTRAINTS";
    }

    public NumericExpression lengthMethod(StringExpression str) {
        ArrayList<StringExpression> args = new ArrayList<StringExpression>();
        args.add(str);
        return new NumericExpression("LENGTH", args);
    }

    public StringExpression substringMethod(StringExpression str, NumericExpression begin) {
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        args.add(str);
        args.add(begin.add(this.getMapping(class$java$math$BigInteger == null ? (class$java$math$BigInteger = OracleAdapter.class$("java.math.BigInteger")) : class$java$math$BigInteger, str).newLiteral(str.getQueryExpression(), BigInteger.ONE)));
        return new StringExpression("SUBSTR", args);
    }

    public StringExpression substringMethod(StringExpression str, NumericExpression begin, NumericExpression end) {
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        args.add(str);
        args.add(begin.add(this.getMapping(class$java$math$BigInteger == null ? (class$java$math$BigInteger = OracleAdapter.class$("java.math.BigInteger")) : class$java$math$BigInteger, str).newLiteral(str.getQueryExpression(), BigInteger.ONE)));
        args.add(end.sub(begin));
        return new StringExpression("SUBSTR", args);
    }

    public NumericExpression modOperator(ScalarExpression operand1, ScalarExpression operand2) {
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        args.add(operand1);
        args.add(operand2);
        return new NumericExpression("MOD", args);
    }

    public NumericExpression getDayMethod(SqlTemporalExpression date) {
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        args.add(date);
        args.add(this.getMapping(class$java$lang$String == null ? (class$java$lang$String = OracleAdapter.class$("java.lang.String")) : class$java$lang$String, date).newLiteral(date.getQueryExpression(), "DD"));
        ArrayList<StringExpression> args1 = new ArrayList<StringExpression>();
        args1.add(new StringExpression("TO_CHAR", args));
        return new NumericExpression("TO_NUMBER", args1);
    }

    public NumericExpression getMonthMethod(SqlTemporalExpression date) {
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        args.add(date);
        args.add(this.getMapping(class$java$lang$String == null ? (class$java$lang$String = OracleAdapter.class$("java.lang.String")) : class$java$lang$String, date).newLiteral(date.getQueryExpression(), "MM"));
        ArrayList<StringExpression> args1 = new ArrayList<StringExpression>();
        args1.add(new StringExpression("TO_CHAR", args));
        JavaTypeMapping m = this.getMapping(class$java$math$BigInteger == null ? (class$java$math$BigInteger = OracleAdapter.class$("java.math.BigInteger")) : class$java$math$BigInteger, date);
        ScalarExpression integerLiteral = m.newLiteral(date.getQueryExpression(), BigInteger.ONE);
        NumericExpression expr = new NumericExpression(new NumericExpression("TO_NUMBER", args1), ScalarExpression.OP_SUB, integerLiteral);
        expr.encloseWithInParentheses();
        return expr;
    }

    public NumericExpression getYearMethod(SqlTemporalExpression date) {
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        args.add(date);
        args.add(this.getMapping(class$java$lang$String == null ? (class$java$lang$String = OracleAdapter.class$("java.lang.String")) : class$java$lang$String, date).newLiteral(date.getQueryExpression(), "YYYY"));
        ArrayList<StringExpression> args1 = new ArrayList<StringExpression>();
        args1.add(new StringExpression("TO_CHAR", args));
        return new NumericExpression("TO_NUMBER", args1);
    }

    public NumericExpression getHourMethod(SqlTemporalExpression time) {
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        args.add(time);
        args.add(this.getMapping(class$java$lang$String == null ? (class$java$lang$String = OracleAdapter.class$("java.lang.String")) : class$java$lang$String, time).newLiteral(time.getQueryExpression(), "HH24"));
        ArrayList<StringExpression> args1 = new ArrayList<StringExpression>();
        args1.add(new StringExpression("TO_CHAR", args));
        return new NumericExpression("TO_NUMBER", args1);
    }

    public NumericExpression getMinuteMethod(SqlTemporalExpression time) {
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        args.add(time);
        args.add(this.getMapping(class$java$lang$String == null ? (class$java$lang$String = OracleAdapter.class$("java.lang.String")) : class$java$lang$String, time).newLiteral(time.getQueryExpression(), "MI"));
        ArrayList<StringExpression> args1 = new ArrayList<StringExpression>();
        args1.add(new StringExpression("TO_CHAR", args));
        return new NumericExpression("TO_NUMBER", args1);
    }

    public NumericExpression getSecondMethod(SqlTemporalExpression time) {
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        args.add(time);
        args.add(this.getMapping(class$java$lang$String == null ? (class$java$lang$String = OracleAdapter.class$("java.lang.String")) : class$java$lang$String, time).newLiteral(time.getQueryExpression(), "SS"));
        ArrayList<StringExpression> args1 = new ArrayList<StringExpression>();
        args1.add(new StringExpression("TO_CHAR", args));
        return new NumericExpression("TO_NUMBER", args1);
    }

    public NumericExpression indexOfMethod(ScalarExpression source, ScalarExpression str, NumericExpression from) {
        ScalarExpression integerLiteral = this.getMapping(class$java$math$BigInteger == null ? (class$java$math$BigInteger = OracleAdapter.class$("java.math.BigInteger")) : class$java$math$BigInteger, source).newLiteral(source.getQueryExpression(), BigInteger.ONE);
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        args.add(source);
        args.add(str);
        if (from != null) {
            args.add(new NumericExpression(from, ScalarExpression.OP_ADD, integerLiteral));
        }
        NumericExpression locateExpr = new NumericExpression("INSTR", args);
        return new NumericExpression(locateExpr, ScalarExpression.OP_SUB, integerLiteral);
    }

    public boolean supportsSequences() {
        return true;
    }

    public String getSequenceCreateStmt(String sequence_name, String min, String max, String start, String increment, String cache_size) {
        if (sequence_name == null) {
            throw new UnsupportedOperationException("Adapter.SequenceNameNullNotSupported");
        }
        StringBuffer stmt = new StringBuffer("CREATE SEQUENCE ");
        stmt.append(sequence_name);
        if (min != null && min.length() > 0) {
            stmt.append(" MINVALUE " + min);
        }
        if (max != null && max.length() > 0) {
            stmt.append(" MAXVALUE " + max);
        }
        if (start != null && start.length() > 0) {
            stmt.append(" START WITH " + start);
        }
        if (increment != null && increment.length() > 0) {
            stmt.append(" INCREMENT BY " + increment);
        }
        if (cache_size != null && cache_size.length() > 0) {
            stmt.append(" CACHE " + cache_size);
        } else {
            stmt.append(" NOCACHE");
        }
        return stmt.toString();
    }

    public String getSequenceNextStmt(String sequence_name) {
        if (sequence_name == null) {
            throw new UnsupportedOperationException("Adapter.SequenceNameNullNotSupported");
        }
        StringBuffer stmt = new StringBuffer("SELECT ");
        stmt.append(sequence_name);
        stmt.append(".NEXTVAL from dual ");
        return stmt.toString();
    }

    public ColumnInfo newColumnInfo(ResultSet rs) {
        return new OracleColumnInfo(rs);
    }

    public int getTransactionIsolationForSchemaCreation() {
        return 2;
    }

    public boolean requiresColumnDefaultsInitialising() {
        return false;
    }

    public ResultSet getColumns(Connection conn, String catalog, String schema, String table) throws SQLException {
        StringBuffer columnsQuery = new StringBuffer();
        columnsQuery.append("SELECT NULL TABLE_CAT, OWNER TABLE_SCHEM, TABLE_NAME, COLUMN_NAME, NULL DATA_TYPE, ");
        columnsQuery.append("DATA_TYPE TYPE_NAME, DECODE(DATA_TYPE,'NUMBER',DATA_PRECISION,DATA_LENGTH) COLUMN_SIZE, ");
        columnsQuery.append("0 BUFFER_LENGTH, DATA_SCALE DECIMAL_DIGITS, 10 NUM_PREC_RADIX, ");
        columnsQuery.append("DECODE(NULLABLE,'Y',1,0) NULLABLE, NULL REMARKS, NULL COLUMN_DEF, 0 SQL_DATA_TYPE, 0 SQL_DATETIME_SUB, ");
        columnsQuery.append("DATA_LENGTH CHAR_OCTET_LENGTH, COLUMN_ID ORDINAL_POSITION, DECODE(NULLABLE,'Y','YES','NO') IS_NULLABLE ");
        columnsQuery.append("FROM ALL_TAB_COLUMNS ");
        boolean outputWhere = false;
        if (schema != null && schema.length() > 0) {
            columnsQuery.append("WHERE OWNER LIKE '").append(schema.toUpperCase()).append("' ");
            outputWhere = true;
        }
        if (table != null) {
            if (!outputWhere) {
                columnsQuery.append("WHERE ");
                outputWhere = true;
            } else {
                columnsQuery.append("AND ");
            }
            if (table.length() > 0) {
                columnsQuery.append("TABLE_NAME LIKE '").append(table.toUpperCase()).append("' ");
            } else {
                columnsQuery.append("TABLE_NAME IS NULL ");
            }
        }
        columnsQuery.append("ORDER BY TABLE_SCHEM, TABLE_NAME, ORDINAL_POSITION ");
        JPOXLogger.RDBMS_SQL.debug("Retrieving Oracle column info using  the following SQL : " + columnsQuery);
        Statement columnsStmt = conn.createStatement();
        ResultSet columnsResult = columnsStmt.executeQuery(columnsQuery.toString());
        columnsQuery = null;
        return columnsResult;
    }

    public MappingManager getNewMappingManager() {
        return new OracleRDBMSMappingManager();
    }

    public String getDatastoreDateStatement() {
        return "SELECT CURRENT_TIMESTAMP FROM DUAL";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

