/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.adapter;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.jpox.ClassLoaderResolver;
import org.jpox.exceptions.ClassNotResolvedException;
import org.jpox.exceptions.JPOXDataStoreException;
import org.jpox.plugin.ConfigurationElement;
import org.jpox.plugin.Extension;
import org.jpox.plugin.PluginManager;
import org.jpox.store.DatastoreAdapter;
import org.jpox.store.rdbms.adapter.DatabaseAdapter;
import org.jpox.util.JPOXLogger;
import org.jpox.util.Localiser;

public class RDBMSAdapterFactory {
    private static final Localiser LOCALISER = Localiser.getInstance("org.jpox.store.rdbms.Localisation");
    static /* synthetic */ Class class$java$sql$DatabaseMetaData;

    public static RDBMSAdapterFactory getInstance() {
        return new RDBMSAdapterFactory();
    }

    protected RDBMSAdapterFactory() {
    }

    public DatastoreAdapter getDatastoreAdapter(ClassLoaderResolver clr, Connection conn, String adapterClassName, PluginManager pluginMgr) throws SQLException {
        DatastoreAdapter adapter = null;
        DatabaseMetaData metadata = conn.getMetaData();
        adapter = this.getNewDatastoreAdapter(clr, metadata, adapterClassName, pluginMgr);
        if (adapter == null) {
            JPOXLogger.RDBMS.warn(LOCALISER.msg("RDBMS.Adapter.NoAdapterFound"));
            adapter = new DatabaseAdapter(metadata);
        }
        return adapter;
    }

    protected DatastoreAdapter getNewDatastoreAdapter(ClassLoaderResolver clr, DatabaseMetaData metadata, String adapterClassName, PluginManager pluginMgr) {
        Object adapter_obj;
        if (metadata == null) {
            return null;
        }
        String productName = null;
        if (adapterClassName == null) {
            try {
                productName = metadata.getDatabaseProductName();
                if (productName == null) {
                    JPOXLogger.RDBMS.error(LOCALISER.msg("RDBMS.Adapter.JDBC.NoProductNameError"));
                    return null;
                }
            }
            catch (SQLException sqe) {
                JPOXLogger.RDBMS.error(LOCALISER.msg("RDBMS.Adapter.JDBC.ProductNameAccessError", sqe));
                return null;
            }
        }
        try {
            Class adapterClass = this.getAdapterClass(pluginMgr, adapterClassName, productName, clr);
            Object[] ctr_args = new Object[]{metadata};
            Class[] ctr_args_classes = new Class[]{class$java$sql$DatabaseMetaData == null ? (class$java$sql$DatabaseMetaData = RDBMSAdapterFactory.class$("java.sql.DatabaseMetaData")) : class$java$sql$DatabaseMetaData};
            Constructor ctr = adapterClass.getConstructor(ctr_args_classes);
            try {
                ctr.setAccessible(true);
                adapter_obj = ctr.newInstance(ctr_args);
            }
            catch (InvocationTargetException ite) {
                if (ite.getTargetException() != null && ite.getTargetException() instanceof JPOXDataStoreException) {
                    throw (JPOXDataStoreException)ite.getTargetException();
                }
                return null;
            }
            catch (Exception e) {
                JPOXLogger.RDBMS.error(LOCALISER.msg("RDBMS.Adapter.InstantiationError", adapterClassName, e));
                return null;
            }
        }
        catch (ClassNotResolvedException ex) {
            JPOXLogger.RDBMS.error(LOCALISER.msg("RDBMS.Adapter.InstantiationError", adapterClassName, ex));
            return null;
        }
        catch (NoSuchMethodException nsme) {
            JPOXLogger.RDBMS.error(LOCALISER.msg("RDBMS.Adapter.InstantiationError", adapterClassName, nsme));
            return null;
        }
        return (DatastoreAdapter)adapter_obj;
    }

    protected Class getAdapterClass(PluginManager pluginMgr, String adapterClassName, String productName, ClassLoaderResolver clr) {
        ConfigurationElement highestMatchingAdapter = null;
        int highestPriority = Integer.MIN_VALUE;
        Extension[] ex = pluginMgr.getExtensionPoint("org.jpox.store_datastoreadapter").getExtensions();
        for (int i = 0; i < ex.length; ++i) {
            ConfigurationElement[] confElm = ex[i].getConfigurationElements();
            for (int c = 0; c < confElm.length; ++c) {
                int priority;
                if (adapterClassName != null) {
                    if (!confElm[c].getAttribute("class-name").equals(adapterClassName)) continue;
                    return pluginMgr.loadClass(confElm[c].getExtension().getPlugin().getId(), confElm[c].getAttribute("class-name"));
                }
                String vendorId = confElm[c].getAttribute("vendor-id");
                if (productName.toLowerCase().indexOf(vendorId.toLowerCase()) < 0 || (priority = Integer.parseInt(confElm[c].getAttribute("priority"))) < highestPriority) continue;
                if (priority > highestPriority && highestMatchingAdapter != null) {
                    JPOXLogger.RDBMS.warn(LOCALISER.msg("RDBMS.Adapter.AdapterClassOverridden", highestMatchingAdapter.getAttribute("class-name"), highestMatchingAdapter.getAttribute("vendor-id"), String.valueOf(priority), confElm[c].getAttribute("class-name")));
                }
                highestMatchingAdapter = confElm[c];
                highestPriority = priority;
            }
        }
        if (adapterClassName != null) {
            return clr.classForName(adapterClassName, false);
        }
        if (highestMatchingAdapter != null) {
            return pluginMgr.loadClass(highestMatchingAdapter.getExtension().getPlugin().getId(), highestMatchingAdapter.getAttribute("class-name"));
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

