/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.key;

import java.util.ArrayList;
import org.jpox.exceptions.JPOXException;
import org.jpox.metadata.ForeignKeyAction;
import org.jpox.metadata.ForeignKeyMetaData;
import org.jpox.store.DatastoreAdapter;
import org.jpox.store.DatastoreClass;
import org.jpox.store.DatastoreField;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.rdbms.adapter.RDBMSAdapter;
import org.jpox.store.rdbms.key.Key;

public class ForeignKey
extends Key {
    public static final FKAction CASCADE_ACTION = new FKAction(1, "CASCADE");
    public static final FKAction RESTRICT_ACTION = new FKAction(2, "RESTRICT");
    public static final FKAction NULL_ACTION = new FKAction(3, "SET NULL");
    public static final FKAction DEFAULT_ACTION = new FKAction(4, "SET DEFAULT");
    private boolean initiallyDeferred;
    private DatastoreClass refTable;
    private DatastoreAdapter dba;
    private FKAction updateAction;
    private FKAction deleteAction;
    private ArrayList refColumns = new ArrayList();

    public ForeignKey(boolean initiallyDeferred) {
        super(null);
        this.initiallyDeferred = initiallyDeferred;
        this.refTable = null;
        this.dba = null;
    }

    public ForeignKey(JavaTypeMapping mapping, DatastoreAdapter dba, DatastoreClass refTable, boolean initiallyDeferred) {
        super(mapping.getDatastoreContainer());
        this.initiallyDeferred = initiallyDeferred;
        this.refTable = refTable;
        this.dba = dba;
        if (refTable.getIDMapping() == null) {
            throw new JPOXException("ForeignKey ID mapping is not initilized for " + mapping + ". Table referenced: " + ((Object)refTable).toString()).setFatal();
        }
        for (int i = 0; i < refTable.getIDMapping().getNumberOfDatastoreFields(); ++i) {
            this.setDatastoreField(i, mapping.getDataStoreMapping(i).getDatastoreField(), refTable.getIDMapping().getDataStoreMapping(i).getDatastoreField());
        }
    }

    public void setForMetaData(ForeignKeyMetaData fkmd) {
        ForeignKeyAction updateAction;
        ForeignKeyAction deleteAction;
        if (fkmd == null) {
            return;
        }
        if (fkmd.getName() != null) {
            this.setName(fkmd.getName());
        }
        if ((deleteAction = fkmd.getDeleteAction()) != null) {
            if (deleteAction.equals(ForeignKeyAction.CASCADE)) {
                this.setDeleteAction(CASCADE_ACTION);
            } else if (deleteAction.equals(ForeignKeyAction.RESTRICT)) {
                this.setDeleteAction(RESTRICT_ACTION);
            } else if (deleteAction.equals(ForeignKeyAction.NULL)) {
                this.setDeleteAction(NULL_ACTION);
            } else if (deleteAction.equals(ForeignKeyAction.DEFAULT)) {
                this.setDeleteAction(DEFAULT_ACTION);
            }
        }
        if ((updateAction = fkmd.getUpdateAction()) != null) {
            if (updateAction.equals(ForeignKeyAction.CASCADE)) {
                this.setUpdateAction(CASCADE_ACTION);
            } else if (updateAction.equals(ForeignKeyAction.RESTRICT)) {
                this.setUpdateAction(RESTRICT_ACTION);
            } else if (updateAction.equals(ForeignKeyAction.NULL)) {
                this.setUpdateAction(NULL_ACTION);
            } else if (updateAction.equals(ForeignKeyAction.DEFAULT)) {
                this.setUpdateAction(DEFAULT_ACTION);
            }
        }
        if (fkmd.isDeferred()) {
            this.initiallyDeferred = true;
        }
    }

    public FKAction getDeleteAction() {
        return this.deleteAction;
    }

    public void setDeleteAction(FKAction deleteAction) {
        this.deleteAction = deleteAction;
    }

    public FKAction getUpdateAction() {
        return this.updateAction;
    }

    public void setUpdateAction(FKAction updateAction) {
        this.updateAction = updateAction;
    }

    public void addDatastoreField(DatastoreField col, DatastoreField refCol) {
        this.setDatastoreField(this.columns.size(), col, refCol);
    }

    public void setDatastoreField(int seq, DatastoreField col, DatastoreField refCol) {
        if (this.table == null) {
            this.table = col.getDatastoreContainerObject();
            this.refTable = (DatastoreClass)refCol.getDatastoreContainerObject();
            this.dba = this.table.getStoreManager().getDatastoreAdapter();
        } else {
            if (!this.table.equals(col.getDatastoreContainerObject())) {
                throw new JPOXException("Cannot add " + col + " as FK column for " + this.table).setFatal();
            }
            if (!this.refTable.equals(refCol.getDatastoreContainerObject())) {
                throw new JPOXException("Cannot add " + refCol + " as referenced FK column for " + this.refTable).setFatal();
            }
        }
        ForeignKey.setMinSize(this.columns, seq + 1);
        ForeignKey.setMinSize(this.refColumns, seq + 1);
        this.columns.set(seq, col);
        this.refColumns.set(seq, refCol);
    }

    public int hashCode() {
        return super.hashCode() ^ this.refColumns.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ForeignKey)) {
            return false;
        }
        ForeignKey fk = (ForeignKey)obj;
        if (!this.refColumns.equals(fk.refColumns)) {
            return false;
        }
        return super.equals(obj);
    }

    public String toString() {
        StringBuffer s = new StringBuffer("FOREIGN KEY ");
        s.append(ForeignKey.getColumnList(this.columns));
        if (this.refTable != null) {
            s.append(" REFERENCES ");
            s.append(((Object)this.refTable).toString());
            s.append(" ").append(ForeignKey.getColumnList(this.refColumns));
        }
        if (this.deleteAction != null && ((RDBMSAdapter)this.dba).supportsForeignKeyDeleteAction(this.deleteAction)) {
            s.append(" ON DELETE ").append(this.deleteAction.getKeyword());
        }
        if (this.updateAction != null && ((RDBMSAdapter)this.dba).supportsForeignKeyUpdateAction(this.updateAction)) {
            s.append(" ON UPDATE ").append(this.updateAction.getKeyword());
        }
        if (this.initiallyDeferred && ((RDBMSAdapter)this.dba).supportsDeferredConstraints()) {
            s.append(" INITIALLY DEFERRED");
        }
        s.append(" ");
        return s.toString();
    }

    public static class FKAction {
        int type;
        String keyword;

        public FKAction(int type, String keyword) {
            this.type = type;
            this.keyword = keyword;
        }

        public int getType() {
            return this.type;
        }

        public String getKeyword() {
            return this.keyword;
        }
    }
}

