/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.mapping;

import java.io.BufferedReader;
import java.io.IOException;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.jpox.exceptions.JPOXDataStoreException;
import org.jpox.store.DatastoreField;
import org.jpox.store.StoreManager;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.rdbms.datatype.ClobImpl;
import org.jpox.store.rdbms.mapping.LongVarcharRDBMSMapping;
import org.jpox.store.rdbms.typeinfo.TypeInfo;

public class ClobRDBMSMapping
extends LongVarcharRDBMSMapping {
    public ClobRDBMSMapping(StoreManager storeMgr, JavaTypeMapping mapping) {
        super(storeMgr, mapping);
    }

    public ClobRDBMSMapping(JavaTypeMapping mapping, StoreManager storeMgr, DatastoreField field) {
        super(mapping, storeMgr, field);
    }

    public TypeInfo getTypeInfo() {
        return this.getDatabaseAdapter().getTypeInfo(2005);
    }

    public void setString(Object ps, int param, String value) {
        if (this.getDatabaseAdapter().supportsSettingClobUsingSetString()) {
            super.setString(ps, param, value);
        } else {
            this.setObject(ps, param, value);
        }
    }

    public void setObject(Object ps, int param, Object value) {
        if (this.getDatabaseAdapter().supportsSettingClobUsingSetString()) {
            super.setObject(ps, param, value);
        } else {
            try {
                if (value == null) {
                    ((PreparedStatement)ps).setNull(param, this.getTypeInfo().dataType);
                } else {
                    ((PreparedStatement)ps).setClob(param, new ClobImpl((String)value));
                }
            }
            catch (SQLException e) {
                throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToSetParam", "Object", "" + value, this.column, e.getMessage()), e);
            }
            catch (IOException e) {
                throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToSetParam", "Object", "" + value, this.column, e.getMessage()), e);
            }
        }
    }

    public String getString(Object rs, int param) {
        if (this.getDatabaseAdapter().supportsSettingClobUsingSetString()) {
            return super.getString(rs, param);
        }
        return (String)this.getObject(rs, param);
    }

    public Object getObject(Object rs, int param) {
        String value;
        if (this.getDatabaseAdapter().supportsSettingClobUsingSetString()) {
            return super.getObject(rs, param);
        }
        try {
            Clob clob = ((ResultSet)rs).getClob(param);
            if (!((ResultSet)rs).wasNull()) {
                int c;
                BufferedReader br = new BufferedReader(clob.getCharacterStream());
                StringBuffer sb = new StringBuffer();
                while ((c = br.read()) != -1) {
                    sb.append((char)c);
                }
                value = sb.toString();
            } else {
                value = null;
            }
        }
        catch (SQLException e) {
            throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToGetParam", "Object", "" + param, this.column, e.getMessage()), e);
        }
        catch (IOException e) {
            throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToGetParam", "Object", "" + param, this.column, e.getMessage()), e);
        }
        return value;
    }
}

