/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.mapping.oracle;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.StreamCorruptedException;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.jdo.spi.PersistenceCapable;
import oracle.sql.BLOB;
import org.jpox.ManagedConnection;
import org.jpox.ObjectManager;
import org.jpox.StateManager;
import org.jpox.exceptions.JPOXDataStoreException;
import org.jpox.exceptions.JPOXObjectNotFoundException;
import org.jpox.exceptions.JPOXUserException;
import org.jpox.store.DatastoreContainerObject;
import org.jpox.store.DatastoreField;
import org.jpox.store.StoreManager;
import org.jpox.store.mapping.DatastoreMapping;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.Mappings;
import org.jpox.store.rdbms.Column;
import org.jpox.store.rdbms.RDBMSFetchStatement;
import org.jpox.store.rdbms.RDBMSManager;
import org.jpox.store.rdbms.SQLController;
import org.jpox.store.rdbms.adapter.DatabaseAdapter;
import org.jpox.store.rdbms.datatype.BlobImpl;
import org.jpox.store.rdbms.mapping.ColumnMapping;
import org.jpox.store.rdbms.typeinfo.TypeInfo;
import org.jpox.util.JPOXLogger;
import org.jpox.util.Localiser;
import org.jpox.util.TypeConversionHelper;

public class OracleBlobRDBMSMapping
extends ColumnMapping {
    protected static final Localiser LOCALISER_RDBMS = Localiser.getInstance("org.jpox.store.rdbms.Localisation");
    static /* synthetic */ Class array$Z;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class array$C;
    static /* synthetic */ Class array$D;
    static /* synthetic */ Class array$F;
    static /* synthetic */ Class array$I;
    static /* synthetic */ Class array$J;
    static /* synthetic */ Class array$S;
    static /* synthetic */ Class array$Ljava$lang$Boolean;
    static /* synthetic */ Class array$Ljava$lang$Byte;
    static /* synthetic */ Class array$Ljava$lang$Character;
    static /* synthetic */ Class array$Ljava$lang$Double;
    static /* synthetic */ Class array$Ljava$lang$Float;
    static /* synthetic */ Class array$Ljava$lang$Integer;
    static /* synthetic */ Class array$Ljava$lang$Long;
    static /* synthetic */ Class array$Ljava$lang$Short;
    static /* synthetic */ Class array$Ljava$math$BigDecimal;
    static /* synthetic */ Class array$Ljava$math$BigInteger;
    static /* synthetic */ Class class$java$util$BitSet;

    public OracleBlobRDBMSMapping(JavaTypeMapping mapping, StoreManager storeMgr, DatastoreField field) {
        super(storeMgr, mapping);
        this.column = (Column)field;
        this.initialize();
    }

    protected OracleBlobRDBMSMapping(StoreManager storeMgr, JavaTypeMapping mapping) {
        super(storeMgr, mapping);
    }

    private void initialize() {
        this.initTypeInfo();
    }

    public String getInsertionInputParameter() {
        return "EMPTY_BLOB()";
    }

    public boolean insertValuesOnInsert() {
        return false;
    }

    public Object getObject(Object rs, int param) {
        Object obj;
        block44: {
            obj = null;
            try {
                byte[] bytes = new byte[]{};
                Blob blob = ((ResultSet)rs).getBlob(param);
                bytes = blob.getBytes(1L, (int)blob.length());
                if (((ResultSet)rs).wasNull()) break block44;
                if (bytes.length < 1) {
                    return null;
                }
                try {
                    if (this.getJavaTypeMapping().isSerialised()) {
                        BlobImpl b = new BlobImpl(bytes);
                        obj = b.getObject();
                    } else if (this.getJavaTypeMapping().getType().equals((array$Z == null ? (array$Z = OracleBlobRDBMSMapping.class$("[Z")) : array$Z).getName())) {
                        obj = TypeConversionHelper.getBooleanArrayFromByteArray(bytes);
                    } else if (this.getJavaTypeMapping().getType().equals((array$B == null ? (array$B = OracleBlobRDBMSMapping.class$("[B")) : array$B).getName())) {
                        obj = bytes;
                    } else if (this.getJavaTypeMapping().getType().equals((array$C == null ? (array$C = OracleBlobRDBMSMapping.class$("[C")) : array$C).getName())) {
                        obj = TypeConversionHelper.getCharArrayFromByteArray(bytes);
                    } else if (this.getJavaTypeMapping().getType().equals((array$D == null ? (array$D = OracleBlobRDBMSMapping.class$("[D")) : array$D).getName())) {
                        obj = TypeConversionHelper.getDoubleArrayFromByteArray(bytes);
                    } else if (this.getJavaTypeMapping().getType().equals((array$F == null ? (array$F = OracleBlobRDBMSMapping.class$("[F")) : array$F).getName())) {
                        obj = TypeConversionHelper.getFloatArrayFromByteArray(bytes);
                    } else if (this.getJavaTypeMapping().getType().equals((array$I == null ? (array$I = OracleBlobRDBMSMapping.class$("[I")) : array$I).getName())) {
                        obj = TypeConversionHelper.getIntArrayFromByteArray(bytes);
                    } else if (this.getJavaTypeMapping().getType().equals((array$J == null ? (array$J = OracleBlobRDBMSMapping.class$("[J")) : array$J).getName())) {
                        obj = TypeConversionHelper.getLongArrayFromByteArray(bytes);
                    } else if (this.getJavaTypeMapping().getType().equals((array$S == null ? (array$S = OracleBlobRDBMSMapping.class$("[S")) : array$S).getName())) {
                        obj = TypeConversionHelper.getShortArrayFromByteArray(bytes);
                    } else if (this.getJavaTypeMapping().getType().equals((array$Ljava$lang$Boolean == null ? (array$Ljava$lang$Boolean = OracleBlobRDBMSMapping.class$("[Ljava.lang.Boolean;")) : array$Ljava$lang$Boolean).getName())) {
                        obj = TypeConversionHelper.getBooleanObjectArrayFromByteArray(bytes);
                    } else if (this.getJavaTypeMapping().getType().equals((array$Ljava$lang$Byte == null ? (array$Ljava$lang$Byte = OracleBlobRDBMSMapping.class$("[Ljava.lang.Byte;")) : array$Ljava$lang$Byte).getName())) {
                        obj = TypeConversionHelper.getByteObjectArrayFromByteArray(bytes);
                    } else if (this.getJavaTypeMapping().getType().equals((array$Ljava$lang$Character == null ? (array$Ljava$lang$Character = OracleBlobRDBMSMapping.class$("[Ljava.lang.Character;")) : array$Ljava$lang$Character).getName())) {
                        obj = TypeConversionHelper.getCharObjectArrayFromByteArray(bytes);
                    } else if (this.getJavaTypeMapping().getType().equals((array$Ljava$lang$Double == null ? (array$Ljava$lang$Double = OracleBlobRDBMSMapping.class$("[Ljava.lang.Double;")) : array$Ljava$lang$Double).getName())) {
                        obj = TypeConversionHelper.getDoubleObjectArrayFromByteArray(bytes);
                    } else if (this.getJavaTypeMapping().getType().equals((array$Ljava$lang$Float == null ? (array$Ljava$lang$Float = OracleBlobRDBMSMapping.class$("[Ljava.lang.Float;")) : array$Ljava$lang$Float).getName())) {
                        obj = TypeConversionHelper.getFloatObjectArrayFromByteArray(bytes);
                    } else if (this.getJavaTypeMapping().getType().equals((array$Ljava$lang$Integer == null ? (array$Ljava$lang$Integer = OracleBlobRDBMSMapping.class$("[Ljava.lang.Integer;")) : array$Ljava$lang$Integer).getName())) {
                        obj = TypeConversionHelper.getIntObjectArrayFromByteArray(bytes);
                    } else if (this.getJavaTypeMapping().getType().equals((array$Ljava$lang$Long == null ? (array$Ljava$lang$Long = OracleBlobRDBMSMapping.class$("[Ljava.lang.Long;")) : array$Ljava$lang$Long).getName())) {
                        obj = TypeConversionHelper.getLongObjectArrayFromByteArray(bytes);
                    } else if (this.getJavaTypeMapping().getType().equals((array$Ljava$lang$Short == null ? (array$Ljava$lang$Short = OracleBlobRDBMSMapping.class$("[Ljava.lang.Short;")) : array$Ljava$lang$Short).getName())) {
                        obj = TypeConversionHelper.getShortObjectArrayFromByteArray(bytes);
                    } else {
                        if (this.getJavaTypeMapping().getType().equals((array$Ljava$math$BigDecimal == null ? (array$Ljava$math$BigDecimal = OracleBlobRDBMSMapping.class$("[Ljava.math.BigDecimal;")) : array$Ljava$math$BigDecimal).getName())) {
                            return TypeConversionHelper.getBigDecimalArrayFromByteArray(bytes);
                        }
                        if (this.getJavaTypeMapping().getType().equals((array$Ljava$math$BigInteger == null ? (array$Ljava$math$BigInteger = OracleBlobRDBMSMapping.class$("[Ljava.math.BigInteger;")) : array$Ljava$math$BigInteger).getName())) {
                            return TypeConversionHelper.getBigIntegerArrayFromByteArray(bytes);
                        }
                        if (this.getJavaTypeMapping().getType().equals((class$java$util$BitSet == null ? (class$java$util$BitSet = OracleBlobRDBMSMapping.class$("java.util.BitSet")) : class$java$util$BitSet).getName())) {
                            return TypeConversionHelper.getBitSetFromBooleanArray((boolean[])TypeConversionHelper.getBooleanArrayFromByteArray(bytes));
                        }
                        obj = new ObjectInputStream(new ByteArrayInputStream(bytes)).readObject();
                    }
                }
                catch (StreamCorruptedException e) {
                    String msg = "StreamCorruptedException: object is corrupted";
                    JPOXLogger.RDBMS.error(msg);
                    throw new JPOXUserException(msg, e).setFatal();
                }
                catch (IOException e) {
                    String msg = "IOException: error when reading object";
                    JPOXLogger.RDBMS.error(msg);
                    throw new JPOXUserException(msg, e).setFatal();
                }
                catch (ClassNotFoundException e) {
                    String msg = "ClassNotFoundException: error when creating object";
                    JPOXLogger.RDBMS.error(msg);
                    throw new JPOXUserException(msg, e).setFatal();
                }
            }
            catch (SQLException sqle) {
                throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToGetParam", "Object", "" + param, this.column, sqle.getMessage()), sqle);
            }
        }
        return obj;
    }

    public TypeInfo getTypeInfo() {
        return this.getDatabaseAdapter().getTypeInfo(2004);
    }

    public String getUpdateInputParameter() {
        return "EMPTY_BLOB()";
    }

    public boolean includeInSQLFetchStatement() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateBlobColumn(StateManager sm, DatastoreContainerObject datastoreContainer, DatastoreMapping mapping, byte[] bytes) {
        StateManager[] embeddedOwners;
        RDBMSFetchStatement fetchStmt = new RDBMSFetchStatement(datastoreContainer);
        fetchStmt.select(mapping.getDatastoreField());
        JavaTypeMapping idMapping = datastoreContainer.getIDMapping();
        for (int i = 0; i < idMapping.getNumberOfDatastoreFields(); ++i) {
            fetchStmt.andCondition(fetchStmt.referenceDatastoreField(idMapping.getDataStoreMapping(i).getDatastoreField()) + " = ?");
        }
        String textStmt = fetchStmt.toString(true);
        if (sm.getPcObjectType() != 0 && (embeddedOwners = sm.getEmbeddedOwners()) != null) {
            sm = embeddedOwners[0];
        }
        try {
            ObjectManager om = sm.getObjectManager();
            RDBMSManager storeMgr = (RDBMSManager)om.getStoreManager();
            ManagedConnection mconn = storeMgr.getConnection(om);
            Connection conn = (Connection)mconn.getConnection();
            SQLController sqlControl = storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForQuery(conn, textStmt);
                try {
                    PersistenceCapable pcObject = sm.getObject();
                    idMapping.setObject(om, ps, Mappings.getParametersIndex(1, idMapping), pcObject);
                    ResultSet rs = sqlControl.executeStatementQuery(conn, textStmt, ps);
                    try {
                        if (!rs.next()) {
                            throw new JPOXObjectNotFoundException("No such database row", sm.getInternalObjectId());
                        }
                        int jdbcMajorVersion = ((DatabaseAdapter)datastoreContainer.getStoreManager().getDatastoreAdapter()).getDriverMajorVersion();
                        if (jdbcMajorVersion < 10) {
                            BLOB blob = (BLOB)rs.getBlob(1);
                            if (blob != null) {
                                blob.putBytes(1L, bytes);
                            }
                        } else {
                            Blob blob = rs.getBlob(1);
                            if (blob != null) {
                                blob.setBytes(1L, bytes);
                            }
                        }
                    }
                    finally {
                        rs.close();
                    }
                }
                finally {
                    sqlControl.closeStatement(conn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new JPOXDataStoreException("Update of BLOB value failed: " + textStmt, e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

