/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.poid;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import org.jpox.store.poid.PoidBlock;
import org.jpox.store.poid.PoidException;
import org.jpox.store.rdbms.RDBMSManager;
import org.jpox.store.rdbms.SQLController;
import org.jpox.store.rdbms.adapter.RDBMSAdapter;
import org.jpox.store.rdbms.poid.AbstractRDBMSPoidGenerator;
import org.jpox.util.Localiser;

public final class DatastoreUUIDHexPoidGenerator
extends AbstractRDBMSPoidGenerator {
    protected static final Localiser LOCALISER_RDBMS = Localiser.getInstance("org.jpox.store.rdbms.Localisation");
    static /* synthetic */ Class class$java$lang$String;

    public DatastoreUUIDHexPoidGenerator(String name, Properties props) {
        super(name, props);
        this.allocationSize = 10;
        if (this.properties != null && this.properties.get("key-cache-size") != null) {
            try {
                this.allocationSize = Integer.parseInt((String)this.properties.get("key-cache-size"));
            }
            catch (Exception e) {
                throw new PoidException(LOCALISER.msg("PoidGenerator.InvalidKeyCacheSize", this.properties.get("key-cache-size")));
            }
        }
    }

    public static Class getStorageClass() {
        return class$java$lang$String == null ? (class$java$lang$String = DatastoreUUIDHexPoidGenerator.class$("java.lang.String")) : class$java$lang$String;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized PoidBlock reserveBlock(long size) {
        PoidBlock poidBlock;
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<String> oid = new ArrayList<String>();
        SQLController sqlControl = ((RDBMSManager)this.storeMgr).getSQLController();
        try {
            RDBMSAdapter dba = (RDBMSAdapter)this.storeMgr.getDatastoreAdapter();
            String stmt = dba.getSelectNewUUIDStmt();
            ps = sqlControl.getStatementForQuery(this.connection, stmt);
            int i = 1;
            while ((long)i < size) {
                rs = sqlControl.executeStatementQuery(this.connection, stmt, ps);
                if (rs.next()) {
                    String nextId = rs.getString(1);
                    oid.add(nextId);
                }
                ++i;
            }
            poidBlock = new PoidBlock(oid);
        }
        catch (SQLException e) {
            try {
                throw new PoidException(LOCALISER.msg("PoidGenerator.IDAllocationError", e.getMessage()));
            }
            catch (Throwable throwable) {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (ps == null) throw throwable;
                    sqlControl.closeStatement(this.connection, ps);
                    throw throwable;
                }
                catch (SQLException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            if (rs != null) {
                rs.close();
            }
            if (ps == null) return poidBlock;
            sqlControl.closeStatement(this.connection, ps);
            return poidBlock;
        }
        catch (SQLException e) {
            // empty catch block
        }
        return poidBlock;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

