/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.poid;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import org.jpox.store.DatastoreClass;
import org.jpox.store.poid.PoidBlock;
import org.jpox.store.poid.PoidException;
import org.jpox.store.rdbms.RDBMSManager;
import org.jpox.store.rdbms.adapter.RDBMSAdapter;
import org.jpox.store.rdbms.poid.AbstractRDBMSPoidGenerator;
import org.jpox.store.rdbms.sqlidentifier.SQLIdentifier;
import org.jpox.store.rdbms.table.SequenceTable;

public final class TablePoidGenerator
extends AbstractRDBMSPoidGenerator {
    private SequenceTable sequenceTable = null;
    private final String sequenceName;
    private static final String DEFAULT_TABLE_NAME = "SEQUENCE_TABLE";

    public TablePoidGenerator(String name, Properties props) {
        super(name, props);
        this.allocationSize = 5;
        if (this.properties != null) {
            if (this.properties.get("key-cache-size") != null) {
                try {
                    this.allocationSize = Integer.parseInt((String)this.properties.get("key-cache-size"));
                }
                catch (Exception e) {
                    throw new PoidException(LOCALISER.msg("SequencePoidGenerator.InvalidKeyCacheSize", this.properties.get("key-cache-size")));
                }
            }
            if (this.properties.get("key-initial-size") != null) {
                try {
                    this.initialValue = new Integer(this.properties.getProperty("key-initial-value"));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        this.sequenceName = this.properties.getProperty("sequence-name") != null ? this.properties.getProperty("sequence-name") : (this.properties.getProperty("sequence-table-basis") != null && this.properties.getProperty("sequence-table-basis").equalsIgnoreCase("table") ? this.properties.getProperty("table-name") : this.properties.getProperty("root-class-name"));
    }

    public PoidBlock reserveBlock(long size) {
        if (size < 1L) {
            return null;
        }
        ArrayList<Long> oid = new ArrayList<Long>();
        try {
            if (this.sequenceTable == null) {
                this.initialiseSequenceTable();
            }
            SQLIdentifier sourceTableIdentifier = null;
            if (this.properties.getProperty("table-name") != null) {
                sourceTableIdentifier = (SQLIdentifier)this.storeMgr.getIdentifierFactory().newDatastoreContainerIdentifier(this.properties.getProperty("table-name"));
            }
            Long nextId = this.sequenceTable.getNextVal(this.sequenceName, this.connection, (int)size, sourceTableIdentifier, this.properties.getProperty("column-name"), this.initialValue);
            int i = 0;
            while ((long)i < size) {
                oid.add(nextId);
                nextId = new Long(nextId + 1L);
                ++i;
            }
            return new PoidBlock(oid);
        }
        catch (SQLException e) {
            throw new PoidException(LOCALISER_RDBMS.msg("SequencePoidGenerator.CantObtainSequenceId", e.getMessage()));
        }
    }

    protected boolean requiresRepository() {
        return true;
    }

    protected boolean createRepository() {
        try {
            if (this.sequenceTable == null) {
                this.initialiseSequenceTable();
            }
            this.sequenceTable.exists(this.connection, true);
            return true;
        }
        catch (SQLException e) {
            throw new PoidException(e.toString());
        }
    }

    protected void initialiseSequenceTable() {
        DatastoreClass table;
        String schemaName;
        String catalogName = this.properties.getProperty("sequence-catalog-name");
        if (catalogName == null) {
            catalogName = this.properties.getProperty("catalog-name");
        }
        if ((schemaName = this.properties.getProperty("sequence-schema-name")) == null) {
            schemaName = this.properties.getProperty("schema-name");
        }
        String tableName = this.properties.getProperty("sequence-table-name") == null ? DEFAULT_TABLE_NAME : this.properties.getProperty("sequence-table-name");
        SQLIdentifier identifier = (SQLIdentifier)this.storeMgr.getIdentifierFactory().newDatastoreContainerIdentifier(tableName);
        if (((RDBMSAdapter)this.storeMgr.getDatastoreAdapter()).supportsCatalogsInTableDefinitions() && catalogName != null) {
            identifier.setCatalogName(catalogName);
        }
        if (((RDBMSAdapter)this.storeMgr.getDatastoreAdapter()).supportsSchemasInTableDefinitions() && schemaName != null) {
            identifier.setSchemaName(schemaName);
        }
        if ((table = this.storeMgr.getDatastoreClass(identifier)) != null) {
            this.sequenceTable = (SequenceTable)((Object)table);
        } else {
            String sequenceNameColumnName = "SEQUENCE_NAME";
            String nextValColumnName = "NEXT_VAL";
            if (this.properties.getProperty("sequence-name-column-name") != null) {
                sequenceNameColumnName = this.properties.getProperty("sequence-name-column-name");
            }
            if (this.properties.getProperty("sequence-nextval-column-name") != null) {
                nextValColumnName = this.properties.getProperty("sequence-nextval-column-name");
            }
            this.sequenceTable = new SequenceTable(identifier, (RDBMSManager)this.storeMgr, sequenceNameColumnName, nextValColumnName);
            this.sequenceTable.initialize(this.storeMgr.getOMFContext().getClassLoaderResolver(null));
            this.storeMgr.addDatastoreContainer(this.sequenceTable);
        }
    }
}

