/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.query;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.jdo.spi.PersistenceCapable;
import org.jpox.ObjectManager;
import org.jpox.ObjectManagerHelper;
import org.jpox.exceptions.JPOXException;
import org.jpox.exceptions.JPOXUserException;
import org.jpox.store.Extent;
import org.jpox.store.exceptions.NoSuchPersistentFieldException;
import org.jpox.store.expression.AggregateExpression;
import org.jpox.store.expression.ArrayExpression;
import org.jpox.store.expression.BooleanExpression;
import org.jpox.store.expression.ClassExpression;
import org.jpox.store.expression.CollectionExpression;
import org.jpox.store.expression.Literal;
import org.jpox.store.expression.MapExpression;
import org.jpox.store.expression.NewObjectExpression;
import org.jpox.store.expression.NullLiteral;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.expression.UnboundVariable;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.query.AbstractJDOQLQuery;
import org.jpox.store.query.CollectionCandidates;
import org.jpox.store.query.Evaluator;
import org.jpox.store.query.JDOQLResultSetMetaData;
import org.jpox.store.query.JDOQLSingleStringParser;
import org.jpox.store.query.Parser;
import org.jpox.store.query.Query;
import org.jpox.store.query.QueryResult;
import org.jpox.store.query.QueryUtils;
import org.jpox.store.query.Queryable;
import org.jpox.store.query.ResultObjectFactory;
import org.jpox.store.rdbms.adapter.RDBMSAdapter;
import org.jpox.store.rdbms.query.PersistentIDROF;
import org.jpox.store.rdbms.query.ResultExpressionsQueryable;
import org.jpox.store.rdbms.query.SQLEvaluator;
import org.jpox.util.ClassUtils;
import org.jpox.util.Imports;
import org.jpox.util.JPOXLogger;

public class JDOQLQuery
extends AbstractJDOQLQuery {
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$jpox$store$expression$QueryExpression;

    public JDOQLQuery(ObjectManager om) {
        this(om, (JDOQLQuery)null);
    }

    public JDOQLQuery(ObjectManager om, JDOQLQuery q) {
        super(om);
        this.registerScalarExpressions(om.getOMFContext().getPluginManager(), om.getClassLoaderResolver());
        if (q == null) {
            this.candidateClass = null;
            this.candidateClassName = null;
            this.filter = null;
            this.imports = null;
            this.variables = null;
            this.parameters = null;
            this.grouping = null;
            this.ordering = null;
            this.result = null;
            this.resultClass = null;
            this.resultClassName = null;
            this.range = null;
            this.fromInclNo = 0L;
            this.toExclNo = Long.MAX_VALUE;
        } else {
            this.candidateClass = q.candidateClass;
            this.candidateClassName = q.candidateClassName;
            this.filter = q.filter;
            this.imports = q.imports;
            this.variables = q.variables;
            this.parameters = q.parameters;
            this.grouping = q.grouping;
            this.ordering = q.ordering;
            this.result = q.result;
            this.resultClass = q.resultClass;
            this.resultClassName = q.resultClassName;
            this.range = q.range;
            this.fromInclNo = q.fromInclNo;
            this.toExclNo = q.toExclNo;
            this.ignoreCache = q.ignoreCache;
        }
    }

    public JDOQLQuery(ObjectManager om, String query) {
        super(om);
        this.registerScalarExpressions(om.getOMFContext().getPluginManager(), om.getClassLoaderResolver());
        new JDOQLSingleStringParser(this, query).parse();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return obj instanceof JDOQLQuery && this.equals(obj);
    }

    public void compile() {
        if (JPOXLogger.QUERY.isDebugEnabled()) {
            JPOXLogger.QUERY.debug(LOCALISER.msg("JDOQL.Statement.Precompile", this.getSingleStringQuery()));
        }
        super.compile();
        Iterator it = userDefinedScalarExpressions.keySet().iterator();
        while (it.hasNext()) {
            this.parsedImports.importPackage((String)it.next());
        }
        if (this.isPreCompile) {
            new Compiler(null).preCompile();
        }
        this.isCompiled = true;
    }

    protected boolean shouldReturnSingleRow() {
        if (this.unique) {
            return true;
        }
        if (this.grouping != null) {
            return false;
        }
        if (this.candidates instanceof ResultExpressionsQueryable) {
            return ((ResultExpressionsQueryable)this.candidates).hasAggregatedExpressionsOnly();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Collection performExecute(Map parameters) {
        this.isPreCompile = false;
        this.discardCompiled();
        try {
            if (JPOXLogger.QUERY.isDebugEnabled()) {
                JPOXLogger.QUERY.debug(LOCALISER.msg("JDOQL.Statement.Summary", this.getSingleStringQuery()));
            }
            long startTime = System.currentTimeMillis();
            AbstractJDOQLQuery.ExecutedCompileCache cache = (AbstractJDOQLQuery.ExecutedCompileCache)compiledCache.get(this.getSingleStringQuery());
            if (cache == null || this.candidateCollection != null) {
                super.compile();
                Iterator it = userDefinedScalarExpressions.keySet().iterator();
                while (it.hasNext()) {
                    this.parsedImports.importPackage((String)it.next());
                }
                Compiler c = new Compiler(parameters);
                this.queryStmt = c.executionCompile();
                if (this.candidateCollection != null) {
                    // empty if block
                }
            } else {
                this.candidates = cache.getCandidates();
                this.queryStmt = cache.getQueryExpression();
                this.parameterNames = cache.getParameterNames();
                this.queryStmt.reset();
            }
            if (this.candidates instanceof CollectionCandidates) {
                ((CollectionCandidates)this.candidates).getFetchPlan().setGroups((Collection)this.fetchPlan.getGroups());
            } else if (this.candidates instanceof Extent) {
                ((Extent)((Object)this.candidates)).getFetchPlan().setGroups((Collection)this.fetchPlan.getGroups());
            }
            boolean useFetchPlan = this.om.getOMFContext().getPersistenceConfiguration().getQueryUseFetchPlan();
            if (this.extensions != null && this.extensions.containsKey("org.jpox.query.useFetchPlan")) {
                useFetchPlan = Boolean.valueOf((String)this.extensions.get("org.jpox.query.useFetchPlan"));
            }
            this.rof = this.candidates.newResultObjectFactory(this.queryStmt, this.getIgnoreCache(), this.resultClass, useFetchPlan);
            if (this.rof instanceof PersistentIDROF) {
                ((PersistentIDROF)this.rof).setPersistentClass(this.candidateClass);
            }
            if (JPOXLogger.QUERY.isDebugEnabled()) {
                JPOXLogger.QUERY.debug(LOCALISER.msg("JDOQL.Statement.CompileTime", "" + (System.currentTimeMillis() - startTime), this.rof));
            }
            this.isCompiled = true;
        }
        finally {
            if (!this.isCompiled) {
                this.discardCompiled();
            }
        }
        if (this.candidates.isEmpty()) {
            return new ArrayList();
        }
        this.isPreCompile = true;
        Evaluator eval = this.getEvaluator(this.om, this.extensions, this.toExclNo, this.distinct, this, this.rof, this.candidateCollection);
        QueryResult qr = eval.evaluate(this.queryStmt);
        this.om.addQueryRun(this.toString());
        this.queryResults.add(qr);
        return qr;
    }

    protected Evaluator getEvaluator(ObjectManager om, Map extensions, long toExclNo, boolean distinct, Query query, ResultObjectFactory rof, Collection candidateCollection) {
        return new SQLEvaluator(om, extensions, toExclNo, distinct, this, rof, candidateCollection);
    }

    protected boolean applyRangeChecks() {
        boolean range_specified;
        boolean bl = range_specified = this.fromInclNo >= 0L && this.toExclNo >= 0L && (this.fromInclNo != 0L || this.toExclNo != Long.MAX_VALUE);
        if (!range_specified) {
            return false;
        }
        RDBMSAdapter rdba = (RDBMSAdapter)this.dba;
        boolean using_limit_select_clause = rdba.getRangeByLimitSelectClause(this.fromInclNo, this.toExclNo).length() > 0;
        boolean using_limit_where_clause = rdba.getRangeByLimitWhereClause(this.fromInclNo, this.toExclNo).length() > 0;
        boolean using_rownum = rdba.getRangeByRowNumberColumn().length() > 0;
        boolean applyRangeChecks = range_specified && !using_limit_select_clause && !using_limit_where_clause && !using_rownum;
        return applyRangeChecks;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class Compiler
    implements UnboundVariable.VariableBinder {
        private final Map parameters;
        private final Map expressionsByVariableName = new HashMap();
        private QueryExpression qs = null;
        private Parser p = null;
        private boolean explicitParameters = false;
        private int implicitParamNo = 0;
        private boolean explicitVariables = false;
        private List fieldExpressions = new ArrayList();

        public Compiler(Map parameters) {
            if (JDOQLQuery.this.variables != null && JDOQLQuery.this.variables.length() > 0) {
                this.explicitVariables = true;
            }
            if (JDOQLQuery.this.parameters != null && JDOQLQuery.this.parameters.length() > 0) {
                this.explicitParameters = true;
                if (parameters != null) {
                    if (parameters.size() != JDOQLQuery.this.parameterNames.size()) {
                        throw new JPOXUserException(LOCALISER.msg("JDOQL.IncorrectNumberOfParametersError", "" + JDOQLQuery.this.parameterNames.size(), "" + parameters.size()));
                    }
                    Iterator it = JDOQLQuery.this.parameterTypesByName.entrySet().iterator();
                    while (it.hasNext()) {
                        PersistenceCapable pc;
                        Map.Entry entry = it.next();
                        Object key = entry.getKey();
                        Object value = parameters.get(key);
                        if (value == null) {
                            if (!((Class)entry.getValue()).isPrimitive()) continue;
                            throw new JPOXUserException(LOCALISER.msg("Query.InvalidNullArgumentForPrimitiveParameter", entry.getKey(), ((Class)entry.getValue()).getName()));
                        }
                        if (!(value instanceof PersistenceCapable) || (pc = (PersistenceCapable)value).jdoGetPersistenceManager() == null || JDOQLQuery.this.om == ObjectManagerHelper.getObjectManager(pc)) continue;
                        throw new JPOXUserException(LOCALISER.msg("JDOQL.ParameterBoundToDifferentPM", key));
                    }
                }
            } else if (parameters != null) {
                Iterator parameterEntryIter = parameters.entrySet().iterator();
                while (parameterEntryIter.hasNext()) {
                    PersistenceCapable pc;
                    Map.Entry entry = parameterEntryIter.next();
                    Object value = entry.getValue();
                    if (value == null || !(value instanceof PersistenceCapable) || (pc = (PersistenceCapable)value).jdoGetPersistenceManager() == null || JDOQLQuery.this.om == ObjectManagerHelper.getObjectManager(pc)) continue;
                    throw new JPOXUserException(LOCALISER.msg("JDOQL.ParameterBoundToDifferentPM", pc));
                }
            }
            this.parameters = parameters;
        }

        public void preCompile() {
            this.compileCandidates();
            this.qs = JDOQLQuery.this.candidates.newQueryStatement(JDOQLQuery.this.candidateClass);
            this.performCompile(this.qs);
        }

        public QueryExpression executionCompile() {
            this.compileCandidates();
            this.qs = JDOQLQuery.this.candidates.newQueryStatement(JDOQLQuery.this.candidateClass);
            boolean useInner = JDOQLQuery.this.om.getOMFContext().getPersistenceConfiguration().getQueryUseInnerJoinsOnly();
            if (JDOQLQuery.this.extensions != null && JDOQLQuery.this.extensions.containsKey("org.jpox.rdbms.jdoql.useInnerJoinsOnly")) {
                useInner = Boolean.valueOf((String)JDOQLQuery.this.extensions.get("org.jpox.rdbms.jdoql.useInnerJoinsOnly"));
            }
            if (useInner) {
                this.qs.setUseInnerJoinsOnly(true);
            }
            this.performCompile(this.qs);
            return this.qs;
        }

        private void performCompile(QueryExpression qs) {
            this.fieldExpressions.clear();
            this.compileResult(qs);
            ScalarExpression[] resultFieldExprs = this.fieldExpressions.toArray(new ScalarExpression[this.fieldExpressions.size()]);
            for (int i = 0; i < resultFieldExprs.length; ++i) {
                if (resultFieldExprs[i].getLogicSetExpression() == null && resultFieldExprs[i] instanceof UnboundVariable) {
                    throw new JPOXUserException(LOCALISER.msg("JDOQL.SpecifiedFieldNotFound", ((UnboundVariable)resultFieldExprs[i]).getVariableName()));
                }
                qs.crossJoin(resultFieldExprs[i].getLogicSetExpression(), true);
            }
            this.compileFilter(qs);
            ScalarExpression[] groupingFieldExprs = null;
            ScalarExpression[] havingFieldExprs = null;
            if (JDOQLQuery.this.grouping != null && JDOQLQuery.this.grouping.length() > 0) {
                String groupingClause = null;
                String havingClause = null;
                if (JDOQLQuery.this.grouping.indexOf("HAVING") >= 0) {
                    havingClause = JDOQLQuery.this.grouping.substring(JDOQLQuery.this.grouping.indexOf("HAVING") + 7);
                    groupingClause = JDOQLQuery.this.grouping.substring(0, JDOQLQuery.this.grouping.indexOf("HAVING") - 1);
                } else if (JDOQLQuery.this.grouping.indexOf("having") >= 0) {
                    havingClause = JDOQLQuery.this.grouping.substring(JDOQLQuery.this.grouping.indexOf("having") + 7);
                    groupingClause = JDOQLQuery.this.grouping.substring(0, JDOQLQuery.this.grouping.indexOf("having") - 1);
                } else {
                    groupingClause = JDOQLQuery.this.grouping;
                }
                this.fieldExpressions.clear();
                this.compileGrouping(qs, groupingClause);
                groupingFieldExprs = this.fieldExpressions.toArray(new ScalarExpression[this.fieldExpressions.size()]);
                this.fieldExpressions.clear();
                this.compileHaving(qs, havingClause);
                havingFieldExprs = this.fieldExpressions.toArray(new ScalarExpression[this.fieldExpressions.size()]);
            }
            this.fieldExpressions.clear();
            this.compileOrdering(qs);
            ScalarExpression[] orderingFieldExprs = this.fieldExpressions.toArray(new ScalarExpression[this.fieldExpressions.size()]);
            if (groupingFieldExprs != null) {
                this.checkExpressionsAgainstGrouping(orderingFieldExprs, groupingFieldExprs, "JDOQL.FieldInOrderingNotSpecifiedInGrouping");
                this.checkExpressionsAgainstGrouping(havingFieldExprs, groupingFieldExprs, "JDOQL.FieldInHavingNotSpecifiedInGrouping");
                this.checkExpressionsAgainstGrouping(resultFieldExprs, groupingFieldExprs, "JDOQL.FieldInResultNotSpecifiedInGrouping");
            }
            this.compileRange(qs);
            this.checkVariableBinding();
        }

        private void checkExpressionsAgainstGrouping(ScalarExpression[] exprs, ScalarExpression[] groupExprs, String localiserErrorString) {
            if (exprs == null) {
                return;
            }
            for (int i = 0; i < exprs.length; ++i) {
                boolean exists = false;
                for (int j = 0; j < groupExprs.length; ++j) {
                    if (!exprs[i].equals(groupExprs[j])) continue;
                    exists = true;
                    break;
                }
                if (exprs[i] instanceof AggregateExpression || exists) continue;
                throw new JPOXUserException(LOCALISER.msg(localiserErrorString, exprs[i]));
            }
        }

        public void bindVariable(String name, ScalarExpression expr) {
            ScalarExpression previousExpr = this.expressionsByVariableName.put(name, expr);
            if (previousExpr != null) {
                throw new JPOXException(LOCALISER.msg("JDOQL.VariableBindError", name, expr, previousExpr)).setFatal();
            }
        }

        private void checkVariableBinding() {
            for (int i = 0; i < JDOQLQuery.this.variableNames.size(); ++i) {
                String variableName = (String)JDOQLQuery.this.variableNames.get(i);
                if (this.expressionsByVariableName.get(variableName) != null) continue;
                boolean foundInResult = false;
                if (JDOQLQuery.this.candidates instanceof ResultExpressionsQueryable) {
                    ScalarExpression[] exprs = ((ResultExpressionsQueryable)JDOQLQuery.this.candidates).getResultExpressions();
                    for (int j = 0; j < exprs.length; ++j) {
                        if (!(exprs[j] instanceof UnboundVariable) || !((UnboundVariable)exprs[j]).getVariableName().equals(variableName)) continue;
                        foundInResult = true;
                    }
                }
                if (foundInResult) continue;
                throw new JPOXUserException(LOCALISER.msg("JDOQL.VariableNotBoundError", variableName));
            }
        }

        private void compileCandidates() {
            if (JDOQLQuery.this.candidateClass == null && JDOQLQuery.this.candidateClassName != null) {
                try {
                    JDOQLQuery.this.candidateClass = JDOQLQuery.this.om.getClassLoaderResolver().classForName(JDOQLQuery.this.candidateClassName, true);
                }
                catch (JPOXException jpe) {
                    JDOQLQuery.this.candidateClass = JDOQLQuery.this.resolveClassDeclaration(JDOQLQuery.this.candidateClassName);
                }
            }
            if (JDOQLQuery.this.candidateExtent != null) {
                JDOQLQuery.this.candidates = (Queryable)((Object)JDOQLQuery.this.candidateExtent);
            } else if (JDOQLQuery.this.candidateCollection != null) {
                JDOQLQuery.this.candidates = new CollectionCandidates(JDOQLQuery.this.om, JDOQLQuery.this.candidateClass, JDOQLQuery.this.candidateCollection);
            } else {
                if (JDOQLQuery.this.candidateClass == null) {
                    throw new JPOXUserException(LOCALISER.msg("JDOQL.NoCandidateClassError"));
                }
                JDOQLQuery.this.candidates = (Queryable)((Object)JDOQLQuery.this.om.getExtent(JDOQLQuery.this.candidateClass, JDOQLQuery.this.subclasses));
            }
            JDOQLQuery.this.distinct = false;
            if (JDOQLQuery.this.result != null) {
                if (JDOQLQuery.this.candidateCollection != null) {
                    JDOQLQuery.this.candidates = new ResultExpressionsQueryable(JDOQLQuery.this.om, JDOQLQuery.this.candidateClass, ((CollectionCandidates)JDOQLQuery.this.candidates).getUserCandidates(), JDOQLQuery.this.subclasses);
                } else {
                    JDOQLQuery.this.candidates = new ResultExpressionsQueryable(JDOQLQuery.this.om, JDOQLQuery.this.candidateClass, JDOQLQuery.this.subclasses);
                }
                if (JDOQLQuery.this.result != null && JDOQLQuery.this.result.toLowerCase().startsWith("distinct")) {
                    JDOQLQuery.this.distinct = true;
                }
            }
        }

        private void compileResult(QueryExpression qs) {
            int i;
            ScalarExpression[] resultExprs = null;
            JDOQLQuery.this.distinct = false;
            if (JDOQLQuery.this.result != null) {
                String resultDefinition = JDOQLQuery.this.result;
                if (JDOQLQuery.this.result != null && JDOQLQuery.this.result.toLowerCase().startsWith("distinct")) {
                    if (qs != null) {
                        qs.setDistinctResults(true);
                    }
                    resultDefinition = JDOQLQuery.this.result.substring(8);
                    JDOQLQuery.this.distinct = true;
                }
                resultExprs = this.compileExpressionsFromString(resultDefinition, JDOQLQuery.this.parsedImports);
                Class[] resultTypes = new Class[resultExprs.length];
                for (i = 0; i < resultExprs.length; ++i) {
                    if (resultExprs[i] instanceof CollectionExpression) {
                        throw new JPOXUserException(resultExprs[i].toStatementText(ScalarExpression.PROJECTION) + " is of type java.util.Collection and cannot be in the result.");
                    }
                    if (resultExprs[i] instanceof MapExpression) {
                        throw new JPOXUserException(resultExprs[i].toStatementText(ScalarExpression.PROJECTION) + " is of type java.util.Map and cannot be in the result.");
                    }
                    if (resultExprs[i].getMapping() == null) continue;
                    resultTypes[i] = resultExprs[i].getMapping().getType() != null ? JDOQLQuery.this.resolveClassDeclaration(resultExprs[i].getMapping().getType()) : resultExprs[i].getMapping().getJavaType();
                }
                ((ResultExpressionsQueryable)JDOQLQuery.this.candidates).setResultExpressions(resultExprs);
                JDOQLQuery.this.resultMetaData = new JDOQLResultSetMetaData(resultTypes);
            } else {
                JDOQLQuery.this.resultMetaData = new JDOQLResultSetMetaData(new Class[]{JDOQLQuery.this.candidateClass});
            }
            if (JDOQLQuery.this.resultClass == null && JDOQLQuery.this.resultClassName != null) {
                ScalarExpression expr = this.compileExpressionFromString(JDOQLQuery.this.resultClassName, JDOQLQuery.this.parsedImports);
                JDOQLQuery.this.resultClass = ((ClassExpression)expr).getCls();
            }
            if (JDOQLQuery.this.resultClass != null && resultExprs != null) {
                if (QueryUtils.resultClassIsSimple(JDOQLQuery.this.resultClass.getName())) {
                    Class resultClassPrimitive;
                    if (resultExprs.length > 1) {
                        throw new JPOXUserException(LOCALISER.msg("Query.ResultClassSimpleButMultipleFields", JDOQLQuery.this.resultClass.getName()));
                    }
                    Class exprType = resultExprs[0].getMapping().getJavaType();
                    boolean typeConsistent = false;
                    if (exprType == JDOQLQuery.this.resultClass) {
                        typeConsistent = true;
                    } else if (exprType.isPrimitive() && (resultClassPrimitive = ClassUtils.getPrimitiveTypeForType(JDOQLQuery.this.resultClass)) == exprType) {
                        typeConsistent = true;
                    }
                    if (!typeConsistent) {
                        throw new JPOXUserException(LOCALISER.msg("Query.ResultClassSimpleButWrongType", JDOQLQuery.this.resultClass.getName(), exprType));
                    }
                } else if (QueryUtils.resultClassIsUserType(JDOQLQuery.this.resultClass.getName())) {
                    Class[] ctrTypes = new Class[resultExprs.length];
                    for (int i2 = 0; i2 < ctrTypes.length; ++i2) {
                        ctrTypes[i2] = resultExprs[i2].getMapping().getJavaType();
                    }
                    Constructor ctr = ClassUtils.getConstructorWithArguments(JDOQLQuery.this.resultClass, ctrTypes);
                    if (ctr == null && !ClassUtils.hasDefaultConstructor(JDOQLQuery.this.resultClass)) {
                        throw new JPOXUserException(LOCALISER.msg("Query.ResultClassNotCreatable", JDOQLQuery.this.resultClass.getName()));
                    }
                    if (ctr == null) {
                        for (i = 0; i < resultExprs.length; ++i) {
                            Method putMethod;
                            Method setMethod;
                            String fieldName = resultExprs[i].getAlias();
                            Class fieldType = resultExprs[i].getMapping().getJavaType();
                            if (fieldName == null && resultExprs[i].getMapping().getFieldMetaData() != null) {
                                fieldName = resultExprs[i].getMapping().getFieldMetaData().getName();
                            }
                            if (fieldName == null) continue;
                            Class<?> resultFieldType = null;
                            boolean publicField = true;
                            try {
                                Field fld = JDOQLQuery.this.resultClass.getDeclaredField(fieldName);
                                resultFieldType = fld.getType();
                                if (!ClassUtils.typesAreCompatible(fieldType, resultFieldType) && !ClassUtils.typesAreCompatible(resultFieldType, fieldType)) {
                                    throw new JPOXUserException(LOCALISER.msg("JDOQL.ResultClassFieldTypeMismatch", fieldName, fieldType.getName(), resultFieldType.getName()));
                                }
                                if (!Modifier.isPublic(fld.getModifiers())) {
                                    publicField = false;
                                }
                            }
                            catch (NoSuchFieldException nsfe) {
                                publicField = false;
                            }
                            if (publicField || (setMethod = QueryUtils.getPublicSetMethodForFieldOfResultClass(JDOQLQuery.this.resultClass, fieldName, resultFieldType)) != null || (putMethod = QueryUtils.getPublicPutMethodForResultClass(JDOQLQuery.this.resultClass)) != null) continue;
                            throw new JPOXUserException(LOCALISER.msg("JDOQL.ResultClassFieldSetterNotFound", JDOQLQuery.this.resultClass.getName(), fieldName));
                        }
                    }
                }
            }
        }

        private void compileFilter(QueryExpression qs) {
            if (JDOQLQuery.this.filter != null && JDOQLQuery.this.filter.length() > 0) {
                ScalarExpression expr = this.compileExpressionFromString(JDOQLQuery.this.filter, JDOQLQuery.this.parsedImports);
                if (!(expr instanceof BooleanExpression)) {
                    throw new JPOXUserException(LOCALISER.msg("JDOQL.FilterExpressionNotBooleanError", JDOQLQuery.this.filter));
                }
                if (qs != null) {
                    qs.andCondition((BooleanExpression)expr, true);
                }
            }
        }

        private void compileOrdering(QueryExpression qs) {
            if (JDOQLQuery.this.ordering != null && JDOQLQuery.this.ordering.length() > 0) {
                StringTokenizer t1 = new StringTokenizer(JDOQLQuery.this.ordering, ",");
                int n = t1.countTokens();
                ScalarExpression[] orderExprs = new ScalarExpression[n];
                boolean[] descending = new boolean[n];
                n = 0;
                while (t1.hasMoreTokens()) {
                    String orderExpression = t1.nextToken().trim();
                    if (orderExpression.endsWith("ascending") || orderExpression.endsWith("ASCENDING")) {
                        descending[n] = false;
                        orderExpression = orderExpression.substring(0, orderExpression.length() - "ascending".length());
                    } else if (orderExpression.endsWith("asc") || orderExpression.endsWith("ASC")) {
                        descending[n] = false;
                        orderExpression = orderExpression.substring(0, orderExpression.length() - "asc".length());
                    } else if (orderExpression.endsWith("descending") || orderExpression.endsWith("DESCENDING")) {
                        descending[n] = true;
                        orderExpression = orderExpression.substring(0, orderExpression.length() - "descending".length());
                    } else if (orderExpression.endsWith("desc") || orderExpression.endsWith("DESC")) {
                        descending[n] = true;
                        orderExpression = orderExpression.substring(0, orderExpression.length() - "desc".length());
                    } else {
                        throw new JPOXUserException(LOCALISER.msg("JDOQL.InvalidOrderDirectionError", JDOQLQuery.this.ordering));
                    }
                    orderExprs[n] = this.compileExpressionFromString(orderExpression, JDOQLQuery.this.parsedImports);
                    ++n;
                }
                if (qs != null) {
                    qs.setOrdering(orderExprs, descending);
                }
            }
        }

        private void compileGrouping(QueryExpression qs, String groupingClause) {
            ScalarExpression[] groupExprs;
            if (groupingClause != null && (groupExprs = this.compileExpressionsFromString(groupingClause, JDOQLQuery.this.parsedImports)) != null && qs != null) {
                for (int i = 0; i < groupExprs.length; ++i) {
                    qs.addGroupingExpression(groupExprs[i]);
                }
            }
        }

        private void compileHaving(QueryExpression qs, String havingClause) {
            if (havingClause != null) {
                ScalarExpression havingExpr = this.compileExpressionFromString(havingClause, JDOQLQuery.this.parsedImports);
                if (qs != null) {
                    if (!(havingExpr instanceof BooleanExpression)) {
                        throw new JPOXUserException(LOCALISER.msg("JDOQL.HavingExpressionNotBoolean", havingExpr));
                    }
                    qs.setHaving((BooleanExpression)havingExpr);
                }
            }
        }

        private void compileRange(QueryExpression qs) {
            if (JDOQLQuery.this.range != null) {
                ScalarExpression[] exprs = this.compileExpressionsFromString(JDOQLQuery.this.range, JDOQLQuery.this.parsedImports);
                if (exprs.length > 0) {
                    if (!(exprs[0] instanceof Literal)) {
                        throw new JPOXUserException(LOCALISER.msg("JDOQL.RangeNeedsLiteralExpression", "FROM", exprs[0]));
                    }
                    if (!(((Literal)((Object)exprs[0])).getValue() instanceof Number)) {
                        throw new JPOXUserException(LOCALISER.msg("JDOQL.RangeLiteralExpressionNumberOnly", "FROM", exprs[0]));
                    }
                    JDOQLQuery.this.fromInclNo = ((Number)((Literal)((Object)exprs[0])).getValue()).longValue();
                }
                if (exprs.length > 1) {
                    if (!(exprs[1] instanceof Literal)) {
                        throw new JPOXUserException(LOCALISER.msg("JDOQL.RangeNeedsLiteralExpression", "TO", exprs[1]));
                    }
                    if (!(((Literal)((Object)exprs[1])).getValue() instanceof Number)) {
                        throw new JPOXUserException(LOCALISER.msg("JDOQL.RangeLiteralExpressionNumberOnly", "TO", exprs[1]));
                    }
                    JDOQLQuery.this.toExclNo = ((Number)((Literal)((Object)exprs[1])).getValue()).longValue();
                }
            }
            if (qs != null && JDOQLQuery.this.fromInclNo > 0L || JDOQLQuery.this.toExclNo != Long.MAX_VALUE) {
                qs.setRangeConstraint(JDOQLQuery.this.fromInclNo, JDOQLQuery.this.toExclNo != Long.MAX_VALUE ? JDOQLQuery.this.toExclNo - JDOQLQuery.this.fromInclNo : -1L);
            }
        }

        private ScalarExpression compileExpressionFromString(String str, Imports imports) {
            this.p = new Parser(str, imports);
            ScalarExpression expr = this.compileExpression();
            if (!this.p.parseEOS()) {
                throw new ExpressionSyntaxException(LOCALISER.msg("JDOQL.InvalidExpressionError"));
            }
            return expr;
        }

        private ScalarExpression[] compileExpressionsFromString(String str, Imports imports) {
            String[] exprList = QueryUtils.getExpressionsFromString(str);
            if (exprList != null && exprList.length > 0) {
                ScalarExpression[] exprs = new ScalarExpression[exprList.length];
                for (int i = 0; i < exprs.length; ++i) {
                    exprs[i] = this.compileExpressionFromString(exprList[i], imports);
                }
                return exprs;
            }
            return null;
        }

        private ScalarExpression compileExpression() {
            return this.compileConditionalOrExpression();
        }

        private ScalarExpression compileConditionalOrExpression() {
            ScalarExpression expr = this.compileConditionalAndExpression();
            while (this.p.parseString("||")) {
                expr = expr.ior(this.compileConditionalAndExpression());
            }
            return expr;
        }

        private ScalarExpression compileConditionalAndExpression() {
            ScalarExpression expr = this.compileInclusiveOrExpression();
            while (this.p.parseString("&&")) {
                expr = expr.and(this.compileInclusiveOrExpression());
            }
            return expr;
        }

        private ScalarExpression compileInclusiveOrExpression() {
            ScalarExpression expr = this.compileExclusiveOrExpression();
            while (this.p.parseChar('|', '|')) {
                expr = expr.ior(this.compileExclusiveOrExpression());
            }
            return expr;
        }

        private ScalarExpression compileExclusiveOrExpression() {
            ScalarExpression expr = this.compileAndExpression();
            while (this.p.parseChar('^')) {
                expr = expr.eor(this.compileExclusiveOrExpression());
            }
            return expr;
        }

        private ScalarExpression compileAndExpression() {
            ScalarExpression expr = this.compileEqualityExpression();
            while (this.p.parseChar('&', '&')) {
                expr = expr.and(this.compileEqualityExpression());
            }
            return expr;
        }

        private ScalarExpression compileEqualityExpression() {
            ScalarExpression expr = this.compileRelationalExpression();
            while (true) {
                if (this.p.parseString("==")) {
                    expr = expr.eq(this.compileRelationalExpression());
                    continue;
                }
                if (!this.p.parseString("!=")) break;
                expr = expr.noteq(this.compileRelationalExpression());
            }
            if (this.p.parseString("=")) {
                throw new JPOXUserException(LOCALISER.msg("JDOQL.InvalidAssignmentOperator", this.p.getInput()));
            }
            return expr;
        }

        private ScalarExpression compileRelationalExpression() {
            ScalarExpression expr = this.compileAdditiveExpression();
            while (true) {
                if (this.p.parseString("<=")) {
                    expr = expr.lteq(this.compileAdditiveExpression());
                    continue;
                }
                if (this.p.parseString(">=")) {
                    expr = expr.gteq(this.compileAdditiveExpression());
                    continue;
                }
                if (this.p.parseChar('<')) {
                    expr = expr.lt(this.compileAdditiveExpression());
                    continue;
                }
                if (this.p.parseChar('>')) {
                    expr = expr.gt(this.compileAdditiveExpression());
                    continue;
                }
                if (this.p.parseString("instanceof")) {
                    expr = expr.instanceOf(this.compileAdditiveExpression());
                    continue;
                }
                if (!this.p.parseString("AS") && !this.p.parseString("as")) break;
                String asName = this.p.parseName();
                expr = expr.as(asName);
            }
            return expr;
        }

        private ScalarExpression compileAdditiveExpression() {
            ScalarExpression expr = this.compileMultiplicativeExpression();
            while (true) {
                if (this.p.parseChar('+')) {
                    expr = expr.add(this.compileMultiplicativeExpression());
                    continue;
                }
                if (!this.p.parseChar('-')) break;
                expr = expr.sub(this.compileMultiplicativeExpression());
            }
            return expr;
        }

        private ScalarExpression compileMultiplicativeExpression() {
            ScalarExpression expr = this.compileUnaryExpression();
            while (true) {
                if (this.p.parseChar('*')) {
                    expr = expr.mul(this.compileUnaryExpression());
                    continue;
                }
                if (this.p.parseChar('/')) {
                    expr = expr.div(this.compileUnaryExpression());
                    continue;
                }
                if (!this.p.parseChar('%')) break;
                expr = expr.mod(this.compileUnaryExpression());
            }
            return expr;
        }

        private ScalarExpression compileUnaryExpression() {
            if (this.p.parseString("++")) {
                throw new JPOXUserException("Unsupported operator '++'");
            }
            if (this.p.parseString("--")) {
                throw new JPOXUserException("Unsupported operator '--'");
            }
            ScalarExpression expr = this.p.parseChar('+') ? this.compileUnaryExpression() : (this.p.parseChar('-') ? this.compileUnaryExpression().neg() : this.compileUnaryExpressionNotPlusMinus());
            return expr;
        }

        private ScalarExpression compileUnaryExpressionNotPlusMinus() {
            ScalarExpression expr;
            if (this.p.parseChar('~')) {
                expr = this.compileUnaryExpression().com();
            } else if (this.p.parseChar('!')) {
                expr = this.compileUnaryExpression().not();
            } else {
                expr = this.compileCastExpression();
                if (expr == null) {
                    expr = this.compilePrimary();
                }
            }
            return expr;
        }

        private ScalarExpression compileCastExpression() {
            Class type = this.p.parseCast(this.qs.getClassLoaderResolver(), JDOQLQuery.this.getCandidateLoader());
            if (type == null) {
                return null;
            }
            return this.compileUnaryExpression().cast(type);
        }

        private ScalarExpression compilePrimary() {
            ArrayList<ScalarExpression> args;
            ScalarExpression expr = this.compileLiteral();
            if (expr == null) {
                if (this.p.parseChar('(')) {
                    expr = this.compileExpression();
                    if (!this.p.parseChar(')')) {
                        throw new ExpressionSyntaxException("')' expected");
                    }
                    expr.encloseWithInParentheses();
                } else if (this.p.parseChar('{')) {
                    ArrayList<ScalarExpression> exprs = new ArrayList<ScalarExpression>();
                    while (!this.p.parseChar('}')) {
                        exprs.add(this.compileExpression());
                        if (this.p.parseChar('}')) break;
                        if (this.p.parseChar(',')) continue;
                        throw new ExpressionSyntaxException("',' or '}' expected");
                    }
                    expr = new ArrayExpression(this.qs, exprs.toArray(new ScalarExpression[exprs.size()]));
                } else {
                    String methodId = this.p.parseMethod();
                    if (methodId == null) {
                        expr = this.compileIdentifier();
                    } else if (this.p.parseChar('(')) {
                        args = new ArrayList();
                        boolean isDistinct = false;
                        if (!this.p.parseChar(')')) {
                            isDistinct = this.p.parseString("DISTINCT");
                            if (!isDistinct) {
                                isDistinct = this.p.parseString("distinct");
                            }
                            do {
                                ScalarExpression argExpr = this.compileExpression();
                                args.add(argExpr);
                                this.fieldExpressions.remove(argExpr);
                            } while (this.p.parseChar(','));
                            if (!this.p.parseChar(')')) {
                                throw new ExpressionSyntaxException("')' expected");
                            }
                        }
                        expr = new AggregateExpression(this.qs);
                        if (isDistinct) {
                            ((AggregateExpression)expr).setDistinct();
                        }
                        expr = expr.callMethod(methodId.toLowerCase(), args);
                        this.fieldExpressions.add(expr);
                    }
                }
            }
            while (this.p.parseChar('.')) {
                String id = this.p.parseIdentifier();
                if (id == null) {
                    throw new ExpressionSyntaxException("Identifier expected");
                }
                if (this.p.parseChar('(')) {
                    args = new ArrayList<ScalarExpression>();
                    if (!this.p.parseChar(')')) {
                        do {
                            args.add(this.compileExpression());
                        } while (this.p.parseChar(','));
                        if (!this.p.parseChar(')')) {
                            throw new ExpressionSyntaxException("')' expected");
                        }
                    }
                    expr = expr.callMethod(id, args);
                    continue;
                }
                expr = expr.accessField(id, false);
            }
            return expr;
        }

        private ScalarExpression compileLiteral() {
            Object litValue;
            Class litType;
            boolean single_quote_next = this.p.nextIsSingleQuote();
            String sLiteral = this.p.parseStringLiteral();
            if (sLiteral != null) {
                if (sLiteral.length() == 1 && single_quote_next) {
                    litType = class$java$lang$Character == null ? (class$java$lang$Character = JDOQLQuery.class$("java.lang.Character")) : class$java$lang$Character;
                    litValue = new Character(sLiteral.charAt(0));
                } else {
                    litType = class$java$lang$String == null ? (class$java$lang$String = JDOQLQuery.class$("java.lang.String")) : class$java$lang$String;
                    litValue = sLiteral;
                }
            } else {
                BigDecimal fLiteral = this.p.parseFloatingPointLiteral();
                if (fLiteral != null) {
                    litType = class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = JDOQLQuery.class$("java.math.BigDecimal")) : class$java$math$BigDecimal;
                    litValue = fLiteral;
                } else {
                    BigInteger iLiteral = this.p.parseIntegerLiteral();
                    if (iLiteral != null) {
                        litType = class$java$lang$Long == null ? (class$java$lang$Long = JDOQLQuery.class$("java.lang.Long")) : class$java$lang$Long;
                        litValue = new Long(iLiteral.longValue());
                    } else {
                        Boolean bLiteral = this.p.parseBooleanLiteral();
                        if (bLiteral != null) {
                            litType = class$java$lang$Boolean == null ? (class$java$lang$Boolean = JDOQLQuery.class$("java.lang.Boolean")) : class$java$lang$Boolean;
                            litValue = bLiteral;
                        } else {
                            if (this.p.parseNullLiteral()) {
                                return new NullLiteral(this.qs);
                            }
                            return null;
                        }
                    }
                }
            }
            JavaTypeMapping m = JDOQLQuery.this.dba.getMapping(litType, this.qs.getStoreManager(), this.qs.getClassLoaderResolver());
            return m.newLiteral(this.qs, litValue);
        }

        private ScalarExpression compileIdentifier() {
            ScalarExpression expr;
            block44: {
                String id = this.p.parseIdentifier();
                if (id == null) {
                    throw new ExpressionSyntaxException("Identifier expected");
                }
                for (int i = 0; i < AbstractJDOQLQuery.SINGLE_STRING_KEYWORDS.length; ++i) {
                    if (!id.equals(AbstractJDOQLQuery.SINGLE_STRING_KEYWORDS[i]) && !id.equals(AbstractJDOQLQuery.SINGLE_STRING_KEYWORDS_LOWERCASE[i])) continue;
                    throw new ExpressionSyntaxException(LOCALISER.msg("JDOQL.IdentifierIsJDOQLKeyword", id));
                }
                if (id.startsWith(":")) {
                    id = id.substring(1);
                    if (this.explicitParameters) {
                        throw new JPOXUserException(LOCALISER.msg("JDOQL.MixedParametersInvalid", this.parameters, id));
                    }
                    if (this.parameters != null && this.parameters.size() > 0) {
                        if (this.parameters.containsKey(id)) {
                            Object paramValue = this.parameters.get(id);
                            if (paramValue != null) {
                                JavaTypeMapping m = this.qs.getStoreManager().getDatastoreAdapter().getMapping(paramValue.getClass(), this.qs.getStoreManager(), this.qs.getClassLoaderResolver());
                                return m.newLiteral(this.qs, paramValue);
                            }
                            return new NullLiteral(this.qs);
                        }
                        if (this.parameters.size() < this.implicitParamNo + 1) {
                            throw new JPOXUserException(LOCALISER.msg("JDOQL.ImplicitParameterWithNoValue", "" + id, "" + this.implicitParamNo));
                        }
                        if (!this.parameters.containsKey("JPOX_" + this.implicitParamNo)) {
                            throw new JPOXUserException(LOCALISER.msg("JDOQL.ImplicitParameterWithNoValue", "" + id, "" + this.implicitParamNo));
                        }
                        Object paramValue = this.parameters.get("JPOX_" + this.implicitParamNo);
                        this.parameters.put(id, paramValue);
                        this.parameters.remove("JPOX_" + this.implicitParamNo);
                        ++this.implicitParamNo;
                        if (paramValue != null) {
                            JavaTypeMapping m = this.qs.getStoreManager().getDatastoreAdapter().getMapping(paramValue.getClass(), this.qs.getStoreManager(), this.qs.getClassLoaderResolver());
                            return m.newLiteral(this.qs, paramValue);
                        }
                        return new NullLiteral(this.qs);
                    }
                    if (JDOQLQuery.this.isPreCompile) {
                        return new NullLiteral(this.qs);
                    }
                    throw new JPOXUserException(LOCALISER.msg("JDOQL.ImplicitParameterWithNoValue", "" + id, "" + this.implicitParamNo));
                }
                if (id.equals("new")) {
                    String newClsName = this.p.parseName();
                    Class newCls = null;
                    try {
                        newCls = JDOQLQuery.this.resolveClassDeclaration(newClsName);
                    }
                    catch (JPOXUserException jpue) {
                        throw new JPOXUserException(LOCALISER.msg("JDOQL.NewObject.ClassNotFound", newClsName));
                    }
                    ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
                    if (this.p.parseChar('(')) {
                        if (!this.p.parseChar(')')) {
                            do {
                                ScalarExpression argExpr = this.compileExpression();
                                args.add(argExpr);
                                this.fieldExpressions.add(argExpr);
                            } while (this.p.parseChar(','));
                            if (!this.p.parseChar(')')) {
                                throw new ExpressionSyntaxException("')' expected, but was " + this.p.remaining());
                            }
                        }
                    } else {
                        throw new JPOXUserException(LOCALISER.msg("JDOQL.NewObject.InvalidSyntax", JDOQLQuery.this.getSingleStringQuery()));
                    }
                    expr = new NewObjectExpression(this.qs, newCls, args);
                } else if (JDOQLQuery.this.parameterNames.contains(id)) {
                    Class parameterClass = (Class)JDOQLQuery.this.parameterTypesByName.get(id);
                    boolean serialised = false;
                    if (parameterClass == (class$java$lang$Object == null ? (class$java$lang$Object = JDOQLQuery.class$("java.lang.Object")) : class$java$lang$Object)) {
                        serialised = true;
                    }
                    JavaTypeMapping m = JDOQLQuery.this.dba.getMapping(parameterClass, serialised, false, this.qs.getStoreManager(), this.qs.getClassLoaderResolver());
                    if (JDOQLQuery.this.isPreCompile) {
                        expr = m.newLiteral(this.qs, m.getSampleValue(this.qs.getClassLoaderResolver()));
                    } else {
                        if (this.parameters == null || !this.parameters.containsKey(id)) {
                            throw new JPOXUserException(LOCALISER.msg("JDOQL.RequiredParameterNotProvidedError", id));
                        }
                        Object parameterValue = this.parameters.get(id);
                        expr = parameterValue == null ? new NullLiteral(this.qs) : m.newLiteral(this.qs, parameterValue);
                    }
                } else if (JDOQLQuery.this.variableNames.contains(id)) {
                    expr = (ScalarExpression)this.expressionsByVariableName.get(id);
                    if (expr == null) {
                        expr = new UnboundVariable(this.qs, id, (Class)JDOQLQuery.this.variableTypesByName.get(id), this);
                    }
                    this.fieldExpressions.add(expr);
                } else {
                    try {
                        expr = this.qs.getDefaultTableExpression().newFieldExpression(id);
                        if (!id.equals("this")) {
                            if (JDOQLQuery.this.candidateCmd == null) {
                                JDOQLQuery.this.candidateCmd = JDOQLQuery.this.om.getMetaDataManager().getMetaDataForClass(JDOQLQuery.this.candidateClass, JDOQLQuery.this.om.getClassLoaderResolver());
                            }
                            if (JDOQLQuery.this.candidateCmd.getField(id) == null) {
                                throw new JPOXUserException(LOCALISER.msg("JDOQL.SpecifiedFieldNotFound", id));
                            }
                        }
                        this.fieldExpressions.add(expr);
                    }
                    catch (NoSuchPersistentFieldException nspfe) {
                        String name = id;
                        if (this.p.nextIsDot()) {
                            this.p.parseChar('.');
                            name = name + ".";
                            name = name + this.p.parseName();
                        }
                        Class cls = null;
                        try {
                            cls = JDOQLQuery.this.resolveClassDeclaration(name);
                            expr = new ClassExpression(this.qs, cls);
                        }
                        catch (JPOXUserException jpue) {
                            if (name.indexOf(46) > 0) {
                                String partialName = name.substring(0, name.lastIndexOf(46));
                                String finalNamePart = name.substring(name.lastIndexOf(46) + 1);
                                try {
                                    expr = this.callUserDefinedScalarExpression(name);
                                    if (expr == null) {
                                        cls = JDOQLQuery.this.resolveClassDeclaration(partialName);
                                        expr = new ClassExpression(this.qs, cls);
                                        expr = expr.accessField(finalNamePart, true);
                                    }
                                    break block44;
                                }
                                catch (JPOXUserException jpue2) {
                                    throw new JPOXUserException(LOCALISER.msg("JDOQL.SpecifiedClassNotFound", partialName), jpue2);
                                }
                            }
                            try {
                                expr = new ClassExpression(this.qs, JDOQLQuery.this.candidateClass);
                                expr = expr.accessField(name, true);
                            }
                            catch (JPOXUserException jpue2) {
                                if (this.explicitVariables) {
                                    throw new JPOXUserException(LOCALISER.msg("JDOQL.MixedVariablesInvalid", JDOQLQuery.this.variables, name));
                                }
                                expr = (ScalarExpression)this.expressionsByVariableName.get(name);
                                if (expr != null) break block44;
                                expr = new UnboundVariable(this.qs, name, (Class)JDOQLQuery.this.variableTypesByName.get(name), this);
                                JDOQLQuery.this.variableNames.add(name);
                                this.fieldExpressions.add(expr);
                            }
                        }
                    }
                }
            }
            return expr;
        }

        private ScalarExpression callUserDefinedScalarExpression(String method) {
            String className = method.substring(0, method.lastIndexOf(46));
            String methodName = method.substring(method.lastIndexOf(46) + 1);
            if (!userDefinedScalarExpressions.containsKey(className)) {
                Class cls = JDOQLQuery.this.resolveClassDeclaration(className);
                className = cls.getName();
            }
            if (userDefinedScalarExpressions.containsKey(className)) {
                ScalarExpression expr = this.newScalarExpression((Class)userDefinedScalarExpressions.get(className));
                if (this.p.parseChar('(')) {
                    ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
                    if (!this.p.parseChar(')')) {
                        do {
                            args.add(this.compileExpression());
                        } while (this.p.parseChar(','));
                        if (!this.p.parseChar(')')) {
                            throw new ExpressionSyntaxException("')' expected");
                        }
                    }
                    return expr.callMethod(methodName, args);
                }
            }
            return null;
        }

        private ScalarExpression newScalarExpression(Class cls) {
            try {
                return (ScalarExpression)cls.getConstructor(class$org$jpox$store$expression$QueryExpression == null ? (class$org$jpox$store$expression$QueryExpression = JDOQLQuery.class$("org.jpox.store.expression.QueryExpression")) : class$org$jpox$store$expression$QueryExpression).newInstance(this.qs);
            }
            catch (IllegalArgumentException e) {
                throw new JPOXException("Cannot create ScalarExpression for class " + cls.getName() + " due to " + e.getMessage(), e).setFatal();
            }
            catch (SecurityException e) {
                throw new JPOXException("Cannot create ScalarExpression for class " + cls.getName() + " due to " + e.getMessage(), e).setFatal();
            }
            catch (InstantiationException e) {
                throw new JPOXException("Cannot create ScalarExpression for class " + cls.getName() + " due to " + e.getMessage(), e).setFatal();
            }
            catch (IllegalAccessException e) {
                throw new JPOXException("Cannot create ScalarExpression for class " + cls.getName() + " due to " + e.getMessage(), e).setFatal();
            }
            catch (InvocationTargetException e) {
                throw new JPOXException("Cannot create ScalarExpression for class " + cls.getName() + " due to " + e.getMessage(), e).setFatal();
            }
            catch (NoSuchMethodException e) {
                throw new JPOXException("Cannot create ScalarExpression for class " + cls.getName() + " due to " + e.getMessage(), e).setFatal();
            }
        }

        private class ExpressionSyntaxException
        extends JPOXUserException {
            public ExpressionSyntaxException(String msg) {
                super(msg + " at character " + (Compiler.this.p.getIndex() + 1) + " in \"" + Compiler.this.p.getInput() + '\"');
            }
        }
    }
}

