/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.query;

import java.sql.ResultSet;
import java.util.Map;
import javax.jdo.spi.PersistenceCapable;
import org.jpox.ClassLoaderResolver;
import org.jpox.JDOFetchPlanImpl;
import org.jpox.ObjectManager;
import org.jpox.StateManager;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.IdentityType;
import org.jpox.metadata.InterfaceMetaData;
import org.jpox.store.DatastoreClass;
import org.jpox.store.FieldValues;
import org.jpox.store.StatementExpressionIndex;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.OIDMapping;
import org.jpox.store.query.ResultObjectFactory;
import org.jpox.store.rdbms.fieldmanager.ResultSetGetter;
import org.jpox.store.rdbms.query.RDBMSQueryUtils;
import org.jpox.util.SoftValueMap;

public final class PersistentIDROF
implements ResultObjectFactory {
    private final DatastoreClass table;
    private final boolean ignoreCache;
    protected int[] fieldNumbers;
    protected StatementExpressionIndex[] statementExpressionIndex;
    protected final int[] datastoreIdentityExpressionIndex;
    protected final int[] versionIndex;
    protected boolean discriminator;
    protected final boolean hasMetaDataInResults;
    protected final JDOFetchPlanImpl fetchPlan;
    protected final AbstractClassMetaData acmd;
    private Map resolvedClasses = new SoftValueMap();
    private Map stmtExprIndexes = new SoftValueMap();
    private Class persistentClass;

    public PersistentIDROF(DatastoreClass table, int[] fieldNumbers, AbstractClassMetaData acmd, StatementExpressionIndex[] statementExpressionIndex, int[] datastoreIdentityExpressionIndex, int[] versionIndex, boolean ignoreCache, boolean discriminator, boolean hasMetaDataInResults, JDOFetchPlanImpl fetchPlan, Class persistentClass) {
        this.statementExpressionIndex = statementExpressionIndex;
        this.fieldNumbers = fieldNumbers == null ? new int[0] : fieldNumbers;
        this.acmd = acmd;
        this.table = table;
        this.datastoreIdentityExpressionIndex = datastoreIdentityExpressionIndex;
        this.versionIndex = versionIndex;
        this.ignoreCache = ignoreCache;
        this.discriminator = discriminator;
        this.hasMetaDataInResults = hasMetaDataInResults;
        this.fetchPlan = fetchPlan;
        this.persistentClass = persistentClass;
    }

    public void setPersistentClass(Class cls) {
        this.persistentClass = cls;
    }

    public Object getObject(ObjectManager om, Object rs) {
        JavaTypeMapping mapping;
        boolean requiresInheritanceCheck = true;
        String className = null;
        if (this.discriminator) {
            className = RDBMSQueryUtils.getClassNameFromDiscriminatorResultSetRow(this.table, (ResultSet)rs, om);
        } else if (this.hasMetaDataInResults) {
            try {
                className = RDBMSQueryUtils.getClassNameFromJPOXMetaDataResultSetRow((ResultSet)rs);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        ClassLoaderResolver clr = om.getClassLoaderResolver();
        Class pcClassForObject = this.persistentClass;
        if (className != null) {
            Class cls = (Class)this.resolvedClasses.get(className);
            if (cls != null) {
                pcClassForObject = cls;
            } else {
                pcClassForObject = this.persistentClass.getName().equals(className) ? this.persistentClass : clr.classForName(className, this.persistentClass.getClassLoader());
                this.resolvedClasses.put(className, pcClassForObject);
            }
            requiresInheritanceCheck = false;
        }
        int[] fieldNumbers = new int[this.fieldNumbers.length];
        AbstractClassMetaData cmd = om.getMetaDataManager().getMetaDataForClass(pcClassForObject, clr);
        for (int i = 0; i < this.fieldNumbers.length; ++i) {
            if (this.acmd instanceof InterfaceMetaData) {
                fieldNumbers[i] = cmd.getFieldNumberAbsolute(this.acmd.getManagedFieldAbsolute(this.fieldNumbers[i]).getName());
                continue;
            }
            fieldNumbers[i] = cmd.getFieldNumberAbsolute(this.acmd.getManagedFieldAbsolute(this.fieldNumbers[i]).getClassName(), this.acmd.getManagedFieldAbsolute(this.fieldNumbers[i]).getName());
            if (fieldNumbers[i] != -1) continue;
            fieldNumbers[i] = cmd.getFieldNumberAbsolute(this.acmd.getManagedFieldAbsolute(this.fieldNumbers[i]).getName());
        }
        Object obj = null;
        if (cmd.getIdentityType() == IdentityType.APPLICATION) {
            obj = this.getObjectByAID(om, (ResultSet)rs, fieldNumbers, cmd, pcClassForObject, requiresInheritanceCheck);
        } else if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            mapping = new OIDMapping();
            mapping.initialize(this.table.getStoreManager().getDatastoreAdapter(), pcClassForObject.getName());
            mapping.addDataStoreMapping(this.table.getDataStoreObjectIdMapping().getDataStoreMapping(0));
            Object id = mapping.getObject(om, rs, this.datastoreIdentityExpressionIndex);
            obj = fieldNumbers == null ? om.findObject(id, false, requiresInheritanceCheck, null) : (requiresInheritanceCheck ? this.getObjectById(om, (ResultSet)rs, fieldNumbers, cmd, id, null) : this.getObjectById(om, (ResultSet)rs, fieldNumbers, cmd, id, pcClassForObject));
        } else if (cmd.getIdentityType() == IdentityType.NONDURABLE) {
            Object id = om.getStoreManager().newObjectID(om, className, null);
            obj = fieldNumbers == null ? om.findObject(id, false, requiresInheritanceCheck, null) : this.getObjectById(om, (ResultSet)rs, fieldNumbers, cmd, id, pcClassForObject);
        }
        if (this.versionIndex != null) {
            mapping = this.table.getVersionMapping();
            Object version = mapping.getObject(om, rs, this.versionIndex);
            StateManager objSM = om.findStateManager((PersistenceCapable)obj);
            objSM.setVersion(version);
        }
        return obj;
    }

    private Object getObjectByAID(ObjectManager om, final ResultSet rs, final int[] fieldNumbers, AbstractClassMetaData cmd, Class pcClass, boolean requiresInheritanceCheck) {
        StatementExpressionIndex[] indexes = (StatementExpressionIndex[])this.stmtExprIndexes.get(cmd.getFullClassName());
        if (indexes == null) {
            indexes = new StatementExpressionIndex[cmd.getNoOfManagedFields() + cmd.getNoOfInheritedManagedFields()];
            for (int i = 0; i < fieldNumbers.length; ++i) {
                indexes[fieldNumbers[i]] = this.statementExpressionIndex[this.fieldNumbers[i]];
            }
            this.stmtExprIndexes.put(cmd.getFullClassName(), indexes);
        }
        final StatementExpressionIndex[] stmtExprIndex = indexes;
        return om.findObjectUsingAID(pcClass, new FieldValues(){

            public void fetchFields(StateManager sm) {
                sm.replaceFields(fieldNumbers, new ResultSetGetter(sm, rs, stmtExprIndex), false);
            }

            public void fetchNonLoadedFields(StateManager sm) {
                sm.replaceNonLoadedFields(fieldNumbers, new ResultSetGetter(sm, rs, stmtExprIndex));
            }

            public JDOFetchPlanImpl getFetchPlanForLoading() {
                return PersistentIDROF.this.fetchPlan;
            }
        }, this.ignoreCache, requiresInheritanceCheck);
    }

    private Object getObjectById(ObjectManager om, final ResultSet rs, final int[] fieldNumbers, AbstractClassMetaData cmd, Object oid, Class pcClass) {
        StatementExpressionIndex[] indexes = (StatementExpressionIndex[])this.stmtExprIndexes.get(cmd.getFullClassName());
        if (indexes == null) {
            indexes = new StatementExpressionIndex[cmd.getNoOfManagedFields() + cmd.getNoOfInheritedManagedFields()];
            for (int i = 0; i < fieldNumbers.length; ++i) {
                indexes[fieldNumbers[i]] = this.statementExpressionIndex[this.fieldNumbers[i]];
            }
            this.stmtExprIndexes.put(cmd.getFullClassName(), indexes);
        }
        final StatementExpressionIndex[] stmtExprIndex = indexes;
        if (pcClass == null) {
            return om.findObject(oid, new FieldValues(){

                public void fetchFields(StateManager sm) {
                    sm.replaceFields(fieldNumbers, new ResultSetGetter(sm, rs, stmtExprIndex), false);
                }

                public void fetchNonLoadedFields(StateManager sm) {
                    sm.replaceNonLoadedFields(fieldNumbers, new ResultSetGetter(sm, rs, stmtExprIndex));
                }

                public JDOFetchPlanImpl getFetchPlanForLoading() {
                    return PersistentIDROF.this.fetchPlan;
                }
            });
        }
        return om.findObject(oid, new FieldValues(){

            public void fetchFields(StateManager sm) {
                sm.replaceFields(fieldNumbers, new ResultSetGetter(sm, rs, stmtExprIndex), false);
            }

            public void fetchNonLoadedFields(StateManager sm) {
                sm.replaceNonLoadedFields(fieldNumbers, new ResultSetGetter(sm, rs, stmtExprIndex));
            }

            public JDOFetchPlanImpl getFetchPlanForLoading() {
                return PersistentIDROF.this.fetchPlan;
            }
        }, pcClass, this.ignoreCache);
    }
}

