/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.query;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.jdo.JDOUserException;
import org.jpox.ObjectManager;
import org.jpox.store.StatementExpressionIndex;
import org.jpox.store.expression.NewObjectExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.query.QueryUtils;
import org.jpox.store.query.ResultObjectFactory;
import org.jpox.util.JPOXLogger;
import org.jpox.util.Localiser;
import org.jpox.util.StringUtils;

public class ResultClassROF
implements ResultObjectFactory {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.jpox.store.Localisation");
    private Class resultClass;
    private final StatementExpressionIndex[] statementExpressionIndex;
    private final ScalarExpression[] expressions;
    private final String[] resultFieldNames;
    private final Map resultClassFieldsByName = new HashMap();
    private static Map resultSetGetters = new HashMap(20);
    static /* synthetic */ Class array$Ljava$lang$Object;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$io$Reader;
    static /* synthetic */ Class class$java$sql$Array;

    public ResultClassROF(Class resultClass, StatementExpressionIndex[] statementExpressionIndex) {
        this(resultClass, statementExpressionIndex, null);
    }

    public ResultClassROF(Class resultClass, StatementExpressionIndex[] statementExpressionIndex, ScalarExpression[] expressions) {
        if (resultClass != null && resultClass.getName().equals("java.util.Map")) {
            try {
                this.resultClass = Class.forName("java.util.HashMap", true, resultClass.getClassLoader());
            }
            catch (ClassNotFoundException cnfe) {
                this.resultClass = resultClass;
            }
        } else {
            this.resultClass = resultClass;
        }
        if (QueryUtils.resultClassIsUserType(resultClass.getName())) {
            this.populateDeclaredFieldsForUserType(this.resultClass);
        }
        this.statementExpressionIndex = statementExpressionIndex;
        this.expressions = expressions;
        this.resultFieldNames = new String[statementExpressionIndex.length];
        for (int i = 0; i < statementExpressionIndex.length; ++i) {
            this.resultFieldNames[i] = statementExpressionIndex[i].getColumnName();
        }
        if (expressions == null && QueryUtils.resultClassIsSimple(resultClass.getName()) && statementExpressionIndex.length != 1) {
            String msg = LOCALISER.msg("Query.ResultClassSimpleButMultipleFields", resultClass.getName());
            JPOXLogger.QUERY.error(msg);
            throw new JDOUserException(msg);
        }
        if (expressions != null && QueryUtils.resultClassIsSimple(resultClass.getName()) && expressions.length != 1) {
            String msg = LOCALISER.msg("Query.ResultClassSimpleButMultipleFields", resultClass.getName());
            JPOXLogger.QUERY.error(msg);
            throw new JDOUserException(msg);
        }
    }

    public ResultClassROF(Class resultClass, String[] resultFieldNames) {
        if (resultClass != null && resultClass.getName().equals("java.util.Map")) {
            try {
                this.resultClass = Class.forName("java.util.HashMap", true, resultClass.getClassLoader());
            }
            catch (ClassNotFoundException cnfe) {
                this.resultClass = resultClass;
            }
        } else {
            this.resultClass = resultClass;
        }
        if (QueryUtils.resultClassIsUserType(resultClass.getName())) {
            this.populateDeclaredFieldsForUserType(this.resultClass);
        }
        this.statementExpressionIndex = null;
        this.expressions = null;
        this.resultFieldNames = resultFieldNames == null ? new String[0] : resultFieldNames;
    }

    public Object getObject(ObjectManager om, Object rs) {
        String msg;
        Object[] fieldValues = null;
        if (this.statementExpressionIndex != null) {
            if (this.expressions != null) {
                fieldValues = new Object[this.expressions.length];
                StatementExpressionIterator stmtExprIterator = new StatementExpressionIterator();
                for (int i = 0; i < this.expressions.length; ++i) {
                    fieldValues[i] = this.processScalarExpression(om, rs, stmtExprIterator, this.expressions[i]);
                }
            } else {
                fieldValues = new Object[this.statementExpressionIndex.length];
                for (int i = 0; i < this.statementExpressionIndex.length; ++i) {
                    fieldValues[i] = this.statementExpressionIndex[i].getMapping().getObject(om, rs, this.statementExpressionIndex[i].getExpressionIndex());
                }
            }
        } else {
            try {
                fieldValues = new Object[this.resultFieldNames.length];
                for (int i = 0; i < fieldValues.length; ++i) {
                    fieldValues[i] = this.getResultObject((ResultSet)rs, i + 1);
                }
            }
            catch (SQLException sqe) {
                String msg2 = LOCALISER.msg("SQL.ResultExtractionError", sqe.getMessage());
                JPOXLogger.QUERY.error(msg2);
                throw new JDOUserException(msg2);
            }
        }
        if (this.resultClass == (array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = ResultClassROF.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object)) {
            return fieldValues;
        }
        if (QueryUtils.resultClassIsSimple(this.resultClass.getName())) {
            if (fieldValues.length == 1 && (fieldValues[0] == null || this.resultClass.isAssignableFrom(fieldValues[0].getClass()))) {
                return fieldValues[0];
            }
            if (fieldValues.length == 1 && !this.resultClass.isAssignableFrom(fieldValues[0].getClass())) {
                msg = LOCALISER.msg("Query.ResultClassSimpleButWrongType", this.resultClass.getName(), fieldValues[0].getClass().getName());
                JPOXLogger.QUERY.error(msg);
                throw new JDOUserException(msg);
            }
        } else {
            Object obj = QueryUtils.createResultObjectUsingArgumentedConstructor(this.resultClass, fieldValues);
            if (obj != null) {
                return obj;
            }
            if (JPOXLogger.QUERY.isDebugEnabled()) {
                Object[] ctr_arg_types = new Class[this.resultFieldNames.length];
                for (int i = 0; i < this.resultFieldNames.length; ++i) {
                    ctr_arg_types[i] = fieldValues[i] != null ? fieldValues[i].getClass() : null;
                }
                JPOXLogger.QUERY.debug(LOCALISER.msg("Query.ResultClass.ConstructorNotAvailable", this.resultClass.getName(), StringUtils.objectArrayToString(ctr_arg_types)));
            }
            obj = QueryUtils.createResultObjectUsingDefaultConstructorAndSetters(this.resultClass, this.resultFieldNames, this.resultClassFieldsByName, fieldValues);
            return obj;
        }
        msg = LOCALISER.msg("Query.ResultClassInvalid", this.resultClass.getName());
        JPOXLogger.QUERY.error(msg);
        throw new JDOUserException(msg);
    }

    private void populateDeclaredFieldsForUserType(Class cls) {
        for (int i = 0; i < cls.getDeclaredFields().length; ++i) {
            if (this.resultClassFieldsByName.put(cls.getDeclaredFields()[i].getName().toUpperCase(), cls.getDeclaredFields()[i]) == null) continue;
            throw new JDOUserException(LOCALISER.msg("Query.ResultClassNotCaseInsensitive", cls.getDeclaredFields()[i].getName()));
        }
        if (cls.getSuperclass() != null) {
            this.populateDeclaredFieldsForUserType(cls.getSuperclass());
        }
    }

    private Object processNewObjectExpression(ObjectManager om, Object rs, StatementExpressionIterator stmtExprIterator, ScalarExpression expr1) {
        NewObjectExpression newObjectExpr = (NewObjectExpression)expr1;
        int numberOfArgs = newObjectExpr.getArgumentExpressions().size();
        ArrayList<Object> argValues = new ArrayList<Object>();
        for (int j = 0; j < numberOfArgs; ++j) {
            ScalarExpression expr = (ScalarExpression)newObjectExpr.getArgumentExpressions().get(j);
            argValues.add(this.processScalarExpression(om, rs, stmtExprIterator, expr));
        }
        return newObjectExpr.createNewObject(argValues.toArray(new Object[argValues.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object processScalarExpression(ObjectManager om, Object rs, StatementExpressionIterator stmtExprIterator, ScalarExpression expr1) {
        if (expr1 instanceof NewObjectExpression) {
            return this.processNewObjectExpression(om, rs, stmtExprIterator, expr1);
        }
        try {
            Object object = stmtExprIterator.current().getMapping().getObject(om, rs, stmtExprIterator.current().getExpressionIndex());
            return object;
        }
        finally {
            if (stmtExprIterator.hasNext()) {
                stmtExprIterator.next();
            }
        }
    }

    private Object getResultObject(ResultSet rs, int columnNumber) throws SQLException {
        ResultSetGetter getter = (ResultSetGetter)resultSetGetters.get(this.resultClass);
        if (getter != null) {
            return getter.getValue(rs, columnNumber);
        }
        return rs.getObject(columnNumber);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        resultSetGetters.put(class$java$lang$Boolean == null ? (class$java$lang$Boolean = ResultClassROF.class$("java.lang.Boolean")) : class$java$lang$Boolean, new ResultSetGetter(){

            public Object getValue(ResultSet rs, int i) throws SQLException {
                return new Boolean(rs.getBoolean(i));
            }
        });
        resultSetGetters.put(class$java$lang$Byte == null ? (class$java$lang$Byte = ResultClassROF.class$("java.lang.Byte")) : class$java$lang$Byte, new ResultSetGetter(){

            public Object getValue(ResultSet rs, int i) throws SQLException {
                return new Byte(rs.getByte(i));
            }
        });
        resultSetGetters.put(class$java$lang$Short == null ? (class$java$lang$Short = ResultClassROF.class$("java.lang.Short")) : class$java$lang$Short, new ResultSetGetter(){

            public Object getValue(ResultSet rs, int i) throws SQLException {
                return new Short(rs.getShort(i));
            }
        });
        resultSetGetters.put(class$java$lang$Integer == null ? (class$java$lang$Integer = ResultClassROF.class$("java.lang.Integer")) : class$java$lang$Integer, new ResultSetGetter(){

            public Object getValue(ResultSet rs, int i) throws SQLException {
                return new Integer(rs.getInt(i));
            }
        });
        resultSetGetters.put(class$java$lang$Long == null ? (class$java$lang$Long = ResultClassROF.class$("java.lang.Long")) : class$java$lang$Long, new ResultSetGetter(){

            public Object getValue(ResultSet rs, int i) throws SQLException {
                return new Long(rs.getLong(i));
            }
        });
        resultSetGetters.put(class$java$lang$Float == null ? (class$java$lang$Float = ResultClassROF.class$("java.lang.Float")) : class$java$lang$Float, new ResultSetGetter(){

            public Object getValue(ResultSet rs, int i) throws SQLException {
                return new Float(rs.getFloat(i));
            }
        });
        resultSetGetters.put(class$java$lang$Double == null ? (class$java$lang$Double = ResultClassROF.class$("java.lang.Double")) : class$java$lang$Double, new ResultSetGetter(){

            public Object getValue(ResultSet rs, int i) throws SQLException {
                return new Double(rs.getDouble(i));
            }
        });
        resultSetGetters.put(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = ResultClassROF.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, new ResultSetGetter(){

            public Object getValue(ResultSet rs, int i) throws SQLException {
                return rs.getBigDecimal(i);
            }
        });
        resultSetGetters.put(array$B == null ? (array$B = ResultClassROF.class$("[B")) : array$B, new ResultSetGetter(){

            public Object getValue(ResultSet rs, int i) throws SQLException {
                return rs.getBytes(i);
            }
        });
        ResultSetGetter timestampGetter = new ResultSetGetter(){

            public Object getValue(ResultSet rs, int i) throws SQLException {
                return rs.getTimestamp(i);
            }
        };
        resultSetGetters.put(class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = ResultClassROF.class$("java.sql.Timestamp")) : class$java$sql$Timestamp, timestampGetter);
        resultSetGetters.put(class$java$util$Date == null ? (class$java$util$Date = ResultClassROF.class$("java.util.Date")) : class$java$util$Date, timestampGetter);
        resultSetGetters.put(class$java$sql$Date == null ? (class$java$sql$Date = ResultClassROF.class$("java.sql.Date")) : class$java$sql$Date, new ResultSetGetter(){

            public Object getValue(ResultSet rs, int i) throws SQLException {
                return rs.getDate(i);
            }
        });
        resultSetGetters.put(class$java$lang$String == null ? (class$java$lang$String = ResultClassROF.class$("java.lang.String")) : class$java$lang$String, new ResultSetGetter(){

            public Object getValue(ResultSet rs, int i) throws SQLException {
                return rs.getString(i);
            }
        });
        resultSetGetters.put(class$java$io$Reader == null ? (class$java$io$Reader = ResultClassROF.class$("java.io.Reader")) : class$java$io$Reader, new ResultSetGetter(){

            public Object getValue(ResultSet rs, int i) throws SQLException {
                return rs.getCharacterStream(i);
            }
        });
        resultSetGetters.put(class$java$sql$Array == null ? (class$java$sql$Array = ResultClassROF.class$("java.sql.Array")) : class$java$sql$Array, new ResultSetGetter(){

            public Object getValue(ResultSet rs, int i) throws SQLException {
                return rs.getArray(i);
            }
        });
    }

    private static interface ResultSetGetter {
        public Object getValue(ResultSet var1, int var2) throws SQLException;
    }

    private class StatementExpressionIterator {
        int index = 0;

        private StatementExpressionIterator() {
        }

        boolean hasNext() {
            return this.index < ResultClassROF.this.statementExpressionIndex.length - 1;
        }

        StatementExpressionIndex next() {
            ++this.index;
            return ResultClassROF.this.statementExpressionIndex[this.index];
        }

        StatementExpressionIndex current() {
            return ResultClassROF.this.statementExpressionIndex[this.index];
        }
    }
}

