/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.query;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import org.jpox.ManagedConnection;
import org.jpox.ObjectManager;
import org.jpox.exceptions.JPOXDataStoreException;
import org.jpox.exceptions.JPOXUserException;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.query.Evaluator;
import org.jpox.store.query.Query;
import org.jpox.store.query.QueryResult;
import org.jpox.store.query.ResultObjectFactory;
import org.jpox.store.rdbms.RDBMSManager;
import org.jpox.store.rdbms.SQLController;
import org.jpox.store.rdbms.query.AbstractQueryResult;
import org.jpox.store.rdbms.query.ForwardQueryResult;
import org.jpox.store.rdbms.query.InsensitiveQueryResult;
import org.jpox.store.rdbms.query.ResultClassROF;
import org.jpox.store.rdbms.query.StatementText;
import org.jpox.util.Localiser;
import org.jpox.util.TypeConversionHelper;

public class SQLEvaluator
implements Evaluator {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.jpox.store.Localisation");
    ObjectManager om;
    Map extensions;
    long toExclNo;
    boolean distinct;
    Query query;
    ResultObjectFactory rof;
    Collection candidateCollection;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class array$Ljava$lang$Object;

    public SQLEvaluator(ObjectManager om, Map extensions, long toExclNo, boolean distinct, Query query, ResultObjectFactory rof, Collection candidateCollection) {
        this.om = om;
        this.extensions = extensions;
        this.toExclNo = toExclNo;
        this.distinct = distinct;
        this.query = query;
        this.rof = rof;
        this.candidateCollection = candidateCollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryResult evaluate(QueryExpression queryStmt) {
        boolean useUpdateLock = (Boolean)this.om.getTransaction().getOptions().get("transaction.serializeReadObjects");
        if (this.extensions != null && this.extensions.containsKey("org.jpox.rdbms.query.useUpdateLock")) {
            useUpdateLock = Boolean.valueOf((String)this.extensions.get("org.jpox.rdbms.query.useUpdateLock"));
        }
        AbstractQueryResult qr = null;
        try {
            RDBMSManager storeMgr = (RDBMSManager)this.om.getStoreManager();
            ManagedConnection mconn = storeMgr.getConnection(this.om);
            Connection conn = (Connection)mconn.getConnection();
            SQLController sqlControl = storeMgr.getSQLController();
            try {
                StatementText stmtText = queryStmt.toStatementText(useUpdateLock);
                PreparedStatement ps = this.getStatement(conn, stmtText);
                try {
                    this.prepareStatementForExecution(ps);
                    if (this.toExclNo != 0L && this.toExclNo != Long.MAX_VALUE) {
                        ps.setMaxRows((int)this.toExclNo);
                    }
                    ResultSet rs = sqlControl.executeStatementQuery(conn, stmtText.toString(), ps);
                    try {
                        boolean forwardResultSet = true;
                        if (this.getResultSetType().equals("scroll-insensitive")) {
                            forwardResultSet = false;
                        }
                        qr = forwardResultSet ? new ForwardQueryResult(queryStmt, this.query, this.rof, rs, this.distinct ? null : this.candidateCollection) : new InsensitiveQueryResult(queryStmt, this.query, this.rof, rs, this.distinct ? null : this.candidateCollection);
                    }
                    finally {
                        if (qr == null) {
                            rs.close();
                        }
                    }
                }
                finally {
                    if (qr == null) {
                        sqlControl.closeStatement(conn, ps);
                    }
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new JPOXDataStoreException(LOCALISER.msg("JDOQL.ExecutionError", queryStmt.toStatementText(useUpdateLock), e.getMessage()), e);
        }
        return qr;
    }

    protected String getResultSetType() {
        String rsTypeString = this.om.getOMFContext().getPersistenceConfiguration().getQueryResultSetType();
        if (this.extensions != null && this.extensions.containsKey("org.jpox.rdbms.query.resultSetType")) {
            rsTypeString = (String)this.extensions.get("org.jpox.rdbms.query.resultSetType");
        }
        return rsTypeString;
    }

    protected String getResultSetConcurrency() {
        String rsConcurrencyString = this.om.getOMFContext().getPersistenceConfiguration().getQueryResultSetConcurrency();
        if (this.extensions != null && this.extensions.containsKey("org.jpox.rdbms.query.resultSetConcurrency")) {
            rsConcurrencyString = (String)this.extensions.get("org.jpox.rdbms.query.resultSetConcurrency");
        }
        return rsConcurrencyString;
    }

    protected PreparedStatement getStatement(Connection conn, String queryStmt) throws SQLException {
        String rsTypeString = this.getResultSetType();
        if (!(rsTypeString == null || rsTypeString.equals("scroll-sensitive") || rsTypeString.equals("forward-only") || rsTypeString.equals("scroll-insensitive"))) {
            throw new JPOXUserException("JDOQL extension for JPOX org.jpox.rdbms.query.resultSetType has valid values of scroll-sensitive,scroll-insensitive,forward-only only.");
        }
        String rsConcurrencyString = this.getResultSetConcurrency();
        if (rsConcurrencyString != null && !rsConcurrencyString.equals("read-only") && !rsConcurrencyString.equals("updateable")) {
            throw new JPOXUserException("JDOQL extension for JPOX org.jpox.rdbms.query.resultSetConcurrency has valid values of read-only,updateable only.");
        }
        SQLController sqlControl = ((RDBMSManager)this.om.getStoreManager()).getSQLController();
        PreparedStatement ps = sqlControl.getStatementForQuery(conn, queryStmt, rsTypeString, rsConcurrencyString);
        return ps;
    }

    protected PreparedStatement getStatement(Connection conn, StatementText stmtText) throws SQLException {
        String rsTypeString = this.getResultSetType();
        if (!(rsTypeString == null || rsTypeString.equals("scroll-sensitive") || rsTypeString.equals("forward-only") || rsTypeString.equals("scroll-insensitive"))) {
            throw new JPOXUserException("JDOQL extension for JPOX org.jpox.rdbms.query.resultSetType has valid values of scroll-sensitive,scroll-insensitive,forward-only only.");
        }
        String rsConcurrencyString = this.getResultSetConcurrency();
        if (rsConcurrencyString != null && !rsConcurrencyString.equals("read-only") && !rsConcurrencyString.equals("updateable")) {
            throw new JPOXUserException("JDOQL extension for JPOX org.jpox.rdbms.query.resultSetConcurrency has valid values of read-only,updateable only.");
        }
        PreparedStatement ps = stmtText.prepareStatement(this.om, conn, rsTypeString, rsConcurrencyString);
        return ps;
    }

    protected void prepareStatementForExecution(PreparedStatement ps) throws SQLException {
        int timeout = this.om.getOMFContext().getPersistenceConfiguration().getQueryTimeout();
        if (this.extensions != null && this.extensions.containsKey("org.jpox.query.timeout")) {
            Object val = this.extensions.get("org.jpox.query.timeout");
            if (val instanceof Integer) {
                timeout = (Integer)val;
            } else if (val instanceof String) {
                timeout = TypeConversionHelper.intFromString((String)val, 0);
            }
        }
        if (timeout > 0) {
            ps.setQueryTimeout(timeout);
        }
        int fetchSize = this.om.getOMFContext().getPersistenceConfiguration().getQueryFetchSize();
        if (this.extensions != null && this.extensions.containsKey("org.jpox.query.fetchSize")) {
            Object val = this.extensions.get("org.jpox.query.fetchSize");
            if (val instanceof Integer) {
                fetchSize = (Integer)val;
            } else if (val instanceof String) {
                fetchSize = TypeConversionHelper.intFromString((String)val, 0);
            }
        }
        if (this.om.getOMFContext().getStoreManager().getDatastoreAdapter().supportsQueryFetchSizeLowerThanOne() && fetchSize < 1 || fetchSize > 0) {
            ps.setFetchSize(fetchSize);
        }
        String fetchDir = this.om.getOMFContext().getPersistenceConfiguration().getQueryFetchDirection();
        if (this.extensions != null && this.extensions.containsKey("org.jpox.query.fetchDirection") && !(fetchDir = (String)this.extensions.get("org.jpox.query.fetchDirection")).equals("forward") && !fetchDir.equals("reverse") && !fetchDir.equals("unknown")) {
            throw new JPOXUserException("Query extension for JPOX org.jpox.query.fetchDirection has valid values of forward,reverse,unknown only");
        }
        if (fetchDir.equals("reverse")) {
            ps.setFetchDirection(1001);
        } else if (fetchDir.equals("unknown")) {
            ps.setFetchDirection(1002);
        }
    }

    protected ResultObjectFactory getResultObjectFactoryForNoCandidateClass(ResultSet rs, Class resultClass) throws SQLException {
        Class requiredResultClass = resultClass;
        int numberOfColumns = 0;
        String[] resultFieldNames = null;
        try {
            ResultSetMetaData rsmd = rs.getMetaData();
            numberOfColumns = rsmd.getColumnCount();
            if (requiredResultClass == null) {
                requiredResultClass = numberOfColumns == 1 ? (class$java$lang$Object == null ? (class$java$lang$Object = SQLEvaluator.class$("java.lang.Object")) : class$java$lang$Object) : (array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = SQLEvaluator.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object);
            }
            resultFieldNames = new String[numberOfColumns];
            for (int i = 0; i < numberOfColumns; ++i) {
                resultFieldNames[i] = rsmd.getColumnName(i + 1);
            }
        }
        catch (SQLException sqe) {
            // empty catch block
        }
        return new ResultClassROF(requiredResultClass, resultFieldNames);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

