/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.request;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.jpox.ClassLoaderResolver;
import org.jpox.ManagedConnection;
import org.jpox.ObjectManager;
import org.jpox.StateManager;
import org.jpox.exceptions.JPOXDataStoreException;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.AbstractPropertyMetaData;
import org.jpox.metadata.InterfaceMetaData;
import org.jpox.store.DatastoreClass;
import org.jpox.store.OID;
import org.jpox.store.StatementExpressionIndex;
import org.jpox.store.mapping.InterfaceMapping;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.MappingCallbacks;
import org.jpox.store.mapping.MappingConsumer;
import org.jpox.store.mapping.Mappings;
import org.jpox.store.mapping.PersistenceCapableMapping;
import org.jpox.store.rdbms.RDBMSManager;
import org.jpox.store.rdbms.SQLController;
import org.jpox.store.rdbms.fieldmanager.ParameterSetter;
import org.jpox.store.rdbms.mapping.RDBMSMapping;
import org.jpox.store.rdbms.request.MappingStatementIndex;
import org.jpox.store.rdbms.request.VersionCheckRequest;
import org.jpox.util.JPOXLogger;
import org.jpox.util.StringUtils;

public class DeleteRequest
extends VersionCheckRequest {
    private final MappingCallbacks[] callbacks;
    private final String deleteStmt;
    private MappingStatementIndex mappingStatementIndex = new MappingStatementIndex();
    private final int[] pkFieldsToBeProvided;
    private final AbstractPropertyMetaData[] fieldsWithRelatedObjects;

    public DeleteRequest(DatastoreClass table, Class cls, ClassLoaderResolver clr) {
        super(table, cls, clr);
        DeleteMappingConsumer consumer = new DeleteMappingConsumer(clr, this.cmd);
        table.providePrimaryKeyMappings(consumer);
        table.provideDatastoreIdMappings(consumer);
        table.provideNonPrimaryKeyMappings(consumer);
        this.pkFieldsToBeProvided = consumer.getPrimaryKeyFieldsToBeProvided();
        this.callbacks = consumer.getMappingCallBacks().toArray(new MappingCallbacks[consumer.getMappingCallBacks().size()]);
        this.fieldsWithRelatedObjects = consumer.getFieldsWithRelatedObjects();
        this.deleteStmt = consumer.getStatement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(StateManager sm) {
        int i;
        if (JPOXLogger.PERSISTENCE.isDebugEnabled()) {
            JPOXLogger.PERSISTENCE.debug(LOCALISER.msg("RDBMS.Request.Delete", StringUtils.toJVMIDString(sm.getObject()), this.table));
        }
        ObjectManager om = sm.getObjectManager();
        boolean batch = false;
        for (i = 0; i < this.callbacks.length; ++i) {
            this.callbacks[i].preDelete(sm);
        }
        if (this.fieldsWithRelatedObjects != null && this.fieldsWithRelatedObjects.length > 0) {
            for (i = 0; i < this.fieldsWithRelatedObjects.length; ++i) {
                AbstractPropertyMetaData relatedFmd = this.fieldsWithRelatedObjects[i];
                this.updateRelatedObjectsForField(sm, relatedFmd);
            }
        }
        RDBMSManager storeMgr = (RDBMSManager)om.getStoreManager();
        try {
            ManagedConnection mconn = storeMgr.getConnection(om);
            Connection conn = (Connection)mconn.getConnection();
            SQLController sqlControl = storeMgr.getSQLController();
            try {
                if (om.getTransaction().getOptimistic()) {
                    this.performVersionCheckForObject(sm, conn, sqlControl);
                }
                PreparedStatement ps = sqlControl.getStatementForUpdate(conn, this.deleteStmt, batch);
                try {
                    if (sm.getInternalObjectId() instanceof OID) {
                        this.table.getDataStoreObjectIdMapping().setObject(om, ps, this.mappingStatementIndex.getDatastoreId().getParameterIndex(), sm.getInternalObjectId());
                    } else {
                        sm.provideFields(this.pkFieldsToBeProvided, new ParameterSetter(sm, ps, this.mappingStatementIndex.getPrimaryKeys(), true));
                    }
                    sqlControl.executeStatementUpdate(conn, this.deleteStmt, ps, !batch);
                }
                finally {
                    sqlControl.closeStatement(conn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new JPOXDataStoreException("Delete request failed: " + this.deleteStmt, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRelatedObjectsForField(StateManager sm, AbstractPropertyMetaData fmd) {
        AbstractPropertyMetaData relatedFmd = fmd.getRelatedFieldMetaData(sm.getObjectManager().getClassLoaderResolver());
        String fullClassName = ((AbstractClassMetaData)relatedFmd.getParent()).getFullClassName();
        String[] classes = (AbstractClassMetaData)relatedFmd.getParent() instanceof InterfaceMetaData ? sm.getStoreManager().getMetaDataManager().getClassesImplementingInterface(fullClassName, sm.getObjectManager().getClassLoaderResolver()) : new String[]{fullClassName};
        HashSet<DatastoreClass> datastoreClasses = new HashSet<DatastoreClass>();
        for (int i = 0; i < classes.length; ++i) {
            datastoreClasses.add(sm.getStoreManager().getDatastoreClass(classes[i], sm.getObjectManager().getClassLoaderResolver()));
        }
        ObjectManager om = sm.getObjectManager();
        RDBMSManager storeMgr = (RDBMSManager)om.getStoreManager();
        Iterator it = datastoreClasses.iterator();
        while (it.hasNext()) {
            int j;
            DatastoreClass refTable = (DatastoreClass)it.next();
            JavaTypeMapping refMapping = refTable.getFieldMapping(fmd.getMappedBy());
            if (!refMapping.isNullable()) continue;
            StringBuffer clearLinkStmt = new StringBuffer("UPDATE " + ((Object)refTable).toString() + " SET ");
            for (j = 0; j < refMapping.getNumberOfDatastoreFields(); ++j) {
                if (j > 0) {
                    clearLinkStmt.append(",");
                }
                clearLinkStmt.append(refMapping.getDataStoreMapping(j).getDatastoreField().getIdentifier());
                clearLinkStmt.append("=NULL");
            }
            clearLinkStmt.append(" WHERE ");
            for (j = 0; j < refMapping.getNumberOfDatastoreFields(); ++j) {
                if (j > 0) {
                    clearLinkStmt.append(" AND ");
                }
                clearLinkStmt.append(refMapping.getDataStoreMapping(j).getDatastoreField().toString());
                clearLinkStmt.append("=?");
            }
            try {
                ManagedConnection mconn = storeMgr.getConnection(om);
                Connection conn = (Connection)mconn.getConnection();
                SQLController sqlControl = storeMgr.getSQLController();
                try {
                    PreparedStatement ps = null;
                    try {
                        ps = sqlControl.getStatementForUpdate(conn, clearLinkStmt.toString(), false);
                        refMapping.setObject(om, ps, Mappings.getParametersIndex(1, refMapping), sm.getObject());
                        sqlControl.executeStatementUpdate(conn, clearLinkStmt.toString(), ps, true);
                    }
                    finally {
                        if (ps == null) continue;
                        sqlControl.closeStatement(conn, ps);
                    }
                }
                finally {
                    mconn.release();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new JPOXDataStoreException("Update request failed", e);
            }
        }
    }

    private class DeleteMappingConsumer
    implements MappingConsumer {
        boolean initialized = false;
        StringBuffer where = new StringBuffer();
        int paramIndex = 1;
        private List pkbp = new ArrayList();
        private List fwro = new ArrayList();
        private List mc = new ArrayList();
        private final ClassLoaderResolver clr;
        private final AbstractClassMetaData cmd;

        public DeleteMappingConsumer(ClassLoaderResolver clr, AbstractClassMetaData cmd) {
            this.clr = clr;
            this.cmd = cmd;
            this.paramIndex = 1;
        }

        public void preConsumeMapping(int highest) {
            if (!this.initialized) {
                DeleteRequest.this.mappingStatementIndex.setPrimaryKeys(new StatementExpressionIndex[highest]);
                DeleteRequest.this.mappingStatementIndex.setFields(new StatementExpressionIndex[highest]);
                this.initialized = true;
            }
        }

        public void consumeMapping(JavaTypeMapping m, AbstractPropertyMetaData fmd) {
            if (!fmd.getAbstractClassMetaData().isSameOrAncestorOf(this.cmd)) {
                return;
            }
            if (m.includeInUpdateStatement()) {
                if (fmd.isPrimaryKey()) {
                    Integer abs_field_num = new Integer(fmd.getAbsoluteFieldNumber());
                    int[] parametersIndex = new int[m.getNumberOfDatastoreFields()];
                    StatementExpressionIndex sei = new StatementExpressionIndex();
                    sei.setMapping(m);
                    sei.setParameterIndex(parametersIndex);
                    ((DeleteRequest)DeleteRequest.this).mappingStatementIndex.getPrimaryKeys()[fmd.getAbsoluteFieldNumber()] = sei;
                    for (int j = 0; j < parametersIndex.length; ++j) {
                        if (this.where.length() > 0) {
                            this.where.append(" AND ");
                        }
                        String condition = m.getDataStoreMapping(j).getDatastoreField().getIdentifier() + "=" + ((RDBMSMapping)m.getDataStoreMapping(j)).getUpdateInputParameter();
                        this.where.append(condition);
                        if (!this.pkbp.contains(abs_field_num)) {
                            this.pkbp.add(abs_field_num);
                        }
                        ++this.paramIndex;
                    }
                } else if (m.getNumberOfDatastoreFields() == 0 && (m instanceof PersistenceCapableMapping || m instanceof InterfaceMapping)) {
                    int relationType = fmd.getRelationType(this.clr);
                    if (relationType == 2) {
                        if (fmd.getMappedBy() != null) {
                            this.fwro.add(fmd);
                        }
                    } else if (relationType == 6) {
                        AbstractPropertyMetaData relatedFmd = fmd.getRelatedFieldMetaData(this.clr);
                        if (fmd.getJoinMetaData() != null || relatedFmd.getJoinMetaData() != null) {
                            // empty if block
                        }
                    }
                }
            }
            if (m instanceof MappingCallbacks) {
                this.mc.add(m);
            }
        }

        public void consumeMapping(JavaTypeMapping m, int mappingType) {
            if (mappingType == 2) {
                this.where.append(((Object)m.getDataStoreMapping(0).getDatastoreField().getIdentifier()).toString());
                this.where.append("=");
                this.where.append(((RDBMSMapping)m.getDataStoreMapping(0)).getUpdateInputParameter());
                int[] param = new int[]{this.paramIndex++};
                DeleteRequest.this.mappingStatementIndex.getDatastoreId().setParameterIndex(param);
            }
        }

        public int[] getPrimaryKeyFieldsToBeProvided() {
            int[] pkfieldsToBeProvided = new int[this.pkbp.size()];
            for (int i = 0; i < this.pkbp.size(); ++i) {
                pkfieldsToBeProvided[i] = (Integer)this.pkbp.get(i);
            }
            return pkfieldsToBeProvided;
        }

        public AbstractPropertyMetaData[] getFieldsWithRelatedObjects() {
            AbstractPropertyMetaData[] fieldsWithRelatedObjects = new AbstractPropertyMetaData[this.fwro.size()];
            for (int i = 0; i < this.fwro.size(); ++i) {
                fieldsWithRelatedObjects[i] = (AbstractPropertyMetaData)this.fwro.get(i);
            }
            return fieldsWithRelatedObjects;
        }

        public List getMappingCallBacks() {
            return this.mc;
        }

        public String getStatement() {
            return "DELETE FROM " + ((Object)DeleteRequest.this.table).toString() + " WHERE " + this.where;
        }
    }
}

