/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.request;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jpox.ManagedConnection;
import org.jpox.ObjectManager;
import org.jpox.StateManager;
import org.jpox.exceptions.JPOXDataStoreException;
import org.jpox.exceptions.JPOXObjectNotFoundException;
import org.jpox.metadata.AbstractPropertyMetaData;
import org.jpox.store.DatastoreClass;
import org.jpox.store.DatastoreField;
import org.jpox.store.FetchStatement;
import org.jpox.store.OID;
import org.jpox.store.StatementExpressionIndex;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.MappingConsumer;
import org.jpox.store.rdbms.RDBMSFetchStatement;
import org.jpox.store.rdbms.RDBMSManager;
import org.jpox.store.rdbms.SQLController;
import org.jpox.store.rdbms.fieldmanager.ParameterSetter;
import org.jpox.store.rdbms.request.MappingStatementIndex;
import org.jpox.store.rdbms.request.Request;
import org.jpox.util.JPOXLogger;

public class LocateRequest
extends Request {
    private final MappingStatementIndex mappingStatementIndex = new MappingStatementIndex();
    private final String locateStmt;
    private final int[] pkFieldsToBeProvided;

    public LocateRequest(DatastoreClass table) {
        super(table);
        RDBMSFetchStatement fetchStmt = new RDBMSFetchStatement(table);
        FetchMappingConsumer consumer = new FetchMappingConsumer(fetchStmt);
        fetchStmt.select("1");
        table.provideDatastoreIdMappings(consumer);
        table.providePrimaryKeyMappings(consumer);
        this.locateStmt = ((Object)fetchStmt).toString();
        this.pkFieldsToBeProvided = consumer.getPrimaryKeyFieldsToBeProvided();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(StateManager sm) {
        if (this.locateStmt != null) {
            ObjectManager om = sm.getObjectManager();
            RDBMSManager storeMgr = (RDBMSManager)om.getStoreManager();
            try {
                ManagedConnection mconn = storeMgr.getConnection(om);
                Connection conn = (Connection)mconn.getConnection();
                SQLController sqlControl = storeMgr.getSQLController();
                try {
                    PreparedStatement ps = sqlControl.getStatementForQuery(conn, this.locateStmt);
                    try {
                        if (sm.getInternalObjectId() instanceof OID) {
                            this.table.getDataStoreObjectIdMapping().setObject(om, ps, this.mappingStatementIndex.getDatastoreId().getParameterIndex(), sm.getInternalObjectId());
                        } else {
                            sm.provideFields(this.pkFieldsToBeProvided, new ParameterSetter(sm, ps, this.mappingStatementIndex.getFields(), false));
                        }
                        ResultSet rs = sqlControl.executeStatementQuery(conn, this.locateStmt, ps);
                        try {
                            if (!rs.next()) {
                                JPOXLogger.RDBMS_SQL.warn(LOCALISER.msg("RDBMS.Manager.ObjectWithIdNotFound", sm.getInternalObjectId()));
                                throw new JPOXObjectNotFoundException("No such database row", sm.getInternalObjectId());
                            }
                        }
                        finally {
                            rs.close();
                        }
                    }
                    finally {
                        sqlControl.closeStatement(conn, ps);
                    }
                }
                finally {
                    mconn.release();
                }
            }
            catch (SQLException e) {
                throw new JPOXDataStoreException("Locate request failed: " + this.locateStmt, e);
            }
        }
    }

    private class FetchMappingConsumer
    implements MappingConsumer {
        private int paramIndex = 1;
        final FetchStatement fetchStmt;
        List pkbp = new ArrayList();
        boolean initialized = false;

        public FetchMappingConsumer(FetchStatement fetchStmt) {
            this.fetchStmt = fetchStmt;
        }

        public void preConsumeMapping(int highestFieldNumber) {
            if (!this.initialized) {
                LocateRequest.this.mappingStatementIndex.setPrimaryKeys(new StatementExpressionIndex[highestFieldNumber]);
                LocateRequest.this.mappingStatementIndex.setFields(new StatementExpressionIndex[highestFieldNumber]);
                this.initialized = true;
            }
        }

        public void consumeMapping(JavaTypeMapping m, AbstractPropertyMetaData fmd) {
            if (m.includeInFetchStatement()) {
                ((LocateRequest)LocateRequest.this).mappingStatementIndex.getFields()[fmd.getAbsoluteFieldNumber()] = new StatementExpressionIndex();
                LocateRequest.this.mappingStatementIndex.getFields()[fmd.getAbsoluteFieldNumber()].setMapping(m);
                if (fmd.isPrimaryKey()) {
                    int[] parametersIndex = new int[m.getNumberOfDatastoreFields()];
                    for (int j = 0; j < parametersIndex.length; ++j) {
                        this.fetchStmt.andCondition(this.fetchStmt.referenceDatastoreField(m.getDataStoreMapping(j).getDatastoreField()) + " = ?");
                        this.pkbp.add(new Integer(fmd.getAbsoluteFieldNumber()));
                        ++this.paramIndex;
                    }
                    LocateRequest.this.mappingStatementIndex.getFields()[fmd.getAbsoluteFieldNumber()].setParameterIndex(parametersIndex);
                }
            }
        }

        public void consumeMapping(JavaTypeMapping m, int mappingType) {
            if (mappingType == 2) {
                this.fetchStmt.andCondition(this.fetchStmt.referenceDatastoreField((DatastoreField)LocateRequest.this.key.getColumns().get(0)) + " = ?");
                int[] nArray = new int[]{this.paramIndex++};
                LocateRequest.this.mappingStatementIndex.getDatastoreId().setParameterIndex(nArray);
            }
        }

        public int[] getPrimaryKeyFieldsToBeProvided() {
            int[] pkfieldsToBeProvided = new int[this.pkbp.size()];
            for (int i = 0; i < this.pkbp.size(); ++i) {
                pkfieldsToBeProvided[i] = (Integer)this.pkbp.get(i);
            }
            return pkfieldsToBeProvided;
        }
    }
}

