/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.scostore;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.jpox.ClassLoaderResolver;
import org.jpox.ManagedConnection;
import org.jpox.ObjectManager;
import org.jpox.StateManager;
import org.jpox.Transaction;
import org.jpox.exceptions.JPOXDataStoreException;
import org.jpox.store.StoreManager;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.mapping.EmbeddedElementPCMapping;
import org.jpox.store.mapping.ReferenceMapping;
import org.jpox.store.mapping.SerialisedPCMapping;
import org.jpox.store.mapping.SerialisedReferenceMapping;
import org.jpox.store.query.ResultObjectFactory;
import org.jpox.store.rdbms.SQLController;
import org.jpox.store.rdbms.SQLWarnings;
import org.jpox.store.rdbms.mapping.RDBMSMapping;
import org.jpox.store.rdbms.scostore.AbstractCollectionStore;
import org.jpox.store.rdbms.table.JoinTable;
import org.jpox.store.scostore.ListStore;

abstract class AbstractListStore
extends AbstractCollectionStore
implements ListStore {
    protected String listName;
    protected String addStmt;
    protected String removeAtStmt;
    protected String setStmt;
    protected String shiftStmt;
    protected String indexOfStmt;
    protected String lastIndexOfStmt;
    protected boolean indexedList = true;

    protected AbstractListStore(StoreManager storeMgr, ClassLoaderResolver clr) {
        super(storeMgr, clr);
    }

    protected void initialiseStatements() {
        super.initialiseStatements();
        this.addStmt = this.getAddStmt();
        if (this.indexedList) {
            this.removeAtStmt = this.getRemoveAtStmt();
            this.indexOfStmt = this.getIndexOfStmt();
            this.lastIndexOfStmt = this.getLastIndexOfStmt();
            this.setStmt = this.getSetStmt();
            this.shiftStmt = this.getShiftStmt();
        }
    }

    public Iterator iterator(StateManager sm) {
        return this.listIterator(sm);
    }

    public ListIterator listIterator(StateManager sm) {
        return this.listIterator(sm, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListIterator listIterator(StateManager ownerSM, int start) {
        ListStoreIterator iter;
        QueryExpression stmt = null;
        stmt = start >= 0 ? this.getIteratorStatement(ownerSM, start, -1) : this.getIteratorStatement(ownerSM, -1, -1);
        ResultObjectFactory rof = this.newResultObjectFactory(ownerSM, stmt, false, true);
        ObjectManager om = ownerSM.getObjectManager();
        Transaction tx = om.getTransaction();
        boolean useUpdateLock = (Boolean)tx.getOptions().get("transaction.serializeReadObjects");
        String statement = stmt.toStatementText(useUpdateLock).toString();
        try {
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            Connection conn = (Connection)mconn.getConnection();
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = stmt.toStatementText(useUpdateLock).prepareStatement(om, conn);
                try {
                    ResultSet rs = sqlControl.executeStatementQuery(conn, statement, ps);
                    try {
                        iter = new ListStoreIterator(ownerSM, rs, rof);
                    }
                    finally {
                        rs.close();
                    }
                }
                finally {
                    sqlControl.closeStatement(conn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.SCO.IteratorRequestFailed", statement), e);
        }
        return iter;
    }

    public boolean add(StateManager sm, Object element) {
        return this.internalAdd(sm, 0, true, Collections.singleton(element), false);
    }

    public void add(StateManager sm, int index, Object element) {
        this.internalAdd(sm, index, false, Collections.singleton(element), false);
    }

    public boolean addAll(StateManager sm, Collection elements) {
        return this.internalAdd(sm, 0, true, elements, false);
    }

    public boolean addAll(StateManager sm, int index, Collection c) {
        return this.internalAdd(sm, index, false, c, false);
    }

    public boolean addAll(StateManager sm, Collection c, boolean initialising) {
        return this.internalAdd(sm, 0, false, c, initialising);
    }

    public Object get(StateManager sm, int index) {
        List list = this.internalGetRange(sm, index, index);
        if (list == null || list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    public int indexOf(StateManager sm, Object element) {
        return this.internalIndexOf(sm, element, this.indexOfStmt);
    }

    public int lastIndexOf(StateManager sm, Object element) {
        return this.internalIndexOf(sm, element, this.lastIndexOfStmt);
    }

    public boolean remove(StateManager sm, Object element) {
        if (!this.validateElementForReading(sm, element)) {
            return false;
        }
        ArrayList<Object> elements = new ArrayList<Object>();
        elements.add(element);
        int[] indices = this.getIndicesOf(sm, elements);
        boolean modified = false;
        for (int i = 0; i < indices.length; ++i) {
            this.removeAt(sm, indices[i]);
            modified = true;
        }
        if (this.ownerFieldMetaData.getCollection().isDependentElement()) {
            sm.getObjectManager().deleteObject(element);
        }
        return modified;
    }

    public boolean removeAll(StateManager sm, Collection elements) {
        if (elements == null || elements.size() == 0) {
            return false;
        }
        boolean modified = false;
        int[] indices = this.getIndicesOf(sm, elements);
        for (int i = 0; i < indices.length; ++i) {
            this.removeAt(sm, indices[i]);
            modified = true;
        }
        if (this.ownerFieldMetaData.getCollection().isDependentElement()) {
            sm.getObjectManager().deleteObjects(elements.toArray());
        }
        return modified;
    }

    public Object remove(StateManager sm, int index) {
        Object element = this.get(sm, index);
        this.removeAt(sm, index);
        if (this.ownerFieldMetaData.getCollection().isDependentElement() && !this.contains(sm, element)) {
            sm.getObjectManager().deleteObject(element);
        }
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object set(StateManager sm, int index, Object element, boolean allowDependentField) {
        this.validateElementForWriting(sm, element);
        Object o = this.get(sm, index);
        try {
            ObjectManager om = sm.getObjectManager();
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            Connection conn = (Connection)mconn.getConnection();
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForUpdate(conn, this.setStmt, false);
                try {
                    int jdbcPosition = 1;
                    jdbcPosition = this.populateElementInStatement(om, ps, element, jdbcPosition);
                    jdbcPosition = this.populateOwnerInStatement(sm, om, ps, jdbcPosition);
                    jdbcPosition = this.populateOrderInStatement(om, ps, index, jdbcPosition);
                    if (this.relationDiscriminatorMapping != null) {
                        jdbcPosition = this.populateRelationDiscriminatorInStatement(om, ps, jdbcPosition);
                    }
                    sqlControl.executeStatementUpdate(conn, this.setStmt, ps, true);
                }
                finally {
                    sqlControl.closeStatement(conn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.SCO.SetRequestFailed", this.setStmt), e);
        }
        if (this.ownerFieldMetaData.getCollection().isDependentElement() && allowDependentField && o != null && !this.contains(sm, o)) {
            sm.getObjectManager().deleteObject(o);
        }
        return o;
    }

    public List subList(StateManager sm, int start, int end) {
        return this.internalGetRange(sm, start, end);
    }

    protected String getIndexOfStmt() {
        int i;
        StringBuffer stmt = new StringBuffer();
        stmt.append("SELECT ");
        for (i = 0; i < this.orderMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(",");
            }
            stmt.append(((Object)this.orderMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
        }
        stmt.append(" FROM ");
        stmt.append(this.containerTable.toString());
        stmt.append(" WHERE ");
        for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(" AND ");
            }
            stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        for (i = 0; i < this.elementMapping.getNumberOfDatastoreFields(); ++i) {
            stmt.append(" AND ");
            stmt.append(((Object)this.elementMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.elementMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        if (this.relationDiscriminatorMapping != null) {
            for (i = 0; i < this.relationDiscriminatorMapping.getNumberOfDatastoreFields(); ++i) {
                stmt.append(" AND ");
                stmt.append(((Object)this.relationDiscriminatorMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)this.relationDiscriminatorMapping.getDataStoreMapping(i)).getUpdateInputParameter());
            }
        }
        stmt.append(" ORDER BY ");
        for (i = 0; i < this.orderMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(",");
            }
            stmt.append(((Object)this.orderMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
        }
        return stmt.toString();
    }

    protected String getLastIndexOfStmt() {
        int i;
        StringBuffer stmt = new StringBuffer();
        stmt.append("SELECT ");
        for (i = 0; i < this.orderMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(",");
            }
            stmt.append(((Object)this.orderMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
        }
        stmt.append(" FROM ");
        stmt.append(this.containerTable.toString());
        stmt.append(" WHERE ");
        for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(" AND ");
            }
            stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        for (i = 0; i < this.elementMapping.getNumberOfDatastoreFields(); ++i) {
            stmt.append(" AND ");
            stmt.append(((Object)this.elementMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.elementMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        if (this.relationDiscriminatorMapping != null) {
            for (i = 0; i < this.relationDiscriminatorMapping.getNumberOfDatastoreFields(); ++i) {
                stmt.append(" AND ");
                stmt.append(((Object)this.relationDiscriminatorMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)this.relationDiscriminatorMapping.getDataStoreMapping(i)).getUpdateInputParameter());
            }
        }
        stmt.append(" ORDER BY ");
        for (i = 0; i < this.orderMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(",");
            }
            stmt.append(((Object)this.orderMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            stmt.append(" DESC ");
        }
        return stmt.toString();
    }

    protected String getRemoveAtStmt() {
        int i;
        StringBuffer stmt = new StringBuffer();
        stmt.append("DELETE FROM ");
        stmt.append(this.containerTable.toString());
        stmt.append(" WHERE ");
        for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(" AND ");
            }
            stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        for (i = 0; i < this.orderMapping.getNumberOfDatastoreFields(); ++i) {
            stmt.append(" AND ");
            stmt.append(((Object)this.orderMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.orderMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        if (this.relationDiscriminatorMapping != null) {
            for (i = 0; i < this.relationDiscriminatorMapping.getNumberOfDatastoreFields(); ++i) {
                stmt.append(" AND ");
                stmt.append(((Object)this.relationDiscriminatorMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)this.relationDiscriminatorMapping.getDataStoreMapping(i)).getUpdateInputParameter());
            }
        }
        return stmt.toString();
    }

    protected String getSetStmt() {
        int i;
        StringBuffer stmt = new StringBuffer();
        stmt.append("UPDATE ");
        stmt.append(this.containerTable.toString());
        stmt.append(" SET ");
        for (i = 0; i < this.elementMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(",");
            }
            stmt.append(((Object)this.elementMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.elementMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        stmt.append(" WHERE ");
        for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(" AND ");
            }
            stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        for (i = 0; i < this.orderMapping.getNumberOfDatastoreFields(); ++i) {
            stmt.append(" AND ");
            stmt.append(((Object)this.orderMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.orderMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        if (this.relationDiscriminatorMapping != null) {
            for (i = 0; i < this.relationDiscriminatorMapping.getNumberOfDatastoreFields(); ++i) {
                stmt.append(" AND ");
                stmt.append(((Object)this.relationDiscriminatorMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)this.relationDiscriminatorMapping.getDataStoreMapping(i)).getUpdateInputParameter());
            }
        }
        return stmt.toString();
    }

    protected String getShiftStmt() {
        int i;
        StringBuffer stmt = new StringBuffer();
        stmt.append("UPDATE ");
        stmt.append(this.containerTable.toString());
        stmt.append(" SET ");
        for (i = 0; i < this.orderMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(",");
            }
            stmt.append(((Object)this.orderMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.orderMapping.getDataStoreMapping(i)).getUpdateInputParameter());
            stmt.append(" + ");
            stmt.append(((Object)this.orderMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
        }
        stmt.append(" WHERE ");
        for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(" AND ");
            }
            stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        for (i = 0; i < this.orderMapping.getNumberOfDatastoreFields(); ++i) {
            stmt.append(" AND ");
            stmt.append(((Object)this.orderMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.orderMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        if (this.relationDiscriminatorMapping != null) {
            for (i = 0; i < this.relationDiscriminatorMapping.getNumberOfDatastoreFields(); ++i) {
                stmt.append(" AND ");
                stmt.append(((Object)this.relationDiscriminatorMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)this.relationDiscriminatorMapping.getDataStoreMapping(i)).getUpdateInputParameter());
            }
        }
        return stmt.toString();
    }

    protected String getIndicesOfStmt(Collection elements) {
        int i;
        StringBuffer stmt = new StringBuffer();
        stmt.append("SELECT ");
        for (int i2 = 0; i2 < this.orderMapping.getNumberOfDatastoreFields(); ++i2) {
            if (i2 > 0) {
                stmt.append(",");
            }
            stmt.append(((Object)this.orderMapping.getDataStoreMapping(i2).getDatastoreField().getIdentifier()).toString());
        }
        stmt.append(" FROM ");
        stmt.append(this.containerTable.toString());
        stmt.append(" WHERE ");
        Iterator iter = elements.iterator();
        boolean first_element = true;
        while (iter.hasNext()) {
            iter.next();
            if (!first_element) {
                stmt.append(" OR (");
            } else {
                stmt.append("(");
            }
            for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
                if (i > 0) {
                    stmt.append(" AND ");
                }
                stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
            }
            for (i = 0; i < this.elementMapping.getNumberOfDatastoreFields(); ++i) {
                stmt.append(" AND ");
                stmt.append(((Object)this.elementMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)this.elementMapping.getDataStoreMapping(i)).getUpdateInputParameter());
            }
            if (this.relationDiscriminatorMapping != null) {
                for (i = 0; i < this.relationDiscriminatorMapping.getNumberOfDatastoreFields(); ++i) {
                    stmt.append(" AND ");
                    stmt.append(((Object)this.relationDiscriminatorMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                    stmt.append(" = ");
                    stmt.append(((RDBMSMapping)this.relationDiscriminatorMapping.getDataStoreMapping(i)).getUpdateInputParameter());
                }
            }
            stmt.append(")");
            first_element = false;
        }
        stmt.append(" ORDER BY ");
        for (i = 0; i < this.orderMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(",");
            }
            stmt.append(((Object)this.orderMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            stmt.append(" DESC");
        }
        return stmt.toString();
    }

    protected void prepareIndicesOfStmt(StateManager sm, PreparedStatement ps, Collection elements) {
        if (elements == null || elements.size() == 0) {
            return;
        }
        ObjectManager om = sm.getObjectManager();
        Iterator iter = elements.iterator();
        int jdbcPosition = 1;
        while (iter.hasNext()) {
            Object element = iter.next();
            jdbcPosition = this.populateOwnerInStatement(sm, om, ps, jdbcPosition);
            jdbcPosition = this.populateElementInStatement(om, ps, element, jdbcPosition);
            if (this.relationDiscriminatorMapping == null) continue;
            jdbcPosition = this.populateRelationDiscriminatorInStatement(om, ps, jdbcPosition);
        }
    }

    protected void removeAt(StateManager sm, int index) {
        this.internalRemoveAt(sm, index, this.removeAtStmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalRemoveAt(StateManager sm, int index, String stmt) {
        int size = this.size(sm);
        ObjectManager om = sm.getObjectManager();
        try {
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            Connection conn = (Connection)mconn.getConnection();
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForUpdate(conn, stmt, false);
                try {
                    int[] rowsDeleted;
                    int jdbcPosition = 1;
                    jdbcPosition = this.populateOwnerInStatement(sm, om, ps, jdbcPosition);
                    jdbcPosition = this.populateOrderInStatement(om, ps, index, jdbcPosition);
                    if (this.relationDiscriminatorMapping != null) {
                        jdbcPosition = this.populateRelationDiscriminatorInStatement(om, ps, jdbcPosition);
                    }
                    if ((rowsDeleted = sqlControl.executeStatementUpdate(conn, stmt, ps, true))[0] == 0) {
                        // empty if block
                    }
                }
                finally {
                    sqlControl.closeStatement(conn, ps);
                }
                if (index != size - 1) {
                    for (int i = index + 1; i < size; ++i) {
                        this.internalShift(sm, conn, false, i, -1, true);
                    }
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.SCO.RemoveRequestFailed", stmt), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean internalAdd(StateManager sm, int start, boolean atEnd, Collection c, boolean initialising) {
        if (c == null || c.size() == 0) {
            return true;
        }
        int shift = c.size();
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            this.validateElementForWriting(sm, iter.next());
        }
        int currentListSize = 0;
        if (!initialising) {
            currentListSize = this.size(sm);
        }
        try {
            ObjectManager om = sm.getObjectManager();
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            Connection conn = (Connection)mconn.getConnection();
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                if (!atEnd && start != currentListSize) {
                    boolean batched = currentListSize - start > 0;
                    for (int i = currentListSize - 1; i >= start; --i) {
                        this.internalShift(sm, conn, batched, i, shift, i == start);
                    }
                } else {
                    start = currentListSize;
                }
                int jdbcPosition = 1;
                boolean batched = c.size() > 1;
                iter = c.iterator();
                while (iter.hasNext()) {
                    Object element = iter.next();
                    PreparedStatement ps = sqlControl.getStatementForUpdate(conn, this.addStmt, batched);
                    try {
                        jdbcPosition = 1;
                        jdbcPosition = this.populateOwnerInStatement(sm, om, ps, jdbcPosition);
                        jdbcPosition = this.populateElementInStatement(om, ps, element, jdbcPosition);
                        if (this.orderMapping != null) {
                            jdbcPosition = this.populateOrderInStatement(om, ps, start, jdbcPosition);
                        }
                        if (this.relationDiscriminatorMapping != null) {
                            jdbcPosition = this.populateRelationDiscriminatorInStatement(om, ps, jdbcPosition);
                        }
                        ++start;
                        sqlControl.executeStatementUpdate(conn, this.addStmt, ps, !iter.hasNext());
                    }
                    finally {
                        sqlControl.closeStatement(conn, ps);
                    }
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.SCO.AddRequestFailed", this.addStmt), e);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int[] internalShift(StateManager ownerSM, Connection conn, boolean batched, int oldIndex, int amount, boolean executeNow) throws SQLException {
        ObjectManager om = ownerSM.getObjectManager();
        SQLController sqlControl = this.storeMgr.getSQLController();
        PreparedStatement ps = sqlControl.getStatementForUpdate(conn, this.shiftStmt, false);
        try {
            int jdbcPosition = 1;
            jdbcPosition = this.populateOrderInStatement(om, ps, amount, jdbcPosition);
            jdbcPosition = this.populateOwnerInStatement(ownerSM, om, ps, jdbcPosition);
            jdbcPosition = this.populateOrderInStatement(om, ps, oldIndex, jdbcPosition);
            if (this.relationDiscriminatorMapping != null) {
                jdbcPosition = this.populateRelationDiscriminatorInStatement(om, ps, jdbcPosition);
            }
            int[] nArray = sqlControl.executeStatementUpdate(conn, this.shiftStmt, ps, executeNow);
            return nArray;
        }
        finally {
            sqlControl.closeStatement(conn, ps);
        }
    }

    /*
     * Exception decompiling
     */
    private int internalIndexOf(StateManager sm, Object element, String stmt) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int[] getIndicesOf(StateManager sm, Collection elements) {
        if (elements == null || elements.size() == 0) {
            return null;
        }
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            this.validateElementForReading(sm, element);
        }
        String stmt = this.getIndicesOfStmt(elements);
        int[] indices = new int[elements.size()];
        try {
            ObjectManager om = sm.getObjectManager();
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            Connection conn = (Connection)mconn.getConnection();
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForUpdate(conn, stmt, false);
                try {
                    this.prepareIndicesOfStmt(sm, ps, elements);
                    ResultSet rs = sqlControl.executeStatementQuery(conn, stmt, ps);
                    try {
                        int i = 0;
                        while (rs.next()) {
                            indices[i++] = rs.getInt(1);
                        }
                        if (i < elements.size()) {
                            throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.SCO.GetIndicesFailed.InvalidElements", stmt));
                        }
                        SQLWarnings.log(rs);
                    }
                    finally {
                        rs.close();
                    }
                }
                finally {
                    sqlControl.closeStatement(conn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.SCO.IndicesofRequestFailed", stmt), e);
        }
        return indices;
    }

    protected abstract QueryExpression getIteratorStatement(StateManager var1, int var2, int var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List internalGetRange(StateManager sm, int start, int end) {
        ArrayList<Object> list = new ArrayList<Object>();
        ObjectManager om = sm.getObjectManager();
        QueryExpression stmt = this.getIteratorStatement(sm, start, end);
        ResultObjectFactory getROF = this.newResultObjectFactory(sm, stmt, false, true);
        Transaction tx = om.getTransaction();
        boolean useUpdateLock = (Boolean)tx.getOptions().get("transaction.serializeReadObjects");
        String statement = stmt.toStatementText(useUpdateLock).toString();
        try {
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            Connection conn = (Connection)mconn.getConnection();
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = stmt.toStatementText(useUpdateLock).prepareStatement(om, conn);
                try {
                    ResultSet rs = sqlControl.executeStatementQuery(conn, statement, ps);
                    try {
                        while (rs.next()) {
                            int i;
                            int[] param;
                            Object obj = null;
                            if (this.elementsAreEmbedded) {
                                param = new int[this.elementMapping.getNumberOfDatastoreFields()];
                                for (i = 0; i < param.length; ++i) {
                                    param[i] = i + 1;
                                }
                                obj = this.elementMapping.getObject(om, rs, param);
                            } else if (this.elementMapping instanceof ReferenceMapping) {
                                param = new int[this.elementMapping.getNumberOfDatastoreFields()];
                                for (i = 0; i < param.length; ++i) {
                                    param[i] = i + 1;
                                }
                                obj = this.elementMapping.getObject(om, rs, param);
                            } else {
                                obj = getROF.getObject(om, rs);
                            }
                            list.add(obj);
                        }
                        SQLWarnings.log(rs);
                    }
                    finally {
                        rs.close();
                    }
                }
                finally {
                    sqlControl.closeStatement(conn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.SCO.GetRequestFailed", statement), e);
        }
        return list;
    }

    private class ListStoreIterator
    implements ListIterator {
        private final StateManager sm;
        private final ObjectManager om;
        private final ListIterator delegate;
        private Object lastElement = null;
        private int currentIndex = -1;

        public ListStoreIterator(StateManager sm, ResultSet rs, ResultObjectFactory rof) throws SQLException {
            this.sm = sm;
            this.om = sm.getObjectManager();
            ArrayList<Object> results = new ArrayList<Object>();
            if (rs != null) {
                while (rs.next()) {
                    Object nextElement;
                    int i;
                    int[] param;
                    if (AbstractListStore.this.elementsAreEmbedded || AbstractListStore.this.elementsAreSerialised) {
                        param = new int[AbstractListStore.this.elementMapping.getNumberOfDatastoreFields()];
                        for (i = 0; i < param.length; ++i) {
                            param[i] = i + 1;
                        }
                        if (AbstractListStore.this.elementMapping instanceof SerialisedPCMapping || AbstractListStore.this.elementMapping instanceof SerialisedReferenceMapping || AbstractListStore.this.elementMapping instanceof EmbeddedElementPCMapping) {
                            int ownerFieldNumber = -1;
                            if (AbstractListStore.this.containerTable != null) {
                                ownerFieldNumber = ((JoinTable)AbstractListStore.this.containerTable).getOwnerFieldMetaData().getAbsoluteFieldNumber();
                            }
                            nextElement = AbstractListStore.this.elementMapping.getObject(this.om, rs, param, sm, ownerFieldNumber);
                        } else {
                            nextElement = AbstractListStore.this.elementMapping.getObject(this.om, rs, param);
                        }
                    } else if (AbstractListStore.this.elementMapping instanceof ReferenceMapping) {
                        param = new int[AbstractListStore.this.elementMapping.getNumberOfDatastoreFields()];
                        for (i = 0; i < param.length; ++i) {
                            param[i] = i + 1;
                        }
                        nextElement = AbstractListStore.this.elementMapping.getObject(this.om, rs, param);
                    } else {
                        nextElement = rof.getObject(this.om, rs);
                    }
                    results.add(nextElement);
                }
            }
            this.delegate = results.listIterator();
        }

        public void add(Object o) {
            this.currentIndex = this.delegate.nextIndex();
            AbstractListStore.this.add(this.sm, this.currentIndex, o);
            this.delegate.add(o);
            this.lastElement = null;
        }

        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        public boolean hasPrevious() {
            return this.delegate.hasPrevious();
        }

        public Object next() {
            this.currentIndex = this.delegate.nextIndex();
            this.lastElement = this.delegate.next();
            return this.lastElement;
        }

        public int nextIndex() {
            return this.delegate.nextIndex();
        }

        public Object previous() {
            this.currentIndex = this.delegate.previousIndex();
            this.lastElement = this.delegate.previous();
            return this.lastElement;
        }

        public int previousIndex() {
            return this.delegate.previousIndex();
        }

        public synchronized void remove() {
            if (this.lastElement == null) {
                throw new IllegalStateException("No entry to remove");
            }
            AbstractListStore.this.remove(this.sm, this.currentIndex);
            this.delegate.remove();
            this.lastElement = null;
            this.currentIndex = -1;
        }

        public synchronized void set(Object o) {
            if (this.lastElement == null) {
                throw new IllegalStateException("No entry to replace");
            }
            AbstractListStore.this.set(this.sm, this.currentIndex, o, true);
            this.delegate.set(o);
            this.lastElement = o;
        }
    }
}

