/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.scostore;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.jdo.JDOHelper;
import javax.jdo.spi.PersistenceCapable;
import org.jpox.ClassLoaderResolver;
import org.jpox.JDOFetchPlanImpl;
import org.jpox.ManagedConnection;
import org.jpox.ObjectManager;
import org.jpox.ObjectManagerHelper;
import org.jpox.StateManager;
import org.jpox.Transaction;
import org.jpox.exceptions.JPOXDataStoreException;
import org.jpox.exceptions.JPOXObjectNotFoundException;
import org.jpox.exceptions.JPOXUserException;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.IdentityType;
import org.jpox.store.DatastoreClass;
import org.jpox.store.DatastoreContainerObject;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.StatementExpressionIndex;
import org.jpox.store.StoreManager;
import org.jpox.store.expression.LogicSetExpression;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.expression.StringLiteral;
import org.jpox.store.mapping.EmbeddedKeyPCMapping;
import org.jpox.store.mapping.EmbeddedValuePCMapping;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.MappingCallbacks;
import org.jpox.store.mapping.Mappings;
import org.jpox.store.mapping.ReferenceMapping;
import org.jpox.store.mapping.SerialisedPCMapping;
import org.jpox.store.mapping.SerialisedReferenceMapping;
import org.jpox.store.query.ResultObjectFactory;
import org.jpox.store.rdbms.SQLController;
import org.jpox.store.rdbms.SQLWarnings;
import org.jpox.store.rdbms.fieldmanager.ParameterSetter;
import org.jpox.store.rdbms.mapping.RDBMSMapping;
import org.jpox.store.rdbms.query.PersistentIDROF;
import org.jpox.store.rdbms.scostore.BaseContainerStore;
import org.jpox.store.rdbms.table.JoinTable;
import org.jpox.store.scostore.MapStore;

abstract class AbstractMapStore
extends BaseContainerStore
implements MapStore {
    protected boolean iterateUsingDiscriminator = false;
    protected DatastoreContainerObject mapTable;
    protected DatastoreClass valueTable;
    protected AbstractClassMetaData kmd;
    protected AbstractClassMetaData vmd;
    protected JavaTypeMapping keyMapping;
    protected JavaTypeMapping valueMapping;
    protected String keyType;
    protected String valueType;
    protected boolean keysAreEmbedded;
    protected boolean keysAreSerialised;
    protected boolean valuesAreEmbedded;
    protected boolean valuesAreSerialised;
    protected String containsValueStmt;
    protected final DatastoreIdentifier elmIdentifier;
    static /* synthetic */ Class class$java$lang$String;

    public AbstractMapStore(StoreManager storeMgr) {
        super(storeMgr);
        this.elmIdentifier = storeMgr.getIdentifierFactory().newIdentifier(0, "ELEMENT");
    }

    protected void initialiseStatements() {
        this.containsValueStmt = this.getContainsValueStmt();
    }

    public boolean keysAreEmbedded() {
        return this.keysAreEmbedded;
    }

    public boolean keysAreSerialised() {
        return this.keysAreSerialised;
    }

    public boolean valuesAreEmbedded() {
        return this.valuesAreEmbedded;
    }

    public boolean valuesAreSerialised() {
        return this.valuesAreSerialised;
    }

    public String getKeyType() {
        return this.keyType;
    }

    public String getValueType() {
        return this.valueType;
    }

    public boolean containsKey(StateManager sm, Object key) {
        if (key == null) {
            return false;
        }
        try {
            this.getValue(sm, key);
            return true;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsValue(StateManager sm, Object value) {
        if (value == null) {
            return false;
        }
        if (!this.validateValueForReading(sm, value)) {
            return false;
        }
        boolean exists = false;
        try {
            ObjectManager om = sm.getObjectManager();
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            Connection conn = (Connection)mconn.getConnection();
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForQuery(conn, this.containsValueStmt);
                try {
                    int jdbcPosition = 1;
                    jdbcPosition = this.populateOwnerInStatement(sm, om, ps, jdbcPosition);
                    jdbcPosition = this.populateValueInStatement(om, ps, value, jdbcPosition);
                    ResultSet rs = sqlControl.executeStatementQuery(conn, this.containsValueStmt, ps);
                    try {
                        if (rs.next()) {
                            exists = true;
                        }
                        SQLWarnings.log(rs);
                    }
                    finally {
                        rs.close();
                    }
                }
                finally {
                    sqlControl.closeStatement(conn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.SCO.ContainsValueRequestFailed", this.containsValueStmt), e);
        }
        return exists;
    }

    public Object get(StateManager sm, Object key) {
        try {
            return this.getValue(sm, key);
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    public void putAll(StateManager sm, Map m) {
        Iterator i = m.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            this.put(sm, e.getKey(), e.getValue());
        }
    }

    private String getContainsValueStmt() {
        int i;
        StringBuffer stmt = new StringBuffer();
        stmt.append("SELECT ");
        for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(",");
            }
            stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
        }
        stmt.append(" FROM ");
        stmt.append(this.mapTable.toString());
        stmt.append(" WHERE ");
        for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(" AND ");
            }
            stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        for (i = 0; i < this.valueMapping.getNumberOfDatastoreFields(); ++i) {
            stmt.append(" AND ");
            stmt.append(((Object)this.valueMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.valueMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        return stmt.toString();
    }

    protected void validateKeyType(ClassLoaderResolver clr, Object key) {
        if (key == null) {
            throw new NullPointerException(LOCALISER.msg("RDBMS.SCO.Map.NullKeysNotAllowed"));
        }
        if (!clr.isAssignableFrom(this.keyType, key.getClass())) {
            throw new ClassCastException(LOCALISER.msg("RDBMS.SCO.Map.KeyIsInvalid", key.getClass().getName(), this.keyType));
        }
    }

    protected void validateValueType(ClassLoaderResolver clr, Object value) {
        if (value != null && !clr.isAssignableFrom(this.valueType, value.getClass())) {
            throw new ClassCastException(LOCALISER.msg("RDBMS.SCO.Map.ValueIsInvalid", value.getClass().getName(), this.valueType));
        }
    }

    protected boolean validateKeyForReading(StateManager sm, Object key) {
        this.validateKeyType(sm.getObjectManager().getClassLoaderResolver(), key);
        if (!this.keysAreEmbedded && !this.keysAreSerialised) {
            ObjectManager om = sm.getObjectManager();
            if (!(key == null || JDOHelper.isPersistent((Object)key) && om == ObjectManagerHelper.getObjectManager(key) || JDOHelper.isDetached((Object)key))) {
                return false;
            }
        }
        return true;
    }

    protected boolean validateValueForReading(StateManager sm, Object value) {
        this.validateValueType(sm.getObjectManager().getClassLoaderResolver(), value);
        if (!this.valuesAreEmbedded && !this.valuesAreSerialised) {
            ObjectManager om = sm.getObjectManager();
            if (!(value == null || JDOHelper.isPersistent((Object)value) && om == ObjectManagerHelper.getObjectManager(value) || JDOHelper.isDetached((Object)value))) {
                return false;
            }
        }
        return true;
    }

    protected void validateKeyForWriting(StateManager sm, Object key) {
        this.validateKeyType(sm.getObjectManager().getClassLoaderResolver(), key);
        if (!this.keysAreEmbedded && !this.keysAreSerialised) {
            ObjectManager om = sm.getObjectManager();
            if (!JDOHelper.isPersistent((Object)key)) {
                boolean exists = false;
                if (JDOHelper.isDetached((Object)key)) {
                    try {
                        StateManager objSM;
                        Object obj = om.findObject(((PersistenceCapable)key).jdoGetObjectId(), true, false, key.getClass().getName());
                        if (obj != null && (objSM = om.findStateManager((PersistenceCapable)obj)) != null) {
                            om.evictFromTransaction(objSM);
                        }
                        exists = true;
                    }
                    catch (JPOXObjectNotFoundException onfe) {
                        exists = false;
                    }
                }
                if (!exists) {
                    om.persistObjectInternal(key, null);
                }
            } else if (om != ObjectManagerHelper.getObjectManager(key)) {
                throw new JPOXUserException(LOCALISER.msg("RDBMS.SCO.Map.WriteKeyInvalidWithDifferentPM"), JDOHelper.getObjectId((Object)key));
            }
        }
    }

    protected void validateValueForWriting(StateManager sm, Object value) {
        this.validateValueType(sm.getObjectManager().getClassLoaderResolver(), value);
        if (!this.valuesAreEmbedded && !this.valuesAreSerialised) {
            ObjectManager om = sm.getObjectManager();
            if (!JDOHelper.isPersistent((Object)value)) {
                boolean exists = false;
                if (JDOHelper.isDetached((Object)value)) {
                    try {
                        StateManager objSM;
                        Object obj = om.findObject(JDOHelper.getObjectId((Object)value), true, false, value.getClass().getName());
                        if (obj != null && (objSM = om.findStateManager((PersistenceCapable)obj)) != null) {
                            om.evictFromTransaction(objSM);
                        }
                        exists = true;
                    }
                    catch (JPOXObjectNotFoundException onfe) {
                        exists = false;
                    }
                }
                if (!exists) {
                    om.persistObjectInternal(value, null);
                }
            } else if (om != ObjectManagerHelper.getObjectManager(value)) {
                throw new JPOXUserException(LOCALISER.msg("RDBMS.SCO.Map.WriteValueInvalidWithDifferentPM"), JDOHelper.getObjectId((Object)value));
            }
        }
    }

    protected QueryExpression getGetStatement(StateManager ownerSm, Object key) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getValue(StateManager sm, Object key) throws NoSuchElementException {
        if (!this.validateKeyForReading(sm, key)) {
            return null;
        }
        QueryExpression stmt = this.getGetStatement(sm, key);
        ResultObjectFactory rof = this.newResultObjectFactory(sm, stmt, false, true);
        ObjectManager om = sm.getObjectManager();
        Transaction tx = om.getTransaction();
        boolean useUpdateLock = (Boolean)tx.getOptions().get("transaction.serializeReadObjects");
        String statement = stmt.toStatementText(useUpdateLock).toString();
        Object value = null;
        try {
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            Connection conn = (Connection)mconn.getConnection();
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = stmt.toStatementText(useUpdateLock).prepareStatement(om, conn);
                try {
                    ResultSet rs = sqlControl.executeStatementQuery(conn, statement, ps);
                    try {
                        boolean found = rs.next();
                        if (!found) {
                            throw new NoSuchElementException();
                        }
                        if (this.valuesAreEmbedded || this.valuesAreSerialised) {
                            int[] param = new int[this.valueMapping.getNumberOfDatastoreFields()];
                            for (int i = 0; i < param.length; ++i) {
                                param[i] = i + 1;
                            }
                            if (this.valueMapping instanceof SerialisedPCMapping || this.valueMapping instanceof SerialisedReferenceMapping || this.valueMapping instanceof EmbeddedKeyPCMapping) {
                                int ownerFieldNumber = -1;
                                if (this.mapTable != null) {
                                    ownerFieldNumber = ((JoinTable)this.mapTable).getOwnerFieldMetaData().getAbsoluteFieldNumber();
                                }
                                value = this.valueMapping.getObject(om, rs, param, sm, ownerFieldNumber);
                            } else {
                                value = this.valueMapping.getObject(om, rs, param);
                            }
                        } else if (this.valueMapping instanceof ReferenceMapping) {
                            int[] param = new int[this.valueMapping.getNumberOfDatastoreFields()];
                            for (int i = 0; i < param.length; ++i) {
                                param[i] = i + 1;
                            }
                            value = this.valueMapping.getObject(om, rs, param);
                        } else {
                            value = rof.getObject(om, rs);
                        }
                        SQLWarnings.log(rs);
                    }
                    finally {
                        rs.close();
                    }
                }
                finally {
                    sqlControl.closeStatement(conn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.SCO.GetRequestFailed", statement), e);
        }
        return value;
    }

    protected int populateKeyInStatement(ObjectManager om, PreparedStatement ps, Object key, int jdbcPosition) {
        if (!((RDBMSMapping)this.keyMapping.getDataStoreMapping(0)).insertValuesOnInsert()) {
            return jdbcPosition;
        }
        this.keyMapping.setObject(om, ps, Mappings.getParametersIndex(jdbcPosition, this.keyMapping), key);
        return jdbcPosition + this.keyMapping.getNumberOfDatastoreFields();
    }

    protected int populateValueInStatement(ObjectManager om, PreparedStatement ps, Object value, int jdbcPosition) {
        if (!((RDBMSMapping)this.valueMapping.getDataStoreMapping(0)).insertValuesOnInsert()) {
            return jdbcPosition;
        }
        this.valueMapping.setObject(om, ps, Mappings.getParametersIndex(jdbcPosition, this.valueMapping), value);
        return jdbcPosition + this.valueMapping.getNumberOfDatastoreFields();
    }

    protected int populateEmbeddedKeyFieldsInStatement(StateManager sm, Object key, PreparedStatement ps, int jdbcPosition, JoinTable joinTable) {
        EmbeddedKeyPCMapping embeddedMapping = (EmbeddedKeyPCMapping)this.keyMapping;
        StatementExpressionIndex[] statementExpressionIndex = new StatementExpressionIndex[this.kmd.getNoOfManagedFields() + this.kmd.getNoOfInheritedManagedFields()];
        int[] elementFieldNumbers = new int[embeddedMapping.getNumberOfJavaTypeMappings()];
        for (int i = 0; i < embeddedMapping.getNumberOfJavaTypeMappings(); ++i) {
            int absFieldNum;
            JavaTypeMapping fieldMapping = embeddedMapping.getJavaTypeMapping(i);
            elementFieldNumbers[i] = absFieldNum = this.kmd.getFieldNumberAbsolute(fieldMapping.getFieldMetaData().getName());
            if (fieldMapping == null) continue;
            statementExpressionIndex[absFieldNum] = new StatementExpressionIndex();
            statementExpressionIndex[absFieldNum].setMapping(fieldMapping);
            int[] jdbcParamPositions = new int[fieldMapping.getNumberOfDatastoreFields()];
            for (int j = 0; j < fieldMapping.getNumberOfDatastoreFields(); ++j) {
                jdbcParamPositions[j] = jdbcPosition++;
            }
            statementExpressionIndex[absFieldNum].setParameterIndex(jdbcParamPositions);
        }
        StateManager elementSM = this.getStateManagerForEmbeddedPCObject(sm, key, joinTable);
        elementSM.setPcObjectType(3);
        elementSM.provideFields(elementFieldNumbers, new ParameterSetter(elementSM, ps, statementExpressionIndex, true));
        return jdbcPosition;
    }

    protected int populateEmbeddedValueFieldsInStatement(StateManager sm, Object value, PreparedStatement ps, int jdbcPosition, JoinTable joinTable) {
        EmbeddedValuePCMapping embeddedMapping = (EmbeddedValuePCMapping)this.valueMapping;
        StatementExpressionIndex[] statementExpressionIndex = new StatementExpressionIndex[this.vmd.getNoOfManagedFields() + this.vmd.getNoOfInheritedManagedFields()];
        int[] elementFieldNumbers = new int[embeddedMapping.getNumberOfJavaTypeMappings()];
        for (int i = 0; i < embeddedMapping.getNumberOfJavaTypeMappings(); ++i) {
            int absFieldNum;
            JavaTypeMapping fieldMapping = embeddedMapping.getJavaTypeMapping(i);
            elementFieldNumbers[i] = absFieldNum = this.vmd.getFieldNumberAbsolute(fieldMapping.getFieldMetaData().getName());
            if (fieldMapping == null) continue;
            statementExpressionIndex[absFieldNum] = new StatementExpressionIndex();
            statementExpressionIndex[absFieldNum].setMapping(fieldMapping);
            int[] jdbcParamPositions = new int[fieldMapping.getNumberOfDatastoreFields()];
            for (int j = 0; j < fieldMapping.getNumberOfDatastoreFields(); ++j) {
                jdbcParamPositions[j] = jdbcPosition++;
            }
            statementExpressionIndex[absFieldNum].setParameterIndex(jdbcParamPositions);
        }
        StateManager elementSM = this.getStateManagerForEmbeddedPCObject(sm, value, joinTable);
        elementSM.setPcObjectType(4);
        elementSM.provideFields(elementFieldNumbers, new ParameterSetter(elementSM, ps, statementExpressionIndex, true));
        return jdbcPosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateEmbeddedKey(StateManager sm, Object key, int fieldNumber, Object newValue) {
        boolean modified = false;
        if (this.keyMapping != null && this.keyMapping instanceof EmbeddedKeyPCMapping) {
            String fieldName = this.vmd.getManagedFieldAbsolute(fieldNumber).getName();
            if (fieldName == null) {
                return false;
            }
            JavaTypeMapping fieldMapping = ((EmbeddedKeyPCMapping)this.keyMapping).getJavaTypeMapping(fieldName);
            if (fieldMapping == null) {
                return false;
            }
            String stmt = this.getUpdateEmbeddedKeyStmt(fieldMapping);
            try {
                ObjectManager om = sm.getObjectManager();
                ManagedConnection mconn = this.storeMgr.getConnection(om);
                Connection conn = (Connection)mconn.getConnection();
                SQLController sqlControl = this.storeMgr.getSQLController();
                try {
                    PreparedStatement ps = sqlControl.getStatementForUpdate(conn, stmt, false);
                    try {
                        int jdbcPosition = 1;
                        fieldMapping.setObject(om, ps, Mappings.getParametersIndex(jdbcPosition, fieldMapping), key);
                        jdbcPosition += fieldMapping.getNumberOfDatastoreFields();
                        jdbcPosition = this.populateOwnerInStatement(sm, om, ps, jdbcPosition);
                        jdbcPosition = this.populateEmbeddedKeyFieldsInStatement(sm, key, ps, jdbcPosition, (JoinTable)this.mapTable);
                        sqlControl.executeStatementUpdate(conn, stmt, ps, true);
                        modified = true;
                    }
                    finally {
                        sqlControl.closeStatement(conn, ps);
                    }
                }
                finally {
                    mconn.release();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.SCO.UpdateEmbeddedKeyFailed", stmt), e);
            }
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateEmbeddedValue(StateManager sm, Object value, int fieldNumber, Object newValue) {
        boolean modified = false;
        if (this.valueMapping != null && this.valueMapping instanceof EmbeddedValuePCMapping) {
            String fieldName = this.vmd.getManagedFieldAbsolute(fieldNumber).getName();
            if (fieldName == null) {
                return false;
            }
            JavaTypeMapping fieldMapping = ((EmbeddedValuePCMapping)this.valueMapping).getJavaTypeMapping(fieldName);
            if (fieldMapping == null) {
                return false;
            }
            String stmt = this.getUpdateEmbeddedValueStmt(fieldMapping);
            try {
                ObjectManager om = sm.getObjectManager();
                ManagedConnection mconn = this.storeMgr.getConnection(om);
                Connection conn = (Connection)mconn.getConnection();
                SQLController sqlControl = this.storeMgr.getSQLController();
                try {
                    PreparedStatement ps = sqlControl.getStatementForUpdate(conn, stmt, false);
                    try {
                        int jdbcPosition = 1;
                        fieldMapping.setObject(om, ps, Mappings.getParametersIndex(jdbcPosition, fieldMapping), newValue);
                        jdbcPosition += fieldMapping.getNumberOfDatastoreFields();
                        jdbcPosition = this.populateOwnerInStatement(sm, om, ps, jdbcPosition);
                        jdbcPosition = this.populateEmbeddedValueFieldsInStatement(sm, value, ps, jdbcPosition, (JoinTable)this.mapTable);
                        sqlControl.executeStatementUpdate(conn, stmt, ps, true);
                        modified = true;
                    }
                    finally {
                        sqlControl.closeStatement(conn, ps);
                    }
                }
                finally {
                    mconn.release();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.SCO.UpdateEmbeddedValueFailed", stmt), e);
            }
        }
        return modified;
    }

    protected String getUpdateEmbeddedKeyStmt(JavaTypeMapping fieldMapping) {
        int i;
        StringBuffer stmt = new StringBuffer();
        stmt.append("UPDATE ");
        stmt.append(this.mapTable.toString());
        stmt.append(" SET ");
        for (i = 0; i < fieldMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(",");
            }
            stmt.append(((Object)fieldMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)fieldMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        stmt.append(" WHERE ");
        for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(" AND ");
            }
            stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        EmbeddedKeyPCMapping embeddedMapping = (EmbeddedKeyPCMapping)this.keyMapping;
        for (int i2 = 0; i2 < embeddedMapping.getNumberOfJavaTypeMappings(); ++i2) {
            JavaTypeMapping m = embeddedMapping.getJavaTypeMapping(i2);
            if (m == null) continue;
            for (int j = 0; j < m.getNumberOfDatastoreFields(); ++j) {
                stmt.append(" AND ");
                stmt.append(((Object)m.getDataStoreMapping(j).getDatastoreField().getIdentifier()).toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)m.getDataStoreMapping(j)).getUpdateInputParameter());
            }
        }
        return stmt.toString();
    }

    protected String getUpdateEmbeddedValueStmt(JavaTypeMapping fieldMapping) {
        int i;
        StringBuffer stmt = new StringBuffer();
        stmt.append("UPDATE ");
        stmt.append(this.mapTable.toString());
        stmt.append(" SET ");
        for (i = 0; i < fieldMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(",");
            }
            stmt.append(((Object)fieldMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)fieldMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        stmt.append(" WHERE ");
        for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(" AND ");
            }
            stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        EmbeddedValuePCMapping embeddedMapping = (EmbeddedValuePCMapping)this.valueMapping;
        for (int i2 = 0; i2 < embeddedMapping.getNumberOfJavaTypeMappings(); ++i2) {
            JavaTypeMapping m = embeddedMapping.getJavaTypeMapping(i2);
            if (m == null) continue;
            for (int j = 0; j < m.getNumberOfDatastoreFields(); ++j) {
                stmt.append(" AND ");
                stmt.append(((Object)m.getDataStoreMapping(j).getDatastoreField().getIdentifier()).toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)m.getDataStoreMapping(j)).getUpdateInputParameter());
            }
        }
        return stmt.toString();
    }

    public ResultObjectFactory newResultObjectFactory(StateManager sm, QueryExpression stmt, boolean ignoreCache, boolean useFetchPlan) {
        ClassLoaderResolver clr = sm.getObjectManager().getClassLoaderResolver();
        if (this.valuesAreEmbedded || this.valuesAreSerialised) {
            return new PersistentIDROF(this.valueTable, null, this.vmd, null, null, null, ignoreCache, false, stmt.hasMetaDataExpression(), null, clr.classForName(this.valueType));
        }
        int[] datastoreIndex = null;
        int[] versionIndex = null;
        if (stmt.getTableExpression(this.elmIdentifier) != null) {
            if (this.valueTable.getIdentityType() == IdentityType.DATASTORE) {
                datastoreIndex = stmt.select(this.elmIdentifier, this.valueTable.getDataStoreObjectIdMapping(), true);
            }
            if (this.valueTable.getVersionMapping() != null) {
                versionIndex = stmt.select(this.elmIdentifier, this.valueTable.getVersionMapping(), true);
            }
        } else {
            if (this.valueTable.getIdentityType() == IdentityType.DATASTORE) {
                datastoreIndex = stmt.select(this.thisIdentifier, this.valueTable.getDataStoreObjectIdMapping(), true);
            }
            if (this.valueTable.getVersionMapping() != null) {
                versionIndex = stmt.select(this.thisIdentifier, this.valueTable.getVersionMapping(), true);
            }
        }
        StatementExpressionIndex[] statementExpressionIndex = null;
        int[] prefetchFieldNumbers = null;
        if (useFetchPlan) {
            JDOFetchPlanImpl fp = (JDOFetchPlanImpl)sm.getObjectManager().getFetchPlan();
            fp.manageFetchPlanForClass(this.vmd);
            JDOFetchPlanImpl.FetchPlanForClass fpc = fp.getFetchPlanForClass(this.vmd);
            int[] fieldNumbers = fpc.getFieldsInActualFetchPlan();
            int[] fn = new int[fieldNumbers.length];
            int prefetchFieldCount = 0;
            int fieldCount = this.vmd.getNoOfInheritedManagedFields() + this.vmd.getNoOfManagedFields();
            statementExpressionIndex = new StatementExpressionIndex[fieldCount];
            for (int i = 0; i < fieldNumbers.length; ++i) {
                JavaTypeMapping m = this.valueTable.getFieldMapping(this.vmd.getManagedFieldAbsolute(fieldNumbers[i]));
                if (m == null || !m.includeInFetchStatement() || m instanceof MappingCallbacks) continue;
                statementExpressionIndex[fieldNumbers[i]] = new StatementExpressionIndex();
                statementExpressionIndex[fieldNumbers[i]].setMapping(m);
                fn[prefetchFieldCount++] = fieldNumbers[i];
            }
            prefetchFieldNumbers = new int[prefetchFieldCount];
            System.arraycopy(fn, 0, prefetchFieldNumbers, 0, prefetchFieldCount);
        } else {
            AbstractClassMetaData cmd = this.vmd;
            if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                prefetchFieldNumbers = new int[cmd.getPrimaryKeyFieldNumbers().length];
                int fieldCount = cmd.getNoOfInheritedManagedFields() + cmd.getNoOfManagedFields();
                statementExpressionIndex = new StatementExpressionIndex[fieldCount];
                for (int i = 0; i < prefetchFieldNumbers.length; ++i) {
                    prefetchFieldNumbers[i] = cmd.getPrimaryKeyFieldNumbers()[i];
                    JavaTypeMapping m = this.valueTable.getFieldMapping(cmd.getManagedFieldAbsolute(prefetchFieldNumbers[i]));
                    if (m == null || !m.includeInFetchStatement() || m instanceof MappingCallbacks) continue;
                    statementExpressionIndex[prefetchFieldNumbers[i]] = new StatementExpressionIndex();
                    statementExpressionIndex[prefetchFieldNumbers[i]].setMapping(m);
                }
            }
        }
        if (stmt.getTableExpression(this.elmIdentifier) != null) {
            Mappings.selectMapping(stmt, this.elmIdentifier, statementExpressionIndex);
        } else {
            Mappings.selectMapping(stmt, statementExpressionIndex);
        }
        return new PersistentIDROF(this.getStoreManager().getDatastoreClass(this.getValueType(), clr), prefetchFieldNumbers, this.vmd, statementExpressionIndex, datastoreIndex, versionIndex, ignoreCache, this.iterateUsingDiscriminator, stmt.hasMetaDataExpression(), null, clr.classForName(this.valueType));
    }

    public QueryExpression getExistsSubquery(QueryExpression qs, JavaTypeMapping mapping, LogicSetExpression ownerTe, DatastoreIdentifier mapRangeVar) {
        QueryExpression stmt = this.dba.newQueryStatement(this.mapTable, mapRangeVar, qs.getClassLoaderResolver());
        ScalarExpression ownerExpr = mapping.newScalarExpression(stmt, ownerTe);
        ScalarExpression ownerInMapExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getTableExpression(mapRangeVar));
        stmt.andCondition(ownerExpr.eq(ownerInMapExpr));
        stmt.select(mapRangeVar, this.valueMapping);
        return stmt;
    }

    public QueryExpression getSizeSubquery(QueryExpression qs, JavaTypeMapping mapping, LogicSetExpression ownerTe, DatastoreIdentifier mapRangeVar) {
        QueryExpression stmt = this.dba.newQueryStatement(this.mapTable, mapRangeVar, qs.getClassLoaderResolver());
        ScalarExpression ownerExpr = mapping.newScalarExpression(stmt, ownerTe);
        ScalarExpression ownerInCollectionExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getTableExpression(mapRangeVar));
        stmt.andCondition(ownerExpr.eq(ownerInCollectionExpr));
        JavaTypeMapping m = this.dba.getMapping(class$java$lang$String == null ? (class$java$lang$String = AbstractMapStore.class$("java.lang.String")) : class$java$lang$String, this.storeMgr);
        StringLiteral lit = (StringLiteral)m.newLiteral(stmt, "COUNT(*)");
        lit.generateStatementWithoutQuotes();
        stmt.selectScalarExpression(lit);
        return stmt;
    }

    public ScalarExpression[] joinKeysToGet(QueryExpression stmt, QueryExpression parentStmt, JavaTypeMapping ownerMapping, LogicSetExpression te, DatastoreIdentifier mapRangeVar, Class filteredKeyType, DatastoreIdentifier keyRangeVar, DatastoreIdentifier valueRangeVar) {
        ClassLoaderResolver clr = stmt.getClassLoaderResolver();
        Class value_class = clr.classForName(this.valueType);
        return this.joinKeysValuesTo(stmt, parentStmt, ownerMapping, te, mapRangeVar, filteredKeyType, value_class, null, null, keyRangeVar, valueRangeVar);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

