/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.scostore;

import java.lang.reflect.Array;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.jpox.ClassLoaderResolver;
import org.jpox.ManagedConnection;
import org.jpox.ObjectManager;
import org.jpox.StateManager;
import org.jpox.exceptions.JPOXDataStoreException;
import org.jpox.exceptions.JPOXUserException;
import org.jpox.metadata.AbstractPropertyMetaData;
import org.jpox.metadata.ArrayMetaData;
import org.jpox.store.DatastoreClass;
import org.jpox.store.DatastoreContainerObject;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.exceptions.IncompatibleQueryElementTypeException;
import org.jpox.store.expression.LogicSetExpression;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.Mappings;
import org.jpox.store.rdbms.RDBMSManager;
import org.jpox.store.rdbms.SQLController;
import org.jpox.store.rdbms.mapping.RDBMSMapping;
import org.jpox.store.rdbms.query.UnionIteratorStatement;
import org.jpox.store.rdbms.scostore.AbstractArrayStore;
import org.jpox.util.JPOXLogger;

public class FKArrayStore
extends AbstractArrayStore {
    private final String updateFkStmt;
    private final String clearNullifyStmt;

    public FKArrayStore(AbstractPropertyMetaData fmd, RDBMSManager storeMgr, ClassLoaderResolver clr) {
        super(storeMgr, clr);
        this.ownerFieldMetaData = fmd;
        ArrayMetaData arrmd = fmd.getArray();
        if (arrmd == null) {
            throw new JPOXUserException(LOCALISER.msg("RDBMS.SCO.ArrayMetaDataMissing", fmd.getFullFieldName()));
        }
        this.elementType = fmd.getType().getComponentType().getName();
        Class element_class = clr.classForName(this.elementType);
        if (storeMgr.getOMFContext().getTypeManager().isReferenceType(element_class)) {
            this.emd = storeMgr.getMetaDataManager().getMetaDataForImplementationOfReference(element_class, null, clr);
            if (this.emd != null) {
                this.elementType = this.emd.getFullClassName();
            }
        } else {
            this.emd = storeMgr.getMetaDataManager().getMetaDataForClass(element_class, clr);
        }
        if (this.emd == null) {
            throw new JPOXUserException(LOCALISER.msg("RDBMS.SCO.ElementMetaDataNotFound", element_class.getName(), fmd.getFullFieldName()));
        }
        this.elementInfo = this.getElementInformationForClass();
        if (this.elementInfo != null && this.elementInfo.length > 1) {
            throw new JPOXUserException(LOCALISER.msg("RDBMS.SCO.Array.ElementWithSubclassTableWithMultipleTablesNotSupported", this.ownerFieldMetaData.getFullFieldName()));
        }
        this.elementMapping = this.elementInfo[0].getDatastoreClass().getIDMapping();
        this.elementsAreEmbedded = false;
        this.elementsAreSerialised = false;
        String mappedByFieldName = fmd.getMappedBy();
        if (mappedByFieldName != null) {
            AbstractPropertyMetaData eofmd = storeMgr.getMetaDataManager().getMetaDataForField(element_class, clr, mappedByFieldName);
            if (eofmd == null) {
                throw new JPOXUserException(LOCALISER.msg("RDBMS.SCO.MappedByNonExistent", fmd.getFullFieldName(), mappedByFieldName, element_class.getName()));
            }
            if (!clr.isAssignableFrom(eofmd.getType(), fmd.getAbstractClassMetaData().getFullClassName())) {
                throw new JPOXUserException(LOCALISER.msg("RDBMS.SCO.MappedByTypeInvalid", fmd.getFullFieldName(), eofmd.getFullFieldName(), eofmd.getTypeName(), fmd.getAbstractClassMetaData().getFullClassName()));
            }
            String ownerFieldName = eofmd.getName();
            this.ownerMapping = this.elementInfo[0].getDatastoreClass().getFieldMapping(eofmd);
            if (this.ownerMapping == null) {
                throw new JPOXUserException(LOCALISER.msg("RDBMS.SCO.Array.InverseOwnerMappedByFieldNotPresent", fmd.getAbstractClassMetaData().getFullClassName(), fmd.getName(), this.elementType, ownerFieldName));
            }
            if (this.isEmbeddedMapping(this.ownerMapping)) {
                throw new JPOXUserException(LOCALISER.msg("RDBMS.SCO.InverseOwnerMappedByFieldInvalidType", ownerFieldName, this.elementType, eofmd.getTypeName(), fmd.getClassName()));
            }
        } else {
            this.ownerMapping = this.elementInfo[0].getDatastoreClass().getExternalMapping(fmd, 5);
            if (this.ownerMapping == null) {
                throw new JPOXUserException(LOCALISER.msg("RDBMS.SCO.Array.InverseOwnerFieldNotPresent", fmd.getAbstractClassMetaData().getFullClassName(), fmd.getName(), this.elementType));
            }
        }
        this.orderMapping = this.elementInfo[0].getDatastoreClass().getExternalMapping(fmd, 4);
        if (this.orderMapping == null) {
            throw new JPOXUserException(LOCALISER.msg("RDBMS.SCO.Array.InverseIndexFieldNotPresent", fmd.getAbstractClassMetaData().getFullClassName(), fmd.getName(), this.elementType));
        }
        this.relationDiscriminatorMapping = this.elementInfo[0].getDatastoreClass().getExternalMapping(fmd, 6);
        if (this.relationDiscriminatorMapping != null) {
            this.relationDiscriminatorValue = fmd.getValueForExtension("relation-discriminator-value");
            if (this.relationDiscriminatorValue == null) {
                this.relationDiscriminatorValue = fmd.getFullFieldName();
            }
        }
        this.containerTable = this.elementInfo[0].getDatastoreClass();
        this.initialiseStatements();
        this.addStmt = null;
        this.clearNullifyStmt = this.getClearNullifyStmt();
        this.updateFkStmt = this.getUpdateFkStmt();
    }

    protected String getClearNullifyStmt() {
        int i;
        StringBuffer stmt = new StringBuffer();
        stmt.append("UPDATE ");
        if (this.elementInfo.length > 1) {
            stmt.append("?");
        } else {
            stmt.append(((Object)this.elementInfo[0].getDatastoreClass()).toString());
        }
        stmt.append(" SET ");
        for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(", ");
            }
            stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString() + " = NULL");
        }
        for (i = 0; i < this.orderMapping.getNumberOfDatastoreFields(); ++i) {
            stmt.append(", ");
            stmt.append(((Object)this.orderMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString() + " = NULL");
        }
        if (this.relationDiscriminatorMapping != null) {
            for (i = 0; i < this.relationDiscriminatorMapping.getNumberOfDatastoreFields(); ++i) {
                stmt.append(", ");
                stmt.append(((Object)this.relationDiscriminatorMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString() + " = NULL");
            }
        }
        stmt.append(" WHERE ");
        for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(" AND ");
            }
            stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        if (this.relationDiscriminatorMapping != null) {
            for (i = 0; i < this.relationDiscriminatorMapping.getNumberOfDatastoreFields(); ++i) {
                stmt.append(" AND ");
                stmt.append(((Object)this.relationDiscriminatorMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)this.relationDiscriminatorMapping.getDataStoreMapping(i)).getUpdateInputParameter());
            }
        }
        return stmt.toString();
    }

    private String getUpdateFkStmt() {
        int i;
        StringBuffer stmt = new StringBuffer();
        stmt.append("UPDATE ");
        if (this.elementInfo.length > 1) {
            stmt.append("?");
        } else {
            stmt.append(((Object)this.elementInfo[0].getDatastoreClass()).toString());
        }
        stmt.append(" SET ");
        for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(",");
            }
            stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        for (i = 0; i < this.orderMapping.getNumberOfDatastoreFields(); ++i) {
            stmt.append(",");
            stmt.append(((Object)this.orderMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.orderMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        if (this.relationDiscriminatorMapping != null) {
            for (i = 0; i < this.relationDiscriminatorMapping.getNumberOfDatastoreFields(); ++i) {
                stmt.append(",");
                stmt.append(((Object)this.relationDiscriminatorMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)this.relationDiscriminatorMapping.getDataStoreMapping(i)).getUpdateInputParameter());
            }
        }
        stmt.append(" WHERE ");
        for (i = 0; i < this.elementMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(" AND ");
            }
            stmt.append(((Object)this.elementMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.elementMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        return stmt.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateElementFk(StateManager sm, Object element, Object owner, int index) {
        boolean retval;
        if (element == null) {
            return false;
        }
        ObjectManager om = sm.getObjectManager();
        try {
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            Connection conn = (Connection)mconn.getConnection();
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForUpdate(conn, this.updateFkStmt, false);
                try {
                    int jdbcPosition = 1;
                    if (this.elementInfo.length > 1) {
                        DatastoreClass table = this.storeMgr.getDatastoreClass(element.getClass().getName(), this.clr);
                        if (table != null) {
                            ps.setString(jdbcPosition++, ((Object)table).toString());
                        } else {
                            JPOXLogger.PERSISTENCE.info(">> InverseArrayStore.updateElementFK : need to set table in statement but dont know table where to store " + element);
                        }
                    }
                    if (owner == null) {
                        this.ownerMapping.setObject(om, ps, Mappings.getParametersIndex(jdbcPosition, this.ownerMapping), null);
                        jdbcPosition += this.ownerMapping.getNumberOfDatastoreFields();
                    } else {
                        jdbcPosition = this.populateOwnerInStatement(sm, om, ps, jdbcPosition);
                    }
                    jdbcPosition = this.populateOrderInStatement(om, ps, index, jdbcPosition);
                    if (this.relationDiscriminatorMapping != null) {
                        jdbcPosition = this.populateRelationDiscriminatorInStatement(om, ps, jdbcPosition);
                    }
                    jdbcPosition = this.populateElementInStatement(om, ps, element, jdbcPosition);
                    sqlControl.executeStatementUpdate(conn, this.updateFkStmt, ps, true);
                    retval = true;
                }
                finally {
                    sqlControl.closeStatement(conn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.SCO.UpdateFkRequestFailed", this.updateFkStmt), e);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(StateManager ownerSM) {
        boolean deleteElements = false;
        if (this.ownerFieldMetaData.getArray().isDependentElement()) {
            JPOXLogger.RDBMS.debug(LOCALISER.msg("RDBMS.SCO.Collection.ClearElementsFromInverseDeleteDependent"));
            deleteElements = true;
        } else if (this.ownerMapping.isNullable() && this.orderMapping.isNullable()) {
            JPOXLogger.RDBMS.debug(LOCALISER.msg("RDBMS.SCO.Collection.ClearElementsFromInverseNull"));
            deleteElements = false;
        } else {
            JPOXLogger.RDBMS.debug(LOCALISER.msg("RDBMS.SCO.Collection.ClearElementsFromInverseDelete"));
            deleteElements = true;
        }
        if (deleteElements) {
            ownerSM.isLoaded(ownerSM.getObject(), this.ownerFieldMetaData.getAbsoluteFieldNumber());
            Object[] value = (Object[])ownerSM.provideField(this.ownerFieldMetaData.getAbsoluteFieldNumber());
            if (value != null && value.length > 0) {
                ownerSM.getObjectManager().deleteObjects(value);
            }
        } else {
            try {
                ObjectManager om = ownerSM.getObjectManager();
                ManagedConnection mconn = this.storeMgr.getConnection(om);
                Connection conn = (Connection)mconn.getConnection();
                SQLController sqlControl = this.storeMgr.getSQLController();
                try {
                    PreparedStatement ps = sqlControl.getStatementForUpdate(conn, this.clearNullifyStmt, false);
                    try {
                        int jdbcPosition = 1;
                        jdbcPosition = this.populateOwnerInStatement(ownerSM, om, ps, jdbcPosition);
                        if (this.relationDiscriminatorMapping != null) {
                            jdbcPosition = this.populateRelationDiscriminatorInStatement(om, ps, jdbcPosition);
                        }
                        sqlControl.executeStatementUpdate(conn, this.clearNullifyStmt, ps, true);
                    }
                    finally {
                        sqlControl.closeStatement(conn, ps);
                    }
                }
                finally {
                    mconn.release();
                }
            }
            catch (SQLException e) {
                throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.SCO.ClearRequestFailed", this.clearNullifyStmt), e);
            }
        }
    }

    public boolean set(StateManager ownerSM, Object array) {
        if (array == null) {
            return true;
        }
        for (int i = 0; i < Array.getLength(array); ++i) {
            this.validateElementForWriting(ownerSM, Array.get(array, i));
        }
        int length = Array.getLength(array);
        for (int i = 0; i < length; ++i) {
            Object obj = Array.get(array, i);
            this.updateElementFk(ownerSM, obj, ownerSM.getObject(), i);
        }
        return true;
    }

    protected QueryExpression getIteratorStatement(StateManager ownerSM) {
        if (this.elementInfo == null) {
            return null;
        }
        final ClassLoaderResolver clr = ownerSM.getObjectManager().getClassLoaderResolver();
        QueryExpression stmt = null;
        for (int i = 0; i < this.elementInfo.length; ++i) {
            final int elementNo = i;
            QueryExpression subStmt = new UnionIteratorStatement(clr, clr.classForName(this.elementType), true, this.storeMgr, new UnionIteratorStatement.AssociationEnd(){

                public JavaTypeMapping getMapping() {
                    return FKArrayStore.this.elementMapping;
                }

                public Class getType() {
                    return clr.classForName(FKArrayStore.this.elementType);
                }

                public DatastoreContainerObject getDatastoreContainerObject() {
                    return FKArrayStore.this.elementInfo[elementNo].getDatastoreClass();
                }

                public boolean useJoin() {
                    return false;
                }
            }).getQueryStatement();
            if (stmt == null) {
                stmt = subStmt;
                continue;
            }
            stmt.union(subStmt);
        }
        ScalarExpression ownerExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getDefaultTableExpression());
        ScalarExpression ownerVal = this.ownerMapping.newLiteral(stmt, ownerSM.getObject());
        stmt.andCondition(ownerExpr.eq(ownerVal), true);
        if (this.relationDiscriminatorMapping != null) {
            ScalarExpression distinguisherExpr = this.relationDiscriminatorMapping.newScalarExpression(stmt, stmt.getDefaultTableExpression());
            ScalarExpression distinguisherVal = this.relationDiscriminatorMapping.newLiteral(stmt, this.relationDiscriminatorValue);
            stmt.andCondition(distinguisherExpr.eq(distinguisherVal), true);
        }
        ScalarExpression[] exprIndex = new ScalarExpression[this.orderMapping.getNumberOfDatastoreFields()];
        boolean[] descendingOrder = new boolean[this.orderMapping.getNumberOfDatastoreFields()];
        exprIndex = this.orderMapping.newScalarExpression(stmt, stmt.getDefaultTableExpression()).getExpressionList().toArray();
        stmt.setOrdering(exprIndex, descendingOrder);
        return stmt;
    }

    public ScalarExpression joinElementsTo(QueryExpression stmt, QueryExpression parentStmt, JavaTypeMapping ownerMapping, LogicSetExpression ownerTe, DatastoreIdentifier listRangeVar, Class filteredElementType, ScalarExpression elmExpr, DatastoreIdentifier elementRangeVar) {
        ClassLoaderResolver clr = stmt.getClassLoaderResolver();
        if (!clr.isAssignableFrom(this.elementType, filteredElementType) && !clr.isAssignableFrom(filteredElementType, this.elementType)) {
            throw new IncompatibleQueryElementTypeException(this.elementType, filteredElementType.getName());
        }
        DatastoreClass filteredElementTable = this.storeMgr.getDatastoreClass(filteredElementType.getName(), stmt.getClassLoaderResolver());
        stmt.newTableExpression(filteredElementTable, elementRangeVar);
        ScalarExpression ownerExpr = ownerMapping.newScalarExpression(stmt, ownerTe);
        DatastoreIdentifier containerRangeVar = listRangeVar;
        if (stmt.getTableExpression(containerRangeVar) == null) {
            containerRangeVar = elementRangeVar;
        }
        ScalarExpression ownerSetExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getTableExpression(containerRangeVar));
        stmt.newTableExpression(this.containerTable, containerRangeVar);
        stmt.andCondition(ownerExpr.eq(ownerSetExpr), true);
        JavaTypeMapping elementTableID = filteredElementTable.getIDMapping();
        return elementTableID.newScalarExpression(stmt, stmt.getTableExpression(containerRangeVar));
    }
}

