/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.scostore;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import javax.jdo.spi.PersistenceCapable;
import org.jpox.ClassLoaderResolver;
import org.jpox.JDOFetchPlanImpl;
import org.jpox.ManagedConnection;
import org.jpox.ObjectManager;
import org.jpox.ObjectManagerHelper;
import org.jpox.StateManager;
import org.jpox.exceptions.JPOXDataStoreException;
import org.jpox.exceptions.JPOXUserException;
import org.jpox.metadata.AbstractPropertyMetaData;
import org.jpox.metadata.CollectionMetaData;
import org.jpox.metadata.DiscriminatorStrategy;
import org.jpox.store.DatastoreClass;
import org.jpox.store.DatastoreContainerObject;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.FieldValues;
import org.jpox.store.exceptions.IncompatibleQueryElementTypeException;
import org.jpox.store.expression.LogicSetExpression;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.Mappings;
import org.jpox.store.query.DiscriminatorIteratorStatement;
import org.jpox.store.rdbms.RDBMSManager;
import org.jpox.store.rdbms.SQLController;
import org.jpox.store.rdbms.mapping.RDBMSMapping;
import org.jpox.store.rdbms.query.UnionIteratorStatement;
import org.jpox.store.rdbms.scostore.AbstractSetStore;
import org.jpox.util.JPOXLogger;
import org.jpox.util.StringUtils;

public class FKSetStore
extends AbstractSetStore {
    private final int ownerFieldNumber;
    private final String updateFkStmt;
    private final String clearNullifyStmt;
    private final boolean isPersistentInterface;

    public FKSetStore(AbstractPropertyMetaData fmd, RDBMSManager storeMgr, ClassLoaderResolver clr) {
        super(storeMgr, clr);
        this.ownerFieldMetaData = fmd;
        CollectionMetaData colmd = fmd.getCollection();
        if (colmd == null) {
            throw new JPOXUserException(LOCALISER.msg("RDBMS.SCO.CollectionMetaDataMissing", fmd.getFullFieldName()));
        }
        this.elementType = colmd.getElementType();
        Class element_class = clr.classForName(this.elementType);
        if (storeMgr.getOMFContext().getTypeManager().isReferenceType(element_class)) {
            this.isPersistentInterface = storeMgr.getMetaDataManager().isPersistentInterface(element_class.getName());
            if (this.isPersistentInterface) {
                this.emd = storeMgr.getMetaDataManager().getMetaDataForInterface(element_class, clr);
            } else {
                this.emd = storeMgr.getMetaDataManager().getMetaDataForImplementationOfReference(element_class, null, clr);
                if (this.emd != null) {
                    // empty if block
                }
            }
        } else {
            this.emd = storeMgr.getMetaDataManager().getMetaDataForClass(element_class, clr);
            this.isPersistentInterface = false;
        }
        if (this.emd == null) {
            throw new JPOXUserException(LOCALISER.msg("RDBMS.SCO.ElementMetaDataNotFound", element_class.getName(), fmd.getFullFieldName()));
        }
        this.elementInfo = this.getElementInformationForClass();
        this.elementMapping = this.elementInfo[0].getDatastoreClass().getIDMapping();
        this.elementsAreEmbedded = false;
        this.elementsAreSerialised = false;
        if (fmd.getMappedBy() != null) {
            AbstractPropertyMetaData eofmd = this.emd.getField(fmd.getMappedBy());
            if (eofmd == null) {
                throw new JPOXUserException(LOCALISER.msg("RDBMS.SCO.MappedByNonExistent", fmd.getFullFieldName(), fmd.getMappedBy(), element_class.getName()));
            }
            String ownerFieldName = eofmd.getName();
            this.ownerFieldNumber = this.emd.getFieldNumberAbsolute(ownerFieldName);
            this.ownerMapping = this.elementInfo[0].getDatastoreClass().getFieldMapping(eofmd);
            if (this.ownerMapping == null) {
                throw new JPOXUserException(LOCALISER.msg("RDBMS.SCO.Collection.InverseOwnerMappedByFieldNotPresent", fmd.getAbstractClassMetaData().getFullClassName(), fmd.getName(), this.elementType, ownerFieldName));
            }
            if (this.isEmbeddedMapping(this.ownerMapping)) {
                throw new JPOXUserException(LOCALISER.msg("RDBMS.SCO.InverseOwnerMappedByFieldInvalidType", ownerFieldName, this.elementType, eofmd.getTypeName(), fmd.getClassName()));
            }
        } else {
            this.ownerFieldNumber = -1;
            this.ownerMapping = this.elementInfo[0].getDatastoreClass().getExternalMapping(fmd, 5);
            if (this.ownerMapping == null) {
                throw new JPOXUserException(LOCALISER.msg("RDBMS.SCO.Collection.InverseOwnerFieldNotPresent", fmd.getAbstractClassMetaData().getFullClassName(), fmd.getName(), this.elementType));
            }
        }
        this.relationDiscriminatorMapping = this.elementInfo[0].getDatastoreClass().getExternalMapping(fmd, 6);
        if (this.relationDiscriminatorMapping != null) {
            this.relationDiscriminatorValue = fmd.getValueForExtension("relation-discriminator-value");
            if (this.relationDiscriminatorValue == null) {
                this.relationDiscriminatorValue = fmd.getFullFieldName();
            }
        }
        this.containerTable = this.elementInfo[0].getDatastoreClass();
        this.setName = "inverseSet";
        this.initialiseStatements();
        this.addStmt = null;
        this.removeStmt = null;
        this.clearStmt = null;
        this.clearNullifyStmt = this.getClearNullifyStmt();
        this.updateFkStmt = this.getUpdateFkStmt();
    }

    protected String getSizeStmt() {
        return super.getSizeStmt();
    }

    protected String getContainsStmt() {
        return super.getContainsStmt();
    }

    protected String getClearNullifyStmt() {
        int i;
        StringBuffer stmt = new StringBuffer();
        stmt.append("UPDATE ");
        if (this.elementInfo.length > 1) {
            stmt.append("<TABLE NAME>");
        } else {
            stmt.append(((Object)this.elementInfo[0].getDatastoreClass()).toString());
        }
        stmt.append(" SET ");
        for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(", ");
            }
            stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString() + " = NULL");
        }
        if (this.relationDiscriminatorMapping != null) {
            for (i = 0; i < this.relationDiscriminatorMapping.getNumberOfDatastoreFields(); ++i) {
                stmt.append(", ");
                stmt.append(((Object)this.relationDiscriminatorMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString() + " = NULL");
            }
        }
        stmt.append(" WHERE ");
        for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(" AND ");
            }
            stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        return stmt.toString();
    }

    private String getUpdateFkStmt() {
        int i;
        StringBuffer stmt = new StringBuffer();
        stmt.append("UPDATE ");
        if (this.elementInfo.length > 1) {
            stmt.append("<TABLE NAME>");
        } else {
            stmt.append(((Object)this.elementInfo[0].getDatastoreClass()).toString());
        }
        stmt.append(" SET ");
        for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(",");
            }
            stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        if (this.relationDiscriminatorMapping != null) {
            for (i = 0; i < this.relationDiscriminatorMapping.getNumberOfDatastoreFields(); ++i) {
                stmt.append(",");
                stmt.append(((Object)this.relationDiscriminatorMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)this.relationDiscriminatorMapping.getDataStoreMapping(i)).getUpdateInputParameter());
            }
        }
        stmt.append(" WHERE ");
        for (i = 0; i < this.elementMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(" AND ");
            }
            stmt.append(((Object)this.elementMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.elementMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        return stmt.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateElementFk(StateManager sm, Object element, Object owner) {
        boolean retval;
        if (element == null) {
            return false;
        }
        this.validateElementForWriting(sm, element);
        ObjectManager om = sm.getObjectManager();
        try {
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            Connection conn = (Connection)mconn.getConnection();
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                String stmt = this.updateFkStmt;
                int jdbcPosition = 1;
                if (this.elementInfo.length > 1) {
                    DatastoreClass table = this.storeMgr.getDatastoreClass(element.getClass().getName(), this.clr);
                    if (table != null) {
                        stmt = StringUtils.replaceAll(stmt, "<TABLE NAME>", ((Object)table).toString());
                    } else {
                        JPOXLogger.PERSISTENCE.warn(">> InverseArrayStore.updateElementFK : need to set table in statement but dont know table where to store " + element);
                    }
                }
                PreparedStatement ps = sqlControl.getStatementForUpdate(conn, stmt, false);
                try {
                    if (owner == null) {
                        this.ownerMapping.setObject(om, ps, Mappings.getParametersIndex(jdbcPosition, this.ownerMapping), null);
                    } else {
                        this.ownerMapping.setObject(om, ps, Mappings.getParametersIndex(jdbcPosition, this.ownerMapping), sm.getObject());
                    }
                    jdbcPosition += this.ownerMapping.getNumberOfDatastoreFields();
                    if (this.relationDiscriminatorMapping != null) {
                        jdbcPosition = this.populateRelationDiscriminatorInStatement(om, ps, jdbcPosition);
                    }
                    this.elementMapping.setObject(om, ps, Mappings.getParametersIndex(jdbcPosition, this.elementMapping), element);
                    jdbcPosition += this.elementMapping.getNumberOfDatastoreFields();
                    sqlControl.executeStatementUpdate(conn, this.updateFkStmt, ps, true);
                    retval = true;
                }
                finally {
                    sqlControl.closeStatement(conn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.SCO.UpdateFkRequestFailed", this.updateFkStmt), e);
        }
        return retval;
    }

    protected void validateElementForWriting(StateManager sm, Object element) {
        super.validateElementForWriting(sm, element);
        if (element != null && !this.elementsAreEmbedded && !this.elementsAreSerialised && element instanceof PersistenceCapable) {
            ObjectManager om = sm.getObjectManager();
            om.findStateManager((PersistenceCapable)element).flush();
        }
    }

    protected int getOwnerFieldOwner(StateManager sm) {
        if (this.ownerFieldNumber < 0) {
            return -1;
        }
        return sm.getClassMetaData().getFieldNumberAbsolute(this.ownerFieldMetaData.getMappedBy());
    }

    public boolean add(StateManager sm, Object element) {
        if (element == null) {
            throw new JPOXUserException(LOCALISER.msg("RDBMS.SCO.Set.NullElementsNotAllowed"));
        }
        if (!this.isPersistentInterface && !sm.getObjectManager().getClassLoaderResolver().isAssignableFrom(this.elementType, element.getClass())) {
            throw new ClassCastException(LOCALISER.msg("RDBMS.SCO.Collection.ElementIsInvalid", element.getClass().getName(), this.ownerFieldMetaData.getFullFieldName(), this.elementType));
        }
        ObjectManager om = sm.getObjectManager();
        PersistenceCapable pcElement = (PersistenceCapable)element;
        final PersistenceCapable newOwner = sm.getObject();
        final StateManager ownerSM = sm;
        if (pcElement.jdoIsPersistent()) {
            if (om != ObjectManagerHelper.getObjectManager(pcElement)) {
                throw new JPOXUserException(LOCALISER.msg("RDBMS.SCO.Set.WriteInvalidWithDifferentPM"), pcElement.jdoGetObjectId());
            }
            StateManager elementSM = om.findStateManager(pcElement);
            if (this.getOwnerFieldOwner(elementSM) >= 0) {
                elementSM.isLoaded(pcElement, this.getOwnerFieldOwner(elementSM));
                Object oldOwner = elementSM.provideField(this.getOwnerFieldOwner(elementSM));
                if (oldOwner != newOwner) {
                    elementSM.setObjectField(pcElement, this.getOwnerFieldOwner(elementSM), oldOwner, newOwner);
                }
                return oldOwner != newOwner;
            }
            boolean contained = this.contains(sm, element);
            if (!contained) {
                return this.updateElementFk(sm, pcElement, newOwner);
            }
            return false;
        }
        om.persistObjectInternal(element, new FieldValues(){

            public void fetchFields(StateManager esm) {
                boolean isPersistentInterface = FKSetStore.this.storeMgr.getMetaDataManager().isPersistentInterface(FKSetStore.this.elementType);
                DatastoreClass elementTable = null;
                elementTable = !isPersistentInterface ? FKSetStore.this.storeMgr.getDatastoreClass(FKSetStore.this.elementType, FKSetStore.this.clr) : FKSetStore.this.storeMgr.getDatastoreClass(FKSetStore.this.storeMgr.getMetaDataManager().getImplementationNameForPersistentInterface(FKSetStore.this.elementType), FKSetStore.this.clr);
                if (elementTable != null) {
                    JavaTypeMapping externalFKMapping = elementTable.getExternalMapping(FKSetStore.this.ownerFieldMetaData, 5);
                    if (externalFKMapping != null) {
                        esm.setExternalFieldValueForMapping(externalFKMapping, ownerSM.getObject());
                    }
                    if (FKSetStore.this.relationDiscriminatorMapping != null) {
                        esm.setExternalFieldValueForMapping(FKSetStore.this.relationDiscriminatorMapping, FKSetStore.this.relationDiscriminatorValue);
                    }
                }
                if (FKSetStore.this.getOwnerFieldOwner(esm) >= 0) {
                    esm.replaceField(FKSetStore.this.getOwnerFieldOwner(esm), newOwner, true);
                }
            }

            public void fetchNonLoadedFields(StateManager sm) {
            }

            public JDOFetchPlanImpl getFetchPlanForLoading() {
                return null;
            }
        });
        StateManager elementSM = om.findStateManager((PersistenceCapable)element);
        if (elementSM != null) {
            elementSM.flush();
        }
        return true;
    }

    public boolean addAll(StateManager sm, Collection elements) {
        if (elements == null || elements.size() == 0) {
            return false;
        }
        boolean success = false;
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            if (!this.add(sm, iter.next())) continue;
            success = true;
        }
        return success;
    }

    public boolean remove(StateManager sm, Object element) {
        if (element == null) {
            return false;
        }
        if (!this.validateElementForReading(sm, element)) {
            return false;
        }
        ObjectManager om = sm.getObjectManager();
        PersistenceCapable pcElement = (PersistenceCapable)element;
        StateManager esm = om.findStateManager(pcElement);
        Object oldOwner = null;
        if (this.ownerFieldNumber >= 0 && !esm.isDeleted(pcElement)) {
            esm.isLoaded(pcElement, this.ownerFieldNumber);
            oldOwner = esm.provideField(this.ownerFieldNumber);
        }
        if (this.ownerFieldNumber >= 0 && oldOwner != sm.getObject()) {
            return false;
        }
        if (this.ownerFieldMetaData.getCollection().isDependentElement()) {
            om.deleteObject(element);
        } else if (this.ownerMapping.isNullable()) {
            if (this.ownerFieldNumber >= 0) {
                esm.setObjectField(pcElement, this.ownerFieldNumber, oldOwner, null);
            } else {
                this.updateElementFk(sm, pcElement, null);
            }
        } else {
            om.deleteObject(element);
        }
        return true;
    }

    public boolean removeAll(StateManager sm, Collection elements) {
        if (elements == null || elements.size() == 0) {
            return false;
        }
        boolean success = true;
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            if (!this.remove(sm, iter.next())) continue;
            success = false;
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(StateManager ownerSM) {
        boolean deleteElements = false;
        if (this.ownerFieldMetaData.getCollection().isDependentElement()) {
            JPOXLogger.RDBMS.debug(LOCALISER.msg("RDBMS.SCO.Collection.ClearElementsFromInverseDeleteDependent"));
            deleteElements = true;
        } else if (this.ownerMapping.isNullable()) {
            JPOXLogger.RDBMS.debug(LOCALISER.msg("RDBMS.SCO.Collection.ClearElementsFromInverseNull"));
            deleteElements = false;
        } else {
            JPOXLogger.RDBMS.debug(LOCALISER.msg("RDBMS.SCO.Collection.ClearElementsFromInverseDelete"));
            deleteElements = true;
        }
        if (deleteElements) {
            ownerSM.isLoaded(ownerSM.getObject(), this.ownerFieldMetaData.getAbsoluteFieldNumber());
            Collection value = (Collection)ownerSM.provideField(this.ownerFieldMetaData.getAbsoluteFieldNumber());
            if (value != null && !value.isEmpty()) {
                ownerSM.getObjectManager().deleteObjects(value.toArray());
            }
        } else {
            String stmt = this.clearNullifyStmt;
            if (this.elementInfo.length > 1) {
                DatastoreClass table = this.storeMgr.getDatastoreClass(this.elementInfo[0].getClassName(), this.clr);
                if (table != null) {
                    stmt = StringUtils.replaceAll(this.clearNullifyStmt, "<TABLE NAME>", ((Object)table).toString());
                } else {
                    JPOXLogger.PERSISTENCE.warn(">> InverseArrayStore.updateElementFK : need to set table in statement but dont know table where to store " + this.elementInfo[0].getClassName());
                }
            }
            try {
                ObjectManager om = ownerSM.getObjectManager();
                ManagedConnection mconn = this.storeMgr.getConnection(om);
                Connection conn = (Connection)mconn.getConnection();
                SQLController sqlControl = this.storeMgr.getSQLController();
                try {
                    PreparedStatement ps = sqlControl.getStatementForUpdate(conn, stmt, false);
                    try {
                        int jdbcPosition = 1;
                        jdbcPosition = this.populateOwnerInStatement(ownerSM, om, ps, jdbcPosition);
                        sqlControl.executeStatementUpdate(conn, stmt, ps, true);
                    }
                    finally {
                        sqlControl.closeStatement(conn, ps);
                    }
                }
                finally {
                    mconn.release();
                }
            }
            catch (SQLException e) {
                throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.SCO.ClearRequestFailed", stmt), e);
            }
        }
    }

    protected QueryExpression getIteratorStatement(StateManager ownerSM) {
        if (this.elementInfo == null || this.elementInfo.length == 0) {
            return null;
        }
        ClassLoaderResolver clr = ownerSM.getObjectManager().getClassLoaderResolver();
        QueryExpression stmt = null;
        if (this.elementInfo[0].getDatastoreClass().getDiscriminatorMetaData() != null && this.elementInfo[0].getDatastoreClass().getDiscriminatorMetaData().getStrategy() != DiscriminatorStrategy.NONE) {
            if (this.storeMgr.getOMFContext().getTypeManager().isReferenceType(clr.classForName(this.ownerFieldMetaData.getCollection().getElementType()))) {
                String[] clsNames = this.storeMgr.getMetaDataManager().getClassesImplementingInterface(this.ownerFieldMetaData.getCollection().getElementType(), clr);
                Class[] cls = new Class[clsNames.length];
                for (int i = 0; i < clsNames.length; ++i) {
                    cls[i] = clr.classForName(clsNames[i]);
                }
                stmt = new DiscriminatorIteratorStatement(clr, cls, true, this.storeMgr, true).getQueryStatement();
            } else {
                stmt = new DiscriminatorIteratorStatement(clr, new Class[]{clr.classForName(this.elementInfo[0].getClassName())}, true, this.storeMgr, true).getQueryStatement();
            }
            this.iterateUsingDiscriminator = true;
        } else {
            for (int i = 0; i < this.elementInfo.length; ++i) {
                final Class elementCls = clr.classForName(this.elementInfo[i].getClassName());
                final int elementNo = i;
                QueryExpression subStmt = new UnionIteratorStatement(clr, elementCls, true, this.storeMgr, new UnionIteratorStatement.AssociationEnd(){

                    public JavaTypeMapping getMapping() {
                        return FKSetStore.this.elementMapping;
                    }

                    public Class getType() {
                        return elementCls;
                    }

                    public DatastoreContainerObject getDatastoreContainerObject() {
                        return FKSetStore.this.elementInfo[elementNo].getDatastoreClass();
                    }

                    public boolean useJoin() {
                        return false;
                    }
                }).getQueryStatement();
                if (stmt == null) {
                    stmt = subStmt;
                    continue;
                }
                stmt.union(subStmt);
            }
        }
        ScalarExpression ownerExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getDefaultTableExpression());
        ScalarExpression ownerVal = this.ownerMapping.newLiteral(stmt, ownerSM.getObject());
        stmt.andCondition(ownerExpr.eq(ownerVal), true);
        if (this.relationDiscriminatorMapping != null) {
            ScalarExpression distinguisherExpr = this.relationDiscriminatorMapping.newScalarExpression(stmt, stmt.getDefaultTableExpression());
            ScalarExpression distinguisherVal = this.relationDiscriminatorMapping.newLiteral(stmt, this.relationDiscriminatorValue);
            stmt.andCondition(distinguisherExpr.eq(distinguisherVal), true);
        }
        if (this.orderMapping != null) {
            ScalarExpression[] exprIndex = new ScalarExpression[this.orderMapping.getNumberOfDatastoreFields()];
            boolean[] descendingOrder = new boolean[this.orderMapping.getNumberOfDatastoreFields()];
            exprIndex = this.orderMapping.newScalarExpression(stmt, stmt.getDefaultTableExpression()).getExpressionList().toArray();
            stmt.setOrdering(exprIndex, descendingOrder);
        }
        return stmt;
    }

    public QueryExpression newQueryStatement(StateManager sm, String candidateClass) {
        if (!sm.getObjectManager().getClassLoaderResolver().isAssignableFrom(this.elementType, candidateClass)) {
            throw new IncompatibleQueryElementTypeException(this.elementType, candidateClass);
        }
        DatastoreClass candidateTable = this.storeMgr.getDatastoreClass(candidateClass, sm.getObjectManager().getClassLoaderResolver());
        QueryExpression stmt = this.dba.newQueryStatement(candidateTable, sm.getObjectManager().getClassLoaderResolver());
        ScalarExpression ownerExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getDefaultTableExpression());
        ScalarExpression ownerVal = this.ownerMapping.newLiteral(stmt, sm.getObject());
        stmt.andCondition(ownerExpr.eq(ownerVal));
        stmt.select(this.elementMapping);
        return stmt;
    }

    public ScalarExpression joinElementsTo(QueryExpression stmt, QueryExpression parentStmt, JavaTypeMapping ownerMapping, LogicSetExpression ownerTe, DatastoreIdentifier setRangeVar, Class filteredElementType, ScalarExpression elmExpr, DatastoreIdentifier elementRangeVar) {
        ClassLoaderResolver clr = stmt.getClassLoaderResolver();
        if (!clr.isAssignableFrom(this.elementType, filteredElementType) && !clr.isAssignableFrom(filteredElementType, this.elementType)) {
            throw new IncompatibleQueryElementTypeException(this.elementType, filteredElementType.getName());
        }
        DatastoreClass filteredElementTable = this.storeMgr.getDatastoreClass(filteredElementType.getName(), stmt.getClassLoaderResolver());
        stmt.newTableExpression(filteredElementTable, elementRangeVar);
        ScalarExpression ownerExpr = ownerMapping.newScalarExpression(stmt, ownerTe);
        DatastoreIdentifier containerRangeVar = setRangeVar;
        if (stmt.getTableExpression(containerRangeVar) == null) {
            containerRangeVar = elementRangeVar;
        }
        ScalarExpression ownerSetExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getTableExpression(containerRangeVar));
        stmt.newTableExpression(this.containerTable, containerRangeVar);
        stmt.andCondition(ownerExpr.eq(ownerSetExpr), true);
        JavaTypeMapping elementTableID = filteredElementTable.getIDMapping();
        return elementTableID.newScalarExpression(stmt, stmt.getTableExpression(containerRangeVar));
    }
}

