/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.scostore;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import org.jpox.ClassLoaderResolver;
import org.jpox.ManagedConnection;
import org.jpox.ObjectManager;
import org.jpox.StateManager;
import org.jpox.exceptions.JPOXDataStoreException;
import org.jpox.exceptions.JPOXUserException;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.AbstractPropertyMetaData;
import org.jpox.metadata.DiscriminatorStrategy;
import org.jpox.metadata.MetaDataUtils;
import org.jpox.metadata.OrderMetaData;
import org.jpox.store.DatastoreClass;
import org.jpox.store.DatastoreContainerObject;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.StoreManager;
import org.jpox.store.exceptions.IncompatibleQueryElementTypeException;
import org.jpox.store.expression.LogicSetExpression;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.ReferenceMapping;
import org.jpox.store.query.DiscriminatorIteratorStatement;
import org.jpox.store.rdbms.SQLController;
import org.jpox.store.rdbms.mapping.RDBMSMapping;
import org.jpox.store.rdbms.query.UnionIteratorStatement;
import org.jpox.store.rdbms.scostore.AbstractListStore;
import org.jpox.store.rdbms.scostore.ElementContainerStore;
import org.jpox.store.rdbms.table.CollectionTable;
import org.jpox.util.JPOXLogger;

public class JoinListStore
extends AbstractListStore {
    public JoinListStore(AbstractPropertyMetaData fmd, CollectionTable joinTable, ClassLoaderResolver clr) {
        super(joinTable.getStoreManager(), clr);
        this.containerTable = joinTable;
        this.ownerFieldMetaData = fmd;
        this.listName = "list";
        this.ownerMapping = joinTable.getOwnerMapping();
        this.elementMapping = joinTable.getElementMapping();
        this.orderMapping = joinTable.getOrderMapping();
        if (this.ownerFieldMetaData.getOrderMetaData() != null && !this.ownerFieldMetaData.getOrderMetaData().isIndexedList()) {
            this.indexedList = false;
        }
        if (this.orderMapping == null && this.indexedList) {
            throw new JPOXUserException(LOCALISER.msg("RDBMS.SCO.List.OrderColumnMissing", this.ownerFieldMetaData.getFullFieldName(), joinTable.toString()));
        }
        this.relationDiscriminatorMapping = joinTable.getRelationDiscriminatorMapping();
        this.relationDiscriminatorValue = joinTable.getRelationDiscriminatorValue();
        this.elementType = fmd.getCollection().getElementType();
        this.elementsAreEmbedded = joinTable.isEmbeddedElement();
        this.elementsAreSerialised = joinTable.isSerialisedElement();
        if (this.elementsAreSerialised) {
            this.elementInfo = null;
        } else {
            Class element_class = clr.classForName(this.elementType);
            if (this.storeMgr.getOMFContext().getTypeManager().isReferenceType(element_class)) {
                String[] implNames = MetaDataUtils.getInstance().getImplementationNamesForReferenceField(this.ownerFieldMetaData, 3, clr);
                this.elementInfo = new ElementContainerStore.ElementInfo[implNames.length];
                for (int i = 0; i < implNames.length; ++i) {
                    DatastoreClass table = this.storeMgr.getDatastoreClass(implNames[i], clr);
                    AbstractClassMetaData cmd = this.storeMgr.getMetaDataManager().getMetaDataForClass(implNames[i], clr);
                    this.elementInfo[i] = new ElementContainerStore.ElementInfo(cmd, table);
                }
            } else {
                this.emd = this.storeMgr.getMetaDataManager().getMetaDataForClass(element_class, clr);
                this.elementInfo = this.emd != null ? (!this.elementsAreEmbedded ? this.getElementInformationForClass() : null) : null;
            }
        }
        this.initialiseStatements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAll(StateManager sm, Collection elements) {
        if (elements == null || elements.size() == 0) {
            return false;
        }
        boolean modified = false;
        int currentListSize = this.size(sm);
        int[] indices = this.getIndicesOf(sm, elements);
        String removeAllStmt = this.getRemoveAllStmt(elements);
        SQLController sqlControl = this.storeMgr.getSQLController();
        try {
            ObjectManager om = sm.getObjectManager();
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            Connection conn = (Connection)mconn.getConnection();
            try {
                PreparedStatement ps = sqlControl.getStatementForUpdate(conn, removeAllStmt, false);
                try {
                    int jdbcPosition = 1;
                    Iterator iter = elements.iterator();
                    while (iter.hasNext()) {
                        Object element = iter.next();
                        jdbcPosition = this.populateOwnerInStatement(sm, om, ps, jdbcPosition);
                        jdbcPosition = this.populateElementInStatement(om, ps, element, jdbcPosition);
                        if (this.relationDiscriminatorMapping == null) continue;
                        jdbcPosition = this.populateRelationDiscriminatorInStatement(om, ps, jdbcPosition);
                    }
                    int[] number = sqlControl.executeStatementUpdate(conn, removeAllStmt, ps, true);
                    if (number[0] > 0) {
                        modified = true;
                    }
                }
                finally {
                    sqlControl.closeStatement(conn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            JPOXLogger.RDBMS.error(e);
            throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.SCO.RemoveRequestFailed", removeAllStmt), e);
        }
        try {
            boolean batched = this.allowsBatching();
            ObjectManager om = sm.getObjectManager();
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            Connection conn = (Connection)mconn.getConnection();
            try {
                for (int i = 0; i < currentListSize; ++i) {
                    int shift = 0;
                    boolean removed = false;
                    for (int j = 0; j < indices.length; ++j) {
                        if (indices[j] == i) {
                            removed = true;
                            break;
                        }
                        if (indices[j] >= i) continue;
                        ++shift;
                    }
                    if (removed || shift <= 0) continue;
                    this.internalShift(sm, conn, batched, i, -1 * shift, i == currentListSize - 1);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            JPOXLogger.RDBMS.error(e);
            throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.SCO.RemoveRequestFailed", removeAllStmt), e);
        }
        if (this.ownerFieldMetaData.getCollection().isDependentElement()) {
            sm.getObjectManager().deleteObjects(elements.toArray());
        }
        return modified;
    }

    protected String getRemoveAllStmt(Collection elements) {
        if (elements == null || elements.size() == 0) {
            return null;
        }
        StringBuffer stmt = new StringBuffer();
        stmt.append("DELETE FROM ");
        stmt.append(this.containerTable.toString());
        stmt.append(" WHERE ");
        Iterator elementsIter = elements.iterator();
        boolean first = true;
        while (elementsIter.hasNext()) {
            int i;
            elementsIter.next();
            if (first) {
                stmt.append("(");
            } else {
                stmt.append(" OR (");
            }
            for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
                if (i > 0) {
                    stmt.append(" AND ");
                }
                stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
            }
            for (i = 0; i < this.elementMapping.getNumberOfDatastoreFields(); ++i) {
                stmt.append(" AND ");
                stmt.append(((Object)this.elementMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                if (this.elementsAreSerialised) {
                    stmt.append(" LIKE ");
                } else {
                    stmt.append(" = ");
                }
                stmt.append(((RDBMSMapping)this.elementMapping.getDataStoreMapping(i)).getUpdateInputParameter());
            }
            if (this.relationDiscriminatorMapping != null) {
                for (i = 0; i < this.relationDiscriminatorMapping.getNumberOfDatastoreFields(); ++i) {
                    stmt.append(" AND ");
                    stmt.append(((Object)this.relationDiscriminatorMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                    stmt.append(" = ");
                    stmt.append(((RDBMSMapping)this.relationDiscriminatorMapping.getDataStoreMapping(i)).getUpdateInputParameter());
                }
            }
            stmt.append(")");
            first = false;
        }
        return stmt.toString();
    }

    protected QueryExpression getIteratorStatement(StateManager ownerSM, int start_index, int end_index) {
        QueryExpression stmt = null;
        final ClassLoaderResolver clr = ownerSM.getObjectManager().getClassLoaderResolver();
        if (this.elementsAreEmbedded || this.elementsAreSerialised) {
            stmt = this.dba.newQueryStatement(this.containerTable, clr);
            stmt.select(this.elementMapping);
        } else if (this.elementMapping instanceof ReferenceMapping) {
            stmt = this.dba.newQueryStatement(this.containerTable, clr);
        } else if (this.elementInfo != null) {
            for (int i = 0; i < this.elementInfo.length; ++i) {
                int elementNo = i;
                final Class elementCls = clr.classForName(this.elementInfo[elementNo].getClassName());
                QueryExpression elementStmt = null;
                if (this.elementInfo[elementNo].getDiscriminatorStrategy() != null && this.elementInfo[elementNo].getDiscriminatorStrategy() != DiscriminatorStrategy.NONE) {
                    if (this.storeMgr.getOMFContext().getTypeManager().isReferenceType(clr.classForName(this.ownerFieldMetaData.getCollection().getElementType()))) {
                        String[] clsNames = this.storeMgr.getMetaDataManager().getClassesImplementingInterface(this.ownerFieldMetaData.getCollection().getElementType(), clr);
                        Class[] cls = new Class[clsNames.length];
                        for (int j = 0; j < clsNames.length; ++j) {
                            cls[j] = clr.classForName(clsNames[j]);
                        }
                        elementStmt = new DiscriminatorIteratorStatement(clr, cls, true, this.storeMgr, true, this.containerTable, this.elementMapping, this.elmIdentifier).getQueryStatement();
                    } else {
                        elementStmt = new DiscriminatorIteratorStatement(clr, new Class[]{elementCls}, true, this.storeMgr, true, this.containerTable, this.elementMapping, this.elmIdentifier).getQueryStatement();
                    }
                    this.iterateUsingDiscriminator = true;
                } else {
                    elementStmt = new UnionIteratorStatement(clr, elementCls, true, (StoreManager)this.storeMgr, new UnionIteratorStatement.AssociationEnd(){

                        public JavaTypeMapping getMapping() {
                            return JoinListStore.this.elementMapping;
                        }

                        public Class getType() {
                            return elementCls;
                        }

                        public DatastoreContainerObject getDatastoreContainerObject() {
                            return JoinListStore.this.containerTable;
                        }

                        public boolean useJoin() {
                            return false;
                        }
                    }, true).getQueryStatement();
                }
                if (stmt == null) {
                    stmt = elementStmt;
                    continue;
                }
                stmt.union(elementStmt);
            }
        } else {
            stmt = new UnionIteratorStatement(clr, clr.classForName(this.elementType), true, this.storeMgr, new UnionIteratorStatement.AssociationEnd(){

                public JavaTypeMapping getMapping() {
                    return JoinListStore.this.elementMapping;
                }

                public Class getType() {
                    return clr.classForName(JoinListStore.this.elementType);
                }

                public DatastoreContainerObject getDatastoreContainerObject() {
                    return JoinListStore.this.containerTable;
                }

                public boolean useJoin() {
                    return false;
                }
            }).getQueryStatement();
        }
        ScalarExpression ownerExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getDefaultTableExpression());
        ScalarExpression ownerVal = this.ownerMapping.newLiteral(stmt, ownerSM.getObject());
        stmt.andCondition(ownerExpr.eq(ownerVal), true);
        if (this.relationDiscriminatorMapping != null) {
            ScalarExpression distinguisherExpr = this.relationDiscriminatorMapping.newScalarExpression(stmt, stmt.getDefaultTableExpression());
            ScalarExpression distinguisherVal = this.relationDiscriminatorMapping.newLiteral(stmt, this.relationDiscriminatorValue);
            stmt.andCondition(distinguisherExpr.eq(distinguisherVal), true);
        }
        if (this.indexedList) {
            ScalarExpression indexVal;
            ScalarExpression indexExpr;
            boolean returning_range = false;
            if (start_index == -1 && end_index == -1) {
                returning_range = true;
            } else if (start_index == end_index && start_index >= 0) {
                indexExpr = this.orderMapping.newScalarExpression(stmt, stmt.getDefaultTableExpression());
                indexVal = this.orderMapping.newLiteral(stmt, new Integer(start_index));
                stmt.andCondition(indexExpr.eq(indexVal), true);
            } else {
                if (start_index >= 0) {
                    indexExpr = this.orderMapping.newScalarExpression(stmt, stmt.getDefaultTableExpression());
                    indexVal = this.orderMapping.newLiteral(stmt, new Integer(start_index));
                    stmt.andCondition(indexExpr.gteq(indexVal), true);
                }
                if (end_index >= 0) {
                    indexExpr = this.orderMapping.newScalarExpression(stmt, stmt.getDefaultTableExpression());
                    indexVal = this.orderMapping.newLiteral(stmt, new Integer(end_index));
                    stmt.andCondition(indexExpr.lt(indexVal), true);
                }
                returning_range = true;
            }
            if (returning_range) {
                ScalarExpression[] exprIndex = new ScalarExpression[this.orderMapping.getNumberOfDatastoreFields()];
                boolean[] descendingOrder = new boolean[this.orderMapping.getNumberOfDatastoreFields()];
                exprIndex = this.orderMapping.newScalarExpression(stmt, stmt.getDefaultTableExpression()).getExpressionList().toArray();
                stmt.setOrdering(exprIndex, descendingOrder);
            }
        } else {
            DatastoreClass elementTbl = this.elementInfo[0].getDatastoreClass();
            OrderMetaData.FieldOrder[] orderComponents = this.ownerFieldMetaData.getOrderMetaData().getFieldOrders();
            for (int i = 0; i < orderComponents.length; ++i) {
                String fieldName = orderComponents[i].getFieldName();
                JavaTypeMapping fieldMapping = elementTbl.getFieldMapping(this.elementInfo[0].getAbstractClassMetaData().getField(fieldName));
                ScalarExpression[] exprIndex = new ScalarExpression[fieldMapping.getNumberOfDatastoreFields()];
                boolean[] descendingOrder = new boolean[fieldMapping.getNumberOfDatastoreFields()];
                for (int j = 0; j < descendingOrder.length; ++j) {
                    descendingOrder[j] = !orderComponents[i].isForward();
                }
                exprIndex = fieldMapping.newScalarExpression(stmt, stmt.getTableExpression(this.elmIdentifier)).getExpressionList().toArray();
                stmt.setOrdering(exprIndex, descendingOrder);
            }
        }
        return stmt;
    }

    public QueryExpression newQueryStatement(StateManager sm, String candidateClass) {
        if (this.elementsAreEmbedded || this.elementsAreSerialised) {
            throw new JPOXUserException(LOCALISER.msg("RDBMS.SCO.QueryOverCollectionImpossible"));
        }
        DatastoreIdentifier listRangeVar = this.storeMgr.getIdentifierFactory().newIdentifier(0, this.listName);
        DatastoreIdentifier elementRangeVar = this.thisIdentifier;
        QueryExpression stmt = this.dba.newQueryStatement(this.containerTable, listRangeVar, sm.getObjectManager().getClassLoaderResolver());
        ScalarExpression ownerExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getTableExpression(listRangeVar));
        ScalarExpression ownerVal = this.ownerMapping.newLiteral(stmt, sm.getObject());
        stmt.andCondition(ownerExpr.eq(ownerVal), true);
        if (!sm.getObjectManager().getClassLoaderResolver().isAssignableFrom(this.elementType, candidateClass)) {
            throw new IncompatibleQueryElementTypeException(this.elementType, candidateClass);
        }
        if (!this.storeMgr.getOMFContext().getTypeManager().isSupportedType(candidateClass)) {
            DatastoreClass candidateTable = this.storeMgr.getDatastoreClass(candidateClass, sm.getObjectManager().getClassLoaderResolver());
            JavaTypeMapping elementTableID = candidateTable.getIDMapping();
            stmt.newTableExpression(candidateTable, elementRangeVar);
            ScalarExpression elmListExpr = this.elementMapping.newScalarExpression(stmt, stmt.getTableExpression(listRangeVar));
            ScalarExpression elmExpr = elementTableID.newScalarExpression(stmt, stmt.getTableExpression(elementRangeVar));
            stmt.innerJoin(elmExpr, elmListExpr, stmt.getTableExpression(elementRangeVar), true, true);
            stmt.select(elementTableID);
        } else {
            stmt.select(listRangeVar, this.elementMapping);
        }
        return stmt;
    }

    public ScalarExpression joinElementsTo(QueryExpression stmt, QueryExpression parentStmt, JavaTypeMapping ownerMapping, LogicSetExpression ownerTe, DatastoreIdentifier listRangeVar, Class filteredElementType, ScalarExpression elmExpr, DatastoreIdentifier elementRangeVar) {
        ClassLoaderResolver clr = stmt.getClassLoaderResolver();
        if (!clr.isAssignableFrom(this.elementType, filteredElementType) && !clr.isAssignableFrom(filteredElementType, this.elementType)) {
            throw new IncompatibleQueryElementTypeException(this.elementType, filteredElementType.getName());
        }
        LogicSetExpression ownTblExpr = stmt.newTableExpression(this.containerTable, listRangeVar);
        ScalarExpression ownerExpr = ownerMapping.newScalarExpression(stmt, ownerTe);
        ScalarExpression ownerSetExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getTableExpression(listRangeVar));
        if (!parentStmt.hasCrossJoin(ownTblExpr)) {
            stmt.crossJoin(ownTblExpr, true);
        }
        stmt.andCondition(ownerExpr.eq(ownerSetExpr), true);
        if (this.storeMgr.getOMFContext().getTypeManager().isSupportedType(filteredElementType.getName())) {
            return this.elementMapping.newScalarExpression(stmt, stmt.getTableExpression(listRangeVar));
        }
        if (this.elementsAreEmbedded || this.elementsAreSerialised) {
            return this.elementMapping.newScalarExpression(stmt, stmt.getTableExpression(listRangeVar));
        }
        DatastoreClass elementTable = this.storeMgr.getDatastoreClass(filteredElementType.getName(), stmt.getClassLoaderResolver());
        DatastoreClass joiningClass = elmExpr.getLogicSetExpression() == null ? elementTable : (DatastoreClass)elmExpr.getLogicSetExpression().getMainTable();
        JavaTypeMapping elementTableID = joiningClass.getIDMapping();
        LogicSetExpression elmTblExpr = stmt.getTableExpression(elementRangeVar);
        if (elmTblExpr == null) {
            elmTblExpr = stmt.newTableExpression(elementTable, elementRangeVar);
        }
        ScalarExpression elmSetExpr = this.elementMapping.newScalarExpression(stmt, stmt.getTableExpression(listRangeVar));
        if (!parentStmt.hasCrossJoin(elmTblExpr)) {
            stmt.crossJoin(elmTblExpr, true);
        }
        if (elmExpr.getLogicSetExpression() != null && !elementTable.equals(elmExpr.getLogicSetExpression().getMainTable())) {
            stmt.andCondition(elmSetExpr.eq(elmExpr), true);
            return this.elementMapping.newScalarExpression(stmt, stmt.getTableExpression(listRangeVar));
        }
        ScalarExpression elementExpr = elementTableID.newScalarExpression(stmt, stmt.getTableExpression(elementRangeVar));
        stmt.andCondition(elmSetExpr.eq(elementExpr), true);
        return elementExpr;
    }
}

