/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.scostore;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.jdo.spi.PersistenceCapable;
import org.jpox.ClassLoaderResolver;
import org.jpox.ManagedConnection;
import org.jpox.ObjectManager;
import org.jpox.StateManager;
import org.jpox.exceptions.JPOXDataStoreException;
import org.jpox.exceptions.JPOXUserException;
import org.jpox.store.DatastoreClass;
import org.jpox.store.DatastoreContainerObject;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.exceptions.IncompatibleQueryElementTypeException;
import org.jpox.store.expression.BooleanExpression;
import org.jpox.store.expression.LogicSetExpression;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.Mappings;
import org.jpox.store.mapping.SerialisedMapping;
import org.jpox.store.rdbms.SQLController;
import org.jpox.store.rdbms.SQLWarnings;
import org.jpox.store.rdbms.mapping.RDBMSMapping;
import org.jpox.store.rdbms.query.UnionIteratorStatement;
import org.jpox.store.rdbms.scostore.AbstractMapStore;
import org.jpox.store.rdbms.scostore.MapEntrySetStore;
import org.jpox.store.rdbms.scostore.MapKeySetStore;
import org.jpox.store.rdbms.scostore.MapValueSetStore;
import org.jpox.store.rdbms.table.JoinTable;
import org.jpox.store.rdbms.table.MapTable;
import org.jpox.store.scostore.SetStore;
import org.jpox.util.JPOXLogger;

public class JoinMapStore
extends AbstractMapStore {
    private final String putStmt;
    private final String updateStmt;
    private final String removeStmt;
    private final String clearStmt;
    private SetStore keySetStore = null;
    private SetStore valueSetStore = null;
    private SetStore entrySetStore = null;
    protected final JavaTypeMapping adapterMapping;
    protected ClassLoaderResolver clr;
    static /* synthetic */ Class class$java$lang$String;

    public JoinMapStore(MapTable mapTable, ClassLoaderResolver clr) {
        super(mapTable.getStoreManager());
        this.clr = clr;
        this.mapTable = mapTable;
        this.ownerFieldMetaData = mapTable.getOwnerFieldMetaData();
        this.ownerMapping = mapTable.getOwnerMapping();
        this.keyMapping = mapTable.getKeyMapping();
        this.valueMapping = mapTable.getValueMapping();
        this.adapterMapping = mapTable.getAdapterMapping();
        this.keyType = mapTable.getKeyType();
        this.keysAreEmbedded = mapTable.isEmbeddedKey();
        this.keysAreSerialised = mapTable.isSerialisedKey();
        this.valueType = mapTable.getValueType();
        this.valuesAreEmbedded = mapTable.isEmbeddedValue();
        this.valuesAreSerialised = mapTable.isSerialisedValue();
        Class key_class = clr.classForName(this.keyType);
        this.kmd = this.storeMgr.getMetaDataManager().getMetaDataForClass(key_class, clr);
        Class value_class = clr.classForName(this.valueType);
        if (this.storeMgr.getOMFContext().getTypeManager().isReferenceType(value_class)) {
            JPOXLogger.PERSISTENCE.warn(LOCALISER.msg("RDBMS.SCO.Map.InterfaceValueNotSupported", value_class.getName()));
            this.vmd = this.storeMgr.getMetaDataManager().getMetaDataForImplementationOfReference(value_class, null, clr);
            if (this.vmd != null) {
                this.valueType = value_class.getName();
                this.valueTable = this.storeMgr.getDatastoreClass(this.vmd.getFullClassName(), clr);
            }
        } else {
            this.vmd = this.storeMgr.getMetaDataManager().getMetaDataForClass(value_class, clr);
            if (this.vmd != null) {
                this.valueType = this.vmd.getFullClassName();
                this.valueTable = this.valuesAreEmbedded ? null : this.storeMgr.getDatastoreClass(this.valueType, clr);
            }
        }
        this.initialiseStatements();
        this.putStmt = this.getPutStmt();
        this.updateStmt = this.getUpdateStmt();
        this.removeStmt = this.getRemoveStmt();
        this.clearStmt = this.getClearStmt();
    }

    private String getPutStmt() {
        int i;
        StringBuffer stmt = new StringBuffer();
        stmt.append("INSERT INTO ");
        stmt.append(this.mapTable.toString());
        stmt.append(" (");
        for (i = 0; i < this.valueMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(",");
            }
            stmt.append(((Object)this.valueMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
        }
        for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
            stmt.append(",");
            stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
        }
        if (this.adapterMapping != null) {
            for (i = 0; i < this.adapterMapping.getNumberOfDatastoreFields(); ++i) {
                stmt.append(",");
                stmt.append(((Object)this.adapterMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            }
        }
        for (i = 0; i < this.keyMapping.getNumberOfDatastoreFields(); ++i) {
            stmt.append(",");
            stmt.append(((Object)this.keyMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
        }
        stmt.append(") VALUES (");
        for (i = 0; i < this.valueMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(",");
            }
            stmt.append(((RDBMSMapping)this.valueMapping.getDataStoreMapping(i)).getInsertionInputParameter());
        }
        for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
            stmt.append(",");
            stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getInsertionInputParameter());
        }
        if (this.adapterMapping != null) {
            for (i = 0; i < this.adapterMapping.getNumberOfDatastoreFields(); ++i) {
                stmt.append(",");
                stmt.append(((RDBMSMapping)this.adapterMapping.getDataStoreMapping(i)).getInsertionInputParameter());
            }
        }
        for (i = 0; i < this.keyMapping.getNumberOfDatastoreFields(); ++i) {
            stmt.append(",");
            stmt.append(((RDBMSMapping)this.keyMapping.getDataStoreMapping(i)).getInsertionInputParameter());
        }
        stmt.append(") ");
        return stmt.toString();
    }

    private String getUpdateStmt() {
        int i;
        StringBuffer stmt = new StringBuffer();
        stmt.append("UPDATE ");
        stmt.append(this.mapTable.toString());
        stmt.append(" SET ");
        for (i = 0; i < this.valueMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(",");
            }
            stmt.append(((Object)this.valueMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.valueMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        stmt.append(" WHERE ");
        for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(" AND ");
            }
            stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        for (i = 0; i < this.keyMapping.getNumberOfDatastoreFields(); ++i) {
            stmt.append(" AND ");
            stmt.append(((Object)this.keyMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.keyMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        return stmt.toString();
    }

    private String getRemoveStmt() {
        int i;
        StringBuffer stmt = new StringBuffer();
        stmt.append("DELETE FROM ");
        stmt.append(this.mapTable.toString());
        stmt.append(" WHERE ");
        for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(" AND ");
            }
            stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        for (i = 0; i < this.keyMapping.getNumberOfDatastoreFields(); ++i) {
            stmt.append(" AND ");
            stmt.append(((Object)this.keyMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.keyMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        return stmt.toString();
    }

    private String getClearStmt() {
        StringBuffer stmt = new StringBuffer();
        stmt.append("DELETE FROM ");
        stmt.append(this.mapTable.toString());
        stmt.append(" WHERE ");
        for (int i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(" AND ");
            }
            stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        return stmt.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNextIDForAdapterColumn(StateManager sm) {
        int nextID;
        try {
            ObjectManager om = sm.getObjectManager();
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            Connection conn = (Connection)mconn.getConnection();
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                String stmt = this.getMaxAdapterColumnIdStmt();
                PreparedStatement ps = sqlControl.getStatementForQuery(conn, stmt);
                try {
                    int jdbcPosition = 1;
                    jdbcPosition = this.populateOwnerInStatement(sm, om, ps, jdbcPosition);
                    ResultSet rs = sqlControl.executeStatementQuery(conn, stmt, ps);
                    try {
                        nextID = !rs.next() ? 1 : rs.getInt(1) + 1;
                        SQLWarnings.log(rs);
                    }
                    finally {
                        rs.close();
                    }
                }
                finally {
                    sqlControl.closeStatement(conn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.SCO.MaxAdapterColumnIdRequestFailed", this.getMaxAdapterColumnIdStmt()), e);
        }
        return nextID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAll(StateManager sm, Map m) {
        Map.Entry entry;
        Iterator iter;
        Connection conn;
        ManagedConnection mconn;
        ObjectManager om;
        if (m == null || m.size() == 0) {
            return;
        }
        HashSet puts = new HashSet();
        HashSet updates = new HashSet();
        Iterator i = m.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            Object key = e.getKey();
            Object value = e.getValue();
            this.validateKeyForWriting(sm, key);
            this.validateValueForWriting(sm, value);
            try {
                Object oldValue = this.getValue(sm, key);
                if (oldValue == value) continue;
                updates.add(e);
            }
            catch (NoSuchElementException nsee) {
                if (value == null) continue;
                puts.add(e);
            }
        }
        boolean batched = this.allowsBatching();
        if (puts.size() > 0) {
            try {
                om = sm.getObjectManager();
                mconn = this.storeMgr.getConnection(om);
                conn = (Connection)mconn.getConnection();
                try {
                    iter = puts.iterator();
                    while (iter.hasNext()) {
                        entry = (Map.Entry)iter.next();
                        this.internalPut(sm, conn, batched, entry.getKey(), entry.getValue(), !iter.hasNext());
                    }
                }
                finally {
                    mconn.release();
                }
            }
            catch (SQLException e) {
                throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.SCO.PutRequestFailed", this.putStmt), e);
            }
        }
        if (updates.size() > 0) {
            try {
                om = sm.getObjectManager();
                mconn = this.storeMgr.getConnection(om);
                conn = (Connection)mconn.getConnection();
                try {
                    iter = updates.iterator();
                    while (iter.hasNext()) {
                        entry = (Map.Entry)iter.next();
                        this.internalUpdate(sm, conn, batched, entry.getKey(), entry.getValue(), !iter.hasNext());
                    }
                }
                finally {
                    mconn.release();
                }
            }
            catch (SQLException e) {
                throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.SCO.PutRequestFailed", this.updateStmt), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(StateManager sm, Object key, Object value) {
        String stmt;
        Object oldValue;
        this.validateKeyForWriting(sm, key);
        this.validateValueForWriting(sm, value);
        try {
            oldValue = this.getValue(sm, key);
            stmt = this.updateStmt;
        }
        catch (NoSuchElementException e) {
            oldValue = null;
            stmt = this.putStmt;
        }
        if (oldValue != value) {
            try {
                ObjectManager om = sm.getObjectManager();
                ManagedConnection mconn = this.storeMgr.getConnection(om);
                Connection conn = (Connection)mconn.getConnection();
                try {
                    if (oldValue == null) {
                        this.internalPut(sm, conn, false, key, value, true);
                    } else {
                        this.internalUpdate(sm, conn, false, key, value, true);
                    }
                }
                finally {
                    mconn.release();
                }
            }
            catch (SQLException e) {
                throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.SCO.PutRequestFailed", stmt), e);
            }
        }
        if (this.ownerFieldMetaData.getMap().isDependentValue() && oldValue != null && !this.containsValue(sm, oldValue)) {
            sm.getObjectManager().deleteObject(oldValue);
        }
        return oldValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int[] internalPut(StateManager ownerSM, Connection conn, boolean batched, Object key, Object value, boolean executeNow) throws SQLException {
        ObjectManager om = ownerSM.getObjectManager();
        SQLController sqlControl = this.storeMgr.getSQLController();
        PreparedStatement ps = sqlControl.getStatementForUpdate(conn, this.putStmt, false);
        try {
            int jdbcPosition = 1;
            jdbcPosition = this.valueMapping != null ? this.populateValueInStatement(om, ps, value, jdbcPosition) : this.populateEmbeddedValueFieldsInStatement(ownerSM, value, ps, jdbcPosition, (JoinTable)this.mapTable);
            jdbcPosition = this.populateOwnerInStatement(ownerSM, om, ps, jdbcPosition);
            if (this.adapterMapping != null) {
                long nextIDAdapter = this.getNextIDForAdapterColumn(ownerSM);
                this.adapterMapping.setObject(om, ps, Mappings.getParametersIndex(jdbcPosition, this.adapterMapping), new Long(nextIDAdapter));
                jdbcPosition += this.adapterMapping.getNumberOfDatastoreFields();
            }
            jdbcPosition = this.populateKeyInStatement(om, ps, key, jdbcPosition);
            int[] nArray = sqlControl.executeStatementUpdate(conn, this.putStmt, ps, true);
            return nArray;
        }
        finally {
            sqlControl.closeStatement(conn, ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalUpdate(StateManager ownerSM, Connection conn, boolean batched, Object key, Object value, boolean executeNow) throws SQLException {
        ObjectManager om = ownerSM.getObjectManager();
        SQLController sqlControl = this.storeMgr.getSQLController();
        PreparedStatement ps = sqlControl.getStatementForUpdate(conn, this.updateStmt, false);
        try {
            int jdbcPosition = 1;
            jdbcPosition = this.valueMapping != null ? this.populateValueInStatement(om, ps, value, jdbcPosition) : this.populateEmbeddedValueFieldsInStatement(ownerSM, value, ps, jdbcPosition, (JoinTable)this.mapTable);
            jdbcPosition = this.populateOwnerInStatement(ownerSM, om, ps, jdbcPosition);
            jdbcPosition = this.populateKeyInStatement(om, ps, key, jdbcPosition);
            if (batched) {
                ps.addBatch();
            } else {
                sqlControl.executeStatementUpdate(conn, this.updateStmt, ps, true);
            }
        }
        finally {
            sqlControl.closeStatement(conn, ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(StateManager sm, Object key) {
        boolean exists;
        Object oldValue;
        if (!this.validateKeyForReading(sm, key)) {
            return null;
        }
        try {
            oldValue = this.getValue(sm, key);
            exists = true;
        }
        catch (NoSuchElementException e) {
            oldValue = null;
            exists = false;
        }
        ObjectManager om = sm.getObjectManager();
        if (exists) {
            try {
                ManagedConnection mconn = this.storeMgr.getConnection(om);
                Connection conn = (Connection)mconn.getConnection();
                SQLController sqlControl = this.storeMgr.getSQLController();
                try {
                    PreparedStatement ps = sqlControl.getStatementForUpdate(conn, this.removeStmt, false);
                    try {
                        int jdbcPosition = 1;
                        jdbcPosition = this.populateOwnerInStatement(sm, om, ps, jdbcPosition);
                        jdbcPosition = this.populateKeyInStatement(om, ps, key, jdbcPosition);
                        sqlControl.executeStatementUpdate(conn, this.removeStmt, ps, true);
                    }
                    finally {
                        sqlControl.closeStatement(conn, ps);
                    }
                }
                finally {
                    mconn.release();
                }
            }
            catch (SQLException e) {
                throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.SCO.RemoveRequestFailed", this.removeStmt), e);
            }
        }
        if (this.ownerFieldMetaData.getMap().isDependentKey() && key instanceof PersistenceCapable) {
            om.deleteObject(key);
        }
        if (this.ownerFieldMetaData.getMap().isDependentValue() && oldValue instanceof PersistenceCapable && !this.containsValue(sm, oldValue)) {
            om.deleteObject(oldValue);
        }
        return oldValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(StateManager ownerSM) {
        HashSet<Object> dependentElements = null;
        if (this.ownerFieldMetaData.getMap().isDependentKey() || this.ownerFieldMetaData.getMap().isDependentValue()) {
            dependentElements = new HashSet<Object>();
            Iterator iter = this.entrySetStore().iterator(ownerSM);
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                if (this.ownerFieldMetaData.getMap().isDependentKey() && this.ownerFieldMetaData.getKeyMetaData() != null) {
                    dependentElements.add(entry.getKey());
                }
                if (!this.ownerFieldMetaData.getMap().isDependentValue() || this.ownerFieldMetaData.getValueMetaData() == null) continue;
                dependentElements.add(entry.getValue());
            }
        }
        try {
            ObjectManager om = ownerSM.getObjectManager();
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            Connection conn = (Connection)mconn.getConnection();
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForUpdate(conn, this.clearStmt, false);
                try {
                    int jdbcPosition = 1;
                    jdbcPosition = this.populateOwnerInStatement(ownerSM, om, ps, jdbcPosition);
                    sqlControl.executeStatementUpdate(conn, this.clearStmt, ps, true);
                }
                finally {
                    sqlControl.closeStatement(conn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.SCO.ClearRequestFailed", this.clearStmt), e);
        }
        if (dependentElements != null && dependentElements.size() > 0) {
            ownerSM.getObjectManager().deleteObjects(dependentElements.toArray());
        }
    }

    public synchronized SetStore keySetStore(ClassLoaderResolver clr) {
        if (this.keySetStore == null) {
            this.keySetStore = new MapKeySetStore((MapTable)this.mapTable, clr);
        }
        return this.keySetStore;
    }

    public synchronized SetStore valueSetStore(ClassLoaderResolver clr) {
        if (this.valueSetStore == null) {
            this.valueSetStore = new MapValueSetStore((MapTable)this.mapTable, this, clr);
        }
        return this.valueSetStore;
    }

    public synchronized SetStore entrySetStore() {
        if (this.entrySetStore == null) {
            this.entrySetStore = new MapEntrySetStore((MapTable)this.mapTable, this, this.clr);
        }
        return this.entrySetStore;
    }

    protected QueryExpression getGetStatement(StateManager ownerSm, Object key) {
        QueryExpression stmt = null;
        final ClassLoaderResolver clr = ownerSm.getObjectManager().getClassLoaderResolver();
        if (this.valuesAreEmbedded || this.valuesAreSerialised) {
            stmt = this.dba.newQueryStatement(this.mapTable, clr);
            stmt.select(this.valueMapping);
        } else {
            stmt = new UnionIteratorStatement(clr, clr.classForName(this.valueType), true, this.storeMgr, new UnionIteratorStatement.AssociationEnd(){

                public JavaTypeMapping getMapping() {
                    return JoinMapStore.this.valueMapping;
                }

                public Class getType() {
                    return clr.classForName(JoinMapStore.this.valueType);
                }

                public DatastoreContainerObject getDatastoreContainerObject() {
                    return JoinMapStore.this.mapTable;
                }

                public boolean useJoin() {
                    return false;
                }
            }).getQueryStatement();
        }
        ScalarExpression ownerExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getDefaultTableExpression());
        ScalarExpression ownerVal = this.ownerMapping.newLiteral(stmt, ownerSm.getObject());
        stmt.andCondition(ownerExpr.eq(ownerVal), true);
        if (this.keyMapping instanceof SerialisedMapping) {
            ScalarExpression keyExpr = this.keyMapping.newScalarExpression(stmt, stmt.getDefaultTableExpression());
            ScalarExpression keyVal = this.keyMapping.newLiteral(stmt, key).add(this.dba.getMapping(class$java$lang$String == null ? (class$java$lang$String = JoinMapStore.class$("java.lang.String")) : class$java$lang$String, this.storeMgr).newLiteral(stmt, "%"));
            stmt.andCondition(new BooleanExpression(keyExpr, ScalarExpression.OP_LIKE, keyVal), true);
        } else {
            ScalarExpression keyExpr = this.keyMapping.newScalarExpression(stmt, stmt.getDefaultTableExpression());
            ScalarExpression keyVal = this.keyMapping.newLiteral(stmt, key);
            stmt.andCondition(keyExpr.eq(keyVal), true);
        }
        return stmt;
    }

    private String getMaxAdapterColumnIdStmt() {
        StringBuffer stmt = new StringBuffer();
        stmt.append("SELECT MAX(" + ((Object)this.adapterMapping.getDataStoreMapping(0).getDatastoreField().getIdentifier()).toString() + ")");
        stmt.append(" FROM ");
        stmt.append(this.mapTable.toString());
        stmt.append(" WHERE ");
        for (int i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(" AND ");
            }
            stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        return stmt.toString();
    }

    public QueryExpression newQueryStatement(StateManager sm, String candidateClass) {
        if (this.valuesAreEmbedded || this.valuesAreSerialised) {
            throw new JPOXUserException(LOCALISER.msg("RDBMS.SCO.QueryOverMapImpossible"));
        }
        DatastoreIdentifier mapRangeVar = this.storeMgr.getIdentifierFactory().newIdentifier(0, "map");
        DatastoreIdentifier valueRangeVar = this.thisIdentifier;
        QueryExpression stmt = this.dba.newQueryStatement(this.mapTable, mapRangeVar, sm.getObjectManager().getClassLoaderResolver());
        ScalarExpression ownerExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getDefaultTableExpression());
        ScalarExpression ownerVal = this.ownerMapping.newLiteral(stmt, sm.getObject());
        stmt.andCondition(ownerExpr.eq(ownerVal), true);
        if (!sm.getObjectManager().getClassLoaderResolver().isAssignableFrom(this.valueType, candidateClass)) {
            throw new IncompatibleQueryElementTypeException(this.valueType, candidateClass);
        }
        if (!this.storeMgr.getOMFContext().getTypeManager().isSupportedType(candidateClass)) {
            DatastoreClass candidateTable = this.storeMgr.getDatastoreClass(candidateClass, sm.getObjectManager().getClassLoaderResolver());
            JavaTypeMapping valueTableID = candidateTable.getIDMapping();
            stmt.newTableExpression(candidateTable, valueRangeVar);
            ScalarExpression valueMapExpr = this.valueMapping.newScalarExpression(stmt, stmt.getTableExpression(mapRangeVar));
            ScalarExpression valueExpr = valueTableID.newScalarExpression(stmt, stmt.getTableExpression(valueRangeVar));
            stmt.innerJoin(valueExpr, valueMapExpr, stmt.getTableExpression(valueRangeVar), true, true);
            stmt.select(valueTableID);
        } else {
            stmt.select(mapRangeVar, this.valueMapping);
        }
        return stmt;
    }

    public ScalarExpression joinKeysTo(QueryExpression stmt, QueryExpression parentStmt, JavaTypeMapping ownerMapping, LogicSetExpression ownerTe, DatastoreIdentifier mapRangeVar, Class filteredKeyType, ScalarExpression keyExpr, DatastoreIdentifier keyRangeVar) {
        ClassLoaderResolver clr = stmt.getClassLoaderResolver();
        if (!clr.isAssignableFrom(this.keyType, filteredKeyType) && !clr.isAssignableFrom(filteredKeyType, this.keyType)) {
            throw new IncompatibleQueryElementTypeException(this.keyType, filteredKeyType == null ? null : filteredKeyType.getName());
        }
        LogicSetExpression mapTblExpr = stmt.newTableExpression(this.mapTable, mapRangeVar);
        ScalarExpression ownerMapExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getTableExpression(mapRangeVar));
        ScalarExpression ownerExpr = ownerMapping.newScalarExpression(stmt, ownerTe);
        if (!parentStmt.hasCrossJoin(mapTblExpr)) {
            stmt.crossJoin(mapTblExpr, true);
        }
        stmt.andCondition(ownerExpr.eq(ownerMapExpr), true);
        if (this.storeMgr.getOMFContext().getTypeManager().isSupportedType(filteredKeyType.getName())) {
            return this.keyMapping.newScalarExpression(stmt, stmt.getTableExpression(mapRangeVar));
        }
        if (this.keysAreEmbedded || this.keysAreSerialised) {
            return this.keyMapping.newScalarExpression(stmt, stmt.getTableExpression(mapRangeVar));
        }
        DatastoreClass keyTable = this.storeMgr.getDatastoreClass(filteredKeyType.getName(), stmt.getClassLoaderResolver());
        JavaTypeMapping keyTableID = keyTable.getIDMapping();
        LogicSetExpression keyTblExpr = stmt.getTableExpression(keyRangeVar);
        if (keyTblExpr == null) {
            keyTblExpr = stmt.newTableExpression(keyTable, keyRangeVar);
        }
        ScalarExpression keyMapExpr = this.keyMapping.newScalarExpression(stmt, stmt.getTableExpression(mapRangeVar));
        if (!parentStmt.hasCrossJoin(keyTblExpr)) {
            stmt.crossJoin(keyTblExpr, true);
        }
        if (keyExpr == null) {
            keyExpr = keyTableID.newScalarExpression(stmt, stmt.getTableExpression(keyRangeVar));
        }
        if (keyExpr.getLogicSetExpression() != null && !keyTable.equals(keyExpr.getLogicSetExpression().getMainTable())) {
            stmt.andCondition(keyMapExpr.eq(keyExpr), true);
            return this.keyMapping.newScalarExpression(stmt, stmt.getTableExpression(mapRangeVar));
        }
        ScalarExpression kExpr = keyTableID.newScalarExpression(stmt, stmt.getTableExpression(keyRangeVar));
        stmt.andCondition(keyMapExpr.eq(kExpr), true);
        return kExpr;
    }

    public ScalarExpression[] joinKeysValuesTo(QueryExpression stmt, QueryExpression parentStmt, JavaTypeMapping ownerMapping, LogicSetExpression ownerTe, DatastoreIdentifier mapRangeVar, Class filteredKeyType, Class filteredValueType, ScalarExpression keyExpr, ScalarExpression valExpr, DatastoreIdentifier keyRangeVar, DatastoreIdentifier valueRangeVar) {
        ScalarExpression[] qclKeyValues = new ScalarExpression[]{this.joinKeysTo(stmt, parentStmt, ownerMapping, ownerTe, mapRangeVar, filteredKeyType, keyExpr, keyRangeVar), this.joinValuesTo(stmt, parentStmt, ownerMapping, ownerTe, mapRangeVar, filteredValueType, valExpr, valueRangeVar)};
        return qclKeyValues;
    }

    public ScalarExpression joinValuesTo(QueryExpression stmt, QueryExpression parentStmt, JavaTypeMapping ownerMapping, LogicSetExpression ownerTe, DatastoreIdentifier mapRangeVar, Class filteredValueType, ScalarExpression valExpr, DatastoreIdentifier valueRangeVar) {
        ClassLoaderResolver clr = stmt.getClassLoaderResolver();
        if (!clr.isAssignableFrom(this.valueType, filteredValueType) && !clr.isAssignableFrom(filteredValueType, this.valueType)) {
            throw new IncompatibleQueryElementTypeException(this.valueType, filteredValueType == null ? null : filteredValueType.getName());
        }
        LogicSetExpression mapTblExpr = stmt.newTableExpression(this.mapTable, mapRangeVar);
        ScalarExpression ownerExpr = ownerMapping.newScalarExpression(stmt, ownerTe);
        ScalarExpression ownerMapExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getTableExpression(mapRangeVar));
        if (!parentStmt.hasCrossJoin(mapTblExpr)) {
            stmt.crossJoin(mapTblExpr, true);
        }
        stmt.andCondition(ownerExpr.eq(ownerMapExpr), true);
        if (this.storeMgr.getOMFContext().getTypeManager().isSupportedType(filteredValueType.getName())) {
            return this.valueMapping.newScalarExpression(stmt, stmt.getTableExpression(mapRangeVar));
        }
        if (this.valuesAreEmbedded || this.valuesAreSerialised) {
            return this.valueMapping.newScalarExpression(stmt, stmt.getTableExpression(mapRangeVar));
        }
        DatastoreClass valueTable = this.storeMgr.getDatastoreClass(filteredValueType.getName(), stmt.getClassLoaderResolver());
        JavaTypeMapping valueTableID = valueTable.getIDMapping();
        LogicSetExpression valueTblExpr = stmt.getTableExpression(valueRangeVar);
        if (valueTblExpr == null) {
            valueTblExpr = stmt.newTableExpression(valueTable, valueRangeVar);
        }
        ScalarExpression valueMapExpr = this.valueMapping.newScalarExpression(stmt, stmt.getTableExpression(mapRangeVar));
        if (!parentStmt.hasCrossJoin(valueTblExpr)) {
            stmt.crossJoin(valueTblExpr, true);
        }
        if (valExpr == null) {
            valExpr = valueTableID.newScalarExpression(stmt, stmt.getTableExpression(valueRangeVar));
        }
        if (valExpr.getLogicSetExpression() != null && !valueTable.equals(valExpr.getLogicSetExpression().getMainTable())) {
            stmt.andCondition(valueMapExpr.eq(valExpr), true);
            return this.valueMapping.newScalarExpression(stmt, stmt.getTableExpression(mapRangeVar));
        }
        ScalarExpression valueExpr = valueTableID.newScalarExpression(stmt, stmt.getTableExpression(valueRangeVar));
        stmt.andCondition(valueMapExpr.eq(valueExpr), true);
        return valueExpr;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

