/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.scostore;

import java.util.Collection;
import org.jpox.ClassLoaderResolver;
import org.jpox.StateManager;
import org.jpox.exceptions.JPOXUserException;
import org.jpox.metadata.AbstractPropertyMetaData;
import org.jpox.metadata.DiscriminatorStrategy;
import org.jpox.store.DatastoreClass;
import org.jpox.store.DatastoreContainerObject;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.expression.LogicSetExpression;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.query.DiscriminatorIteratorStatement;
import org.jpox.store.rdbms.query.UnionIteratorStatement;
import org.jpox.store.rdbms.scostore.AbstractSetStore;
import org.jpox.store.rdbms.table.MapTable;
import org.jpox.store.rdbms.table.SCOTable;

public class MapKeySetStore
extends AbstractSetStore {
    private DatastoreIdentifier valueIdentifier;
    protected static final int MAP_TYPE_JOIN = 0;
    protected static final int MAP_TYPE_KEY_IN_VALUE = 1;
    protected static final int MAP_TYPE_VALUE_IN_KEY = 2;
    private final int mapType;

    public MapKeySetStore(MapTable mapTable, ClassLoaderResolver clr) {
        super(mapTable.getStoreManager(), clr);
        this.containerTable = mapTable;
        this.setName = "keys";
        this.ownerFieldMetaData = mapTable.getOwnerFieldMetaData();
        this.mapType = 0;
        this.ownerMapping = mapTable.getOwnerMapping();
        this.elementMapping = mapTable.getKeyMapping();
        this.initialize(clr);
        this.valueIdentifier = this.storeMgr.getIdentifierFactory().newIdentifier(0, "VALUE");
    }

    public MapKeySetStore(DatastoreContainerObject valueTable, JavaTypeMapping ownerMapping, JavaTypeMapping keyMapping, ClassLoaderResolver clr, AbstractPropertyMetaData fmd) {
        super(valueTable.getStoreManager(), clr);
        this.containerTable = valueTable;
        this.setName = "keys";
        this.ownerFieldMetaData = fmd;
        this.mapType = this.ownerFieldMetaData.getValueMetaData() != null && this.ownerFieldMetaData.getValueMetaData().getMappedBy() != null ? 2 : 1;
        this.ownerMapping = ownerMapping;
        this.elementMapping = keyMapping;
        this.initialize(clr);
        this.removeStmt = null;
        this.clearStmt = null;
    }

    private void initialize(ClassLoaderResolver clr) {
        this.elementType = this.elementMapping.getType();
        this.elementsAreEmbedded = this.isEmbeddedMapping(this.elementMapping);
        this.elementsAreSerialised = this.isEmbeddedMapping(this.elementMapping);
        this.initialiseStatements();
        Class element_class = clr.classForName(this.elementType);
        this.emd = this.storeMgr.getOMFContext().getTypeManager().isReferenceType(element_class) ? this.storeMgr.getMetaDataManager().getMetaDataForImplementationOfReference(element_class, null, clr) : this.storeMgr.getMetaDataManager().getMetaDataForClass(element_class, clr);
        if (this.emd != null) {
            this.elementType = this.emd.getFullClassName();
            this.elementInfo = this.getElementInformationForClass();
        }
        this.valueIdentifier = this.storeMgr.getIdentifierFactory().newIdentifier(0, "VALUE");
    }

    protected QueryExpression getIteratorStatement(StateManager ownerSM) {
        ScalarExpression ownerVal;
        ScalarExpression ownerExpr;
        ClassLoaderResolver clr = ownerSM.getObjectManager().getClassLoaderResolver();
        final Class elementCls = clr.classForName(this.elementType);
        QueryExpression stmt = null;
        if (this.emd != null && this.emd.getDiscriminatorStrategy() != null && this.emd.getDiscriminatorStrategy() != DiscriminatorStrategy.NONE && this.containerTable instanceof DatastoreClass) {
            if (this.storeMgr.getOMFContext().getTypeManager().isReferenceType(clr.classForName(this.elementType))) {
                String[] clsNames = this.storeMgr.getMetaDataManager().getClassesImplementingInterface(this.elementType, clr);
                Class[] cls = new Class[clsNames.length];
                for (int j = 0; j < clsNames.length; ++j) {
                    cls[j] = clr.classForName(clsNames[j]);
                }
                stmt = new DiscriminatorIteratorStatement(clr, cls, true, this.storeMgr, true).getQueryStatement();
            } else {
                stmt = new DiscriminatorIteratorStatement(clr, new Class[]{elementCls}, true, this.storeMgr, true).getQueryStatement();
            }
            this.iterateUsingDiscriminator = true;
            DatastoreClass sourceTable = this.storeMgr.getDatastoreClass(this.elementType, clr);
            ScalarExpression sourceExpr = sourceTable.getIDMapping().newScalarExpression(stmt, stmt.getDefaultTableExpression());
            LogicSetExpression teTargetElement = stmt.newTableExpression(this.containerTable, this.valueIdentifier);
            ScalarExpression targetExpr = this.elementMapping.newScalarExpression(stmt, teTargetElement);
            stmt.innerJoin(sourceExpr, targetExpr, teTargetElement, true);
        } else {
            stmt = new UnionIteratorStatement(clr, elementCls, true, this.storeMgr, new UnionIteratorStatement.AssociationEnd(){

                public JavaTypeMapping getMapping() {
                    return MapKeySetStore.this.elementMapping;
                }

                public Class getType() {
                    return elementCls;
                }

                public DatastoreContainerObject getDatastoreContainerObject() {
                    return MapKeySetStore.this.containerTable;
                }

                public boolean useJoin() {
                    return MapKeySetStore.this.mapType == 0 || MapKeySetStore.this.mapType == 1;
                }
            }).getQueryStatement();
        }
        if (this.containerTable instanceof SCOTable || this.storeMgr.getOMFContext().getTypeManager().isSupportedType(this.elementType) || this.mapType == 2) {
            ownerExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getDefaultTableExpression());
            ownerVal = this.ownerMapping.newLiteral(stmt, ownerSM.getObject());
            stmt.andCondition(ownerExpr.eq(ownerVal), true);
        } else {
            ownerExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getTableExpression(this.valueIdentifier));
            ownerVal = this.ownerMapping.newLiteral(stmt, ownerSM.getObject());
            stmt.andCondition(ownerExpr.eq(ownerVal), true);
        }
        return stmt;
    }

    public boolean add(StateManager sm, Object element) {
        throw new UnsupportedOperationException("Cannot add to a map through its key set");
    }

    public boolean addAll(StateManager sm, Collection elements) {
        throw new UnsupportedOperationException("Cannot add to a map through its key set");
    }

    public boolean remove(StateManager sm, Object element) {
        if (this.removeStmt == null) {
            throw new UnsupportedOperationException("Cannot remove from an inverse map through its key set");
        }
        return super.remove(sm, element);
    }

    public boolean removeAll(StateManager sm, Collection elements) {
        if (this.removeStmt == null) {
            throw new UnsupportedOperationException("Cannot remove from an inverse map through its key set");
        }
        return super.removeAll(sm, elements);
    }

    public void clear(StateManager sm) {
        if (this.clearStmt == null) {
            throw new UnsupportedOperationException("Cannot clear an inverse map through its key set");
        }
        super.clear(sm);
    }

    public ScalarExpression joinElementsTo(QueryExpression stmt, QueryExpression qs, JavaTypeMapping ownerMapping, LogicSetExpression te, DatastoreIdentifier setRangeVar, Class filteredElementType, ScalarExpression elmExpr, DatastoreIdentifier elementRangeVar) {
        throw new JPOXUserException("Cannot query sets obtained by Map.keySet()");
    }

    public QueryExpression newQueryStatement(StateManager sm, String candidateClass) {
        throw new JPOXUserException("Cannot query sets obtained by Map.keySet()");
    }
}

