/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.table;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jpox.ClassLoaderResolver;
import org.jpox.exceptions.JPOXException;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.AbstractPropertyMetaData;
import org.jpox.metadata.ColumnMetaData;
import org.jpox.metadata.ColumnMetaDataContainer;
import org.jpox.metadata.ExtendableMetaData;
import org.jpox.metadata.IdentityStrategy;
import org.jpox.metadata.IdentityType;
import org.jpox.plugin.ConfigurationElement;
import org.jpox.store.DatastoreClass;
import org.jpox.store.DatastoreContainerObject;
import org.jpox.store.DatastoreField;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.MappingConsumer;
import org.jpox.store.mapping.OIDMapping;
import org.jpox.store.mapping.PersistenceCapableMapping;
import org.jpox.store.rdbms.Column;
import org.jpox.store.rdbms.RDBMSManager;
import org.jpox.store.rdbms.table.TableImpl;
import org.jpox.util.JPOXLogger;

public abstract class AbstractClassTable
extends TableImpl {
    protected Map fieldMappingsMap = new HashMap();
    protected JavaTypeMapping datastoreIDMapping;
    protected JavaTypeMapping[] pkMappings;
    protected JavaTypeMapping idMapping;
    protected JavaTypeMapping versionMapping;
    protected JavaTypeMapping discriminatorMapping;
    protected int highestFieldNumber = 0;
    static /* synthetic */ Class class$org$jpox$store$OID;
    static /* synthetic */ Class class$java$lang$Long;

    public AbstractClassTable(DatastoreIdentifier tableName, RDBMSManager storeMgr) {
        super(tableName, storeMgr);
    }

    public DatastoreContainerObject getPrimaryDatastoreContainerObject() {
        return this;
    }

    protected abstract void initializePK(ClassLoaderResolver var1);

    public boolean managesField(String fieldName) {
        if (fieldName == null) {
            return false;
        }
        Set fields = this.fieldMappingsMap.keySet();
        Iterator fieldsIter = fields.iterator();
        while (fieldsIter.hasNext()) {
            AbstractPropertyMetaData fmd = (AbstractPropertyMetaData)fieldsIter.next();
            if (!fmd.getFullFieldName().equals(fieldName)) continue;
            return true;
        }
        return false;
    }

    final void addApplicationIdUsingClassTableId(ColumnMetaDataContainer columnContainer, DatastoreClass refTable, ClassLoaderResolver clr, AbstractClassMetaData cmd) {
        ColumnMetaData[] userdefinedCols = null;
        int nextUserdefinedCol = 0;
        if (columnContainer != null) {
            userdefinedCols = columnContainer.getColumnMetaData();
        }
        this.pkMappings = new JavaTypeMapping[cmd.getPrimaryKeyFieldNumbers().length];
        for (int i = 0; i < cmd.getPrimaryKeyFieldNumbers().length; ++i) {
            JavaTypeMapping masterMapping;
            JavaTypeMapping mapping = refTable.getFieldMapping(cmd.getManagedFieldAbsolute(cmd.getPrimaryKeyFieldNumbers()[i]));
            this.pkMappings[i] = masterMapping = this.dba.getMapping(clr.classForName(mapping.getType()), this.storeMgr);
            for (int j = 0; j < mapping.getNumberOfDatastoreFields(); ++j) {
                JavaTypeMapping m = masterMapping;
                DatastoreField refColumn = mapping.getDataStoreMapping(j).getDatastoreField();
                if (mapping instanceof PersistenceCapableMapping) {
                    m = this.dba.getMapping(clr.classForName(refColumn.getMapping().getType()), this.storeMgr);
                    ((PersistenceCapableMapping)masterMapping).addJavaTypeMapping(m);
                }
                ColumnMetaData userdefinedColumn = null;
                if (userdefinedCols != null) {
                    for (int k = 0; k < userdefinedCols.length; ++k) {
                        if (!((Object)refColumn.getIdentifier()).toString().equals(userdefinedCols[k].getTarget())) continue;
                        userdefinedColumn = userdefinedCols[k];
                        break;
                    }
                    if (userdefinedColumn == null && nextUserdefinedCol < userdefinedCols.length) {
                        userdefinedColumn = userdefinedCols[nextUserdefinedCol++];
                    }
                }
                DatastoreField idColumn = null;
                idColumn = userdefinedColumn != null ? this.addDatastoreField(refColumn.getStoredJavaType(), this.storeMgr.getIdentifierFactory().newIdentifier(1, userdefinedColumn.getName()), m, refColumn.getExtendableMetaData()) : this.addDatastoreField(refColumn.getStoredJavaType(), refColumn.getIdentifier(), m, refColumn.getExtendableMetaData());
                if (mapping != null && mapping.getDataStoreMapping(j).getDatastoreField().getExtendableMetaData() != null) {
                    refColumn.copyConfigurationTo(idColumn);
                }
                idColumn.setAsPrimaryKey();
                this.getStoreManager().getMappingManager().createDatastoreMapping(m, this.storeMgr, idColumn, refColumn.getMapping().getType());
            }
        }
    }

    void addDatastoreId(ColumnMetaDataContainer columnContainer, DatastoreClass refTable, AbstractClassMetaData cmd) {
        this.datastoreIDMapping = new OIDMapping();
        this.datastoreIDMapping.initialize(this.dba, cmd.getFullClassName());
        ColumnMetaData colmd = null;
        colmd = columnContainer == null ? new ColumnMetaData(null, (String)null) : (columnContainer.getColumnMetaData().length < 1 ? new ColumnMetaData((ExtendableMetaData)((Object)columnContainer), (String)null) : columnContainer.getColumnMetaData()[0]);
        if (colmd.getName() == null) {
            if (refTable != null) {
                colmd.setName(this.storeMgr.getIdentifierFactory().newDatastoreFieldIdentifier(refTable.getIdentifier().getIdentifier(), this.storeMgr.getOMFContext().getTypeManager().isDefaultEmbeddedType(class$org$jpox$store$OID == null ? (class$org$jpox$store$OID = AbstractClassTable.class$("org.jpox.store.OID")) : class$org$jpox$store$OID), 1).getIdentifier());
            } else {
                colmd.setName(this.storeMgr.getIdentifierFactory().newDatastoreFieldIdentifier(this.identifier.getIdentifier(), this.storeMgr.getOMFContext().getTypeManager().isDefaultEmbeddedType(class$org$jpox$store$OID == null ? (class$org$jpox$store$OID = AbstractClassTable.class$("org.jpox.store.OID")) : class$org$jpox$store$OID), 0).getIdentifier());
            }
        }
        Column idColumn = (Column)this.addDatastoreField((class$org$jpox$store$OID == null ? (class$org$jpox$store$OID = AbstractClassTable.class$("org.jpox.store.OID")) : class$org$jpox$store$OID).getName(), this.storeMgr.getIdentifierFactory().newIdentifier(1, colmd.getName()), this.datastoreIDMapping, colmd);
        idColumn.setAsPrimaryKey();
        String strategyName = cmd.getIdentityMetaData().getStrategyValue().toString();
        if (cmd.getIdentityMetaData().getStrategyValue().equals(IdentityStrategy.CUSTOM)) {
            strategyName = cmd.getIdentityMetaData().getStrategyValue().getCustomName();
        }
        Class poidClass = class$java$lang$Long == null ? (class$java$lang$Long = AbstractClassTable.class$("java.lang.Long")) : class$java$lang$Long;
        ConfigurationElement elem = this.storeMgr.getOMFContext().getPluginManager().getConfigurationElementForExtension("org.jpox.store_valuegenerator", new String[]{"name", "datastore"}, new String[]{strategyName, "jdbc"});
        if (elem != null) {
            String generatorClassName = elem.getAttribute("class-name");
            Class generatorClass = this.getStoreManager().getOMFContext().getClassLoaderResolver(null).classForName(generatorClassName);
            try {
                Method storageClassMethod = generatorClass.getMethod("getStorageClass", null);
                poidClass = (Class)storageClassMethod.invoke(null, null);
            }
            catch (Exception e) {
                JPOXLogger.POID.warn("Error retrieving storage class for POID generator " + generatorClassName + " " + e.getMessage());
            }
        }
        this.dba.getMappingManager().createDatastoreMapping(this.datastoreIDMapping, this.storeMgr, idColumn, poidClass.getName());
        if (this.isObjectIDDatastoreAttributed() && this instanceof DatastoreClass && ((DatastoreClass)((Object)this)).isBaseDatastoreClass()) {
            idColumn.setAutoIncrement(true);
        }
        if (idColumn.isAutoIncrement() && !this.dba.supportsAutoIncrementFields()) {
            throw new JPOXException(LOCALISER.msg("RDBMS.Table.AutoIncrementNotSupportedByRDBMS", cmd.getFullClassName(), "datastore-identity")).setFatal();
        }
    }

    protected void addFieldMapping(JavaTypeMapping fieldMapping) {
        AbstractPropertyMetaData fmd = fieldMapping.getFieldMetaData();
        if (JPOXLogger.RDBMS.isDebugEnabled()) {
            StringBuffer columnsStr = new StringBuffer();
            for (int i = 0; i < fieldMapping.getNumberOfDatastoreFields(); ++i) {
                if (i > 0) {
                    columnsStr.append(",");
                }
                columnsStr.append(fieldMapping.getDataStoreMapping(i).getDatastoreField());
            }
            if (fieldMapping.getNumberOfDatastoreFields() == 0) {
                columnsStr.append("[none]");
            }
            StringBuffer datastoreMappingTypes = new StringBuffer();
            for (int i = 0; i < fieldMapping.getNumberOfDatastoreFields(); ++i) {
                if (i > 0) {
                    datastoreMappingTypes.append(',');
                }
                datastoreMappingTypes.append(fieldMapping.getDataStoreMapping(i).getClass().getName());
            }
            JPOXLogger.RDBMS.debug(LOCALISER.msg("RDBMS.Table.FieldToColumnMapping", fmd.getFullFieldName(), columnsStr.toString(), fieldMapping.getClass().getName(), datastoreMappingTypes.toString()));
        }
        this.fieldMappingsMap.put(fmd, fieldMapping);
        int absoluteFieldNumber = fmd.getAbsoluteFieldNumber();
        if (absoluteFieldNumber > this.highestFieldNumber) {
            this.highestFieldNumber = absoluteFieldNumber;
        }
    }

    public abstract IdentityType getIdentityType();

    public abstract boolean isObjectIDDatastoreAttributed();

    public JavaTypeMapping getDataStoreObjectIdMapping() {
        this.assertIsInitialized();
        return this.datastoreIDMapping;
    }

    public JavaTypeMapping getVersionMapping() {
        return this.versionMapping;
    }

    public JavaTypeMapping getDiscriminatorMapping() {
        return this.discriminatorMapping;
    }

    public final void provideDatastoreIdMappings(MappingConsumer consumer) {
        consumer.preConsumeMapping(this.highestFieldNumber + 1);
        if (this.getIdentityType() == IdentityType.DATASTORE) {
            consumer.consumeMapping(this.getDataStoreObjectIdMapping(), 2);
        }
    }

    public abstract void providePrimaryKeyMappings(MappingConsumer var1);

    public final void provideNonPrimaryKeyMappings(MappingConsumer consumer) {
        consumer.preConsumeMapping(this.highestFieldNumber + 1);
        Set fieldNumbersSet = this.fieldMappingsMap.keySet();
        Iterator iter = fieldNumbersSet.iterator();
        while (iter.hasNext()) {
            AbstractPropertyMetaData fmd = (AbstractPropertyMetaData)iter.next();
            JavaTypeMapping fieldMapping = (JavaTypeMapping)this.fieldMappingsMap.get(fmd);
            if (fieldMapping == null || fmd.isPrimaryKey()) continue;
            consumer.consumeMapping(fieldMapping, fmd);
        }
    }

    public void provideMappingsForFields(MappingConsumer consumer, AbstractPropertyMetaData[] fieldMetaData, boolean includeSecondaryTables) {
        consumer.preConsumeMapping(this.highestFieldNumber + 1);
        for (int i = 0; i < fieldMetaData.length; ++i) {
            JavaTypeMapping fieldMapping = (JavaTypeMapping)this.fieldMappingsMap.get(fieldMetaData[i]);
            if (fieldMapping == null || fieldMetaData[i].isPrimaryKey()) continue;
            consumer.consumeMapping(fieldMapping, fieldMetaData[i]);
        }
    }

    public final void provideVersionMappings(MappingConsumer consumer) {
        consumer.preConsumeMapping(this.highestFieldNumber + 1);
        if (this.getVersionMapping() != null) {
            consumer.consumeMapping(this.getVersionMapping(), 1);
        }
    }

    public final void provideDiscriminatorMappings(MappingConsumer consumer) {
        consumer.preConsumeMapping(this.highestFieldNumber + 1);
        if (this.getDiscriminatorMapping() != null) {
            consumer.consumeMapping(this.getDiscriminatorMapping(), 3);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

