/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.table;

import org.jpox.ClassLoaderResolver;
import org.jpox.exceptions.JPOXUserException;
import org.jpox.metadata.AbstractPropertyMetaData;
import org.jpox.metadata.CollectionMetaData;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.rdbms.RDBMSManager;
import org.jpox.store.rdbms.table.ElementContainerTable;

public class CollectionTable
extends ElementContainerTable {
    public CollectionTable(DatastoreIdentifier tableName, AbstractPropertyMetaData fmd, RDBMSManager storeMgr) {
        super(tableName, fmd, storeMgr);
    }

    public void initialize(ClassLoaderResolver clr) {
        CollectionMetaData colmd = this.fmd.getCollection();
        if (colmd == null) {
            throw new JPOXUserException(LOCALISER.msg("RDBMS.Table.CollectionMetaDataError", this.fmd));
        }
        super.initialize(clr);
    }

    public String getElementType() {
        return this.fmd.getCollection().getElementType();
    }

    public boolean isSerialisedElement() {
        return this.fmd.getCollection() != null && this.fmd.getCollection().isSerializedElement();
    }

    public boolean isEmbeddedElement() {
        if (this.fmd.getCollection() != null && this.fmd.getCollection().isSerializedElement()) {
            return false;
        }
        return this.fmd.getCollection() != null && this.fmd.getCollection().isEmbeddedElement();
    }

    public boolean isSerialisedElementPC() {
        return this.fmd.getCollection() != null && this.fmd.getCollection().isSerializedElement() && this.fmd.getCollection().getElementClassMetaData() != null;
    }

    public boolean isEmbeddedElementPC() {
        if (this.fmd.getCollection() != null && this.fmd.getCollection().isSerializedElement()) {
            return false;
        }
        return this.fmd.getElementMetaData() != null && this.fmd.getElementMetaData().getEmbeddedMetaData() != null;
    }
}

